/*
 * Decompiled with CFR 0.152.
 */
package training.ui.welcomeScreen;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.wm.BannerStartPagePromoter;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import java.awt.Color;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.FeaturesTrainerIcons;
import training.dsl.LessonUtil;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.OpenLessonActivities;
import training.learn.course.Lesson;
import training.ui.OnboardingFeedbackFormKt;
import training.ui.UISettings;
import training.util.OnboardingFeedbackData;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltraining/ui/welcomeScreen/OnboardingLessonPromoter;", "Lcom/intellij/openapi/wm/BannerStartPagePromoter;", "lessonId", "", "languageName", "(Ljava/lang/String;Ljava/lang/String;)V", "getActionLabel", "getDescription", "getHeaderLabel", "getPromotionForInitialState", "Ljavax/swing/JPanel;", "outLineColor", "Ljava/awt/Color;", "promoImage", "Ljavax/swing/Icon;", "runAction", "", "scheduleOnboardingFeedback", "startOnboardingLessonWithSdk", "intellij.featuresTrainer"})
@ApiStatus.Internal
public class OnboardingLessonPromoter
extends BannerStartPagePromoter {
    private final String lessonId;
    private final String languageName;

    @NotNull
    public Icon promoImage() {
        Icon icon = FeaturesTrainerIcons.Img.PluginIcon;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FeaturesTrainerIcons.Img.PluginIcon");
        return icon;
    }

    @Nullable
    public JPanel getPromotionForInitialState() {
        this.scheduleOnboardingFeedback();
        return super.getPromotionForInitialState();
    }

    @NotNull
    public String getHeaderLabel() {
        return LearnBundle.INSTANCE.message("welcome.promo.header", new Object[0]);
    }

    @NotNull
    public String getActionLabel() {
        return LearnBundle.INSTANCE.message("welcome.promo.start.tour", new Object[0]);
    }

    public void runAction() {
        this.startOnboardingLessonWithSdk();
    }

    @NotNull
    public String getDescription() {
        return LearnBundle.INSTANCE.message("welcome.promo.description", LessonUtil.INSTANCE.getProductName(), this.languageName);
    }

    @NotNull
    protected Color outLineColor() {
        return UISettings.Companion.getInstance().getSeparatorColor();
    }

    private final void startOnboardingLessonWithSdk() {
        block4: {
            Object v0;
            Object object;
            block3: {
                Iterable iterable = CourseManager.Companion.getInstance().getLessonsForModules();
                object = iterable;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    Lesson it = (Lesson)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.lessonId)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            Lesson lesson = v0;
            if (lesson == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(OnboardingLessonPromoter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.error("No lesson with id " + this.lessonId);
                return;
            }
            LangSupport langSupport2 = lesson.getModule().getPrimaryLanguage();
            if (langSupport2 == null) {
                object = "No primary language for promoting lesson " + lesson.getName();
                throw new IllegalStateException(object.toString());
            }
            LangSupport primaryLanguage = langSupport2;
            UtilsKt.resetPrimaryLanguage(primaryLanguage);
            LangSupport langSupport3 = LangManager.Companion.getInstance().getLangSupport();
            if (langSupport3 == null) break block4;
            langSupport3.startFromWelcomeFrame((Function1<? super Sdk, Unit>)((Function1)new Function1<Sdk, Unit>(lesson){
                final /* synthetic */ Lesson $lesson;

                public final void invoke(@Nullable Sdk selectedSdk) {
                    OpenLessonActivities.INSTANCE.openOnboardingFromWelcomeScreen(this.$lesson, selectedSdk);
                }
                {
                    this.$lesson = lesson;
                    super(1);
                }
            }));
        }
    }

    private final void scheduleOnboardingFeedback() {
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            return;
        }
        LangSupport langSupport3 = langSupport2;
        OnboardingFeedbackData onboardingFeedbackData = langSupport3.getOnboardingFeedbackData();
        if (onboardingFeedbackData == null) {
            return;
        }
        OnboardingFeedbackData onboardingFeedbackData2 = onboardingFeedbackData;
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(langSupport3, onboardingFeedbackData2){
            final /* synthetic */ LangSupport $langSupport$inlined;
            final /* synthetic */ OnboardingFeedbackData $onboardingFeedbackData$inlined;
            {
                this.$langSupport$inlined = langSupport2;
                this.$onboardingFeedbackData$inlined = onboardingFeedbackData;
            }

            public final void run() {
                block1: {
                    boolean bl = false;
                    this.$langSupport$inlined.setOnboardingFeedbackData(null);
                    OnboardingFeedbackFormKt.showOnboardingFeedbackNotification(null, this.$onboardingFeedbackData$inlined);
                    IdeFrame ideFrame = WelcomeFrame.getInstance();
                    Object object = ideFrame != null ? ideFrame.getBalloonLayout() : null;
                    if (!(object instanceof WelcomeBalloonLayoutImpl)) {
                        object = null;
                    }
                    WelcomeBalloonLayoutImpl welcomeBalloonLayoutImpl = (WelcomeBalloonLayoutImpl)object;
                    if (welcomeBalloonLayoutImpl == null) break block1;
                    welcomeBalloonLayoutImpl.showPopup();
                }
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable, modalityState);
    }

    public OnboardingLessonPromoter(@NonNls @NotNull String lessonId, @NonNls @NotNull String languageName) {
        Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
        Intrinsics.checkNotNullParameter((Object)languageName, (String)"languageName");
        this.lessonId = lessonId;
        this.languageName = languageName;
    }
}

