/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.description.Description;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.awt.AWT;
import org.assertj.swing.core.ComponentDragAndDrop;
import org.assertj.swing.core.KeyPressInfo;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.MouseClickInfo;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.Settings;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.ComponentEnabledCondition;
import org.assertj.swing.driver.ComponentPerformDefaultAccessibleActionTask;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiLazyLoadingDescription;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.query.ComponentEnabledQuery;
import org.assertj.swing.query.ComponentHasFocusQuery;
import org.assertj.swing.query.ComponentSizeQuery;
import org.assertj.swing.query.ComponentVisibleQuery;
import org.assertj.swing.timing.Condition;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.timing.Timeout;
import org.assertj.swing.util.TimeoutWatch;

@InternalApi
public class ComponentDriver {
    private static final String ENABLED_PROPERTY = "enabled";
    private static final String SIZE_PROPERTY = "size";
    private static final String VISIBLE_PROPERTY = "visible";
    protected final Robot robot;
    private final ComponentDragAndDrop dragAndDrop;

    public ComponentDriver(@Nonnull Robot robot) {
        this.robot = robot;
        this.dragAndDrop = new ComponentDragAndDrop(robot);
    }

    @RunsInEDT
    public void click(@Nonnull Component c) {
        this.checkClickAllowed(c);
        this.robot.click(c);
    }

    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull MouseButton button2) {
        this.click(c, button2, 1);
    }

    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull MouseClickInfo mouseClickInfo) {
        Preconditions.checkNotNull(mouseClickInfo);
        this.click(c, mouseClickInfo.button(), mouseClickInfo.times());
    }

    @RunsInEDT
    public void doubleClick(@Nonnull Component c) {
        this.click(c, MouseButton.LEFT_BUTTON, 2);
    }

    @RunsInEDT
    public void rightClick(@Nonnull Component c) {
        this.click(c, MouseButton.RIGHT_BUTTON);
    }

    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull MouseButton button2, int times) {
        Preconditions.checkNotNull(button2);
        this.checkClickAllowed(c);
        this.robot.click(c, button2, times);
    }

    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull Point where) {
        this.checkClickAllowed(c);
        this.robot.click(c, where);
    }

    @Nonnull
    protected Settings settings() {
        return this.robot.settings();
    }

    @RunsInEDT
    public void requireSize(@Nonnull Component c, @Nonnull Dimension size) {
        ((ObjectAssert)((AbstractObjectAssert)((Object)Assertions.assertThat(ComponentSizeQuery.sizeOf(c)))).as(ComponentDriver.propertyName(c, SIZE_PROPERTY))).isEqualTo(size);
    }

    @RunsInEDT
    public void requireVisible(@Nonnull Component c) {
        ((AbstractBooleanAssert)Assertions.assertThat(ComponentVisibleQuery.isVisible(c)).as(ComponentDriver.visibleProperty(c))).isTrue();
    }

    @RunsInEDT
    public void requireNotVisible(@Nonnull Component c) {
        ((AbstractBooleanAssert)Assertions.assertThat(ComponentVisibleQuery.isVisible(c)).as(ComponentDriver.visibleProperty(c))).isFalse();
    }

    @Nonnull
    @RunsInEDT
    private static Description visibleProperty(@Nonnull Component c) {
        return ComponentDriver.propertyName(c, VISIBLE_PROPERTY);
    }

    @RunsInEDT
    public void requireFocused(@Nonnull Component c) {
        ((AbstractBooleanAssert)Assertions.assertThat(ComponentHasFocusQuery.hasFocus(c)).as(ComponentDriver.requiredFocusedErrorMessage(c))).isTrue();
    }

    @Nonnull
    private static Description requiredFocusedErrorMessage(final Component c) {
        return new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                return String.format("Expected component %s to have input focus", Formatting.format(c));
            }
        };
    }

    @RunsInEDT
    public void requireEnabled(@Nonnull Component c) {
        ((AbstractBooleanAssert)Assertions.assertThat(ComponentEnabledQuery.isEnabled(c)).as(ComponentDriver.enabledProperty(c))).isTrue();
    }

    @RunsInEDT
    public void requireEnabled(@Nonnull Component c, @Nonnull Timeout timeout) {
        Pause.pause((Condition)ComponentEnabledCondition.untilIsEnabled(c), timeout);
    }

    @RunsInEDT
    public void requireDisabled(@Nonnull Component c) {
        ((AbstractBooleanAssert)Assertions.assertThat(ComponentEnabledQuery.isEnabled(c)).as(ComponentDriver.enabledProperty(c))).isFalse();
    }

    @Nonnull
    @RunsInEDT
    private static Description enabledProperty(@Nonnull Component c) {
        return ComponentDriver.propertyName(c, ENABLED_PROPERTY);
    }

    @RunsInEDT
    public void pressAndReleaseKeys(@Nonnull Component c, int ... keyCodes) {
        Preconditions.checkNotNull(keyCodes);
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.focusAndWaitForFocusGain(c);
        this.robot.pressAndReleaseKeys(keyCodes);
    }

    @RunsInEDT
    public void pressAndReleaseKey(@Nonnull Component c, @Nonnull KeyPressInfo keyPressInfo) {
        Preconditions.checkNotNull(keyPressInfo);
        this.pressAndReleaseKey(c, keyPressInfo.keyCode(), keyPressInfo.modifiers());
    }

    @RunsInEDT
    public void pressAndReleaseKey(@Nonnull Component c, int keyCode, @Nonnull int[] modifiers) {
        this.focusAndWaitForFocusGain(c);
        this.robot.pressAndReleaseKey(keyCode, modifiers);
    }

    @RunsInEDT
    public void pressKey(@Nonnull Component c, int keyCode) {
        this.focusAndWaitForFocusGain(c);
        this.robot.pressKey(keyCode);
    }

    @RunsInEDT
    public void pressKeyWhileRunning(@Nonnull Component c, int keyCode, @Nonnull Runnable runnable) {
        this.focusAndWaitForFocusGain(c);
        this.robot.pressKeyWhileRunning(keyCode, runnable);
    }

    @RunsInEDT
    public void releaseKey(@Nonnull Component c, int keyCode) {
        this.focusAndWaitForFocusGain(c);
        this.robot.releaseKey(keyCode);
    }

    @RunsInEDT
    public void focusAndWaitForFocusGain(@Nonnull Component c) {
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.robot.focusAndWaitForFocusGain(c);
    }

    @RunsInEDT
    public void focus(@Nonnull Component c) {
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.robot.focus(c);
    }

    @RunsInEDT
    protected final void drag(@Nonnull Component c, @Nonnull Point where) {
        this.dragAndDrop.drag(c, where);
    }

    @RunsInEDT
    public void drop(@Nonnull Component c) {
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.drop(c, AWT.visibleCenterOf(c));
    }

    @RunsInEDT
    protected final void drop(@Nonnull Component c, @Nonnull Point where) {
        this.dragAndDrop.drop(c, where);
    }

    protected final void dragOver(@Nonnull Component c, @Nonnull Point where) {
        this.dragAndDrop.dragOver(c, where);
    }

    @RunsInCurrentThread
    protected final void performAccessibleActionOf(@Nonnull Component c) {
        ComponentPerformDefaultAccessibleActionTask.performDefaultAccessibleAction(c);
        this.robot.waitForIdle();
    }

    @RunsInCurrentThread
    protected final boolean waitForShowing(@Nonnull Component c, long timeout) {
        if (this.robot.isReadyForInput(c)) {
            return true;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!this.robot.isReadyForInput(c)) {
            Component invoker;
            if (c instanceof JPopupMenu && (invoker = ((JPopupMenu)c).getInvoker()) instanceof JMenu) {
                this.robot.jitter(invoker);
            }
            if (watch.isTimeOut()) {
                return false;
            }
            Pause.pause();
        }
        return true;
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu invokePopupMenu(@Nonnull Component c) {
        this.checkClickAllowed(c);
        return this.robot.showPopupMenu(c);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu invokePopupMenu(@Nonnull Component c, @Nonnull Point p) {
        Preconditions.checkNotNull(p);
        this.checkClickAllowed(c);
        return this.robot.showPopupMenu(c, p);
    }

    @RunsInEDT
    protected static void checkInEdtEnabledAndShowing(@Nonnull Component c) {
        GuiActionRunner.execute(() -> ComponentPreconditions.checkEnabledAndShowing(c));
    }

    @RunsInEDT
    protected static void checkInEdtShowing(@Nonnull Component c) {
        GuiActionRunner.execute(() -> ComponentPreconditions.checkShowing(c));
    }

    @RunsInEDT
    protected void checkClickAllowed(@Nonnull Component c) {
        if (this.robot.settings().clickOnDisabledComponentsAllowed()) {
            ComponentDriver.checkInEdtShowing(c);
        } else {
            ComponentDriver.checkInEdtEnabledAndShowing(c);
        }
    }

    @Nonnull
    @RunsInEDT
    public static Description propertyName(final @Nonnull Component c, final @Nonnull String propertyName) {
        return new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                return String.format("%s - property:'%s'", Formatting.format(c), propertyName);
            }
        };
    }

    @RunsInEDT
    protected final void moveMouseIgnoringAnyError(@Nonnull Component c, @Nonnull Point p) {
        this.moveMouseIgnoringAnyError(c, p.x, p.y);
    }

    @RunsInEDT
    protected final void moveMouseIgnoringAnyError(@Nonnull Component c, int x, int y) {
        try {
            this.robot.moveMouse(c, x, y);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Nonnull
    @RunsInEDT
    public Font fontOf(@Nonnull Component c) {
        Font result2 = GuiActionRunner.execute(() -> c.getFont());
        return Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInEDT
    public Color backgroundOf(@Nonnull Component c) {
        Color result2 = GuiActionRunner.execute(() -> c.getBackground());
        return Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInEDT
    public Color foregroundOf(@Nonnull Component c) {
        Color result2 = GuiActionRunner.execute(() -> c.getForeground());
        return Preconditions.checkNotNull(result2);
    }
}

