/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.settings.LocationSettingType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ui.configuration.SdkComboBox;
import com.intellij.openapi.roots.ui.configuration.SdkComboBoxModel;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import one.util.streamex.StreamEx;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.target.GradleRuntimeTargetUI;
import org.jetbrains.plugins.gradle.execution.target.TargetPathFieldWithBrowseButton;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmComboBoxUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class IdeaGradleProjectSettingsControlBuilder
implements GradleProjectSettingsControlBuilder {
    private static final Logger LOG = Logger.getInstance(IdeaGradleProjectSettingsControlBuilder.class);
    private static final long BALLOON_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final String HIDDEN_KEY = "hidden";
    @NotNull
    private final GradleProjectSettings myInitialSettings;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private final Ref<Project> myProjectRef;
    @NotNull
    private final Disposable myProjectRefDisposable;
    @Nullable
    JComboBox<DistributionTypeItem> myGradleDistributionComboBox;
    @Nullable
    JBLabel myGradleDistributionHint;
    @NotNull
    private LocationSettingType myGradleHomeSettingType;
    private boolean myShowBalloonIfNecessary;
    @Nullable
    private TargetPathFieldWithBrowseButton myGradleHomePathField;
    private JPanel myGradlePanel;
    @Nullable
    private JLabel myGradleJdkLabel;
    @Nullable
    private SdkComboBox myGradleJdkComboBox;
    private JPanel myGradleJdkComboBoxWrapper;
    private boolean dropGradleJdkComponents;
    private boolean dropUseWrapperButton;
    private boolean dropCustomizableWrapperButton;
    private boolean dropUseLocalDistributionButton;
    private boolean dropUseBundledDistributionButton;
    private JPanel myImportPanel;
    private JPanel myModulePerSourceSetPanel;
    @Nullable
    private JBCheckBox myResolveModulePerSourceSetCheckBox;
    private boolean dropResolveModulePerSourceSetCheckBox;
    @Nullable
    private JBCheckBox myResolveExternalAnnotationsCheckBox;
    private boolean dropResolveExternalAnnotationsCheckBox;
    @Nullable
    private JLabel myDelegateBuildLabel;
    @Nullable
    private ComboBox<BuildRunItem> myDelegateBuildCombobox;
    private boolean dropDelegateBuildCombobox;
    @Nullable
    private JLabel myTestRunnerLabel;
    @Nullable
    private ComboBox<TestRunnerItem> myTestRunnerCombobox;
    private boolean dropTestRunnerCombobox;
    private JPanel myDelegatePanel;

    public IdeaGradleProjectSettingsControlBuilder(@NotNull GradleProjectSettings initialSettings) {
        if (initialSettings == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(0);
        }
        this.myAlarm = new Alarm();
        this.myProjectRef = Ref.create();
        this.myProjectRefDisposable = () -> this.myProjectRef.set(null);
        this.myGradleHomeSettingType = LocationSettingType.UNKNOWN;
        this.dropResolveExternalAnnotationsCheckBox = false;
        this.myInitialSettings = initialSettings;
    }

    public IdeaGradleProjectSettingsControlBuilder dropGradleJdkComponents() {
        this.dropGradleJdkComponents = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseWrapperButton() {
        this.dropUseWrapperButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropCustomizableWrapperButton() {
        this.dropCustomizableWrapperButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseLocalDistributionButton() {
        this.dropUseLocalDistributionButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseBundledDistributionButton() {
        this.dropUseBundledDistributionButton = true;
        return this;
    }

    @Deprecated(forRemoval=true)
    public IdeaGradleProjectSettingsControlBuilder dropUseAutoImportBox() {
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropResolveModulePerSourceSetCheckBox() {
        this.dropResolveModulePerSourceSetCheckBox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropResolveExternalAnnotationsCheckBox() {
        this.dropResolveExternalAnnotationsCheckBox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropDelegateBuildCombobox() {
        this.dropDelegateBuildCombobox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropTestRunnerCombobox() {
        this.dropTestRunnerCombobox = true;
        return this;
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi((Object)this, (boolean)show);
        if (show) {
            this.updateDistributionComponents();
            this.updateDeprecatedControls();
        }
    }

    @Override
    @NotNull
    public GradleProjectSettings getInitialSettings() {
        GradleProjectSettings gradleProjectSettings = this.myInitialSettings;
        if (gradleProjectSettings == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(1);
        }
        return gradleProjectSettings;
    }

    @Override
    public void createAndFillControls(PaintAwarePanel content, int indentLevel) {
        content.setPaintCallback(graphics -> this.showBalloonIfNecessary());
        content.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!"ancestor".equals(evt.getPropertyName())) {
                    return;
                }
                boolean bl = IdeaGradleProjectSettingsControlBuilder.this.myShowBalloonIfNecessary = evt.getNewValue() != null && evt.getOldValue() == null;
                if (evt.getNewValue() == null && evt.getOldValue() != null) {
                    IdeaGradleProjectSettingsControlBuilder.this.myAlarm.cancelAllRequests();
                }
            }
        });
        this.addImportComponents(content, indentLevel);
        this.addDelegationComponents(content, indentLevel);
        this.addGradleComponents(content, indentLevel);
    }

    private void addImportComponents(PaintAwarePanel content, int indentLevel) {
        this.myImportPanel = IdeaGradleProjectSettingsControlBuilder.addComponentsGroup(null, content, indentLevel, (Consumer<JPanel>)((Consumer)panel2 -> {
            if (!this.dropResolveModulePerSourceSetCheckBox) {
                this.myModulePerSourceSetPanel = new JPanel(new GridBagLayout());
                panel2.add((Component)this.myModulePerSourceSetPanel, ExternalSystemUiUtil.getFillLineConstraints((int)0).insets(0, 0, 0, 0));
                this.myResolveModulePerSourceSetCheckBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.module.per.source.set", IdeaGradleProjectSettingsControlBuilder.getIDEName()));
                this.myModulePerSourceSetPanel.add((Component)this.myResolveModulePerSourceSetCheckBox, ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
                JBLabel myResolveModulePerSourceSetHintLabel = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)GradleBundle.message("gradle.settings.text.module.per.source.set.hint", new Object[0])), UIUtil.ComponentStyle.SMALL);
                myResolveModulePerSourceSetHintLabel.setIcon(AllIcons.General.BalloonWarning12);
                myResolveModulePerSourceSetHintLabel.setVerticalTextPosition(1);
                myResolveModulePerSourceSetHintLabel.setForeground(UIUtil.getLabelFontColor((UIUtil.FontColor)UIUtil.FontColor.BRIGHTER));
                GridBag constraints = ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel);
                constraints.insets.top = 0;
                constraints.insets.left += UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.myResolveModulePerSourceSetCheckBox);
                this.myModulePerSourceSetPanel.add((Component)myResolveModulePerSourceSetHintLabel, constraints);
            }
            if (!this.dropResolveExternalAnnotationsCheckBox) {
                this.myResolveExternalAnnotationsCheckBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.download.annotations", new Object[0]));
                panel2.add((Component)this.myResolveExternalAnnotationsCheckBox, ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
            }
        }));
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi((Object)this);
        Disposer.dispose((Disposable)this.myAlarm);
    }

    private void deduceGradleHomeIfPossible() {
        if (this.myGradleHomePathField == null) {
            return;
        }
        File gradleHome2 = GradleInstallationManager.getInstance().getAutodetectedGradleHome((Project)this.myProjectRef.get());
        if (gradleHome2 == null) {
            new DelayedBalloonInfo(MessageType.WARNING, LocationSettingType.UNKNOWN, BALLOON_DELAY_MILLIS).run();
            return;
        }
        this.myGradleHomeSettingType = LocationSettingType.DEDUCED;
        new DelayedBalloonInfo(MessageType.INFO, LocationSettingType.DEDUCED, BALLOON_DELAY_MILLIS).run();
        this.myGradleHomePathField.setText(gradleHome2.getPath());
        this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.DEDUCED.getColor());
    }

    private void addGradleComponents(PaintAwarePanel content, int indentLevel) {
        this.myGradlePanel = IdeaGradleProjectSettingsControlBuilder.addComponentsGroup("Gradle", content, indentLevel, (Consumer<JPanel>)((Consumer)panel2 -> {
            this.addGradleChooserComponents((JPanel)panel2, indentLevel + 1);
            this.addGradleJdkComponents((JPanel)panel2, indentLevel + 1);
        }));
    }

    @Override
    public IdeaGradleProjectSettingsControlBuilder addGradleJdkComponents(JPanel content, int indentLevel) {
        if (!this.dropGradleJdkComponents) {
            Project project = ProjectManager.getInstance().getDefaultProject();
            this.myGradleJdkLabel = new JBLabel(GradleBundle.message("gradle.settings.text.jvm.path", new Object[0]));
            this.myGradleJdkComboBoxWrapper = new JPanel(new BorderLayout());
            this.recreateGradleJdkComboBox(project, new ProjectSdksModel());
            this.myGradleJdkLabel.setLabelFor(this.myGradleJdkComboBoxWrapper);
            content.add((Component)this.myGradleJdkLabel, ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
            content.add((Component)this.myGradleJdkComboBoxWrapper, ExternalSystemUiUtil.getFillLineConstraints((int)0));
        }
        return this;
    }

    @Override
    public IdeaGradleProjectSettingsControlBuilder addGradleChooserComponents(JPanel content, int indentLevel) {
        ArrayList<DistributionTypeItem> availableDistributions = new ArrayList<DistributionTypeItem>();
        if (!this.dropUseWrapperButton) {
            availableDistributions.add(new DistributionTypeItem(DistributionType.DEFAULT_WRAPPED));
        }
        if (!this.dropCustomizableWrapperButton) {
            availableDistributions.add(new DistributionTypeItem(DistributionType.WRAPPED));
        }
        if (!this.dropUseLocalDistributionButton) {
            availableDistributions.add(new DistributionTypeItem(DistributionType.LOCAL));
        }
        if (!this.dropUseBundledDistributionButton) {
            availableDistributions.add(new DistributionTypeItem(DistributionType.BUNDLED));
        }
        this.myGradleDistributionComboBox = new ComboBox();
        this.myGradleDistributionComboBox.setRenderer((ListCellRenderer<DistributionTypeItem>)((Object)new MyItemCellRenderer()));
        this.myGradleDistributionHint = new JBLabel();
        this.myGradleHomePathField = new TargetPathFieldWithBrowseButton();
        this.myGradleDistributionHint.setLabelFor((Component)((Object)this.myGradleHomePathField));
        this.myGradleHomePathField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.myGradleDistributionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeaGradleProjectSettingsControlBuilder.this.updateDistributionComponents();
            }
        });
        this.myGradleDistributionComboBox.setModel((ComboBoxModel<DistributionTypeItem>)new CollectionComboBoxModel(availableDistributions));
        if (!availableDistributions.isEmpty()) {
            content.add((Component)new JBLabel(GradleBundle.message("gradle.settings.text.distribution", new Object[0])), ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
            content.add(this.myGradleDistributionComboBox, ExternalSystemUiUtil.getLabelConstraints((int)0));
            JPanel additionalControlsPanel = new JPanel(new GridBagLayout());
            additionalControlsPanel.add((Component)this.myGradleDistributionHint);
            additionalControlsPanel.add((Component)((Object)this.myGradleHomePathField), ExternalSystemUiUtil.getFillLineConstraints((int)0));
            content.add((Component)additionalControlsPanel, ExternalSystemUiUtil.getFillLineConstraints((int)0).insets(0, 0, 0, 0));
            boolean macTheme = UIUtil.isUnderDefaultMacTheme();
            this.myGradleDistributionComboBox.setPreferredSize(new Dimension(this.myGradleDistributionComboBox.getPreferredSize().width, this.myGradleHomePathField.getPreferredSize().height + (macTheme ? 3 : 0)));
        }
        return this;
    }

    private void updateDistributionComponents() {
        if (this.myGradleDistributionComboBox == null) {
            return;
        }
        if (this.myGradleHomePathField == null) {
            return;
        }
        boolean localEnabled = this.getSelectedGradleDistribution() == DistributionType.LOCAL;
        boolean wrapperSelected = this.getSelectedGradleDistribution() == DistributionType.DEFAULT_WRAPPED;
        this.myGradleHomePathField.setEnabled(localEnabled);
        this.myGradleHomePathField.setVisible(localEnabled);
        if (this.myGradleDistributionHint != null) {
            this.myGradleDistributionHint.setEnabled(wrapperSelected);
            this.myGradleDistributionHint.setVisible(wrapperSelected);
        }
        if (localEnabled) {
            if (this.myGradleHomePathField.getText().isEmpty()) {
                this.deduceGradleHomeIfPossible();
            } else {
                Project project = (Project)this.myProjectRef.get();
                if (GradleInstallationManager.getInstance().isGradleSdkHome(project, this.myGradleHomePathField.getText())) {
                    this.myGradleHomeSettingType = LocationSettingType.EXPLICIT_CORRECT;
                } else {
                    this.myGradleHomeSettingType = LocationSettingType.EXPLICIT_INCORRECT;
                    this.myShowBalloonIfNecessary = true;
                }
            }
            this.showBalloonIfNecessary();
        } else {
            this.myAlarm.cancelAllRequests();
        }
    }

    @Nullable
    private DistributionType getSelectedGradleDistribution() {
        if (this.myGradleDistributionComboBox == null) {
            return null;
        }
        Object selection = this.myGradleDistributionComboBox.getSelectedItem();
        return selection == null ? null : (DistributionType)((Object)((DistributionTypeItem)selection).value);
    }

    @Override
    public boolean validate(GradleProjectSettings settings2) throws ConfigurationException {
        if (this.myGradleJdkComboBox != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            String homePath;
            SdkLookupProvider.SdkInfo sdkInfo2 = this.getSelectedGradleJvmInfo(this.myGradleJdkComboBox);
            if (sdkInfo2 instanceof SdkLookupProvider.SdkInfo.Undefined) {
                throw new ConfigurationException(GradleBundle.message("gradle.jvm.undefined", new Object[0]));
            }
            if (sdkInfo2 instanceof SdkLookupProvider.SdkInfo.Resolved && !ExternalSystemJdkUtil.isValidJdk((String)(homePath = ((SdkLookupProvider.SdkInfo.Resolved)sdkInfo2).getHomePath()))) {
                throw new ConfigurationException(GradleBundle.message("gradle.jvm.incorrect", homePath));
            }
        }
        if (this.myGradleHomePathField != null && this.getSelectedGradleDistribution() == DistributionType.LOCAL) {
            String gradleHomePath = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
            if (StringUtil.isEmpty((String)gradleHomePath)) {
                this.myGradleHomeSettingType = LocationSettingType.UNKNOWN;
                throw new ConfigurationException(GradleBundle.message("gradle.home.setting.type.explicit.empty", gradleHomePath));
            }
            if (!GradleInstallationManager.getInstance().isGradleSdkHome((Project)this.myProjectRef.get(), new File(gradleHomePath))) {
                this.myGradleHomeSettingType = LocationSettingType.EXPLICIT_INCORRECT;
                new DelayedBalloonInfo(MessageType.ERROR, this.myGradleHomeSettingType, 0L).run();
                throw new ConfigurationException(GradleBundle.message("gradle.home.setting.type.explicit.incorrect", gradleHomePath));
            }
        }
        return true;
    }

    @NotNull
    private SdkLookupProvider getSdkLookupProvider(@NotNull Project project) {
        if (project == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(2);
        }
        SdkLookupProvider sdkLookupProvider = GradleJvmResolutionUtil.getGradleJvmLookupProvider(project, this.myInitialSettings);
        if (sdkLookupProvider == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(3);
        }
        return sdkLookupProvider;
    }

    @NotNull
    private SdkLookupProvider.SdkInfo getSelectedGradleJvmInfo(@NotNull SdkComboBox comboBox) {
        if (comboBox == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(4);
        }
        Project project = comboBox.getModel().getProject();
        SdkLookupProvider sdkLookupProvider = this.getSdkLookupProvider(project);
        String externalProjectPath2 = this.myInitialSettings.getExternalProjectPath();
        Sdk projectSdk = comboBox.getModel().getSdksModel().getProjectSdk();
        String gradleJvm = GradleJvmComboBoxUtil.getSelectedGradleJvmReference(comboBox, sdkLookupProvider);
        SdkLookupProvider.SdkInfo sdkInfo2 = GradleJvmUtil.nonblockingResolveGradleJvmInfo(sdkLookupProvider, project, projectSdk, externalProjectPath2, gradleJvm);
        if (sdkInfo2 == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(5);
        }
        return sdkInfo2;
    }

    @Override
    public void apply(GradleProjectSettings settings2) {
        Object testRunnerSelectedItem;
        Object delegateBuildSelectedItem;
        Object selected;
        settings2.setCompositeBuild(this.myInitialSettings.getCompositeBuild());
        if (this.myGradleHomePathField != null) {
            String finalGradleHomePath;
            String gradleHomePath = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
            File gradleHomeFile = new File(gradleHomePath);
            if (GradleInstallationManager.getInstance().isGradleSdkHome((Project)this.myProjectRef.get(), gradleHomeFile)) {
                finalGradleHomePath = gradleHomePath;
            } else {
                finalGradleHomePath = GradleInstallationManager.getInstance().suggestBetterGradleHomePath((Project)this.myProjectRef.get(), gradleHomePath);
                if (finalGradleHomePath != null) {
                    SwingUtilities.invokeLater(() -> this.myGradleHomePathField.setText(finalGradleHomePath));
                }
            }
            if (StringUtil.isEmpty((String)finalGradleHomePath)) {
                settings2.setGradleHome(null);
            } else {
                settings2.setGradleHome(finalGradleHomePath);
                GradleUtil.storeLastUsedGradleHome(finalGradleHomePath);
            }
        }
        if (this.myGradleJdkComboBox != null) {
            IdeaGradleProjectSettingsControlBuilder.wrapExceptions((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> this.myGradleJdkComboBox.getModel().getSdksModel().apply()));
            SdkLookupProvider sdkLookupProvider = this.getSdkLookupProvider(this.myGradleJdkComboBox.getModel().getProject());
            String gradleJvm = GradleJvmComboBoxUtil.getSelectedGradleJvmReference(this.myGradleJdkComboBox, sdkLookupProvider);
            settings2.setGradleJvm(StringUtil.isEmpty((String)gradleJvm) ? null : gradleJvm);
        }
        if (this.myResolveModulePerSourceSetCheckBox != null) {
            settings2.setResolveModulePerSourceSet(this.myResolveModulePerSourceSetCheckBox.isSelected());
        }
        if (this.myResolveExternalAnnotationsCheckBox != null) {
            settings2.setResolveExternalAnnotations(this.myResolveExternalAnnotationsCheckBox.isSelected());
        }
        if (this.myGradleDistributionComboBox != null && (selected = this.myGradleDistributionComboBox.getSelectedItem()) instanceof DistributionTypeItem) {
            settings2.setDistributionType((DistributionType)((Object)((DistributionTypeItem)selected).value));
        }
        if (this.myDelegateBuildCombobox != null && (delegateBuildSelectedItem = this.myDelegateBuildCombobox.getSelectedItem()) instanceof BuildRunItem) {
            settings2.setDelegatedBuild((Boolean)ObjectUtils.notNull((Object)((Boolean)((BuildRunItem)delegateBuildSelectedItem).value), (Object)true));
        }
        if (this.myTestRunnerCombobox != null && (testRunnerSelectedItem = this.myTestRunnerCombobox.getSelectedItem()) instanceof TestRunnerItem) {
            settings2.setTestRunner((TestRunner)((Object)ObjectUtils.notNull((Object)((Object)((TestRunner)((Object)((TestRunnerItem)testRunnerSelectedItem).value))), (Object)((Object)GradleProjectSettings.DEFAULT_TEST_RUNNER))));
        }
    }

    @Override
    public boolean isModified() {
        if (this.myGradleDistributionComboBox != null && this.myGradleDistributionComboBox.getSelectedItem() instanceof DistributionTypeItem && ((DistributionTypeItem)this.myGradleDistributionComboBox.getSelectedItem()).value != this.myInitialSettings.getDistributionType()) {
            return true;
        }
        if (this.myResolveModulePerSourceSetCheckBox != null && this.myResolveModulePerSourceSetCheckBox.isSelected() != this.myInitialSettings.isResolveModulePerSourceSet()) {
            return true;
        }
        if (this.myResolveExternalAnnotationsCheckBox != null && this.myResolveExternalAnnotationsCheckBox.isSelected() != this.myInitialSettings.isResolveExternalAnnotations()) {
            return true;
        }
        if (this.myDelegateBuildCombobox != null && this.myDelegateBuildCombobox.getSelectedItem() instanceof MyItem && !Objects.equals(((MyItem)this.myDelegateBuildCombobox.getSelectedItem()).value, this.myInitialSettings.getDelegatedBuild())) {
            return true;
        }
        if (this.myTestRunnerCombobox != null && this.myTestRunnerCombobox.getSelectedItem() instanceof MyItem && !Objects.equals(((MyItem)this.myTestRunnerCombobox.getSelectedItem()).value, (Object)this.myInitialSettings.getTestRunner())) {
            return true;
        }
        if (this.myGradleJdkComboBox != null) {
            SdkLookupProvider sdkLookupProvider = this.getSdkLookupProvider(this.myGradleJdkComboBox.getModel().getProject());
            String gradleJvm = GradleJvmComboBoxUtil.getSelectedGradleJvmReference(this.myGradleJdkComboBox, sdkLookupProvider);
            if (!StringUtil.equals((CharSequence)gradleJvm, (CharSequence)this.myInitialSettings.getGradleJvm())) {
                return true;
            }
            if (this.myGradleJdkComboBox.getModel().getSdksModel().isModified()) {
                return true;
            }
        }
        if (this.myGradleHomePathField == null) {
            return false;
        }
        String gradleHome2 = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
        if (StringUtil.isEmpty((String)gradleHome2)) {
            return !StringUtil.isEmpty((String)this.myInitialSettings.getGradleHome());
        }
        return !gradleHome2.equals(this.myInitialSettings.getGradleHome());
    }

    @Override
    public void reset(@Nullable Project project, GradleProjectSettings settings2, boolean isDefaultModuleCreation) {
        this.reset(project, settings2, isDefaultModuleCreation, null);
    }

    @Override
    public void reset(@Nullable Project project, GradleProjectSettings settings2, boolean isDefaultModuleCreation, @Nullable WizardContext wizardContext) {
        this.updateProjectRef(project, wizardContext);
        String gradleHome2 = settings2.getGradleHome();
        if (this.myGradleHomePathField != null) {
            GradleRuntimeTargetUI.installActionListener(this.myGradleHomePathField, (Project)this.myProjectRef.get(), GradleBundle.message("gradle.settings.text.home.path", new Object[0]));
            this.myGradleHomePathField.setText(gradleHome2 == null ? "" : gradleHome2);
            this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
        }
        this.resetImportControls(settings2);
        this.resetGradleJdkComboBox(project, settings2, wizardContext);
        this.resetWrapperControls(settings2.getExternalProjectPath(), settings2, isDefaultModuleCreation);
        this.resetGradleDelegationControls(wizardContext);
        if (StringUtil.isEmpty((String)gradleHome2)) {
            this.myGradleHomeSettingType = LocationSettingType.UNKNOWN;
            this.deduceGradleHomeIfPossible();
        } else {
            File gradleHomeFile = new File(gradleHome2);
            this.myGradleHomeSettingType = GradleInstallationManager.getInstance().isGradleSdkHome(project, gradleHomeFile) ? LocationSettingType.EXPLICIT_CORRECT : (GradleInstallationManager.getInstance().suggestBetterGradleHomePath(project, gradleHome2) != null ? LocationSettingType.EXPLICIT_CORRECT : LocationSettingType.EXPLICIT_INCORRECT);
            this.myAlarm.cancelAllRequests();
            if (this.myGradleHomeSettingType == LocationSettingType.EXPLICIT_INCORRECT && settings2.getDistributionType() == DistributionType.LOCAL) {
                new DelayedBalloonInfo(MessageType.ERROR, this.myGradleHomeSettingType, 0L).run();
            }
        }
        this.updateDeprecatedControls();
    }

    @Override
    public void update(String linkedProjectPath, GradleProjectSettings settings2, boolean isDefaultModuleCreation) {
        this.resetWrapperControls(linkedProjectPath, settings2, isDefaultModuleCreation);
        this.resetImportControls(settings2);
        this.updateDeprecatedControls();
    }

    private void resetImportControls(GradleProjectSettings settings2) {
        if (this.myResolveModulePerSourceSetCheckBox != null) {
            this.myResolveModulePerSourceSetCheckBox.setSelected(settings2.isResolveModulePerSourceSet());
            boolean showSetting = !settings2.isResolveModulePerSourceSet() || Registry.is((String)"gradle.settings.showDeprecatedSettings", (boolean)false);
            this.myModulePerSourceSetPanel.putClientProperty(HIDDEN_KEY, showSetting);
        }
        if (this.myResolveExternalAnnotationsCheckBox != null) {
            this.myResolveExternalAnnotationsCheckBox.setSelected(settings2.isResolveExternalAnnotations());
        }
    }

    private void updateDeprecatedControls() {
        if (this.myModulePerSourceSetPanel != null) {
            this.myModulePerSourceSetPanel.setVisible(this.myModulePerSourceSetPanel.getClientProperty(HIDDEN_KEY) == Boolean.TRUE);
        }
    }

    protected void resetGradleJdkComboBox(@Nullable Project project, GradleProjectSettings settings2, @Nullable WizardContext wizardContext) {
        ProjectSdksModel sdksModel = new ProjectSdksModel();
        this.resetGradleJdkComboBox(project, settings2, wizardContext, sdksModel);
    }

    protected final void resetGradleJdkComboBox(@Nullable Project project, @NotNull GradleProjectSettings settings2, @Nullable WizardContext wizardContext, @NotNull ProjectSdksModel sdksModel) {
        if (settings2 == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(6);
        }
        if (sdksModel == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(7);
        }
        if (this.myGradleJdkComboBox == null) {
            return;
        }
        project = project == null || project.isDisposed() ? ProjectManager.getInstance().getDefaultProject() : project;
        Sdk projectSdk = wizardContext != null ? wizardContext.getProjectJdk() : null;
        IdeaGradleProjectSettingsControlBuilder.setupProjectSdksModel(sdksModel, project, projectSdk);
        this.recreateGradleJdkComboBox(project, sdksModel);
        SdkLookupProvider sdkLookupProvider = this.getSdkLookupProvider(project);
        String externalProjectPath2 = this.myInitialSettings.getExternalProjectPath();
        GradleJvmComboBoxUtil.addUsefulGradleJvmReferences(this.myGradleJdkComboBox, externalProjectPath2);
        GradleJvmComboBoxUtil.setSelectedGradleJvmReference(this.myGradleJdkComboBox, sdkLookupProvider, externalProjectPath2, settings2.getGradleJvm());
    }

    private void recreateGradleJdkComboBox(@NotNull Project project, @NotNull ProjectSdksModel sdksModel) {
        if (project == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(8);
        }
        if (sdksModel == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(9);
        }
        if (this.myGradleJdkComboBox != null) {
            this.myGradleJdkComboBoxWrapper.remove((Component)this.myGradleJdkComboBox);
        }
        this.myGradleJdkComboBox = new SdkComboBox(SdkComboBoxModel.createJdkComboBoxModel((Project)project, (ProjectSdksModel)sdksModel));
        this.myGradleJdkComboBoxWrapper.add((Component)this.myGradleJdkComboBox, "Center");
    }

    private void resetWrapperControls(String linkedProjectPath, @NotNull GradleProjectSettings settings2, boolean isDefaultModuleCreation) {
        if (settings2 == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(10);
        }
        if (this.myGradleDistributionComboBox == null) {
            return;
        }
        if (isDefaultModuleCreation) {
            DistributionTypeItem toRemove = new DistributionTypeItem(DistributionType.WRAPPED);
            ((CollectionComboBoxModel)this.myGradleDistributionComboBox.getModel()).remove((Object)toRemove);
        }
        if (StringUtil.isEmpty((String)linkedProjectPath) && !isDefaultModuleCreation) {
            this.myGradleDistributionComboBox.setSelectedItem(new DistributionTypeItem(DistributionType.LOCAL));
            return;
        }
        if (this.myGradleDistributionHint != null && !this.dropUseWrapperButton) {
            boolean isGradleDefaultWrapperFilesExist = GradleUtil.isGradleDefaultWrapperFilesExist(linkedProjectPath);
            boolean showError = !isGradleDefaultWrapperFilesExist && !isDefaultModuleCreation;
            this.myGradleDistributionHint.setText(showError ? GradleBundle.message("gradle.settings.wrapper.not.found", new Object[0]) : null);
            this.myGradleDistributionHint.setIcon(showError ? AllIcons.General.Error : null);
        }
        if (settings2.getDistributionType() == null) {
            if (this.myGradleDistributionComboBox.getItemCount() > 0) {
                this.myGradleDistributionComboBox.setSelectedIndex(0);
            }
        } else {
            this.myGradleDistributionComboBox.setSelectedItem(new DistributionTypeItem(settings2.getDistributionType()));
        }
    }

    private void addDelegationComponents(PaintAwarePanel content, int indentLevel) {
        this.myDelegatePanel = IdeaGradleProjectSettingsControlBuilder.addComponentsGroup(GradleBundle.message("gradle.settings.text.build.run.title", new Object[0]), content, indentLevel, (Consumer<JPanel>)((Consumer)panel2 -> {
            if (this.dropDelegateBuildCombobox && this.dropTestRunnerCombobox) {
                return;
            }
            JBLabel label = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)GradleBundle.message("gradle.settings.text.build.run.hint", IdeaGradleProjectSettingsControlBuilder.getIDEName())), UIUtil.ComponentStyle.SMALL);
            label.setForeground(UIUtil.getLabelFontColor((UIUtil.FontColor)UIUtil.FontColor.BRIGHTER));
            GridBag constraints = ExternalSystemUiUtil.getFillLineConstraints((int)(indentLevel + 1));
            constraints.insets.bottom = 12;
            panel2.add((Component)label, constraints);
            if (!this.dropDelegateBuildCombobox) {
                Object[] states = new BuildRunItem[]{new BuildRunItem(Boolean.TRUE), new BuildRunItem(Boolean.FALSE)};
                this.myDelegateBuildCombobox = new ComboBox(states);
                this.myDelegateBuildCombobox.setRenderer(new MyItemCellRenderer());
                this.myDelegateBuildCombobox.setSelectedItem((Object)new BuildRunItem(this.myInitialSettings.getDelegatedBuild()));
                this.myDelegateBuildLabel = new JBLabel(GradleBundle.message("gradle.settings.text.build.run", new Object[0]));
                panel2.add((Component)this.myDelegateBuildLabel, IdeaGradleProjectSettingsControlBuilder.getLabelConstraints(indentLevel + 1));
                panel2.add((Component)this.myDelegateBuildCombobox, IdeaGradleProjectSettingsControlBuilder.getLabelConstraints(0));
                panel2.add(Box.createGlue(), ExternalSystemUiUtil.getFillLineConstraints((int)(indentLevel + 1)));
                this.myDelegateBuildLabel.setLabelFor((Component)this.myDelegateBuildCombobox);
            }
            if (!this.dropTestRunnerCombobox) {
                Object[] testRunners = (TestRunnerItem[])StreamEx.of((Object[])TestRunner.values()).map(x$0 -> new TestRunnerItem((TestRunner)((Object)((Object)x$0)))).toArray(TestRunnerItem[]::new);
                this.myTestRunnerCombobox = new ComboBox(testRunners);
                this.myTestRunnerCombobox.setRenderer(new MyItemCellRenderer());
                this.myTestRunnerCombobox.setSelectedItem((Object)new TestRunnerItem(this.myInitialSettings.getTestRunner()));
                this.myTestRunnerCombobox.setPrototypeDisplayValue((Object)new TestRunnerItem(TestRunner.CHOOSE_PER_TEST));
                if (this.myDelegateBuildCombobox != null) {
                    this.myDelegateBuildCombobox.setPreferredSize(this.myTestRunnerCombobox.getPreferredSize());
                }
                this.myTestRunnerLabel = new JBLabel(GradleBundle.message("gradle.settings.text.run.tests", new Object[0]));
                panel2.add((Component)this.myTestRunnerLabel, IdeaGradleProjectSettingsControlBuilder.getLabelConstraints(indentLevel + 1));
                panel2.add((Component)this.myTestRunnerCombobox, IdeaGradleProjectSettingsControlBuilder.getLabelConstraints(0));
                panel2.add(Box.createGlue(), ExternalSystemUiUtil.getFillLineConstraints((int)(indentLevel + 1)));
                this.myTestRunnerLabel.setLabelFor((Component)this.myTestRunnerCombobox);
            }
        }));
    }

    private void resetGradleDelegationControls(@Nullable WizardContext wizardContext) {
        if (wizardContext != null) {
            this.dropTestRunnerCombobox();
            this.dropDelegateBuildCombobox();
            if (this.myDelegatePanel != null) {
                Container parent = this.myDelegatePanel.getParent();
                if (parent != null) {
                    parent.remove(this.myDelegatePanel);
                }
                this.myDelegatePanel = null;
                this.myDelegateBuildCombobox = null;
                this.myTestRunnerCombobox = null;
            }
            return;
        }
        if (this.myDelegateBuildCombobox != null) {
            this.myDelegateBuildCombobox.setSelectedItem((Object)new BuildRunItem(this.myInitialSettings.getDelegatedBuild()));
        }
        if (this.myTestRunnerCombobox != null) {
            this.myTestRunnerCombobox.setSelectedItem((Object)new TestRunnerItem(this.myInitialSettings.getTestRunner()));
        }
    }

    void showBalloonIfNecessary() {
        if (!this.myShowBalloonIfNecessary || this.myGradleHomePathField != null && !this.myGradleHomePathField.isEnabled()) {
            return;
        }
        this.myShowBalloonIfNecessary = false;
        MessageType messageType = null;
        switch (this.myGradleHomeSettingType) {
            case DEDUCED: {
                messageType = MessageType.INFO;
                break;
            }
            case EXPLICIT_INCORRECT: 
            case UNKNOWN: {
                messageType = MessageType.ERROR;
                break;
            }
        }
        if (messageType != null) {
            new DelayedBalloonInfo(messageType, this.myGradleHomeSettingType, BALLOON_DELAY_MILLIS).run();
        }
    }

    private void updateProjectRef(@Nullable Project project, @Nullable WizardContext wizardContext) {
        if (wizardContext != null && wizardContext.getProject() != null) {
            project = wizardContext.getProject();
        }
        if (project != null && project != this.myProjectRef.get()) {
            Disposer.register((Disposable)project, (Disposable)this.myProjectRefDisposable);
        }
        this.myProjectRef.set((Object)project);
    }

    private static JPanel addComponentsGroup(@Nullable @NlsContexts.Separator String title, PaintAwarePanel content, int indentLevel, @NotNull Consumer<JPanel> configuration) {
        if (configuration == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(11);
        }
        JPanel result = new JPanel(new GridBagLayout());
        if (title != null) {
            GridBag constraints = ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel);
            constraints.insets.top = 12;
            result.add((Component)new TitledSeparator(title), constraints);
        }
        int count = result.getComponentCount();
        configuration.consume((Object)result);
        if (result.getComponentCount() > count) {
            content.add((Component)result, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)0).insets(0, 0, 0, 0));
        }
        return result;
    }

    private static void setupProjectSdksModel(@NotNull ProjectSdksModel sdksModel, @NotNull Project project, @Nullable Sdk projectSdk) {
        if (sdksModel == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(12);
        }
        if (project == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(13);
        }
        sdksModel.reset(project);
        IdeaGradleProjectSettingsControlBuilder.deduplicateSdkNames(sdksModel);
        if (projectSdk == null) {
            projectSdk = sdksModel.getProjectSdk();
            projectSdk = sdksModel.findSdk(projectSdk);
        }
        if (projectSdk != null) {
            projectSdk = ExternalSystemJdkUtil.resolveDependentJdk((Sdk)projectSdk);
            projectSdk = sdksModel.findSdk(projectSdk.getName());
        }
        sdksModel.setProjectSdk(projectSdk);
    }

    @NotNull
    private static GridBag getLabelConstraints(int indentLevel) {
        JBInsets insets = JBUI.insets((int)0, (int)(5 + 5 * indentLevel), (int)0, (int)5);
        GridBag gridBag = new GridBag().anchor(17).weightx(0.0).insets((Insets)insets);
        if (gridBag == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(14);
        }
        return gridBag;
    }

    private static void wrapExceptions(ThrowableRunnable<Throwable> runnable) {
        try {
            runnable.run();
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static void deduplicateSdkNames(@NotNull ProjectSdksModel projectSdksModel) {
        if (projectSdksModel == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(15);
        }
        HashSet<String> processedNames = new HashSet<String>();
        Collection editableSdks = projectSdksModel.getProjectSdks().values();
        for (Sdk sdk : editableSdks) {
            if (processedNames.contains(sdk.getName())) {
                SdkModificator sdkModificator = sdk.getSdkModificator();
                String name2 = SdkConfigurationUtil.createUniqueSdkName((String)sdk.getName(), editableSdks);
                sdkModificator.setName(name2);
                sdkModificator.commitChanges();
            }
            processedNames.add(sdk.getName());
        }
    }

    @NlsSafe
    static String getIDEName() {
        return ApplicationNamesInfo.getInstance().getFullProductName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder";
                break;
            }
            case 2: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdksModel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSdksModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkLookupProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedGradleJvmInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelConstraints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSdkLookupProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedGradleJvmInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resetGradleJdkComboBox";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "recreateGradleJdkComboBox";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resetWrapperControls";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addComponentsGroup";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setupProjectSdksModel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deduplicateSdkNames";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class DistributionTypeItem
    extends MyItem<DistributionType> {
        private DistributionTypeItem(DistributionType value) {
            super(value);
        }

        @Override
        protected String getText() {
            return this.getText((DistributionType)((Object)this.value));
        }

        @Override
        protected String getComment() {
            return null;
        }

        @NotNull
        @NlsContexts.ListItem
        private String getText(@Nullable DistributionType value) {
            if (value != null) {
                switch (value) {
                    case BUNDLED: {
                        String string2 = GradleBundle.message("gradle.settings.text.distribution.bundled", GradleVersion.current().getVersion());
                        if (string2 == null) {
                            DistributionTypeItem.$$$reportNull$$$0(0);
                        }
                        return string2;
                    }
                    case DEFAULT_WRAPPED: {
                        String string3 = GradleBundle.message("gradle.settings.text.distribution.wrapper", new Object[0]);
                        if (string3 == null) {
                            DistributionTypeItem.$$$reportNull$$$0(1);
                        }
                        return string3;
                    }
                    case WRAPPED: {
                        String string4 = GradleBundle.message("gradle.settings.text.distribution.wrapper.task", new Object[0]);
                        if (string4 == null) {
                            DistributionTypeItem.$$$reportNull$$$0(2);
                        }
                        return string4;
                    }
                    case LOCAL: {
                        String string5 = GradleBundle.message("gradle.settings.text.distribution.location", new Object[0]);
                        if (string5 == null) {
                            DistributionTypeItem.$$$reportNull$$$0(3);
                        }
                        return string5;
                    }
                }
            }
            LOG.error("Unexpected: " + value);
            String string6 = GradleBundle.message("gradle.settings.text.unexpected", new Object[]{value});
            if (string6 == null) {
                DistributionTypeItem.$$$reportNull$$$0(4);
            }
            return string6;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$DistributionTypeItem", "getText"));
        }
    }

    private final class TestRunnerItem
    extends MyItem<TestRunner> {
        private TestRunnerItem(TestRunner value) {
            super(value);
        }

        @Override
        protected String getText() {
            return this.getText((TestRunner)((Object)this.value));
        }

        @Override
        protected String getComment() {
            return Comparing.equal((Object)((Object)((TestRunner)((Object)this.value))), (Object)((Object)GradleProjectSettings.DEFAULT_TEST_RUNNER)) ? GradleBundle.message("gradle.settings.text.default", new Object[0]) : null;
        }

        @NotNull
        @NlsContexts.ListItem
        private String getText(@Nullable TestRunner runner) {
            if (runner == TestRunner.GRADLE) {
                return "Gradle";
            }
            if (runner == TestRunner.PLATFORM) {
                String string2 = IdeaGradleProjectSettingsControlBuilder.getIDEName();
                if (string2 == null) {
                    TestRunnerItem.$$$reportNull$$$0(0);
                }
                return string2;
            }
            if (runner == TestRunner.CHOOSE_PER_TEST) {
                String string3 = GradleBundle.message("gradle.settings.text.build.run.per.test", new Object[0]);
                if (string3 == null) {
                    TestRunnerItem.$$$reportNull$$$0(1);
                }
                return string3;
            }
            LOG.error("Unexpected: " + runner);
            String string4 = GradleBundle.message("gradle.settings.text.unexpected", new Object[]{runner});
            if (string4 == null) {
                TestRunnerItem.$$$reportNull$$$0(2);
            }
            return string4;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$TestRunnerItem", "getText"));
        }
    }

    private final class BuildRunItem
    extends MyItem<Boolean> {
        private BuildRunItem(Boolean value) {
            super(value);
        }

        @Override
        protected String getText() {
            return this.getText((Boolean)this.value);
        }

        @Override
        protected String getComment() {
            return Comparing.equal((Object)((Boolean)this.value), (Object)true) ? GradleBundle.message("gradle.settings.text.default", new Object[0]) : null;
        }

        @NotNull
        @NlsContexts.ListItem
        private String getText(@Nullable Boolean state) {
            if (state == Boolean.TRUE) {
                return "Gradle";
            }
            if (state == Boolean.FALSE) {
                String string2 = IdeaGradleProjectSettingsControlBuilder.getIDEName();
                if (string2 == null) {
                    BuildRunItem.$$$reportNull$$$0(0);
                }
                return string2;
            }
            LOG.error("Unexpected: " + state);
            String string3 = GradleBundle.message("gradle.settings.text.unexpected", state);
            if (string3 == null) {
                BuildRunItem.$$$reportNull$$$0(1);
            }
            return string3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$BuildRunItem", "getText"));
        }
    }

    private class DelayedBalloonInfo
    implements Runnable {
        private final MessageType myMessageType;
        @Nls
        private final String myText;
        private final long myTriggerTime;

        DelayedBalloonInfo(@NotNull MessageType messageType, LocationSettingType settingType, long delayMillis) {
            if (messageType == null) {
                DelayedBalloonInfo.$$$reportNull$$$0(0);
            }
            if (settingType == null) {
                DelayedBalloonInfo.$$$reportNull$$$0(1);
            }
            this.myMessageType = messageType;
            this.myText = settingType.getDescription(GradleConstants.SYSTEM_ID);
            this.myTriggerTime = System.currentTimeMillis() + delayMillis;
        }

        @Override
        public void run() {
            long diff = this.myTriggerTime - System.currentTimeMillis();
            if (diff > 0L) {
                IdeaGradleProjectSettingsControlBuilder.this.myAlarm.cancelAllRequests();
                IdeaGradleProjectSettingsControlBuilder.this.myAlarm.addRequest((Runnable)this, diff);
                return;
            }
            if (IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField == null || !IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.isShowing()) {
                return;
            }
            ExternalSystemUiUtil.showBalloon((JComponent)((Object)IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField), (MessageType)this.myMessageType, (String)this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settingType";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$DelayedBalloonInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MyItem<T> {
        @Nullable
        protected final T value;

        private MyItem(@Nullable T value) {
            this.value = value;
        }

        @NlsContexts.ListItem
        protected abstract String getText();

        @NlsContexts.ListItem
        protected abstract String getComment();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MyItem)) {
                return false;
            }
            MyItem item = (MyItem)o;
            return Objects.equals(this.value, item.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static class MyItemCellRenderer<T>
    extends ColoredListCellRenderer<MyItem<T>> {
        private MyItemCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends MyItem<T>> list2, MyItem<T> value, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                MyItemCellRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                return;
            }
            CompositeAppearance.DequeEnd ending = new CompositeAppearance().getEnding();
            ending.addText(value.getText(), MyItemCellRenderer.getTextAttributes(selected));
            if (value.getComment() != null) {
                SimpleTextAttributes commentAttributes = MyItemCellRenderer.getCommentAttributes(selected);
                ending.addComment(value.getComment(), commentAttributes);
            }
            ending.getAppearance().customize((SimpleColoredComponent)this);
        }

        @NotNull
        private static SimpleTextAttributes getTextAttributes(boolean selected) {
            SimpleTextAttributes simpleTextAttributes = selected && (!SystemInfoRt.isWindows || !UIManager.getLookAndFeel().getName().contains("Windows")) ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                MyItemCellRenderer.$$$reportNull$$$0(1);
            }
            return simpleTextAttributes;
        }

        @NotNull
        private static SimpleTextAttributes getCommentAttributes(boolean selected) {
            SimpleTextAttributes simpleTextAttributes = SystemInfo.isMac && selected ? new SimpleTextAttributes(0, (Color)JBColor.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                MyItemCellRenderer.$$$reportNull$$$0(2);
            }
            return simpleTextAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$MyItemCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$MyItemCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommentAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

