/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.MethodProcessorRunnable;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructMethodParametersAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class ClassWrapper {
    private final StructClass classStruct;
    private final Set<String> hiddenMembers = new HashSet<String>();
    private final VBStyleCollection<Exprent, String> staticFieldInitializers = new VBStyleCollection();
    private final VBStyleCollection<Exprent, String> dynamicFieldInitializers = new VBStyleCollection();
    private final VBStyleCollection<MethodWrapper, String> methods = new VBStyleCollection();

    public ClassWrapper(StructClass classStruct) {
        this.classStruct = classStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        DecompilerContext.setProperty("CURRENT_CLASS", this.classStruct);
        DecompilerContext.setProperty("CURRENT_CLASS_WRAPPER", this);
        DecompilerContext.getLogger().startClass(this.classStruct.qualifiedName);
        int maxSec = Integer.parseInt(DecompilerContext.getProperty("mpm").toString());
        boolean testMode = DecompilerContext.getOption("__unit_test_mode__");
        for (StructMethod mt : this.classStruct.getMethods()) {
            boolean isError;
            RootStatement root;
            CounterContainer counter;
            VarProcessor varProc;
            MethodDescriptor md;
            block15: {
                DecompilerContext.getLogger().startMethod(mt.getName() + " " + mt.getDescriptor());
                md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                varProc = new VarProcessor(this.classStruct, mt, md);
                DecompilerContext.startMethod(varProc);
                VarNamesCollector vc = varProc.getVarNamesCollector();
                counter = DecompilerContext.getCounterContainer();
                root = null;
                isError = false;
                try {
                    if (mt.containsCode()) {
                        if (maxSec == 0 || testMode) {
                            root = MethodProcessorRunnable.codeToJava(this.classStruct, mt, md, varProc);
                            break block15;
                        }
                        MethodProcessorRunnable mtProc = new MethodProcessorRunnable(this.classStruct, mt, md, varProc, DecompilerContext.getCurrentContext());
                        Thread mtThread = new Thread((Runnable)mtProc, "Java decompiler");
                        long stopAt = System.currentTimeMillis() + (long)maxSec * 1000L;
                        mtThread.start();
                        while (!mtProc.isFinished()) {
                            try {
                                Object object = mtProc.lock;
                                synchronized (object) {
                                    mtProc.lock.wait(200L);
                                }
                            }
                            catch (InterruptedException e) {
                                ClassWrapper.killThread(mtThread);
                                throw e;
                            }
                            if (System.currentTimeMillis() < stopAt) continue;
                            String message = "Processing time limit exceeded for method " + mt.getName() + ", execution interrupted.";
                            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.ERROR);
                            ClassWrapper.killThread(mtThread);
                            isError = true;
                            break;
                        }
                        if (!isError) {
                            root = mtProc.getResult();
                        }
                        break block15;
                    }
                    int varIndex = 0;
                    if (!mt.hasModifier(8)) {
                        varProc.getThisVars().put(new VarVersionPair(0, 0), this.classStruct.qualifiedName);
                        varProc.setVarName(new VarVersionPair(0, 0), vc.getFreeName(0));
                        varIndex = 1;
                    }
                    for (int i = 0; i < md.params.length; ++i) {
                        varProc.setVarName(new VarVersionPair(varIndex, 0), vc.getFreeName(varIndex));
                        varIndex += md.params[i].getStackSize();
                    }
                }
                catch (Throwable t) {
                    String message = "Method " + mt.getName() + " " + mt.getDescriptor() + " couldn't be decompiled.";
                    DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN, t);
                    isError = true;
                }
            }
            MethodWrapper methodWrapper = new MethodWrapper(root, varProc, mt, counter);
            methodWrapper.decompiledWithErrors = isError;
            this.methods.addWithKey(methodWrapper, InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
            if (!isError) {
                VarNamesCollector namesCollector = new VarNamesCollector();
                this.classStruct.getFields().forEach(f -> namesCollector.addName(f.getName()));
                varProc.refreshVarNames(namesCollector);
                ClassWrapper.applyParameterNames(mt, md, varProc);
                ClassWrapper.applyDebugInfo(mt, varProc, methodWrapper);
            }
            DecompilerContext.getLogger().endMethod();
        }
        DecompilerContext.getLogger().endClass();
    }

    private static void applyParameterNames(StructMethod mt, MethodDescriptor md, VarProcessor varProc) {
        StructMethodParametersAttribute attr;
        if (DecompilerContext.getOption("ump") && (attr = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_METHOD_PARAMETERS)) != null) {
            List<StructMethodParametersAttribute.Entry> entries = attr.getEntries();
            int index = varProc.getFirstParameterVarIndex();
            for (int i = varProc.getFirstParameterPosition(); i < entries.size(); ++i) {
                StructMethodParametersAttribute.Entry entry = entries.get(i);
                if (entry.myName != null) {
                    varProc.setVarName(new VarVersionPair(index, 0), entry.myName);
                }
                if ((entry.myAccessFlags & 0x10) != 0) {
                    varProc.setParameterFinal(new VarVersionPair(index, 0));
                }
                index += md.params[i].getStackSize();
            }
        }
    }

    private static void applyDebugInfo(StructMethod mt, VarProcessor varProc, MethodWrapper methodWrapper) {
        StructLocalVariableTableAttribute attr;
        if (DecompilerContext.getOption("udv") && (attr = mt.getLocalVariableAttr()) != null) {
            varProc.setDebugVarNames(attr.getMapParamNames());
            methodWrapper.getOrBuildGraph().iterateExprents(exprent -> {
                List<Exprent> lst = exprent.getAllExprents(true);
                lst.add(exprent);
                lst.stream().filter(e -> e.type == 12).forEach(e -> {
                    VarExprent varExprent = (VarExprent)e;
                    String name = varExprent.getDebugName(mt);
                    if (name != null) {
                        varProc.setVarName(varExprent.getVarVersionPair(), name);
                    }
                });
                return 0;
            });
        }
    }

    private static void killThread(Thread thread) {
        thread.stop();
    }

    public MethodWrapper getMethodWrapper(String name, String descriptor) {
        return this.methods.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public StructClass getClassStruct() {
        return this.classStruct;
    }

    public VBStyleCollection<MethodWrapper, String> getMethods() {
        return this.methods;
    }

    public Set<String> getHiddenMembers() {
        return this.hiddenMembers;
    }

    public VBStyleCollection<Exprent, String> getStaticFieldInitializers() {
        return this.staticFieldInitializers;
    }

    public VBStyleCollection<Exprent, String> getDynamicFieldInitializers() {
        return this.dynamicFieldInitializers;
    }

    public String toString() {
        return this.classStruct.qualifiedName;
    }
}

