/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.TempUIThemeBasedLookAndFeelInfo;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import javax.swing.UIManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplyThemeAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ApplyThemeAction.$$$reportNull$$$0(0);
        }
        ApplyThemeAction.applyTempTheme(e);
    }

    @Contract(value="null -> false")
    private static boolean isThemeFile(@Nullable VirtualFile file) {
        return file != null && StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)".theme.json");
    }

    public static boolean applyTempTheme(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ApplyThemeAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return false;
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (!ApplyThemeAction.isThemeFile(file)) {
            file = null;
        }
        if (file == null) {
            for (VirtualFile virtualFile : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
                if (!ApplyThemeAction.isThemeFile(virtualFile)) continue;
                file = virtualFile;
                break;
            }
        }
        if (file == null) {
            file = (VirtualFile)ContainerUtil.getFirstItem((Collection)FilenameIndex.getAllFilesByExt((Project)project, (String)"theme.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
        }
        if (file != null && ApplyThemeAction.isThemeFile(file)) {
            return ApplyThemeAction.applyTempTheme(file, project);
        }
        return false;
    }

    private static boolean applyTempTheme(@NotNull VirtualFile json, @NotNull Project project) {
        if (json == null) {
            ApplyThemeAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ApplyThemeAction.$$$reportNull$$$0(3);
        }
        try {
            VirtualFile editorSchemeFile;
            FileDocumentManager.getInstance().saveAllDocuments();
            final Module module = ModuleUtilCore.findModuleForFile((VirtualFile)json, (Project)project);
            UITheme theme = TempUIThemeBasedLookAndFeelInfo.loadTempTheme((InputStream)json.getInputStream(), (IconPathPatcher)new IconPathPatcher(){

                @NotNull
                public String patchPath(@NotNull String path, @Nullable ClassLoader classLoader) {
                    if (path == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String result = module != null ? ApplyThemeAction.findAbsoluteFilePathByRelativePath(module, path) : null;
                    String string = result != null ? result : path;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/idea/devkit/themes/actions/ApplyThemeAction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/idea/devkit/themes/actions/ApplyThemeAction$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "patchPath";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "patchPath";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            if (module != null) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                editorSchemeFile = ApplyThemeAction.findThemeFile(moduleRootManager, theme.getEditorScheme());
                ApplyThemeAction.patchBackgroundImagePath(moduleRootManager, theme.getBackground());
                ApplyThemeAction.patchBackgroundImagePath(moduleRootManager, theme.getEmptyFrameBackground());
            } else {
                editorSchemeFile = null;
            }
            LafManager lafManager = LafManager.getInstance();
            lafManager.setCurrentLookAndFeel((UIManager.LookAndFeelInfo)new TempUIThemeBasedLookAndFeelInfo(theme, editorSchemeFile, lafManager.getCurrentLookAndFeel()));
            IconLoader.clearCache();
            lafManager.updateUI();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static void patchBackgroundImagePath(@NotNull ModuleRootManager moduleRootManager, @Nullable Map<String, Object> background) {
        VirtualFile pathToBg;
        if (moduleRootManager == null) {
            ApplyThemeAction.$$$reportNull$$$0(4);
        }
        if (background != null && (pathToBg = ApplyThemeAction.findThemeFile(moduleRootManager, background.get("image").toString())) != null) {
            background.put("image", pathToBg.getPath());
        }
    }

    @Nullable
    private static VirtualFile findThemeFile(@NotNull ModuleRootManager moduleRootManager, @Nullable String pathToFile) {
        if (moduleRootManager == null) {
            ApplyThemeAction.$$$reportNull$$$0(5);
        }
        if (pathToFile != null) {
            for (VirtualFile root : moduleRootManager.getSourceRoots(false)) {
                Path path = Paths.get(root.getPath(), pathToFile);
                if (!path.toFile().exists()) continue;
                return VfsUtil.findFile((Path)path, (boolean)true);
            }
        }
        return null;
    }

    @Nullable
    private static String findAbsoluteFilePathByRelativePath(@NotNull Module module, @NotNull String relativePath) {
        if (module == null) {
            ApplyThemeAction.$$$reportNull$$$0(6);
        }
        if (relativePath == null) {
            ApplyThemeAction.$$$reportNull$$$0(7);
        }
        String filename = new File(relativePath).getName();
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleScope((Module)module);
        Collection filesByName = FilenameIndex.getVirtualFilesByName((String)filename, (GlobalSearchScope)moduleScope);
        for (VirtualFile file : filesByName) {
            String path = file.getPath();
            if (!path.endsWith(relativePath) && !path.endsWith(relativePath.replaceAll("/", "\\"))) continue;
            return "file://" + path;
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ApplyThemeAction.$$$reportNull$$$0(8);
        }
        if (LafManager.getInstance().getCurrentLookAndFeel() instanceof TempUIThemeBasedLookAndFeelInfo) {
            e.getPresentation().setIcon(AllIcons.Actions.Rerun);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ApplyThemeAction.$$$reportNull$$$0(9);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRootManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/themes/actions/ApplyThemeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/themes/actions/ApplyThemeAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyTempTheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "patchBackgroundImagePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findThemeFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findAbsoluteFilePathByRelativePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

