/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleListCellRenderer;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CreateHtmlDescriptionFix
implements LocalQuickFix,
Iconable {
    @NonNls
    private static final String TEMPLATE_NAME = "InspectionDescription.html";
    private final String myFilename;
    private final Module myModule;
    private final DescriptionType myDescriptionType;

    public CreateHtmlDescriptionFix(String filename, Module module, DescriptionType descriptionType) {
        this.myModule = module;
        this.myDescriptionType = descriptionType;
        this.myFilename = this.getNormalizedFileName(filename);
    }

    private boolean isFixedDescriptionFilename() {
        return this.myDescriptionType.isFixedDescriptionFilename();
    }

    private static List<VirtualFile> getPotentialRoots(Module module, PsiDirectory[] dirs) {
        if (dirs.length != 0) {
            return StreamEx.of((Object[])dirs).map(PsiDirectory::getParentDirectory).nonNull().map(PsiDirectory::getVirtualFile).toList();
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        List resourceRoots = rootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        if (!resourceRoots.isEmpty()) {
            return resourceRoots;
        }
        return rootManager.getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
    }

    private String getNormalizedFileName(String filename) {
        return this.myDescriptionType.isFixedDescriptionFilename() ? filename : filename + ".html";
    }

    @NotNull
    public String getName() {
        String string = DevKitBundle.message("create.description.file", this.getNewFileName());
        if (string == null) {
            CreateHtmlDescriptionFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("create.description.file.family.name", new Object[0]);
        if (string == null) {
            CreateHtmlDescriptionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiDirectory[] dirs;
        List<VirtualFile> roots;
        if (project == null) {
            CreateHtmlDescriptionFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            CreateHtmlDescriptionFix.$$$reportNull$$$0(3);
        }
        if ((roots = CreateHtmlDescriptionFix.getPotentialRoots(this.myModule, dirs = this.getDirectories())).size() == 1) {
            ApplicationManager.getApplication().runWriteAction(() -> this.createDescription((VirtualFile)roots.get(0)));
        } else {
            Editor editor = FileEditorManager.getInstance((Project)this.myModule.getProject()).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            JBPopupFactory.getInstance().createPopupChooserBuilder(roots).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", VirtualFile::getPath)).setSelectionMode(0).setTitle(DevKitBundle.message("select.target.location.of.description", this.myFilename)).setItemChosenCallback(root -> ApplicationManager.getApplication().runWriteAction(() -> this.createDescription((VirtualFile)root))).createPopup().showInBestPositionFor(editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private String getPath(VirtualFile file) {
        String path = file.getPresentableUrl() + File.separator + this.getDescriptionFolderName() + File.separator + this.myFilename;
        if (this.isFixedDescriptionFilename()) {
            path = path + File.separator + "description.html";
        }
        return path;
    }

    private PsiDirectory[] getDirectories() {
        return DescriptionCheckerUtil.getDescriptionsDirs(this.myModule, this.myDescriptionType);
    }

    private void createDescription(VirtualFile root) {
        if (!root.isDirectory()) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
        PsiDirectory psiRoot = psiManager.findDirectory(root);
        if (psiRoot == null) {
            return;
        }
        PsiDirectory descrRoot = StreamEx.of((Object[])psiRoot.getSubdirectories()).findFirst(dir -> this.getDescriptionFolderName().equals(dir.getName())).orElse(null);
        try {
            VirtualFile file;
            FileTemplate descrTemplate;
            PsiElement template;
            PsiDirectory dir2;
            PsiDirectory psiDirectory = descrRoot = descrRoot == null ? psiRoot.createSubdirectory(this.getDescriptionFolderName()) : descrRoot;
            if (this.isFixedDescriptionFilename() && (dir2 = descrRoot.findSubdirectory(this.myFilename)) == null) {
                descrRoot = descrRoot.createSubdirectory(this.myFilename);
            }
            if ((template = FileTemplateUtil.createFromTemplate((FileTemplate)(descrTemplate = FileTemplateManager.getInstance((Project)this.myModule.getProject()).getJ2eeTemplate(TEMPLATE_NAME)), (String)this.getNewFileName(), null, (PsiDirectory)descrRoot)) instanceof PsiFile && (file = ((PsiFile)template).getVirtualFile()) != null) {
                FileEditorManager.getInstance((Project)this.myModule.getProject()).openFile(file, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getNewFileName() {
        return this.isFixedDescriptionFilename() ? "description.html" : this.myFilename;
    }

    public Icon getIcon(int flags2) {
        return new LayeredIcon(new Icon[]{AllIcons.FileTypes.Html, AllIcons.Actions.New});
    }

    private VirtualFile[] prepare(VirtualFile[] roots) {
        VirtualFile[] found = (VirtualFile[])Arrays.stream(roots).filter(this::containsDescriptionDir).toArray(VirtualFile[]::new);
        return found.length > 0 ? found : roots;
    }

    private boolean containsDescriptionDir(VirtualFile root) {
        if (!root.isDirectory()) {
            return false;
        }
        return Arrays.stream(root.getChildren()).anyMatch(file -> file.isDirectory() && this.getDescriptionFolderName().equals(file.getName()));
    }

    private String getDescriptionFolderName() {
        return this.myDescriptionType.getDescriptionFolder();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

