/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PerformWithDocumentsCommitted;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;

public class GenerateComponentExternalizationAction
extends AnAction
implements PerformWithDocumentsCommitted {
    private static final Logger LOG = Logger.getInstance(GenerateComponentExternalizationAction.class);
    @NonNls
    private static final String BASE_COMPONENT = "com.intellij.openapi.components.BaseComponent";
    @NonNls
    private static final String PERSISTENCE_STATE_COMPONENT = "com.intellij.openapi.components.PersistentStateComponent";
    @NonNls
    private static final String STATE = "com.intellij.openapi.components.State";
    @NonNls
    private static final String STORAGE = "com.intellij.openapi.components.Storage";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GenerateComponentExternalizationAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateComponentExternalizationAction.$$$reportNull$$$0(1);
        }
        PsiClass target = GenerateComponentExternalizationAction.getComponentInContext(e.getDataContext());
        assert (target != null);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)target.getProject()).getElementFactory();
        CodeStyleManager formatter = CodeStyleManager.getInstance((Project)target.getManager().getProject());
        JavaCodeStyleManager styler = JavaCodeStyleManager.getInstance((Project)target.getProject());
        String qualifiedName = target.getQualifiedName();
        Runnable runnable = () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                PsiReferenceList implList = target.getImplementsList();
                assert (implList != null);
                PsiJavaCodeReferenceElement referenceElement = factory.createReferenceFromText("com.intellij.openapi.components.PersistentStateComponent<" + qualifiedName + ">", (PsiElement)target);
                implList.add(styler.shortenClassReferences(referenceElement.copy()));
                PsiMethod read = factory.createMethodFromText("public void loadState(" + qualifiedName + " state) {\n    com.intellij.util.xmlb.XmlSerializerUtil.copyBean(state, this);\n}", (PsiElement)target);
                read = (PsiMethod)formatter.reformat(target.add((PsiElement)read));
                styler.shortenClassReferences((PsiElement)read);
                PsiMethod write = factory.createMethodFromText("public " + qualifiedName + " getState() {\n    return this;\n}\n", (PsiElement)target);
                write = (PsiMethod)formatter.reformat(target.add((PsiElement)write));
                styler.shortenClassReferences((PsiElement)write);
                PsiAnnotation annotation = target.getModifierList().addAnnotation(STATE);
                annotation = (PsiAnnotation)formatter.reformat(annotation.replace((PsiElement)factory.createAnnotationFromText("@com.intellij.openapi.components.State(name = \"" + qualifiedName + "\", storages = {@com.intellij.openapi.components.Storage(file = \"$WORKSPACE_FILE$\"\n )})", (PsiElement)target)));
                styler.shortenClassReferences((PsiElement)annotation);
            }
            catch (IncorrectOperationException e1) {
                LOG.error((Throwable)e1);
            }
        });
        CommandProcessor.getInstance().executeCommand(target.getProject(), runnable, DevKitBundle.message("command.implement.externalizable", new Object[0]), null);
    }

    @Nullable
    private static PsiClass getComponentInContext(DataContext context) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (editor == null || project == null) {
            return null;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (file == null) {
            return null;
        }
        PsiClass contextClass = (PsiClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset(), PsiClass.class, (boolean)false);
        if (contextClass == null || contextClass.isEnum() || contextClass.isInterface() || contextClass instanceof PsiAnonymousClass) {
            return null;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)file.getProject());
        PsiClass componentClass = javaPsiFacade.findClass(BASE_COMPONENT, file.getResolveScope());
        if (componentClass == null || !contextClass.isInheritor(componentClass, true)) {
            return null;
        }
        PsiClass persistenceStateComponentClass = javaPsiFacade.findClass(PERSISTENCE_STATE_COMPONENT, file.getResolveScope());
        if (persistenceStateComponentClass == null || contextClass.isInheritor(persistenceStateComponentClass, true)) {
            return null;
        }
        return contextClass;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateComponentExternalizationAction.$$$reportNull$$$0(2);
        }
        PsiClass target = GenerateComponentExternalizationAction.getComponentInContext(e.getDataContext());
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(target != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/actions/GenerateComponentExternalizationAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/actions/GenerateComponentExternalizationAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

