/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import freemarker.template.Template;
import java.io.IOException;
import jetbrains.coverage.report.impl.FooterInfos;
import jetbrains.coverage.report.impl.html.TemplateFactory;
import jetbrains.coverage.report.impl.html.TemplateProcessor;
import jetbrains.coverage.report.impl.html.TemplateProcessorBase;
import jetbrains.coverage.report.impl.html.fs.FileSystem;
import org.jetbrains.annotations.NotNull;

public class TemplateProcessorFactory {
    private final TemplateFactory myFactory;
    private final String myResourceBundleName;
    private final boolean myIncludeModule;
    private final FooterInfos myFooterInfos;
    private final FileSystem myFS;

    public TemplateProcessorFactory(@NotNull TemplateFactory factory, @NotNull String resourceBundleName, boolean includeModule, @NotNull FooterInfos footerText, @NotNull FileSystem fs) {
        this.myFactory = factory;
        this.myResourceBundleName = resourceBundleName;
        this.myIncludeModule = includeModule;
        this.myFooterInfos = footerText;
        this.myFS = fs;
    }

    @NotNull
    public TemplateProcessor createEmptyTemplate() {
        return new TemplateProcessorBase(this.myResourceBundleName, this.myIncludeModule, this.myFS){

            protected String getFooterText() {
                return TemplateProcessorFactory.this.myFooterInfos.getModulesIndexFooterHTML();
            }

            @NotNull
            protected Template createTemplate() throws IOException {
                return TemplateProcessorFactory.this.myFactory.createEmptyTemplate();
            }
        };
    }

    @NotNull
    public TemplateProcessor createModulesIndexProcessor() {
        return new TemplateProcessorBase(this.myResourceBundleName, this.myIncludeModule, this.myFS){

            @NotNull
            protected Template createTemplate() throws IOException {
                return TemplateProcessorFactory.this.myFactory.createModulesIndexTemplate();
            }

            protected String getFooterText() {
                return TemplateProcessorFactory.this.myFooterInfos.getModulesIndexFooterHTML();
            }
        };
    }

    @NotNull
    public TemplateProcessor createNamespacesIndexProcessor() {
        return new TemplateProcessorBase(this.myResourceBundleName, this.myIncludeModule, this.myFS){

            @NotNull
            protected Template createTemplate() throws IOException {
                return TemplateProcessorFactory.this.myFactory.createNamespacesPerModuleIndexTemplate();
            }

            protected String getFooterText() {
                return TemplateProcessorFactory.this.myFooterInfos.getNamespacesIndexFooterHTML();
            }
        };
    }

    @NotNull
    public TemplateProcessor createClassesIndexProcessor() {
        return new TemplateProcessorBase(this.myResourceBundleName, this.myIncludeModule, this.myFS){

            @NotNull
            protected Template createTemplate() throws IOException {
                return TemplateProcessorFactory.this.myFactory.createNamespaceIndexTemplate();
            }

            protected String getFooterText() {
                return TemplateProcessorFactory.this.myFooterInfos.getClassesIndexFooterHTML();
            }
        };
    }

    @NotNull
    public TemplateProcessor createClassSourceProcessor() {
        return new TemplateProcessorBase(this.myResourceBundleName, this.myIncludeModule, this.myFS){

            @NotNull
            protected Template createTemplate() throws IOException {
                return TemplateProcessorFactory.this.myFactory.createClassCoverageTemplate();
            }

            protected String getFooterText() {
                return TemplateProcessorFactory.this.myFooterInfos.getSourceFooterHTML();
            }
        };
    }
}

