/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0007J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0007J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0007J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010+\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/resolve/InlineClassDescriptorResolver;", "", "()V", "BOXING_VALUE_PARAMETER_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getBOXING_VALUE_PARAMETER_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "BOX_METHOD_NAME", "SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME", "getSPECIALIZED_EQUALS_FIRST_PARAMETER_NAME", "SPECIALIZED_EQUALS_NAME", "SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME", "getSPECIALIZED_EQUALS_SECOND_PARAMETER_NAME", "UNBOX_METHOD_NAME", "createBoxFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "owner", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createConversionFunctionDescriptor", "isBoxMethod", "", "createSpecializedEqualsDescriptor", "createUnboxFunctionDescriptor", "createValueParameter", "Lorg/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "name", "index", "", "createValueParameterForBoxing", "underlyingType", "createValueParametersForSpecializedEquals", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "isSpecializedEqualsMethod", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isSynthesizedBoxMethod", "isSynthesizedBoxOrUnboxMethod", "isSynthesizedInlineClassMember", "isSynthesizedInlineClassMemberWithName", "isSynthesizedUnboxMethod", "frontend"})
public final class InlineClassDescriptorResolver {
    @NotNull
    public static final InlineClassDescriptorResolver INSTANCE = new InlineClassDescriptorResolver();
    @JvmField
    @NotNull
    public static final Name BOX_METHOD_NAME;
    @JvmField
    @NotNull
    public static final Name UNBOX_METHOD_NAME;
    @JvmField
    @NotNull
    public static final Name SPECIALIZED_EQUALS_NAME;
    @NotNull
    private static final Name BOXING_VALUE_PARAMETER_NAME;
    @NotNull
    private static final Name SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME;
    @NotNull
    private static final Name SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME;

    private InlineClassDescriptorResolver() {
    }

    @NotNull
    public final Name getBOXING_VALUE_PARAMETER_NAME() {
        return BOXING_VALUE_PARAMETER_NAME;
    }

    @NotNull
    public final Name getSPECIALIZED_EQUALS_FIRST_PARAMETER_NAME() {
        return SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME;
    }

    @NotNull
    public final Name getSPECIALIZED_EQUALS_SECOND_PARAMETER_NAME() {
        return SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME;
    }

    @JvmStatic
    @NotNull
    public static final SimpleFunctionDescriptor createBoxFunctionDescriptor(@NotNull ClassDescriptor owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return INSTANCE.createConversionFunctionDescriptor(true, owner);
    }

    @JvmStatic
    @NotNull
    public static final SimpleFunctionDescriptor createUnboxFunctionDescriptor(@NotNull ClassDescriptor owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return INSTANCE.createConversionFunctionDescriptor(false, owner);
    }

    @JvmStatic
    public static final boolean isSynthesizedBoxMethod(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return INSTANCE.isSynthesizedInlineClassMemberWithName(descriptor2, BOX_METHOD_NAME);
    }

    @JvmStatic
    public static final boolean isSynthesizedUnboxMethod(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return INSTANCE.isSynthesizedInlineClassMemberWithName(descriptor2, UNBOX_METHOD_NAME);
    }

    @JvmStatic
    public static final boolean isSynthesizedBoxOrUnboxMethod(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return INSTANCE.isSynthesizedInlineClassMember(descriptor2) && (Intrinsics.areEqual((Object)descriptor2.getName(), (Object)BOX_METHOD_NAME) || Intrinsics.areEqual((Object)descriptor2.getName(), (Object)UNBOX_METHOD_NAME));
    }

    @JvmStatic
    public static final boolean isSpecializedEqualsMethod(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return INSTANCE.isSynthesizedInlineClassMemberWithName(descriptor2, SPECIALIZED_EQUALS_NAME);
    }

    private final boolean isSynthesizedInlineClassMemberWithName(CallableMemberDescriptor descriptor2, Name name) {
        return this.isSynthesizedInlineClassMember(descriptor2) && Intrinsics.areEqual((Object)descriptor2.getName(), (Object)name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSynthesizedInlineClassMember(CallableMemberDescriptor descriptor2) {
        if (descriptor2.getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED) return false;
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        if (!InlineClassesUtilsKt.isInlineClass(declarationDescriptor)) return false;
        return true;
    }

    @NotNull
    public final SimpleFunctionDescriptor createSpecializedEqualsDescriptor(@NotNull ClassDescriptor owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create(owner, Annotations.Companion.getEMPTY(), SPECIALIZED_EQUALS_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE);
        Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptorImpl, (String)"create(\n            owne\u2026ement.NO_SOURCE\n        )");
        SimpleFunctionDescriptorImpl functionDescriptor = simpleFunctionDescriptorImpl;
        List list2 = CollectionsKt.emptyList();
        List list3 = CollectionsKt.emptyList();
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        InlineClassRepresentation<SimpleType> inlineClassRepresentation = DescriptorUtilsKt.getInlineClassRepresentation(owner);
        Intrinsics.checkNotNull(inlineClassRepresentation);
        functionDescriptor.initialize((ReceiverParameterDescriptor)null, (ReceiverParameterDescriptor)null, list2, list3, (List)this.createValueParametersForSpecializedEquals(functionDescriptor2, (KotlinType)inlineClassRepresentation.getUnderlyingType()), (KotlinType)DescriptorUtilsKt.getBuiltIns(owner).getBooleanType(), Modality.FINAL, DescriptorVisibilities.PUBLIC);
        return functionDescriptor;
    }

    private final SimpleFunctionDescriptor createConversionFunctionDescriptor(boolean isBoxMethod, ClassDescriptor owner) {
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create(owner, Annotations.Companion.getEMPTY(), isBoxMethod ? BOX_METHOD_NAME : UNBOX_METHOD_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE);
        Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptorImpl, (String)"create(\n            owne\u2026ement.NO_SOURCE\n        )");
        SimpleFunctionDescriptorImpl functionDescriptor = simpleFunctionDescriptorImpl;
        InlineClassRepresentation<SimpleType> inlineClassRepresentation = DescriptorUtilsKt.getInlineClassRepresentation(owner);
        Intrinsics.checkNotNull(inlineClassRepresentation);
        SimpleType underlyingType = (SimpleType)inlineClassRepresentation.getUnderlyingType();
        functionDescriptor.initialize((ReceiverParameterDescriptor)null, isBoxMethod ? null : owner.getThisAsReceiverParameter(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), isBoxMethod ? CollectionsKt.listOf((Object)this.createValueParameterForBoxing(functionDescriptor, underlyingType)) : CollectionsKt.emptyList(), (KotlinType)(isBoxMethod ? owner.getDefaultType() : underlyingType), Modality.FINAL, DescriptorVisibilities.PUBLIC);
        return functionDescriptor;
    }

    private final ValueParameterDescriptorImpl createValueParameterForBoxing(FunctionDescriptor functionDescriptor, KotlinType underlyingType) {
        return this.createValueParameter(functionDescriptor, underlyingType, BOXING_VALUE_PARAMETER_NAME, 0);
    }

    private final List<ValueParameterDescriptor> createValueParametersForSpecializedEquals(FunctionDescriptor functionDescriptor, KotlinType underlyingType) {
        Object[] objectArray = new ValueParameterDescriptorImpl[]{this.createValueParameter(functionDescriptor, underlyingType, SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME, 0), this.createValueParameter(functionDescriptor, underlyingType, SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME, 1)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final ValueParameterDescriptorImpl createValueParameter(FunctionDescriptor functionDescriptor, KotlinType type2, Name name, int index2) {
        CallableDescriptor callableDescriptor = functionDescriptor;
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
        return new ValueParameterDescriptorImpl(callableDescriptor, null, index2, annotations2, name, type2, false, false, false, null, sourceElement);
    }

    static {
        Name name = Name.identifier((String)"box");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"box\")");
        BOX_METHOD_NAME = name;
        Name name2 = Name.identifier((String)"unbox");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"unbox\")");
        UNBOX_METHOD_NAME = name2;
        Name name3 = Name.identifier((String)"equals-impl0");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(\"equals-impl0\")");
        SPECIALIZED_EQUALS_NAME = name3;
        Name name4 = Name.identifier((String)"v");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(\"v\")");
        BOXING_VALUE_PARAMETER_NAME = name4;
        Name name5 = Name.identifier((String)"p1");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(\"p1\")");
        SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME = name5;
        Name name6 = Name.identifier((String)"p2");
        Intrinsics.checkNotNullExpressionValue((Object)name6, (String)"identifier(\"p2\")");
        SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME = name6;
    }
}

