/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering$EnumClassTransformer$run$;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "EnumClassTransformer", "backend.jvm.lower"})
final class EnumClassLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public EnumClassLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (!IrUtilsKt.isEnumClass((IrClass)irClass)) {
            return;
        }
        new EnumClassTransformer(irClass).run();
    }

    public void lower(@NotNull IrFile irFile) {
        ClassLoweringPass.DefaultImpls.lower((ClassLoweringPass)this, (IrFile)irFile);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0006\u0010\u001c\u001a\u00020\u001dR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u000ej\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "declarationToEnumEntry", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "enumEntryOrdinals", "Lgnu/trove/TObjectIntHashMap;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "loweredEnumConstructorParameters", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lkotlin/collections/HashMap;", "loweredEnumConstructors", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildEnumEntryField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "enumEntry", "buildValuesField", "valuesHelperFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "buildValuesHelperFunction", "run", "", "EnumClassCallTransformer", "EnumClassDeclarationsTransformer", "backend.jvm.lower"})
    private final class EnumClassTransformer {
        @NotNull
        private final IrClass irClass;
        @NotNull
        private final HashMap<IrConstructorSymbol, IrConstructor> loweredEnumConstructors;
        @NotNull
        private final HashMap<IrValueParameterSymbol, IrValueParameter> loweredEnumConstructorParameters;
        @NotNull
        private final TObjectIntHashMap<IrEnumEntry> enumEntryOrdinals;
        @NotNull
        private final Map<IrDeclaration, IrEnumEntry> declarationToEnumEntry;

        public EnumClassTransformer(IrClass irClass) {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            this.irClass = irClass;
            this.loweredEnumConstructors = new HashMap();
            this.loweredEnumConstructorParameters = new HashMap();
            this.enumEntryOrdinals = new TObjectIntHashMap();
            this.declarationToEnumEntry = new LinkedHashMap();
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        public final void run() {
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)this.irClass.getDeclarations());
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)EnumClassTransformer$run$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$forEach$iv = SequencesKt.withIndex((Sequence)sequence2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IndexedValue indexedValue = (IndexedValue)element$iv;
                boolean bl = false;
                int index2 = indexedValue.component1();
                IrEnumEntry enumEntry = (IrEnumEntry)indexedValue.component2();
                this.enumEntryOrdinals.put((Object)enumEntry, index2);
                if (enumEntry.getCorrespondingClass() != null) {
                    IrClass entryClass;
                    boolean bl2 = false;
                    this.declarationToEnumEntry.put((IrDeclaration)entryClass, enumEntry);
                }
                this.declarationToEnumEntry.put((IrDeclaration)this.buildEnumEntryField(enumEntry), enumEntry);
            }
            CollectionsKt.removeAll((List)this.irClass.getDeclarations(), (Function1)run.2.INSTANCE);
            CollectionsKt.addAll((Collection)this.irClass.getDeclarations(), (Iterable)this.declarationToEnumEntry.keySet());
            IrFunction valuesHelperFunction = this.buildValuesHelperFunction();
            IrField valuesField = this.buildValuesField(valuesHelperFunction);
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)this.irClass), (IrElementTransformerVoid)new EnumClassDeclarationsTransformer(valuesField));
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)this.irClass), (IrElementTransformerVoid)((IrElementTransformerVoid)new EnumClassCallTransformer()));
        }

        private final IrField buildEnumEntryField(IrEnumEntry enumEntry) {
            IrField irField;
            IrField $this$buildEnumEntryField_u24lambda_u2d2 = irField = EnumClassLowering.this.getContext().getCachedDeclarations().getFieldForEnumEntry(enumEntry);
            boolean bl = false;
            IrExpressionBody irExpressionBody = enumEntry.getInitializerExpression();
            Intrinsics.checkNotNull((Object)irExpressionBody);
            $this$buildEnumEntryField_u24lambda_u2d2.setInitializer((IrExpressionBody)new IrExpressionBodyImpl((IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)irExpressionBody.getExpression()), (IrDeclarationParent)((IrDeclarationParent)$this$buildEnumEntryField_u24lambda_u2d2))));
            $this$buildEnumEntryField_u24lambda_u2d2.setAnnotations(CollectionsKt.plus((Collection)$this$buildEnumEntryField_u24lambda_u2d2.getAnnotations(), (Iterable)enumEntry.getAnnotations()));
            return irField;
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction buildValuesHelperFunction() {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$irArray$iv;
            IrArrayBuilder irArrayBuilder;
            void $this$buildValuesHelperFunction_u24lambda_u2d6_u24lambda_u2d5;
            IrSimpleFunction irSimpleFunction;
            void $this$addFunction$iv;
            IrClass irClass = this.irClass;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction22 = false;
            IrFactory $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$buildValuesHelperFunction_u24lambda_u2d3 = $this$buildFun_u24lambda_u2d16$iv$iv$iv;
            boolean bl2 = false;
            Name name = Name.identifier((String)"$values");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(VALUES_HELPER_FUNCTION_NAME)");
            $this$buildValuesHelperFunction_u24lambda_u2d3.setName(name);
            IrType[] irTypeArray = new IrType[]{(IrType)IrUtilsKt.getDefaultType((IrClass)this.irClass)};
            $this$buildValuesHelperFunction_u24lambda_u2d3.setReturnType((IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)enumClassLowering.getContext().getIrBuiltIns().getArrayClass()), (IrType[])irTypeArray));
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$buildValuesHelperFunction_u24lambda_u2d3.setVisibility(descriptorVisibility);
            $this$buildValuesHelperFunction_u24lambda_u2d3.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.SYNTHETIC_HELPER_FOR_ENUM_VALUES.INSTANCE);
            IrSimpleFunction function$iv$iv = irSimpleFunction = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2d16$iv$iv$iv);
            boolean $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add(function$iv$iv);
            function$iv$iv.setParent((IrDeclarationParent)((IrDeclarationContainer)$this$addFunction$iv));
            irClass = irSimpleFunction;
            enumClassLowering = EnumClassLowering.this;
            IrClass $this$buildValuesHelperFunction_u24lambda_u2d6 = irClass;
            boolean bl3 = false;
            JvmIrBuilder $i$f$addFunction22 = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.getContext(), (IrSymbol)$this$buildValuesHelperFunction_u24lambda_u2d6.getSymbol(), 0, 0, 6, null);
            irSimpleFunction = $this$buildValuesHelperFunction_u24lambda_u2d6;
            boolean bl4 = false;
            void $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = $this$buildValuesHelperFunction_u24lambda_u2d6_u24lambda_u2d5;
            IrType arrayType$iv = $this$buildValuesHelperFunction_u24lambda_u2d6.getReturnType();
            boolean $i$f$irArray = false;
            IrArrayBuilder $this$irArray_u24lambda_u2d0$iv = irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
            boolean bl5 = false;
            IrArrayBuilder irArrayBuilder2 = $this$irArray_u24lambda_u2d0$iv;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildValuesHelperFunction_u24lambda_u2d6_u24lambda_u2d5;
            boolean bl6 = false;
            Iterable $this$filterIsInstance$iv = this.declarationToEnumEntry.keySet();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrField)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (IrField irField : (List)destination$iv$iv) {
                void $this$buildValuesHelperFunction_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4;
                $this$buildValuesHelperFunction_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.unaryPlus((IrExpression)ExpressionHelpersKt.irGetField((IrBuilderWithScope)((IrBuilderWithScope)$this$buildValuesHelperFunction_u24lambda_u2d6_u24lambda_u2d5), null, (IrField)irField));
            }
            irSimpleFunction.setBody((IrBody)ExpressionHelpersKt.irExprBody((IrBuilderWithScope)irBuilderWithScope, (IrExpression)irArrayBuilder.build()));
            return (IrFunction)irClass;
        }

        /*
         * WARNING - void declaration
         */
        private final IrField buildValuesField(IrFunction valuesHelperFunction) {
            void $this$buildValuesField_u24lambda_u2d9_u24lambda_u2d8;
            void $this$addField$iv;
            IrClass irClass = this.irClass;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            boolean $i$f$addField = false;
            IrFactory $this$buildField$iv$iv = $this$addField$iv.getFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u2d4$iv$iv = new IrFieldBuilder();
            boolean bl = false;
            IrFieldBuilder $this$buildValuesField_u24lambda_u2d7 = $this$buildField_u24lambda_u2d4$iv$iv;
            boolean bl2 = false;
            Name name = Name.identifier((String)"$VALUES");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(Implementatio\u2026n.ENUM_VALUES_FIELD_NAME)");
            $this$buildValuesField_u24lambda_u2d7.setName(name);
            IrType[] irTypeArray = new IrType[]{(IrType)IrUtilsKt.getDefaultType((IrClass)this.irClass)};
            $this$buildValuesField_u24lambda_u2d7.setType((IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)enumClassLowering.getContext().getIrBuiltIns().getArrayClass()), (IrType[])irTypeArray));
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$buildValuesField_u24lambda_u2d7.setVisibility(descriptorVisibility);
            $this$buildValuesField_u24lambda_u2d7.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.FIELD_FOR_ENUM_VALUES.INSTANCE);
            $this$buildValuesField_u24lambda_u2d7.setFinal(true);
            $this$buildValuesField_u24lambda_u2d7.setStatic(true);
            Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, (IrFieldBuilder)$this$buildField_u24lambda_u2d4$iv$iv);
            boolean bl3 = false;
            field$iv.setParent((IrDeclarationParent)$this$addField$iv);
            $this$addField$iv.getDeclarations().add(field$iv);
            irClass = $this$buildField$iv$iv;
            enumClassLowering = EnumClassLowering.this;
            IrClass $this$buildValuesField_u24lambda_u2d9 = irClass;
            boolean bl4 = false;
            field$iv = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.getContext(), (IrSymbol)$this$buildValuesField_u24lambda_u2d9.getSymbol(), 0, 0, 6, null);
            IrClass irClass2 = $this$buildValuesField_u24lambda_u2d9;
            boolean bl5 = false;
            irClass2.setInitializer(ExpressionHelpersKt.irExprBody((IrBuilderWithScope)((IrBuilderWithScope)$this$buildValuesField_u24lambda_u2d9_u24lambda_u2d8), (IrExpression)((IrExpression)ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$buildValuesField_u24lambda_u2d9_u24lambda_u2d8), (IrFunctionSymbol)valuesHelperFunction.getSymbol()))));
            return irClass;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "valuesField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "getValuesField", "()Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.jvm.lower"})
        private final class EnumClassDeclarationsTransformer
        extends IrElementTransformerVoid {
            @NotNull
            private final IrField valuesField;

            public EnumClassDeclarationsTransformer(IrField valuesField) {
                Intrinsics.checkNotNullParameter((Object)valuesField, (String)"valuesField");
                this.valuesField = valuesField;
            }

            @NotNull
            public final IrField getValuesField() {
                return this.valuesField;
            }

            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                return IrUtilsKt.isEnumEntry((IrClass)declaration) ? super.visitClass(declaration) : (IrStatement)declaration;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration) {
                Collection<IrValueParameter> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrFactory $this$buildConstructor$iv = EnumClassLowering.this.getContext().getIrFactory();
                boolean $i$f$buildConstructor = false;
                IrFunctionBuilder $this$buildConstructor_u24lambda_u2d20$iv = new IrFunctionBuilder();
                boolean bl = false;
                IrFunctionBuilder $this$visitConstructor_u24lambda_u2d0 = $this$buildConstructor_u24lambda_u2d20$iv;
                boolean $i$a$-buildConstructor-EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer$visitConstructor$22 = false;
                $this$visitConstructor_u24lambda_u2d0.updateFrom((IrFunction)declaration);
                $this$visitConstructor_u24lambda_u2d0.setReturnType(declaration.getReturnType());
                IrConstructor irConstructor = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2d20$iv);
                EnumClassLowering enumClassLowering = EnumClassLowering.this;
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                IrConstructor $this$visitConstructor_u24lambda_u2d3 = irConstructor;
                boolean bl2 = false;
                $this$visitConstructor_u24lambda_u2d3.setParent(declaration.getParent());
                $this$visitConstructor_u24lambda_u2d3.setAnnotations(declaration.getAnnotations());
                DeclarationBuildersKt.addValueParameter((IrFunction)((IrFunction)$this$visitConstructor_u24lambda_u2d3), (String)"$enum$name", (IrType)enumClassLowering.getContext().getIrBuiltIns().getStringType(), (IrDeclarationOrigin)((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.ENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER.INSTANCE));
                DeclarationBuildersKt.addValueParameter((IrFunction)((IrFunction)$this$visitConstructor_u24lambda_u2d3), (String)"$enum$ordinal", (IrType)enumClassLowering.getContext().getIrBuiltIns().getIntType(), (IrDeclarationOrigin)((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.ENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER.INSTANCE));
                Iterable $i$a$-buildConstructor-EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer$visitConstructor$22 = declaration.getValueParameters();
                Collection collection2 = $this$visitConstructor_u24lambda_u2d3.getValueParameters();
                IrConstructor irConstructor2 = $this$visitConstructor_u24lambda_u2d3;
                boolean $i$f$map = false;
                void var11_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void param;
                    IrValueParameter irValueParameter;
                    IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    IrValueParameter newParam = irValueParameter = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)param, (IrFunction)((IrFunction)$this$visitConstructor_u24lambda_u2d3), null, (int)(param.getIndex() + 2), (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (int)8186, null);
                    boolean bl4 = false;
                    ((Map)enumClassTransformer.loweredEnumConstructorParameters).put(param.getSymbol(), newParam);
                    collection.add(irValueParameter);
                }
                collection = (List)destination$iv$iv;
                irConstructor2.setValueParameters(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
                IrBody irBody = declaration.getBody();
                $this$visitConstructor_u24lambda_u2d3.setBody(irBody != null ? (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)irBody), (IrDeclarationParent)((IrDeclarationParent)$this$visitConstructor_u24lambda_u2d3)) : null);
                ((Map)enumClassTransformer.loweredEnumConstructors).put(declaration.getSymbol(), $this$visitConstructor_u24lambda_u2d3);
                $this$visitConstructor_u24lambda_u2d3.setMetadata(declaration.getMetadata());
                return (IrStatement)irConstructor;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                IrCall irCall;
                IrBuilderWithScope irBuilderWithScope;
                void $this$visitSimpleFunction_u24lambda_u2d6;
                IrBody irBody;
                block9: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        irBody = declaration.getBody();
                        if (irBody == null) break block8;
                        IrBody $this$safeAs$iv = irBody;
                        boolean $i$f$safeAs = false;
                        IrBody irBody2 = $this$safeAs$iv;
                        if (!(irBody2 instanceof IrSyntheticBody)) {
                            irBody2 = null;
                        }
                        if ((irBody = (IrSyntheticBody)irBody2) != null) break block9;
                    }
                    return (IrStatement)declaration;
                }
                IrBody body2 = irBody;
                JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(EnumClassLowering.this.getContext(), (IrSymbol)declaration.getSymbol(), 0, 0, 6, null);
                EnumClassLowering enumClassLowering = EnumClassLowering.this;
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                JvmIrBuilder $i$f$safeAs = jvmIrBuilder;
                IrSimpleFunction irSimpleFunction = declaration;
                boolean bl = false;
                IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u2d6;
                switch (WhenMappings.$EnumSwitchMapping$0[body2.getKind().ordinal()]) {
                    case 1: {
                        void $this$visitSimpleFunction_u24lambda_u2d6_u24lambda_u2d4;
                        IrCall irCall2;
                        IrCall irCall3 = irCall2 = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u2d6), (IrSimpleFunctionSymbol)enumClassLowering.getContext().getIr().getSymbols().getObjectCloneFunction(), (IrType)declaration.getReturnType(), (int)0, (int)0, null, (int)28, null);
                        IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope2;
                        boolean bl2 = false;
                        $this$visitSimpleFunction_u24lambda_u2d6_u24lambda_u2d4.setDispatchReceiver((IrExpression)ExpressionHelpersKt.irGetField((IrBuilderWithScope)((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u2d6), null, (IrField)this.valuesField));
                        irBuilderWithScope = irBuilderWithScope3;
                        irCall = irCall2;
                        break;
                    }
                    case 2: {
                        void $this$visitSimpleFunction_u24lambda_u2d6_u24lambda_u2d5;
                        IrCall irCall4;
                        IrCall $this$visitSimpleFunction_u24lambda_u2d6_u24lambda_u2d4 = irCall4 = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u2d6), (IrSimpleFunctionSymbol)$this$visitSimpleFunction_u24lambda_u2d6.getBackendContext().getIr().getSymbols().getEnumValueOfFunction());
                        IrBuilderWithScope irBuilderWithScope4 = irBuilderWithScope2;
                        boolean bl3 = false;
                        $this$visitSimpleFunction_u24lambda_u2d6_u24lambda_u2d5.putValueArgument(0, (IrExpression)JvmIrUtilsKt.javaClassReference((JvmIrBuilder)$this$visitSimpleFunction_u24lambda_u2d6, (IrType)IrUtilsKt.getDefaultType((IrClass)enumClassTransformer.getIrClass())));
                        $this$visitSimpleFunction_u24lambda_u2d6_u24lambda_u2d5.putValueArgument(1, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u2d6), (IrValueDeclaration)((IrValueDeclaration)declaration.getValueParameters().get(0))));
                        irBuilderWithScope = irBuilderWithScope4;
                        irCall = irCall4;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                irSimpleFunction.setBody((IrBody)ExpressionHelpersKt.irExprBody((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irCall)));
                return (IrStatement)declaration;
            }

            @Metadata(mv={1, 7, 1}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[IrSyntheticBodyKind.values().length];
                    nArray[IrSyntheticBodyKind.ENUM_VALUES.ordinal()] = 1;
                    nArray[IrSyntheticBodyKind.ENUM_VALUEOF.ordinal()] = 2;
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassCallTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;)V", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "passConstructorArguments", "", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "original", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "backend.jvm.lower"})
        private final class EnumClassCallTransformer
        extends IrElementTransformerVoidWithContext {
            @NotNull
            public IrStatement visitClassNew(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                return IrUtilsKt.isEnumEntry((IrClass)declaration) ? super.visitClassNew(declaration) : (IrStatement)declaration;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrValueParameter irValueParameter = (IrValueParameter)((Map)EnumClassTransformer.this.loweredEnumConstructorParameters).get(expression2.getSymbol());
                if (irValueParameter != null) {
                    IrValueParameter it = irValueParameter;
                    boolean bl = false;
                    irExpression = (IrExpression)new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), (IrValueSymbol)it.getSymbol(), expression2.getOrigin());
                } else {
                    irExpression = (IrExpression)expression2;
                }
                return irExpression;
            }

            @NotNull
            public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid((IrElement)expression2);
                IrValueParameter irValueParameter = (IrValueParameter)((Map)EnumClassTransformer.this.loweredEnumConstructorParameters).get(expression2.getSymbol());
                if (irValueParameter != null) {
                    IrValueParameter it = irValueParameter;
                    boolean bl = false;
                    irExpression = (IrExpression)new IrSetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), (IrValueSymbol)it.getSymbol(), expression2.getValue(), expression2.getOrigin());
                } else {
                    irExpression = (IrExpression)expression2;
                }
                return irExpression;
            }

            @NotNull
            public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrFunctionAccessExpression irFunctionAccessExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                IrSymbol scopeOwnerSymbol = scopeWithIr.getScope().getScopeOwnerSymbol();
                IrBuilder irBuilder = LowerUtilsKt.at((IrBuilder)((IrBuilder)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)EnumClassLowering.this.getContext()), (IrSymbol)scopeOwnerSymbol, (int)0, (int)0, (int)6, null)), (IrElement)((IrElement)expression2));
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                DeclarationIrBuilder $this$visitEnumConstructorCall_u24lambda_u2d3 = (DeclarationIrBuilder)irBuilder;
                boolean bl = false;
                IrConstructor irConstructor = (IrConstructor)enumClassTransformer.loweredEnumConstructors.get(expression2.getSymbol());
                if (irConstructor == null) {
                    irConstructor = (IrConstructor)expression2.getSymbol().getOwner();
                }
                Intrinsics.checkNotNullExpressionValue((Object)irConstructor, (String)"loweredEnumConstructors[\u2026: expression.symbol.owner");
                IrConstructor constructor = irConstructor;
                IrFunctionAccessExpression it = irFunctionAccessExpression = scopeOwnerSymbol instanceof IrConstructorSymbol ? (IrFunctionAccessExpression)ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)((IrBuilderWithScope)$this$visitEnumConstructorCall_u24lambda_u2d3), (IrConstructor)constructor) : ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$visitEnumConstructorCall_u24lambda_u2d3), (IrFunction)((IrFunction)constructor));
                boolean bl2 = false;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$visitEnumConstructorCall_u24lambda_u2d3;
                IrFunctionAccessExpression irFunctionAccessExpression2 = (IrFunctionAccessExpression)expression2;
                Map map = enumClassTransformer.declarationToEnumEntry;
                IrSymbolOwner irSymbolOwner = scopeOwnerSymbol.getOwner();
                Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                this.passConstructorArguments(irBuilderWithScope, it, irFunctionAccessExpression2, (IrEnumEntry)map.get((IrDeclaration)irSymbolOwner));
                return (IrExpression)irFunctionAccessExpression;
            }

            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrDelegatingConstructorCall irDelegatingConstructorCall;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
                IrConstructor irConstructor = (IrConstructor)EnumClassTransformer.this.loweredEnumConstructors.get(expression2.getSymbol());
                if (irConstructor == null) {
                    return (IrExpression)expression2;
                }
                IrConstructor replacement = irConstructor;
                BackendContext backendContext = (BackendContext)EnumClassLowering.this.getContext();
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                DeclarationIrBuilder $this$visitDelegatingConstructorCall_u24lambda_u2d5 = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)((IrBuilder)LowerUtilsKt.createIrBuilder$default((BackendContext)backendContext, (IrSymbol)scopeWithIr.getScope().getScopeOwnerSymbol(), (int)0, (int)0, (int)6, null)), (IrElement)((IrElement)expression2));
                boolean bl = false;
                IrDelegatingConstructorCall it = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)((IrBuilderWithScope)$this$visitDelegatingConstructorCall_u24lambda_u2d5), (IrConstructor)replacement);
                boolean bl2 = false;
                EnumClassCallTransformer.passConstructorArguments$default(this, (IrBuilderWithScope)$this$visitDelegatingConstructorCall_u24lambda_u2d5, (IrFunctionAccessExpression)it, (IrFunctionAccessExpression)expression2, null, 4, null);
                return (IrExpression)irDelegatingConstructorCall;
            }

            private final void passConstructorArguments(IrBuilderWithScope $this$passConstructorArguments, IrFunctionAccessExpression call2, IrFunctionAccessExpression original, IrEnumEntry enumEntry) {
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)((IrMemberAccessExpression)call2), (IrMemberAccessExpression)((IrMemberAccessExpression)original), (int)0, (int)2, null);
                if (enumEntry != null) {
                    String string2 = enumEntry.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"enumEntry.name.asString()");
                    call2.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)$this$passConstructorArguments, (String)string2));
                    call2.putValueArgument(1, (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$passConstructorArguments, (int)EnumClassTransformer.this.enumEntryOrdinals.get((Object)enumEntry), null, (int)2, null));
                } else {
                    ScopeWithIr scopeWithIr = this.getCurrentScope();
                    Intrinsics.checkNotNull((Object)scopeWithIr);
                    IrSymbol irSymbol = scopeWithIr.getScope().getScopeOwnerSymbol();
                    Intrinsics.checkNotNull((Object)irSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol");
                    IrConstructorSymbol constructor = (IrConstructorSymbol)irSymbol;
                    call2.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$passConstructorArguments, (IrValueDeclaration)((IrValueDeclaration)((IrConstructor)constructor.getOwner()).getValueParameters().get(0))));
                    call2.putValueArgument(1, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$passConstructorArguments, (IrValueDeclaration)((IrValueDeclaration)((IrConstructor)constructor.getOwner()).getValueParameters().get(1))));
                }
                int n = original.getValueArgumentsCount();
                for (int index2 = 0; index2 < n; ++index2) {
                    IrExpression it;
                    if (original.getValueArgument(index2) == null) continue;
                    boolean bl = false;
                    call2.putValueArgument(index2 + 2, it);
                }
            }

            static /* synthetic */ void passConstructorArguments$default(EnumClassCallTransformer enumClassCallTransformer, IrBuilderWithScope irBuilderWithScope, IrFunctionAccessExpression irFunctionAccessExpression, IrFunctionAccessExpression irFunctionAccessExpression2, IrEnumEntry irEnumEntry, int n, Object object) {
                if ((n & 4) != 0) {
                    irEnumEntry = null;
                }
                enumClassCallTransformer.passConstructorArguments(irBuilderWithScope, irFunctionAccessExpression, irFunctionAccessExpression2, irEnumEntry);
            }
        }
    }
}

