/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.JavaFXCommonBundle;
import org.jetbrains.plugins.javaFX.packaging.JavaFxAntGenerator;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationIcons;
import org.jetbrains.plugins.javaFX.packaging.JavaFxManifestAttribute;
import org.jetbrains.plugins.javaFX.packaging.JavaFxPackagerConstants;

public abstract class AbstractJavaFxPackager {
    private static final Logger LOG = Logger.getInstance(AbstractJavaFxPackager.class);
    private static final String JB_JFX_JKS = "jb-jfx.jks";
    private static final String NATIVE_BUNDLES = "bundles";

    protected String getArtifactRootName() {
        return PathUtilRt.getFileName((String)this.getArtifactOutputFilePath());
    }

    protected abstract String getArtifactName();

    protected abstract String getArtifactOutputPath();

    protected abstract String getArtifactOutputFilePath();

    protected abstract String getAppClass();

    protected abstract String getTitle();

    protected abstract String getVendor();

    protected abstract String getDescription();

    protected abstract String getVersion();

    protected abstract String getWidth();

    protected abstract String getHeight();

    protected abstract String getHtmlTemplateFile();

    protected abstract String getHtmlPlaceholderId();

    protected abstract String getHtmlParamFile();

    protected abstract String getParamFile();

    protected abstract String getUpdateMode();

    protected abstract JavaFxPackagerConstants.NativeBundles getNativeBundle();

    protected abstract void registerJavaFxPackagerError(@Nls String var1);

    protected abstract void registerJavaFxPackagerInfo(@Nls String var1);

    protected abstract JavaFxApplicationIcons getIcons();

    protected abstract JavaFxPackagerConstants.MsgOutputLevel getMsgOutputLevel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildJavaFxArtifact(String homePath) {
        File tempUnzippedArtifactOutput;
        if (!this.checkNotEmpty(this.getAppClass(), "Application class")) {
            return;
        }
        if (!this.checkNotEmpty(this.getWidth(), "Width")) {
            return;
        }
        if (!this.checkNotEmpty(this.getHeight(), "Height")) {
            return;
        }
        String zipPath = this.getArtifactOutputFilePath();
        try {
            tempUnzippedArtifactOutput = FileUtil.createTempDirectory((String)"artifact", (String)"unzipped");
            File artifactOutputFile = new File(zipPath);
            ZipUtil.extract((File)artifactOutputFile, (File)tempUnzippedArtifactOutput, null);
            this.copyLibraries(FileUtilRt.getNameWithoutExtension((String)artifactOutputFile.getName()), tempUnzippedArtifactOutput);
        }
        catch (IOException e) {
            this.registerJavaFxPackagerError(e);
            return;
        }
        File tempDirectory = new File(tempUnzippedArtifactOutput, "deploy");
        try {
            String taskDefJar = homePath + "/lib/ant-javafx.jar";
            if (!new File(taskDefJar).exists()) {
                this.registerJavaFxPackagerError(JavaFXCommonBundle.message("cant.build.artifact.fx.deploy.is.not.available.in.this.jdk", new Object[0]));
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("<project default=\"build artifact\">\n");
            buf.append("<taskdef resource=\"com/sun/javafx/tools/ant/antlib.xml\" uri=\"javafx:com.sun.javafx.tools.ant\" ").append("classpath=\"").append(taskDefJar).append("\"/>\n");
            buf.append("<target name=\"build artifact\" xmlns:fx=\"javafx:com.sun.javafx.tools.ant\">");
            String artifactFileName = this.getArtifactRootName();
            List<JavaFxAntGenerator.SimpleTag> tags = JavaFxAntGenerator.createJarAndDeployTasks(this, artifactFileName, this.getArtifactName(), tempUnzippedArtifactOutput.getPath(), tempDirectory.getPath(), null);
            for (JavaFxAntGenerator.SimpleTag tag : tags) {
                tag.generate(buf);
            }
            buf.append("</target>");
            buf.append("</project>");
            int result = this.startAntTarget(buf.toString(), homePath);
            if (result == 0) {
                if (this.isEnabledSigning()) {
                    this.signApp(homePath + File.separator + "bin", tempDirectory);
                }
            } else {
                this.registerJavaFxPackagerError(JavaFXCommonBundle.message("fx.deploy.task.has.failed", new Object[0]));
            }
        }
        finally {
            this.copyResultsToArtifactsOutput(tempDirectory);
            FileUtil.delete((File)tempUnzippedArtifactOutput);
        }
    }

    private void copyLibraries(String zipPath, File tempUnzippedArtifactOutput) throws IOException {
        File[] outFiles = new File(this.getArtifactOutputPath()).listFiles();
        if (outFiles != null) {
            Object[] generatedItems = new String[]{JB_JFX_JKS, zipPath + ".jar", zipPath + ".jnlp", zipPath + ".html", NATIVE_BUNDLES};
            for (File file : outFiles) {
                String fileName = file.getName();
                if (ArrayUtilRt.find((Object[])generatedItems, (Object)fileName) >= 0) continue;
                File destination = new File(tempUnzippedArtifactOutput, fileName);
                FileUtil.copyFileOrDir((File)file, (File)destination);
            }
        }
    }

    private boolean checkNotEmpty(String text, String title) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            this.registerJavaFxPackagerError(JavaFXCommonBundle.message("unable.to.build.javafx.artifact.not.specified", title));
            return false;
        }
        return true;
    }

    private void signApp(String binPath, File tempDirectory) {
        int genResult;
        boolean selfSigning = this.isSelfSigning();
        int n = genResult = selfSigning ? this.genKey(binPath) : 0;
        if (genResult == 0) {
            File[] files = tempDirectory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                    this.sign(binPath, selfSigning, file.getPath());
                }
            }
        } else {
            this.registerJavaFxPackagerError(JavaFXCommonBundle.message("javafx.generate.certificate.task.has.failed", new Object[0]));
        }
    }

    private void sign(String binPath, boolean selfSigning, String jar2Sign) {
        ArrayList<String> signCommandLine = new ArrayList<String>();
        AbstractJavaFxPackager.addParameter(signCommandLine, FileUtil.toSystemDependentName((String)(binPath + File.separator + "jarsigner")));
        this.collectStoreParams(selfSigning, signCommandLine);
        AbstractJavaFxPackager.addParameter(signCommandLine, jar2Sign);
        AbstractJavaFxPackager.addParameter(signCommandLine, this.getAlias(selfSigning));
        int signedResult = this.startProcess(signCommandLine);
        if (signedResult != 0) {
            this.registerJavaFxPackagerError(JavaFXCommonBundle.message("javafx.sign.task.has.failed.for.0", jar2Sign));
        }
    }

    private int genKey(String binPath) {
        String keyStorePath = this.getKeystore(true);
        File keyStoreFile = new File(keyStorePath);
        if (keyStoreFile.isFile()) {
            FileUtil.delete((File)keyStoreFile);
        }
        ArrayList<String> genCommandLine = new ArrayList<String>();
        AbstractJavaFxPackager.addParameter(genCommandLine, FileUtil.toSystemDependentName((String)(binPath + File.separator + "keytool")));
        AbstractJavaFxPackager.addParameter(genCommandLine, "-genkeypair");
        AbstractJavaFxPackager.addParameter(genCommandLine, "-dname");
        String vendor = this.getVendor();
        if (StringUtil.isEmptyOrSpaces((String)vendor)) {
            vendor = "jb-fx-build";
        }
        AbstractJavaFxPackager.addParameter(genCommandLine, "CN=" + vendor.replaceAll(",", "\\\\,"));
        AbstractJavaFxPackager.addParameter(genCommandLine, "-alias");
        AbstractJavaFxPackager.addParameter(genCommandLine, this.getAlias(true));
        this.collectStoreParams(true, genCommandLine);
        return this.startProcess(genCommandLine);
    }

    private void collectStoreParams(boolean selfSigning, List<String> signCommandLine) {
        AbstractJavaFxPackager.addParameter(signCommandLine, "-keyStore");
        AbstractJavaFxPackager.addParameter(signCommandLine, this.getKeystore(selfSigning));
        AbstractJavaFxPackager.addParameter(signCommandLine, "-storepass");
        AbstractJavaFxPackager.addParameter(signCommandLine, this.getStorepass(selfSigning));
        AbstractJavaFxPackager.addParameter(signCommandLine, "-keypass");
        AbstractJavaFxPackager.addParameter(signCommandLine, this.getKeypass(selfSigning));
    }

    private void copyResultsToArtifactsOutput(File tempDirectory) {
        try {
            File resultedJar = new File(this.getArtifactOutputPath());
            FileUtil.copyDir((File)tempDirectory, (File)resultedJar);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        FileUtil.delete((File)tempDirectory);
    }

    private void registerJavaFxPackagerError(Exception ex) {
        this.registerJavaFxPackagerError(ex.getMessage());
    }

    private static void addParameter(List<String> commandLine, String param) {
        if (!StringUtil.isEmptyOrSpaces((String)param)) {
            commandLine.add(param);
        }
    }

    private int startProcess(final List<String> commands) {
        try {
            final AtomicInteger exitCode = new AtomicInteger();
            final @NlsSafe StringBuilder errorOutput = new StringBuilder();
            final ArrayList<@NlsSafe E> delayedInfoOutput = new ArrayList();
            final boolean isVerbose = this.getMsgOutputLevel() != null && this.getMsgOutputLevel().isVerbose();
            Process process = new ProcessBuilder(CommandLineUtil.toCommandLine(commands)).start();
            BaseOSProcessHandler handler = new BaseOSProcessHandler(process, commands.toString(), null);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (isVerbose) {
                        LOG.info("Started " + commands);
                    }
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (isVerbose) {
                        LOG.info("Terminated " + commands + ", exit code: " + event.getExitCode());
                    }
                    exitCode.set(event.getExitCode());
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    String message = StringUtil.trimTrailing((String)event.getText());
                    if (outputType == ProcessOutputTypes.STDERR) {
                        LOG.error(message, (Throwable)null);
                        errorOutput.append(event.getText());
                    } else {
                        LOG.info(message);
                        if (isVerbose) {
                            AbstractJavaFxPackager.this.registerJavaFxPackagerInfo(message);
                        } else {
                            delayedInfoOutput.add(message);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/packaging/AbstractJavaFxPackager$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            handler.startNotify();
            handler.waitFor();
            int result = exitCode.get();
            if (result != 0) {
                String message = errorOutput.toString();
                if (!StringUtil.isEmptyOrSpaces((String)message)) {
                    this.registerJavaFxPackagerError(message);
                }
                for (String info : delayedInfoOutput) {
                    this.registerJavaFxPackagerInfo(info);
                }
            }
            return result;
        }
        catch (Exception e) {
            this.registerJavaFxPackagerError(e);
            return -1;
        }
    }

    private int startAntTarget(String buildText, String javaHome) {
        String cmdLineParam;
        String antHome = AbstractJavaFxPackager.getAntHome();
        if (antHome == null) {
            this.registerJavaFxPackagerError(JavaFXCommonBundle.message("bundled.ant.not.found", new Object[0]));
            return -1;
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(javaHome + File.separator + "bin" + File.separator + "java");
        commands.add("-Dant.home=" + antHome);
        commands.add("-classpath");
        commands.add(antHome + "/lib/ant.jar" + File.pathSeparator + antHome + "/lib/ant-launcher.jar" + File.pathSeparator + javaHome + "/lib/ant-javafx.jar" + File.pathSeparator + javaHome + "/jre/lib/jfxrt.jar");
        commands.add("org.apache.tools.ant.launch.Launcher");
        String string = cmdLineParam = this.getMsgOutputLevel() != null ? this.getMsgOutputLevel().getCmdLineParam() : "";
        if (!cmdLineParam.isEmpty()) {
            commands.add(cmdLineParam);
        }
        commands.add("-f");
        try {
            File tempFile = FileUtil.createTempFile((String)"build", (String)".xml");
            tempFile.deleteOnExit();
            FileUtil.writeToFile((File)tempFile, (byte[])buildText.getBytes(Charset.defaultCharset()));
            commands.add(tempFile.getCanonicalPath());
        }
        catch (IOException e) {
            this.registerJavaFxPackagerError(e);
            return -1;
        }
        return this.startProcess(commands);
    }

    private static String getAntHome() {
        File communityAntHome;
        String appHome = PathManager.getHomePath();
        if (appHome == null) {
            return null;
        }
        File antHome = new File(appHome, "lib" + File.separator + "ant");
        if (!antHome.exists() && (communityAntHome = new File(appHome, "community" + File.separator + "lib" + File.separator + "ant")).exists()) {
            antHome = communityAntHome;
        }
        if (!antHome.exists()) {
            return null;
        }
        return antHome.getPath();
    }

    private String getAlias(boolean selfSigning) {
        return selfSigning ? "jb" : this.getAlias();
    }

    private String getKeypass(boolean selfSigning) {
        return selfSigning ? "keypass" : new String(Base64.getDecoder().decode(this.getKeypass()), StandardCharsets.UTF_8);
    }

    private String getKeystore(boolean selfSigning) {
        return selfSigning ? this.getArtifactOutputPath() + File.separator + JB_JFX_JKS : this.getKeystore();
    }

    private String getStorepass(boolean selfSigning) {
        return selfSigning ? "storepass" : new String(Base64.getDecoder().decode(this.getStorepass()), StandardCharsets.UTF_8);
    }

    public abstract String getKeypass();

    public abstract String getStorepass();

    public abstract String getKeystore();

    public abstract String getAlias();

    public abstract boolean isSelfSigning();

    public abstract boolean isEnabledSigning();

    public abstract String getPreloaderClass();

    public abstract String getPreloaderJar();

    public abstract boolean convertCss2Bin();

    public abstract List<JavaFxManifestAttribute> getCustomManifestAttributes();
}

