/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.Premium;
import org.languagetool.Tag;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.GRPCRule;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleMetrics;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.ml.MLServerProto;
import org.languagetool.rules.ml.PostProcessingServerGrpc;
import org.languagetool.tools.CircuitBreakers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCPostProcessing {
    private static final Logger log = LoggerFactory.getLogger(GRPCPostProcessing.class);
    public static final String CONFIG_TYPE = "grpc-post";
    private final CircuitBreaker circuitBreaker;
    private ManagedChannel channel;
    private PostProcessingServerGrpc.PostProcessingServerBlockingStub stub;
    private RemoteRuleConfig config;
    private static ConcurrentMap<String, GRPCPostProcessing> instances = new ConcurrentHashMap<String, GRPCPostProcessing>();
    private static ConcurrentMap<Language, Set<String>> configIDs = new ConcurrentHashMap<Language, Set<String>>();

    protected GRPCPostProcessing(RemoteRuleConfig config) throws Exception {
        this.config = config;
        CircuitBreakerConfig circuitBreakerConfig = RemoteRule.getCircuitBreakerConfig(config, config.getRuleId());
        this.circuitBreaker = CircuitBreakers.registry().circuitBreaker("grpc-postprocessing-" + config.getRuleId(), circuitBreakerConfig);
        String host = config.getUrl();
        int port = config.getPort();
        boolean ssl = Boolean.parseBoolean(config.getOptions().getOrDefault("secure", "false"));
        String key = config.getOptions().get("clientKey");
        String cert = config.getOptions().get("clientCertificate");
        String ca = config.getOptions().get("rootCertificate");
        this.channel = GRPCRule.Connection.getManagedChannel(host, port, ssl, key, cert, ca);
        this.stub = PostProcessingServerGrpc.newBlockingStub((Channel)this.channel);
    }

    @NotNull
    public static List<GRPCPostProcessing> get(Language lang) {
        return configIDs.getOrDefault(lang, Collections.emptySet()).stream().map(instances::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void configure(Language lang, List<RemoteRuleConfig> configs) {
        configs.stream().filter(RemoteRuleConfig.isRelevantConfig(CONFIG_TYPE, lang)).forEach(config -> {
            String key = config.getRuleId();
            configIDs.computeIfAbsent(lang, k -> new HashSet()).add(key);
            instances.computeIfAbsent(key, k -> {
                try {
                    return new GRPCPostProcessing((RemoteRuleConfig)config);
                }
                catch (Exception e) {
                    log.warn(String.format("Couldn't initialize GRPCPostProcessing instance for language '%s' and configuration '%s'", lang, config), (Throwable)e);
                    return null;
                }
            });
        });
    }

    @NotNull
    private static String nullAsEmpty(@Nullable String s) {
        return s != null ? s : "";
    }

    @Nullable
    private static String emptyAsNull(String s) {
        if (s != null && s.isEmpty()) {
            return null;
        }
        return s;
    }

    private MLServerProto.SuggestedReplacement convertSuggestedReplacement(SuggestedReplacement s) {
        MLServerProto.SuggestedReplacement.Builder sb = MLServerProto.SuggestedReplacement.newBuilder().setReplacement(s.getReplacement()).setDescription(GRPCPostProcessing.nullAsEmpty(s.getShortDescription())).setSuffix(GRPCPostProcessing.nullAsEmpty(s.getSuffix())).setType(MLServerProto.SuggestedReplacement.SuggestionType.valueOf(s.getType().name()));
        if (s.getConfidence() != null) {
            sb.setConfidence(s.getConfidence().floatValue());
        }
        return sb.build();
    }

    private SuggestedReplacement convertSuggestedReplacement(MLServerProto.SuggestedReplacement s) {
        SuggestedReplacement sb = new SuggestedReplacement(s.getReplacement(), GRPCPostProcessing.emptyAsNull(s.getDescription()), GRPCPostProcessing.emptyAsNull(s.getSuffix()));
        sb.setType(SuggestedReplacement.SuggestionType.valueOf(s.getType().name()));
        if (s.getConfidence() != 0.0f) {
            sb.setConfidence(Float.valueOf(s.getConfidence()));
        }
        return sb;
    }

    private MLServerProto.Match convertMatch(RuleMatch m) {
        return MLServerProto.Match.newBuilder().setOffset(m.getFromPos()).setLength(m.getToPos() - m.getFromPos()).setId(m.getSpecificRuleId()).setSubId(GRPCPostProcessing.nullAsEmpty(m.getRule().getSubId())).addAllSuggestedReplacements(m.getSuggestedReplacementObjects().stream().map(this::convertSuggestedReplacement).collect(Collectors.toList())).setRuleDescription(GRPCPostProcessing.nullAsEmpty(m.getRule().getDescription())).setMatchDescription(GRPCPostProcessing.nullAsEmpty(m.getMessage())).setMatchShortDescription(GRPCPostProcessing.nullAsEmpty(m.getShortMessage())).setUrl(m.getUrl() != null ? m.getUrl().toString() : "").setAutoCorrect(m.isAutoCorrect()).setType(MLServerProto.Match.MatchType.valueOf(m.getType().name())).setContextForSureMatch(m.getRule().estimateContextForSureMatch()).setRule(MLServerProto.Rule.newBuilder().setSourceFile(GRPCPostProcessing.nullAsEmpty(m.getRule().getSourceFile())).setIssueType(m.getRule().getLocQualityIssueType().name()).setTempOff(m.getRule().isDefaultTempOff()).setCategory(MLServerProto.RuleCategory.newBuilder().setId(m.getRule().getCategory().getId().toString()).setName(m.getRule().getCategory().getName()).build()).setIsPremium(Premium.get().isPremiumRule(m.getRule())).addAllTags(m.getRule().getTags().stream().map(t -> MLServerProto.Rule.Tag.valueOf(t.name())).collect(Collectors.toList())).build()).build();
    }

    private RuleMatch convertMatch(MLServerProto.Match m, AnalyzedSentence s) {
        RuleData rule = new RuleData(m);
        RuleMatch r = new RuleMatch(rule, s, m.getOffset(), m.getOffset() + m.getLength(), m.getMatchDescription(), m.getMatchShortDescription());
        r.setSuggestedReplacementObjects(m.getSuggestedReplacementsList().stream().map(this::convertSuggestedReplacement).collect(Collectors.toList()));
        r.setAutoCorrect(m.getAutoCorrect());
        r.setType(RuleMatch.Type.valueOf(m.getType().name()));
        if (!m.getUrl().isEmpty()) {
            try {
                r.setUrl(new URL(m.getUrl()));
            }
            catch (MalformedURLException e) {
                log.warn("Got invalid URL from GRPC match filter {}: {}", (Object)this, (Object)e);
            }
        }
        return r;
    }

    private MLServerProto.PostProcessingRequest buildRequest(List<AnalyzedSentence> sentences2, List<RuleMatch> ruleMatches, List<Integer> offset, Long textSessionId, boolean inputLogging) {
        ruleMatches = ruleMatches.stream().map(r -> new RuleMatch((RuleMatch)r)).collect(Collectors.toList());
        ArrayList<MLServerProto.MatchList> matches = new ArrayList<MLServerProto.MatchList>();
        for (int i2 = 0; i2 < sentences2.size(); ++i2) {
            AnalyzedSentence sentence = sentences2.get(i2);
            if (i2 == 0) {
                offset.add(0);
            } else {
                offset.add(offset.get(i2 - 1) + sentences2.get(i2 - 1).getText().length());
            }
            ArrayList<RuleMatch> sentenceMatches = new ArrayList<RuleMatch>();
            Iterator<RuleMatch> iter = ruleMatches.iterator();
            while (iter.hasNext()) {
                RuleMatch m = iter.next();
                if (!sentence.getText().equals(m.getSentence().getText())) continue;
                iter.remove();
                m.setOffsetPosition(m.getFromPos() - offset.get(i2), m.getToPos() - offset.get(i2));
                sentenceMatches.add(m);
            }
            matches.add(MLServerProto.MatchList.newBuilder().addAllMatches(sentenceMatches.stream().map(this::convertMatch).collect(Collectors.toList())).build());
        }
        List<String> sentenceText = sentences2.stream().map(AnalyzedSentence::getText).collect(Collectors.toList());
        MLServerProto.PostProcessingRequest.Builder req = MLServerProto.PostProcessingRequest.newBuilder().addAllSentences(sentenceText).addAllMatches(matches);
        if (textSessionId != null) {
            req.addAllTextSessionID(Collections.nCopies(sentenceText.size(), textSessionId));
        }
        req.setInputLogging(inputLogging);
        return req.build();
    }

    public List<RuleMatch> filter(List<AnalyzedSentence> sentences2, List<RuleMatch> ruleMatches, Long textSessionID, boolean inputLogging) {
        List result;
        if (this.channel == null) {
            return ruleMatches;
        }
        int chars = sentences2.stream().map(s -> s.getText().length()).reduce(0, Integer::sum);
        long start = System.nanoTime();
        try {
            result = this.circuitBreaker != null ? RemoteRuleMetrics.inCircuitBreaker(System.nanoTime(), this.circuitBreaker, this.config.ruleId, chars, () -> this.runPostprocessing(sentences2, ruleMatches, textSessionID, inputLogging, chars)) : this.runPostprocessing(sentences2, ruleMatches, textSessionID, inputLogging, chars);
        }
        catch (Exception e) {
            log.warn("gRPC postprocessing failed", (Throwable)e);
            return ruleMatches;
        }
        if (result == null) {
            return ruleMatches;
        }
        long delta = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        log.info("gRPC postprocessing chars={} sentences={} matches={} time={}ms", new Object[]{chars, sentences2.size(), ruleMatches.size(), delta});
        RemoteRuleMetrics.wait(this.config.getRuleId(), delta);
        RemoteRuleMetrics.request(this.config.getRuleId(), start, chars, RemoteRuleMetrics.RequestResult.SUCCESS);
        return result;
    }

    protected MLServerProto.MatchResponse sendRequest(MLServerProto.PostProcessingRequest req, long timeout) throws Exception {
        return ((PostProcessingServerGrpc.PostProcessingServerBlockingStub)this.stub.withDeadlineAfter(timeout, TimeUnit.MILLISECONDS)).process(req);
    }

    protected List<RuleMatch> runPostprocessing(List<AnalyzedSentence> sentences2, List<RuleMatch> ruleMatches, Long textSessionID, boolean inputLogging, int chars) throws Exception {
        ArrayList<Integer> offset = new ArrayList<Integer>();
        long timeout = RemoteRule.getTimeout(this.config, chars);
        try {
            MLServerProto.PostProcessingRequest req = this.buildRequest(sentences2, ruleMatches, offset, textSessionID, inputLogging);
            MLServerProto.MatchResponse response = this.sendRequest(req, timeout);
            ArrayList<RuleMatch> result = new ArrayList<RuleMatch>(response.getSentenceMatchesCount());
            for (int i2 = 0; i2 < response.getSentenceMatchesCount(); ++i2) {
                MLServerProto.MatchList matchList = response.getSentenceMatches(i2);
                AnalyzedSentence sentence = sentences2.get(i2);
                int offsetShift = (Integer)offset.get(i2);
                for (int j = 0; j < matchList.getMatchesCount(); ++j) {
                    RuleMatch match = this.convertMatch(matchList.getMatches(j), sentence);
                    match.setOffsetPosition(match.getFromPos() + offsetShift, match.getToPos() + offsetShift);
                    result.add(match);
                }
            }
            return result;
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.DEADLINE_EXCEEDED.getCode()) {
                throw new TimeoutException("gRPC postprocessing timed out: " + e.getMessage());
            }
            throw e;
        }
    }

    class RuleData
    extends Rule {
        private final MLServerProto.Match m;
        private final String sourceFile;

        RuleData(MLServerProto.Match m) {
            this.m = m;
            this.sourceFile = m.getRule().getSourceFile();
            if (!m.getRule().getIssueType().isEmpty()) {
                this.setLocQualityIssueType(ITSIssueType.valueOf(m.getRule().getIssueType()));
            }
            if (m.getRule().getTempOff()) {
                this.setDefaultTempOff();
            }
            if (m.getRule().hasCategory()) {
                Category c = new Category(new CategoryId(m.getRule().getCategory().getId()), m.getRule().getCategory().getName());
                this.setCategory(c);
            }
            this.setPremium(m.getRule().getIsPremium());
            this.setTags(m.getRule().getTagsList().stream().map(t -> Tag.valueOf(t.name())).collect(Collectors.toList()));
        }

        @Override
        @Nullable
        public String getSourceFile() {
            return GRPCPostProcessing.emptyAsNull(this.sourceFile);
        }

        @Override
        public String getId() {
            return this.m.getId();
        }

        @Override
        public String getSubId() {
            return GRPCPostProcessing.emptyAsNull(this.m.getSubId());
        }

        @Override
        public String getDescription() {
            return this.m.getRuleDescription();
        }

        @Override
        public int estimateContextForSureMatch() {
            return this.m.getContextForSureMatch();
        }

        @Override
        public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
            throw new UnsupportedOperationException("Not implemented; internal class used for returning match information from remote endpoint");
        }
    }
}

