/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import morfologik.stemming.BufferUtils;
import morfologik.stemming.ISequenceEncoder;

public class TrimPrefixAndSuffixEncoder
implements ISequenceEncoder {
    private static final int REMOVE_EVERYTHING = 255;

    @Override
    public ByteBuffer encode(ByteBuffer reuse, ByteBuffer source2, ByteBuffer target) {
        int maxSubsequenceLength = 0;
        int maxSubsequenceIndex = 0;
        for (int i2 = 0; i2 < source2.remaining(); ++i2) {
            int sharedPrefix = BufferUtils.sharedPrefixLength(source2, i2, target, 0);
            if (sharedPrefix <= maxSubsequenceLength || i2 >= 255 || source2.remaining() - (i2 + sharedPrefix) >= 255) continue;
            maxSubsequenceLength = sharedPrefix;
            maxSubsequenceIndex = i2;
        }
        int truncatePrefixBytes = maxSubsequenceIndex;
        int truncateSuffixBytes = source2.remaining() - (maxSubsequenceIndex + maxSubsequenceLength);
        if (truncatePrefixBytes >= 255 || truncateSuffixBytes >= 255) {
            maxSubsequenceLength = 0;
            maxSubsequenceIndex = 0;
            truncateSuffixBytes = 255;
            truncatePrefixBytes = 255;
        }
        int len1 = target.remaining() - maxSubsequenceLength;
        reuse = BufferUtils.clearAndEnsureCapacity(reuse, 2 + len1);
        assert (target.hasArray() && target.position() == 0 && target.arrayOffset() == 0);
        reuse.put((byte)(truncatePrefixBytes + 65 & 0xFF));
        reuse.put((byte)(truncateSuffixBytes + 65 & 0xFF));
        reuse.put(target.array(), maxSubsequenceLength, len1);
        reuse.flip();
        return reuse;
    }

    @Override
    public int prefixBytes() {
        return 2;
    }

    @Override
    public ByteBuffer decode(ByteBuffer reuse, ByteBuffer source2, ByteBuffer encoded) {
        assert (encoded.remaining() >= 2);
        int p2 = encoded.position();
        int truncatePrefixBytes = encoded.get(p2) - 65 & 0xFF;
        int truncateSuffixBytes = encoded.get(p2 + 1) - 65 & 0xFF;
        if (truncatePrefixBytes == 255 || truncateSuffixBytes == 255) {
            truncatePrefixBytes = source2.remaining();
            truncateSuffixBytes = 0;
        }
        assert (source2.hasArray() && source2.position() == 0 && source2.arrayOffset() == 0);
        assert (encoded.hasArray() && encoded.position() == 0 && encoded.arrayOffset() == 0);
        int len1 = source2.remaining() - (truncateSuffixBytes + truncatePrefixBytes);
        int len2 = encoded.remaining() - 2;
        reuse = BufferUtils.clearAndEnsureCapacity(reuse, len1 + len2);
        reuse.put(source2.array(), truncatePrefixBytes, len1);
        reuse.put(encoded.array(), 2, len2);
        reuse.flip();
        return reuse;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

