/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ShortCharHashMap;

public class ShortCharScatterMap
extends ShortCharHashMap {
    public ShortCharScatterMap() {
        this(4);
    }

    public ShortCharScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortCharScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(short key) {
        return BitMixer.mixPhi(key);
    }

    public static ShortCharScatterMap from(short[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortCharScatterMap map2 = new ShortCharScatterMap(keys.length);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            map2.put(keys[i2], values[i2]);
        }
        return map2;
    }
}

