/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifier;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectJavaClassifierType
extends ReflectJavaType
implements JavaClassifierType {
    @NotNull
    private final Type reflectType;
    @NotNull
    private final JavaClassifier classifier;

    /*
     * WARNING - void declaration
     */
    public ReflectJavaClassifierType(@NotNull Type reflectType) {
        JavaClassifier javaClassifier;
        void $this$classifier_u24lambda_u2d0;
        Type type2;
        Intrinsics.checkNotNullParameter((Object)reflectType, (String)"reflectType");
        this.reflectType = reflectType;
        ReflectJavaClassifierType reflectJavaClassifierType = this;
        ReflectJavaClassifierType reflectJavaClassifierType2 = this;
        boolean bl = false;
        Type type3 = type2 = $this$classifier_u24lambda_u2d0.getReflectType();
        if (type3 instanceof Class) {
            javaClassifier = new ReflectJavaClass((Class)type2);
        } else if (type3 instanceof TypeVariable) {
            javaClassifier = new ReflectJavaTypeParameter((TypeVariable)type2);
        } else if (type3 instanceof ParameterizedType) {
            Type type4 = ((ParameterizedType)type2).getRawType();
            Intrinsics.checkNotNull((Object)type4, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            javaClassifier = new ReflectJavaClass((Class)type4);
        } else {
            throw new IllegalStateException("Not a classifier type (" + type2.getClass() + "): " + type2);
        }
        JavaClassifier classifier2 = javaClassifier;
        reflectJavaClassifierType2.classifier = classifier2;
    }

    @Override
    @NotNull
    public Type getReflectType() {
        return this.reflectType;
    }

    @Override
    @NotNull
    public JavaClassifier getClassifier() {
        return this.classifier;
    }

    @Override
    @NotNull
    public String getClassifierQualifiedName() {
        throw new UnsupportedOperationException("Type not found: " + this.getReflectType());
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return this.getReflectType().toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isRaw() {
        Type $this$_get_isRaw__u24lambda_u2d1 = this.getReflectType();
        boolean bl = false;
        if (!($this$_get_isRaw__u24lambda_u2d1 instanceof Class)) return false;
        TypeVariable<Class<T>>[] typeVariableArray = ((Class)$this$_get_isRaw__u24lambda_u2d1).getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"getTypeParameters()");
        if (((Object[])typeVariableArray).length != 0) return true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<JavaType> getTypeArguments() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = ReflectClassUtilKt.getParameterizedTypeArguments(this.getReflectType());
        ReflectJavaType.Factory factory = ReflectJavaType.Factory;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Type type2 = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(factory.create((Type)p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        return CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public JavaAnnotation findAnnotation(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return null;
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return false;
    }
}

