/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.io.File;
import java.net.URI;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.UpdateRunner;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.update.UpdateType;
import net.i2p.util.EepGet;

class DevSU3UpdateRunner
extends UpdateRunner {
    public DevSU3UpdateRunner(RouterContext ctx, ConsoleUpdateManager mgr, List<URI> uris) {
        super(ctx, mgr, UpdateType.ROUTER_DEV_SU3, uris);
        if (!uris.isEmpty()) {
            this._currentURI = uris.get(0);
        }
    }

    @Override
    protected void update() {
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = ConfigUpdateHandler.proxyPort(this._context);
        if (proxyPort == 4444 && proxyHost.equals("127.0.0.1") && this._context.portMapper().getPort("HTTP") < 0) {
            String msg = this._t("HTTP client proxy tunnel must be running");
            if (this._log.shouldWarn()) {
                this._log.warn(msg);
            }
            this.updateStatus("<b>" + msg + "</b>");
            this._mgr.notifyTaskFailed(this, msg, null);
            return;
        }
        String zipURL = this._currentURI.toString();
        if (this._log.shouldLog(10)) {
            this._log.debug("Starting signed dev update URL: " + zipURL);
        }
        try {
            this._get = new EepGet((I2PAppContext)this._context, proxyHost, proxyPort, 40, this._updateFile, zipURL, false);
            this._get.addStatusListener(this);
            this._get.fetch(55000L, -1L, 300000L);
        }
        catch (Throwable t) {
            this._log.error("Error updating", t);
        }
        if (!this.done) {
            this._mgr.notifyTaskFailed(this, "", null);
        }
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        File tmp = new File(this._updateFile);
        String version = TrustedUpdate.getVersionString(tmp);
        if (version.equals("")) {
            version = "unknown";
        }
        if (this._mgr.notifyComplete(this, version, tmp)) {
            this.done = true;
        } else {
            tmp.delete();
        }
    }
}

