/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.tunnel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.auth.jdbc.tunnel.ActiveConnectionRecord;

public class ActiveConnectionMultimap {
    private final Map<String, Set<ActiveConnectionRecord>> records = new HashMap<String, Set<ActiveConnectionRecord>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String identifier, ActiveConnectionRecord record) {
        Map<String, Set<ActiveConnectionRecord>> map = this.records;
        synchronized (map) {
            Set<ActiveConnectionRecord> connections = this.records.get(identifier);
            if (connections == null) {
                connections = Collections.synchronizedSet(Collections.newSetFromMap(new LinkedHashMap()));
                this.records.put(identifier, connections);
            }
            connections.add(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String identifier, ActiveConnectionRecord record) {
        Map<String, Set<ActiveConnectionRecord>> map = this.records;
        synchronized (map) {
            Set<ActiveConnectionRecord> connections = this.records.get(identifier);
            assert (connections != null);
            connections.remove(record);
            if (connections.isEmpty()) {
                this.records.remove(identifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ActiveConnectionRecord> get(String identifier) {
        Map<String, Set<ActiveConnectionRecord>> map = this.records;
        synchronized (map) {
            Collection connections = this.records.get(identifier);
            if (connections != null) {
                return Collections.unmodifiableCollection(connections);
            }
            return Collections.emptyList();
        }
    }
}

