/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.sharing.connection;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.auth.jdbc.sharing.SharedConnectionMap;
import org.apache.guacamole.auth.jdbc.sharing.connection.SharedConnection;
import org.apache.guacamole.auth.jdbc.sharing.connection.SharedConnectionDefinition;
import org.apache.guacamole.auth.jdbc.user.RemoteAuthenticatedUser;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.Directory;

public class SharedConnectionDirectory
implements Directory<Connection> {
    @Inject
    private SharedConnectionMap connectionMap;
    @Inject
    private Provider<SharedConnection> connectionProvider;
    private RemoteAuthenticatedUser currentUser;
    private final Set<String> shareKeys = Collections.newSetFromMap(new ConcurrentHashMap());

    public void init(RemoteAuthenticatedUser currentUser) {
        this.currentUser = currentUser;
    }

    public void registerShareKey(String shareKey) {
        this.shareKeys.add(shareKey);
    }

    public Connection get(String identifier) throws GuacamoleException {
        if (!this.shareKeys.contains(identifier)) {
            return null;
        }
        SharedConnectionDefinition connectionDefinition = this.connectionMap.get(identifier);
        if (connectionDefinition == null) {
            this.shareKeys.remove(identifier);
            return null;
        }
        SharedConnection connection = this.connectionProvider.get();
        connection.init(this.currentUser, connectionDefinition);
        return connection;
    }

    public Collection<Connection> getAll(Collection<String> identifiers) throws GuacamoleException {
        ArrayList<Connection> matchingConnections = new ArrayList<Connection>(identifiers.size());
        for (String identifier : identifiers) {
            Connection connection = this.get(identifier);
            if (connection == null) continue;
            matchingConnections.add(connection);
        }
        return Collections.unmodifiableCollection(matchingConnections);
    }

    public Set<String> getIdentifiers() throws GuacamoleException {
        return Collections.unmodifiableSet(this.shareKeys);
    }

    public void add(Connection object) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    public void update(Connection object) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    public void remove(String identifier) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }
}

