/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/LateinitModifierApplicabilityChecker;", "", "()V", "checkLateinitModifierApplicability", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "frontend"})
public final class LateinitModifierApplicabilityChecker {
    public static final LateinitModifierApplicabilityChecker INSTANCE;

    public final void checkLateinitModifierApplicability(@NotNull BindingTrace trace, @NotNull KtCallableDeclaration ktDeclaration, @NotNull VariableDescriptor descriptor2) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)ktDeclaration, (String)"ktDeclaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = ktDeclaration.getModifierList();
        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.LATEINIT_KEYWORD)) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"ktDeclaration.modifierLi\u2026TEINIT_KEYWORD) ?: return");
        PsiElement modifier = psiElement;
        VariableDescriptor variableDescriptor = descriptor2;
        if (variableDescriptor instanceof PropertyDescriptor) {
            string2 = "properties";
        } else if (variableDescriptor instanceof LocalVariableDescriptor) {
            string2 = "local variables";
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Should be a property or a local variable: " + descriptor2)));
        }
        String variables = string2;
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"descriptor.type");
        KotlinType type2 = kotlinType;
        if (!descriptor2.isVar()) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is allowed only on mutable " + variables));
        }
        if (InlineClassesUtilsKt.isInlineClassType(type2)) {
            if (UnsignedTypes.INSTANCE.isUnsignedType(type2)) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on " + variables + " of unsigned types"));
            } else {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on " + variables + " of inline class types"));
            }
        }
        if (type2.isMarkedNullable()) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on " + variables + " of nullable types"));
        } else if (TypeUtils.isNullableType(type2)) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on " + variables + " of a type with nullable upper bound"));
        }
        if (KotlinBuiltIns.isPrimitiveType(type2)) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on " + variables + " of primitive types"));
        }
        if (ktDeclaration instanceof KtProperty) {
            if (((KtProperty)ktDeclaration).hasDelegateExpression()) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on delegated properties"));
            } else if (((KtProperty)ktDeclaration).hasInitializer()) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on " + variables + " with initializer"));
            }
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            boolean isAbstract = ((PropertyDescriptor)descriptor2).getModality() == Modality.ABSTRACT;
            boolean hasDelegateExpressionOrInitializer = ktDeclaration instanceof KtProperty && ((KtProperty)ktDeclaration).hasDelegateExpressionOrInitializer();
            boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAccessorImplementation((PropertyDescriptor)descriptor2);
            Boolean bl = (Boolean)trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2);
            if (bl == null) {
                bl = false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"trace.bindingContext.get\u2026RED, descriptor) ?: false");
            boolean hasBackingField = bl;
            if (ktDeclaration instanceof KtParameter) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primary constructor parameters"));
            }
            if (isAbstract) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on abstract properties"));
            }
            if (!hasDelegateExpressionOrInitializer) {
                if (hasAccessorImplementation) {
                    trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with a custom getter or setter"));
                } else if (!isAbstract && !hasBackingField) {
                    trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties without backing field"));
                }
            }
            if (((PropertyDescriptor)descriptor2).getExtensionReceiverParameter() != null) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on extension properties"));
            }
        }
    }

    private LateinitModifierApplicabilityChecker() {
    }

    static {
        LateinitModifierApplicabilityChecker lateinitModifierApplicabilityChecker;
        INSTANCE = lateinitModifierApplicabilityChecker = new LateinitModifierApplicabilityChecker();
    }
}

