/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;
import net.java.plaf.windows.common.CommonMenuItemUI;

public class MenuItemPainter {
    private CommonMenuItemUI _ui;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    public MenuItemPainter(CommonMenuItemUI ui) {
        this._ui = ui;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this._ui.getAcceleratorDelimiter();
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        FontMetrics fmAccel = b.getFontMetrics(this._ui.getAcceleratorFont());
        this.resetRects();
        this.myLayoutMenuItem(fm, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(MenuItemPainter.iconRect.x, MenuItemPainter.iconRect.y, MenuItemPainter.iconRect.width, MenuItemPainter.iconRect.height, r);
        Container parent = this._ui.getMenuItem().getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this._ui.getMenuItem() instanceof JMenu && ((JMenu)this._ui.getMenuItem()).isTopLevelMenu())) {
            int maxAccValue;
            JComponent p = (JComponent)parent;
            Integer maxTextWidth = (Integer)p.getClientProperty(MAX_TEXT_WIDTH);
            Integer maxAccWidth = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
            int maxTextValue = maxTextWidth != null ? maxTextWidth : 0;
            int n = maxAccValue = maxAccWidth != null ? maxAccWidth : 0;
            if (MenuItemPainter.r.width < maxTextValue) {
                MenuItemPainter.r.width = maxTextValue;
            } else {
                p.putClientProperty(MAX_TEXT_WIDTH, new Integer(MenuItemPainter.r.width));
            }
            if (MenuItemPainter.acceleratorRect.width > maxAccValue) {
                maxAccValue = MenuItemPainter.acceleratorRect.width;
                p.putClientProperty(MAX_ACC_WIDTH, new Integer(MenuItemPainter.acceleratorRect.width));
            }
            MenuItemPainter.r.width += maxAccValue;
            MenuItemPainter.r.width += defaultTextIconGap;
        }
        if (this.myUseCheckAndArrow()) {
            MenuItemPainter.r.width += MenuItemPainter.checkIconRect.width;
            MenuItemPainter.r.width += defaultTextIconGap;
            MenuItemPainter.r.width += defaultTextIconGap;
            MenuItemPainter.r.width += MenuItemPainter.arrowIconRect.width;
        }
        MenuItemPainter.r.width += 2 * defaultTextIconGap;
        Insets insets = b.getInsets();
        if (insets != null) {
            MenuItemPainter.r.width += insets.left + insets.right;
            MenuItemPainter.r.height += insets.top + insets.bottom;
        }
        if (MenuItemPainter.r.width % 2 == 0) {
            ++MenuItemPainter.r.width;
        }
        if (MenuItemPainter.r.height % 2 == 0) {
            ++MenuItemPainter.r.height;
        }
        return r.getSize();
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        MenuItemPainter.viewRect.x += i.left;
        MenuItemPainter.viewRect.y += i.top;
        MenuItemPainter.viewRect.width -= i.right + MenuItemPainter.viewRect.x;
        MenuItemPainter.viewRect.height -= i.bottom + MenuItemPainter.viewRect.y;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this._ui.getAcceleratorFont());
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this._ui.getAcceleratorDelimiter();
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        String text = this.myLayoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, 0);
        this.paintBackground(g, b, background);
        Color holdc = g.getColor();
        if (checkIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if (this.myUseCheckAndArrow()) {
                if (!model.isEnabled()) {
                    g.setColor(this._ui.getDisabledForeground());
                }
                checkIcon.paintIcon(c, g, MenuItemPainter.checkIconRect.x, MenuItemPainter.checkIconRect.y);
            }
            g.setColor(holdc);
        }
        if (b.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(c, g, MenuItemPainter.iconRect.x, MenuItemPainter.iconRect.y);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = this._ui.getMenuItem().getParent();
            if (parent != null && parent instanceof JComponent) {
                JComponent p = (JComponent)parent;
                Integer maxValueInt = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
                int maxValue = maxValueInt != null ? maxValueInt : MenuItemPainter.acceleratorRect.width;
                accOffset = maxValue - MenuItemPainter.acceleratorRect.width;
            }
            g.setFont(this._ui.getAcceleratorFont());
            if (!model.isEnabled()) {
                if (this._ui.getDisabledForeground() != null) {
                    g.setColor(this._ui.getDisabledForeground());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, MenuItemPainter.acceleratorRect.x - accOffset, MenuItemPainter.acceleratorRect.y + fmAccel.getAscent());
                } else {
                    g.setColor(b.getBackground().brighter());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, MenuItemPainter.acceleratorRect.x - accOffset, MenuItemPainter.acceleratorRect.y + fmAccel.getAscent());
                    g.setColor(b.getBackground().darker());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, MenuItemPainter.acceleratorRect.x - accOffset - 1, MenuItemPainter.acceleratorRect.y + fmAccel.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(this._ui.getAcceleratorSelectionForeground());
                } else {
                    g.setColor(this._ui.getAcceleratorForeground());
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, MenuItemPainter.acceleratorRect.x - accOffset, MenuItemPainter.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isEnabled() && (model.isArmed() || c instanceof JMenu && model.isSelected())) {
                g.setColor(foreground);
            }
            if (this.myUseCheckAndArrow()) {
                arrowIcon.paintIcon(c, g, MenuItemPainter.arrowIconRect.x, MenuItemPainter.arrowIconRect.y);
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    private String myLayoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(this._ui.getMenuItem(), fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (this.myUseCheckAndArrow()) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (this._ui.getMenuItem().getComponentOrientation().isLeftToRight()) {
            if (icon == null) {
                textRect.x += viewRect.x + checkIcon.getIconWidth();
                iconRect.x += viewRect.x + checkIcon.getIconWidth();
            }
            acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
            if (this.myUseCheckAndArrow()) {
                checkIconRect.x = viewRect.x;
                textRect.x += menuItemGap + checkIconRect.width;
                iconRect.x += menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
            }
        } else {
            textRect.x -= menuItemGap;
            iconRect.x -= menuItemGap;
            acceleratorRect.x = viewRect.x + arrowIconRect.width + menuItemGap;
            if (this.myUseCheckAndArrow()) {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - checkIconRect.width;
                textRect.x -= menuItemGap + checkIconRect.width;
                iconRect.x -= menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + menuItemGap;
            }
        }
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (this.myUseCheckAndArrow()) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
        }
        return text;
    }

    private boolean myUseCheckAndArrow() {
        boolean b = true;
        JMenuItem menuItem = this._ui.getMenuItem();
        if (menuItem instanceof JMenu && ((JMenu)menuItem).isTopLevelMenu()) {
            b = false;
        }
        return b;
    }

    protected void paintBackground(Graphics g, JMenuItem item, Color bgColor) {
        ButtonModel model = item.getModel();
        Color oldColor = g.getColor();
        if (item.isOpaque()) {
            if (item.isArmed() || item instanceof JMenu && model.isSelected() || !model.isEnabled() && this._ui.isMouseOver()) {
                g.setColor(bgColor);
            } else {
                g.setColor(item.getBackground());
            }
        }
        g.fillRect(0, 0, item.getWidth(), item.getHeight());
        g.setColor(oldColor);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        if (!model.isEnabled()) {
            MenuItemPainter.fixedPaintText(g, menuItem, textRect, text, 0);
        } else {
            FontMetrics fm = g.getFontMetrics();
            int mnemonicIndex = menuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                mnemonicIndex = -1;
            }
            Color oldColor = g.getColor();
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(this._ui.getSelectionForeground());
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g.setColor(oldColor);
        }
    }

    public static void fixedPaintText(Graphics g, AbstractButton b, Rectangle textRect, String text, int textShiftOffset) {
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (WindowsLookAndFeel.isMnemonicHidden()) {
            mnemIndex = -1;
        }
        Color color = b.getForeground();
        if (model.isEnabled()) {
            g.setColor(color);
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x + textShiftOffset, textRect.y + fm.getAscent() + textShiftOffset);
        } else {
            color = UIManager.getColor("Button.disabledForeground");
            Color shadow = UIManager.getColor("Button.disabledShadow");
            if (WindowsLookAndFeel.isClassicWindows()) {
                if (shadow == null) {
                    shadow = b.getBackground().darker();
                }
                g.setColor(shadow);
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                if (color == null) {
                    color = b.getBackground().brighter();
                }
                g.setColor(color);
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
            } else {
                color = UIManager.getColor("textInactiveText");
                g.setColor(color);
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }
}

