/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.checkin;

import com.almworks.tracklink.checkin.StopFactory;
import com.almworks.tracklink.checkin.TracklinkCheckinHandler;
import com.almworks.tracklink.toolwindow.Dashboard;
import com.almworks.tracklink.util.BooleanWrapper;
import com.almworks.tracklink.util.BooleanWrapperImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@State(name="TL_CHECKIN_HANDLER", storages={@Storage(id="default", file="$PROJECT_FILE$")})
public class TracklinkCheckinHandlerFactory
extends CheckinHandlerFactory
implements ProjectComponent,
PersistentStateComponent<TracklinkCheckinHandlerFactory> {
    public boolean myCheckin = true;
    public boolean myFiltering = true;
    public int myDefaultDialogHeight = 700;
    public int myDefaultDialogWidth = 580;
    @Nullable
    private Project myProject;
    private final Dashboard myDashboard;
    private final BooleanWrapper myCheckinWrapper = new BooleanWrapperImpl();
    private final BooleanWrapper myFilteringWrapper = new BooleanWrapperImpl();
    private Dimension myDefaultDialogDimension;

    public TracklinkCheckinHandlerFactory() {
        this.myDashboard = null;
        this.readFromExtern();
    }

    private void readFromExtern() {
        this.myCheckinWrapper.setValue(this.myCheckin);
        this.myFilteringWrapper.setValue(this.myFiltering);
        this.myDefaultDialogDimension = new Dimension(this.myDefaultDialogWidth, this.myDefaultDialogHeight);
    }

    public TracklinkCheckinHandlerFactory(Project project, Dashboard dashboard) {
        this.myDashboard = dashboard;
        this.myProject = project;
        this.readFromExtern();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public CheckinHandler createHandler(CheckinProjectPanel panel) {
        TracklinkCheckinHandler tracklinkCheckinHandler = new TracklinkCheckinHandler(this.myProject, this.myDashboard.getArtifactInfoCache(), this.myCheckinWrapper, this.myFilteringWrapper, panel, this.myDashboard.getIssueMonitor(), this.myDefaultDialogDimension);
        if (tracklinkCheckinHandler == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/checkin/TracklinkCheckinHandlerFactory.createHandler must not return null");
        }
        return tracklinkCheckinHandler;
    }

    public void projectOpened() {
        if (this.myProject == null) {
            return;
        }
        ProjectLevelVcsManager.getInstance((Project)this.myProject).registerCheckinHandlerFactory((CheckinHandlerFactory)this);
        if (Boolean.getBoolean("tracklink.stopcommit")) {
            ProjectLevelVcsManager.getInstance((Project)this.myProject).registerCheckinHandlerFactory((CheckinHandlerFactory)new StopFactory());
        }
    }

    public void projectClosed() {
        ProjectLevelVcsManager.getInstance((Project)this.myProject).unregisterCheckinHandlerFactory((CheckinHandlerFactory)this);
        this.myProject = null;
    }

    @NotNull
    public String getComponentName() {
        if ("TL_CHECKIN_HANDLER" == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/checkin/TracklinkCheckinHandlerFactory.getComponentName must not return null");
        }
        return "TL_CHECKIN_HANDLER";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void loadState(TracklinkCheckinHandlerFactory state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
        this.readFromExtern();
    }

    public TracklinkCheckinHandlerFactory getState() {
        this.myCheckin = this.myCheckinWrapper.getValue();
        this.myFiltering = this.myFilteringWrapper.getValue();
        this.myDefaultDialogHeight = this.myDefaultDialogDimension.height;
        this.myDefaultDialogWidth = this.myDefaultDialogDimension.width;
        return this;
    }
}

