/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.tomcat.jakartaee.bcel.classfile.Attribute;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.StackMapEntry;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public final class StackMap
extends Attribute {
    private StackMapEntry[] table;

    StackMap(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (StackMapEntry[])null, constant_pool);
        int map_length = input.readUnsignedShort();
        this.table = new StackMapEntry[map_length];
        for (int i = 0; i < map_length; ++i) {
            this.table[i] = new StackMapEntry(input, constant_pool);
        }
    }

    public StackMap(int name_index, int length, StackMapEntry[] map, ConstantPool constant_pool) {
        super((byte)11, name_index, length, constant_pool);
        this.table = map;
    }

    @Override
    public void accept(Visitor v) {
        v.visitStackMap(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        StackMap c = (StackMap)this.clone();
        c.table = new StackMapEntry[this.table.length];
        Arrays.setAll(c.table, i -> this.table[i].copy());
        c.setConstantPool(constantPool);
        return c;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.table.length);
        for (StackMapEntry entry : this.table) {
            entry.dump(file);
        }
    }

    public int getMapLength() {
        return this.table == null ? 0 : this.table.length;
    }

    public StackMapEntry[] getStackMap() {
        return this.table;
    }

    public void setStackMap(StackMapEntry[] table) {
        this.table = table;
        int len = 2;
        for (StackMapEntry element : table) {
            len += element.getMapEntrySize();
        }
        this.setLength(len);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("StackMap(");
        int running_offset = -1;
        for (int i = 0; i < this.table.length; ++i) {
            running_offset = this.table[i].getByteCodeOffset() + running_offset + 1;
            buf.append(String.format("%n@%03d %s", running_offset, this.table[i]));
            if (i >= this.table.length - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }
}

