/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;

public class SqlFilterOperator
extends SqlBinaryOperator {
    public SqlFilterOperator() {
        super("FILTER", SqlKind.FILTER, 2, true, ReturnTypes.ARG0_FORCE_NULLABLE, null, (SqlOperandTypeChecker)OperandTypes.ANY_ANY);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, this.getLeftPrec());
        writer.sep(this.getName());
        writer.sep("(");
        writer.sep("WHERE");
        ((SqlNode)call.operand(1)).unparse(writer, this.getRightPrec(), rightPrec);
        writer.sep(")");
        writer.endList(frame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlCall aggCall = SqlFilterOperator.getAggCall(call);
        if (!aggCall.getOperator().isAggregator()) {
            throw validator.newValidationError(aggCall, Static.RESOURCE.filterNonAggregate());
        }
        Object condition = call.operand(1);
        SqlNodeList orderList = null;
        if (SqlFilterOperator.hasWithinGroupCall(call)) {
            SqlCall withinGroupCall = SqlFilterOperator.getWithinGroupCall(call);
            orderList = (SqlNodeList)withinGroupCall.operand(1);
        }
        validator.validateAggregateParams(aggCall, (SqlNode)condition, orderList, scope);
        RelDataType type = validator.deriveType(scope, (SqlNode)condition);
        if (!SqlTypeUtil.inBooleanFamily(type)) {
            throw validator.newValidationError((SqlNode)condition, Static.RESOURCE.condMustBeBoolean("FILTER"));
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        this.validateOperands(validator, scope, call);
        SqlCall aggCall = SqlFilterOperator.getAggCall(call);
        SqlCallBinding opBinding = new SqlCallBinding(validator, scope, aggCall){

            @Override
            public int getGroupCount() {
                return 0;
            }
        };
        RelDataType ret = aggCall.getOperator().inferReturnType(opBinding);
        ((SqlValidatorImpl)validator).setValidatedNodeType(call, ret);
        ((SqlValidatorImpl)validator).setValidatedNodeType(aggCall, ret);
        if (SqlFilterOperator.hasWithinGroupCall(call)) {
            ((SqlValidatorImpl)validator).setValidatedNodeType(SqlFilterOperator.getWithinGroupCall(call), ret);
        }
        return ret;
    }

    private static SqlCall getAggCall(SqlCall call) {
        assert (call.getOperator().getKind() == SqlKind.FILTER);
        if ((call = (SqlCall)call.operand(0)).getOperator().getKind() == SqlKind.WITHIN_GROUP) {
            call = (SqlCall)call.operand(0);
        }
        return call;
    }

    private static SqlCall getWithinGroupCall(SqlCall call) {
        assert (call.getOperator().getKind() == SqlKind.FILTER);
        if ((call = (SqlCall)call.operand(0)).getOperator().getKind() == SqlKind.WITHIN_GROUP) {
            return call;
        }
        throw new AssertionError();
    }

    private static boolean hasWithinGroupCall(SqlCall call) {
        assert (call.getOperator().getKind() == SqlKind.FILTER);
        return (call = (SqlCall)call.operand(0)).getOperator().getKind() == SqlKind.WITHIN_GROUP;
    }
}

