/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.WriteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class CloudStorageWriteChannel
implements SeekableByteChannel {
    private final WriteChannel channel;
    private long position;
    private long size;

    CloudStorageWriteChannel(WriteChannel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        CloudStorageWriteChannel cloudStorageWriteChannel = this;
        synchronized (cloudStorageWriteChannel) {
            return this.channel.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CloudStorageWriteChannel cloudStorageWriteChannel = this;
        synchronized (cloudStorageWriteChannel) {
            this.channel.close();
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        throw new NonReadableChannelException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        CloudStorageWriteChannel cloudStorageWriteChannel = this;
        synchronized (cloudStorageWriteChannel) {
            this.checkOpen();
            int amt = this.channel.write(src);
            if (amt > 0) {
                this.position += (long)amt;
                this.size += (long)amt;
            }
            return amt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        CloudStorageWriteChannel cloudStorageWriteChannel = this;
        synchronized (cloudStorageWriteChannel) {
            this.checkOpen();
            return this.position;
        }
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        CloudStorageWriteChannel cloudStorageWriteChannel = this;
        synchronized (cloudStorageWriteChannel) {
            this.checkOpen();
            return this.size;
        }
    }

    @Override
    public SeekableByteChannel truncate(long newSize) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

