/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.BTreePostCommit;
import org.apache.derby.impl.store.access.btree.BTreeRowPosition;
import org.apache.derby.impl.store.access.btree.BTreeScanInfo;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;
import org.apache.derby.impl.store.access.btree.WaitError;

public abstract class BTreeScan
extends OpenBTree
implements ScanManager {
    protected Transaction init_rawtran = null;
    protected boolean init_forUpdate;
    protected FormatableBitSet init_scanColumnList;
    protected DataValueDescriptor[] init_template;
    protected DataValueDescriptor[] init_startKeyValue;
    protected int init_startSearchOperator = 0;
    protected Qualifier[][] init_qualifier = null;
    protected DataValueDescriptor[] init_stopKeyValue;
    protected int init_stopSearchOperator = 0;
    protected boolean init_hold;
    protected FetchDescriptor init_fetchDesc;
    protected FetchDescriptor init_lock_fetch_desc;
    BTreeRowPosition scan_position;
    protected boolean init_useUpdateLocks = false;
    protected static final int SCAN_INIT = 1;
    protected static final int SCAN_INPROGRESS = 2;
    protected static final int SCAN_DONE = 3;
    protected static final int SCAN_HOLD_INIT = 4;
    protected static final int SCAN_HOLD_INPROGRESS = 5;
    protected int scan_state = 1;
    protected int stat_numpages_visited = 0;
    protected int stat_numrows_visited = 0;
    protected int stat_numrows_qualified = 0;
    protected int stat_numdeleted_rows_visited = 0;
    protected int lock_operation;
    protected DataValueDescriptor[][] fetchNext_one_slot_array = new DataValueDescriptor[1][];

    protected abstract int fetchRows(BTreeRowPosition var1, DataValueDescriptor[][] var2, RowLocation[] var3, BackingStoreHashtable var4, long var5, int[] var7) throws StandardException;

    private void initScanParams(DataValueDescriptor[] dataValueDescriptorArray, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n2) throws StandardException {
        this.init_startKeyValue = dataValueDescriptorArray;
        if (RowUtil.isRowEmpty(this.init_startKeyValue)) {
            this.init_startKeyValue = null;
        }
        this.init_startSearchOperator = n;
        if (qualifierArray != null && qualifierArray.length == 0) {
            qualifierArray = null;
        }
        this.init_qualifier = qualifierArray;
        this.init_stopKeyValue = dataValueDescriptorArray2;
        if (RowUtil.isRowEmpty(this.init_stopKeyValue)) {
            this.init_stopKeyValue = null;
        }
        this.init_stopSearchOperator = n2;
        this.scan_position = new BTreeRowPosition(this);
        this.scan_position.init();
        this.scan_position.current_lock_template = new DataValueDescriptor[this.init_template.length];
        this.scan_position.current_lock_row_loc = (RowLocation)this.init_template[this.init_template.length - 1].cloneValue(false);
        this.scan_position.current_lock_template[this.init_template.length - 1] = this.scan_position.current_lock_row_loc;
    }

    protected void positionAtStartForForwardScan(BTreeRowPosition bTreeRowPosition) throws StandardException {
        while (true) {
            boolean bl;
            ControlRow controlRow = ControlRow.get(this, 1L);
            this.stat_numpages_visited += controlRow.getLevel() + 1;
            boolean bl2 = true;
            if (this.init_startKeyValue == null) {
                bTreeRowPosition.current_leaf = (LeafControlRow)controlRow.searchLeft(this);
                bTreeRowPosition.current_slot = 0;
                bl = false;
            } else {
                SearchParameters searchParameters = new SearchParameters(this.init_startKeyValue, this.init_startSearchOperator == 1 ? 1 : -1, this.init_template, this, false);
                bTreeRowPosition.current_leaf = (LeafControlRow)controlRow.search(searchParameters);
                bTreeRowPosition.current_slot = searchParameters.resultSlot;
                bl = searchParameters.resultExact;
                if (bl && this.init_startSearchOperator == 1) {
                    --bTreeRowPosition.current_slot;
                    if (this.getConglomerate().nUniqueColumns < this.getConglomerate().nKeyFields) {
                        bl2 = false;
                    }
                }
            }
            boolean bl3 = false;
            if (bl2) {
                boolean bl4 = bl3 = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), bTreeRowPosition, this.init_lock_fetch_desc, bTreeRowPosition.current_lock_template, bTreeRowPosition.current_lock_row_loc, true, this.init_forUpdate, this.lock_operation);
            }
            if (!bl3) break;
            bTreeRowPosition.init();
        }
        this.scan_state = 2;
    }

    protected void positionAtNextPage(BTreeRowPosition bTreeRowPosition) throws StandardException {
        bTreeRowPosition.next_leaf = (LeafControlRow)bTreeRowPosition.current_leaf.getRightSibling(this);
        if (bTreeRowPosition.current_rh != null) {
            this.getLockingPolicy().unlockScanRecordAfterRead(bTreeRowPosition, this.init_forUpdate);
        }
        bTreeRowPosition.current_leaf.release();
        bTreeRowPosition.current_leaf = bTreeRowPosition.next_leaf;
        bTreeRowPosition.current_slot = 0;
        bTreeRowPosition.current_rh = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void positionAtPreviousPage() throws StandardException, WaitError {
        BTreeRowPosition bTreeRowPosition = this.scan_position;
        LeafControlRow leafControlRow = (LeafControlRow)bTreeRowPosition.current_leaf.getLeftSibling(this);
        while (leafControlRow != null && BTreeScan.isEmpty(leafControlRow.page)) {
            LeafControlRow leafControlRow2;
            try {
                leafControlRow2 = (LeafControlRow)leafControlRow.getLeftSibling(this);
            }
            finally {
                leafControlRow.release();
            }
            leafControlRow = leafControlRow2;
        }
        if (bTreeRowPosition.current_rh != null) {
            this.getLockingPolicy().unlockScanRecordAfterRead(bTreeRowPosition, this.init_forUpdate);
        }
        bTreeRowPosition.current_leaf.release();
        bTreeRowPosition.current_leaf = leafControlRow;
        bTreeRowPosition.current_slot = bTreeRowPosition.current_leaf == null ? -1 : bTreeRowPosition.current_leaf.page.recordCount();
        bTreeRowPosition.current_rh = null;
    }

    static boolean isEmpty(Page page) throws StandardException {
        return page.recordCount() <= 1;
    }

    abstract void positionAtStartPosition(BTreeRowPosition var1) throws StandardException;

    protected void positionAtDoneScanFromClose(BTreeRowPosition bTreeRowPosition) throws StandardException {
        if (!(bTreeRowPosition.current_rh == null || bTreeRowPosition.current_rh_qualified || bTreeRowPosition.current_leaf != null && bTreeRowPosition.current_leaf.page != null)) {
            this.getLockingPolicy().unlockScanRecordAfterRead(bTreeRowPosition, this.init_forUpdate);
        }
        bTreeRowPosition.current_slot = -1;
        bTreeRowPosition.current_rh = null;
        bTreeRowPosition.current_positionKey = null;
        this.scan_state = 3;
    }

    protected void positionAtDoneScan(BTreeRowPosition bTreeRowPosition) throws StandardException {
        bTreeRowPosition.current_slot = -1;
        bTreeRowPosition.current_rh = null;
        bTreeRowPosition.current_positionKey = null;
        this.scan_state = 3;
    }

    protected boolean process_qualifier(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        Qualifier qualifier;
        int n;
        boolean bl = true;
        for (n = 0; n < this.init_qualifier[0].length; ++n) {
            bl = false;
            qualifier = this.init_qualifier[0][n];
            DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[qualifier.getColumnId()];
            bl = dataValueDescriptor.compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
            if (qualifier.negateCompareResult()) {
                boolean bl2 = bl = !bl;
            }
            if (bl) continue;
            return false;
        }
        for (n = 1; n < this.init_qualifier.length; ++n) {
            bl = false;
            for (int i = 0; i < this.init_qualifier[n].length; ++i) {
                qualifier = this.init_qualifier[n][i];
                DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[qualifier.getColumnId()];
                bl = dataValueDescriptor.compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
                if (qualifier.negateCompareResult()) {
                    boolean bl3 = bl = !bl;
                }
                if (bl) break;
            }
            if (!bl) break;
        }
        return bl;
    }

    protected boolean reposition(BTreeRowPosition bTreeRowPosition, boolean bl) throws StandardException {
        Object object;
        if (this.scan_state != 2) {
            throw StandardException.newException("XSCB4.S", new Integer(this.scan_state));
        }
        if (bTreeRowPosition.current_positionKey == null) {
            throw StandardException.newException("XSCB7.S", (Object)new Boolean(bTreeRowPosition.current_rh == null), (Object)new Boolean(bTreeRowPosition.current_positionKey == null));
        }
        if (bTreeRowPosition.current_rh != null && (object = this.container.getPage(bTreeRowPosition.current_rh.getPageNumber())) != null) {
            ControlRow controlRow = ControlRow.getControlRowForPage(this.container, (Page)object);
            if (controlRow instanceof LeafControlRow && !controlRow.page.isRepositionNeeded(bTreeRowPosition.versionWhenSaved)) {
                bTreeRowPosition.current_leaf = (LeafControlRow)controlRow;
                bTreeRowPosition.current_slot = controlRow.page.getSlotNumber(bTreeRowPosition.current_rh);
                bTreeRowPosition.current_positionKey = null;
                return true;
            }
            controlRow.release();
        }
        object = new SearchParameters(bTreeRowPosition.current_positionKey, 1, this.init_template, this, false);
        bTreeRowPosition.current_leaf = (LeafControlRow)ControlRow.get(this, 1L).search((SearchParameters)object);
        if (!((SearchParameters)object).resultExact && !bl) {
            bTreeRowPosition.current_leaf.release();
            bTreeRowPosition.current_leaf = null;
            return false;
        }
        bTreeRowPosition.current_slot = ((SearchParameters)object).resultSlot;
        if (bTreeRowPosition.current_rh != null) {
            bTreeRowPosition.current_rh = bTreeRowPosition.current_leaf.page.getRecordHandleAtSlot(bTreeRowPosition.current_slot);
        }
        bTreeRowPosition.current_positionKey = null;
        return true;
    }

    public void init(TransactionManager transactionManager, Transaction transaction, boolean bl, int n, int n2, BTreeLockingPolicy bTreeLockingPolicy, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n3, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n4, BTree bTree, LogicalUndo logicalUndo, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        super.init(transactionManager, transactionManager, null, transaction, bl, n, n2, bTreeLockingPolicy, bTree, logicalUndo, dynamicCompiledOpenConglomInfo);
        this.init_rawtran = transaction;
        this.init_forUpdate = (n & 4) == 4;
        this.init_useUpdateLocks = (n & 0x1000) != 0;
        this.init_hold = bl;
        this.init_template = this.runtime_mem.get_template(this.getRawTran());
        this.init_scanColumnList = formatableBitSet;
        this.init_lock_fetch_desc = RowUtil.getFetchDescriptorConstant(this.init_template.length - 1);
        this.init_fetchDesc = new FetchDescriptor(this.init_template.length, this.init_scanColumnList, null);
        this.initScanParams(dataValueDescriptorArray, n3, qualifierArray, dataValueDescriptorArray2, n4);
        int n5 = this.lock_operation = this.init_forUpdate ? 1 : 0;
        if (this.init_useUpdateLocks) {
            this.lock_operation |= 8;
        }
    }

    public void close() throws StandardException {
        this.positionAtDoneScanFromClose(this.scan_position);
        super.close();
        this.init_rawtran = null;
        this.init_template = null;
        this.init_startKeyValue = null;
        this.init_qualifier = null;
        this.init_stopKeyValue = null;
        this.getXactMgr().closeMe(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() throws StandardException {
        boolean bl = false;
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        try {
            if (!this.reposition(this.scan_position, false)) {
                throw StandardException.newException("XSAM6.S", (Object)new Long(this.err_containerid), (Object)new Long(this.scan_position.current_rh.getPageNumber()), (Object)new Long(this.scan_position.current_rh.getId()));
            }
            if (this.init_useUpdateLocks) {
                boolean bl2;
                boolean bl3 = bl2 = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), this.scan_position, this.init_lock_fetch_desc, this.scan_position.current_lock_template, this.scan_position.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
                if (bl2 && !this.reposition(this.scan_position, false)) {
                    throw StandardException.newException("XSAM6.S", (Object)new Long(this.err_containerid), (Object)new Long(this.scan_position.current_rh.getPageNumber()), (Object)new Long(this.scan_position.current_rh.getId()));
                }
            }
            if (this.scan_position.current_leaf.page.isDeletedAtSlot(this.scan_position.current_slot)) {
                bl = false;
            } else {
                this.scan_position.current_leaf.page.deleteAtSlot(this.scan_position.current_slot, true, this.btree_undo);
                bl = true;
            }
            if (!(this.scan_position.current_leaf.page.nonDeletedRecordCount() != 1 || this.scan_position.current_leaf.getIsRoot() && this.scan_position.current_leaf.getLevel() == 0)) {
                this.getXactMgr().addPostCommitWork(new BTreePostCommit(this.getXactMgr().getAccessManager(), this.getConglomerate(), this.scan_position.current_leaf.page.getPageNumber()));
            }
        }
        finally {
            if (this.scan_position.current_leaf != null) {
                this.savePositionAndReleasePage();
            }
        }
        return bl;
    }

    public void didNotQualify() throws StandardException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesCurrentPositionQualify() throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        try {
            if (!this.reposition(this.scan_position, false)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !this.scan_position.current_leaf.page.isDeletedAtSlot(this.scan_position.current_slot);
            return bl;
        }
        finally {
            if (this.scan_position.current_leaf != null) {
                this.savePositionAndReleasePage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetch(DataValueDescriptor[] dataValueDescriptorArray, boolean bl) throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        try {
            if (!this.reposition(this.scan_position, false)) {
                throw StandardException.newException("XSAM6.S", (Object)new Long(this.err_containerid), (Object)new Long(this.scan_position.current_rh.getPageNumber()), (Object)new Long(this.scan_position.current_rh.getId()));
            }
            this.scan_position.current_rh = this.scan_position.current_leaf.page.fetchFromSlot(null, this.scan_position.current_slot, dataValueDescriptorArray, bl ? this.init_fetchDesc : null, true);
            if (this.scan_position.current_leaf.page.isDeletedAtSlot(this.scan_position.current_slot)) {
                // empty if block
            }
        }
        finally {
            if (this.scan_position.current_leaf != null) {
                this.savePositionAndReleasePage();
            }
        }
    }

    public boolean isHeldAfterCommit() throws StandardException {
        return this.scan_state == 4 || this.scan_state == 5;
    }

    public void fetch(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        this.fetch(dataValueDescriptorArray, true);
    }

    public void fetchWithoutQualify(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        this.fetch(dataValueDescriptorArray, false);
    }

    public ScanInfo getScanInfo() throws StandardException {
        return new BTreeScanInfo(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrentPositionDeleted() throws StandardException {
        boolean bl;
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        try {
            bl = this.reposition(this.scan_position, false) ? this.scan_position.current_leaf.page.isDeletedAtSlot(this.scan_position.current_slot) : false;
        }
        finally {
            if (this.scan_position.current_leaf != null) {
                this.savePositionAndReleasePage();
            }
        }
        return bl;
    }

    public boolean isKeyed() {
        return true;
    }

    public boolean positionAtRowLocation(RowLocation rowLocation) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public boolean next() throws StandardException {
        this.fetchNext_one_slot_array[0] = this.runtime_mem.get_scratch_row(this.getRawTran());
        boolean bl = this.fetchRows(this.scan_position, this.fetchNext_one_slot_array, null, null, 1L, null) == 1;
        return bl;
    }

    public boolean fetchNext(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        this.fetchNext_one_slot_array[0] = dataValueDescriptorArray;
        boolean bl = this.fetchRows(this.scan_position, this.fetchNext_one_slot_array, null, null, 1L, null) == 1;
        return bl;
    }

    public int fetchNextGroup(DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray) throws StandardException {
        return this.fetchRows(this.scan_position, dataValueDescriptorArray, rowLocationArray, null, dataValueDescriptorArray.length, null);
    }

    public int fetchNextGroup(DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray, RowLocation[] rowLocationArray2) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public void fetchSet(long l, int[] nArray, BackingStoreHashtable backingStoreHashtable) throws StandardException {
        this.fetchRows(this.scan_position, null, null, backingStoreHashtable, l, nArray);
    }

    public final void reopenScan(DataValueDescriptor[] dataValueDescriptorArray, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n2) throws StandardException {
        if (this.scan_position.current_rh != null) {
            this.getLockingPolicy().unlockScanRecordAfterRead(this.scan_position, this.init_forUpdate);
        }
        this.scan_position.current_slot = -1;
        this.scan_position.current_rh = null;
        this.scan_position.current_positionKey = null;
        this.initScanParams(dataValueDescriptorArray, n, qualifierArray, dataValueDescriptorArray2, n2);
        this.scan_state = !this.init_hold ? 1 : (this.container != null ? 1 : 4);
    }

    public void reopenScanByRowLocation(RowLocation rowLocation, Qualifier[][] qualifierArray) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public void fetchLocation(RowLocation rowLocation) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public RowLocation newRowLocationTemplate() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public boolean replace(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public boolean closeForEndTransaction(boolean bl) throws StandardException {
        if (!this.init_hold || bl) {
            this.positionAtDoneScan(this.scan_position);
            super.close();
            this.init_rawtran = null;
            this.init_template = null;
            this.init_startKeyValue = null;
            this.init_qualifier = null;
            this.init_stopKeyValue = null;
            this.getXactMgr().closeMe(this);
            return true;
        }
        if (this.scan_state == 2) {
            this.scan_position.current_rh = null;
            this.scan_state = 5;
        } else if (this.scan_state == 1) {
            this.scan_state = 4;
        }
        super.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void savePositionAndReleasePage(DataValueDescriptor[] dataValueDescriptorArray, int[] nArray) throws StandardException {
        Page page = this.scan_position.current_leaf.getPage();
        try {
            Object[] objectArray = this.scan_position.getKeyTemplate();
            FetchDescriptor fetchDescriptor = null;
            boolean bl = false;
            if (dataValueDescriptorArray != null) {
                int n = 0;
                int n2 = nArray == null ? dataValueDescriptorArray.length : nArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (nArray != null && nArray[i] == 0) continue;
                    objectArray[i].setValue(dataValueDescriptorArray[i]);
                    ++n;
                }
                if (n < objectArray.length) {
                    fetchDescriptor = this.scan_position.getFetchDescriptorForSaveKey(nArray, objectArray.length);
                } else {
                    bl = true;
                }
            }
            if (!bl) {
                RecordHandle recordHandle = page.fetchFromSlot(null, this.scan_position.current_slot, objectArray, fetchDescriptor, true);
            }
            this.scan_position.current_positionKey = objectArray;
            this.scan_position.versionWhenSaved = page.getPageVersion();
            this.scan_position.current_slot = -1;
        }
        finally {
            this.scan_position.current_leaf.release();
            this.scan_position.current_leaf = null;
        }
    }

    void savePositionAndReleasePage() throws StandardException {
        this.savePositionAndReleasePage(null, null);
    }

    public RecordHandle getCurrentRecordHandleForDebugging() {
        return this.scan_position.current_rh;
    }

    public String toString() {
        return null;
    }
}

