/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.ErrorCode;
import com.gitlab.pdftk_java.InputPdf;
import com.gitlab.pdftk_java.PageRef;
import com.gitlab.pdftk_java.TK_Session;
import com.gitlab.pdftk_java.attachments;
import com.gitlab.pdftk_java.data_import;
import com.gitlab.pdftk_java.pdftk;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import pdftk.com.lowagie.text.DocumentException;
import pdftk.com.lowagie.text.Rectangle;
import pdftk.com.lowagie.text.pdf.AcroFields;
import pdftk.com.lowagie.text.pdf.FdfReader;
import pdftk.com.lowagie.text.pdf.PdfBoolean;
import pdftk.com.lowagie.text.pdf.PdfContentByte;
import pdftk.com.lowagie.text.pdf.PdfDictionary;
import pdftk.com.lowagie.text.pdf.PdfImportedPage;
import pdftk.com.lowagie.text.pdf.PdfName;
import pdftk.com.lowagie.text.pdf.PdfNumber;
import pdftk.com.lowagie.text.pdf.PdfObject;
import pdftk.com.lowagie.text.pdf.PdfReader;
import pdftk.com.lowagie.text.pdf.PdfStamperImp;
import pdftk.com.lowagie.text.pdf.XfdfReader;

class filter {
    TK_Session session;
    String m_output_filename;
    ArrayList<InputPdf> m_input_pdf;
    ArrayList<ArrayList<PageRef>> m_page_seq;
    String m_form_data_filename;
    String m_background_filename;
    String m_stamp_filename;
    String m_update_info_filename;
    boolean m_output_need_appearances_b;
    static final String g_page_marker = "pdftk_PageNum";

    filter(TK_Session session) {
        this.session = session;
        this.m_output_filename = session.m_output_filename;
        this.m_input_pdf = session.m_input_pdf;
        this.m_page_seq = session.m_page_seq;
        this.m_form_data_filename = session.m_form_data_filename;
        this.m_background_filename = session.m_background_filename;
        this.m_stamp_filename = session.m_stamp_filename;
        this.m_update_info_filename = session.m_update_info_filename;
        this.m_output_need_appearances_b = session.m_output_need_appearances_b;
    }

    static void add_mark_to_page(PdfReader reader_p, int page_index, int page_num) {
        PdfName page_marker_p = new PdfName(g_page_marker);
        PdfDictionary page_p = reader_p.getPageN(page_index);
        if (page_p != null && page_p.isDictionary()) {
            page_p.put(page_marker_p, new PdfNumber(page_num));
        }
    }

    static void add_marks_to_pages(PdfReader reader_p) {
        int num_pages = reader_p.getNumberOfPages();
        for (int ii = 1; ii <= num_pages; ++ii) {
            filter.add_mark_to_page(reader_p, ii, ii);
        }
    }

    static void remove_mark_from_page(PdfReader reader_p, int page_num) {
        PdfName page_marker_p = new PdfName(g_page_marker);
        PdfDictionary page_p = reader_p.getPageN(page_num);
        if (page_p != null && page_p.isDictionary()) {
            page_p.remove(page_marker_p);
        }
    }

    static void remove_marks_from_pages(PdfReader reader_p) {
        int num_pages = reader_p.getNumberOfPages();
        for (int ii = 1; ii <= num_pages; ++ii) {
            filter.remove_mark_from_page(reader_p, ii);
        }
    }

    ErrorCode create_output_filter() throws DocumentException, IOException {
        PdfDictionary catalog_p;
        PdfDictionary catalog_p2;
        OutputStream ofs_p;
        InputPdf.PagesReader reader;
        InputPdf input;
        ErrorCode ret_val = ErrorCode.NO_ERROR;
        if (1 < this.m_input_pdf.size()) {
            System.err.println("Error: Only one input PDF file may be given for this");
            System.err.println("   operation.  Maybe you meant to use the \"cat\" operator?");
            return ErrorCode.ERROR;
        }
        FdfReader fdf_reader_p = null;
        XfdfReader xfdf_reader_p = null;
        if (this.m_form_data_filename.equals("PROMPT")) {
            this.m_form_data_filename = pdftk.prompt_for_filename("Please enter a filename for the form data:");
        }
        if (!this.m_form_data_filename.isEmpty()) {
            if (this.m_form_data_filename.equals("-")) {
                try {
                    fdf_reader_p = new FdfReader(System.in);
                }
                catch (IOException ioe_p) {
                    try {
                        xfdf_reader_p = new XfdfReader(System.in);
                    }
                    catch (IOException ioe2_p) {
                        System.err.println("Error: Failed read form data on stdin.");
                        return ErrorCode.ERROR;
                    }
                }
            } else {
                try {
                    fdf_reader_p = new FdfReader(this.m_form_data_filename);
                }
                catch (IOException ioe_p) {
                    try {
                        xfdf_reader_p = new XfdfReader(this.m_form_data_filename);
                    }
                    catch (IOException ioe2_p) {
                        System.err.println("Error: Failed to open form data file: ");
                        System.err.println("   " + this.m_form_data_filename);
                        return ErrorCode.ERROR;
                    }
                }
            }
        }
        PdfReader mark_p = null;
        boolean background_b = true;
        if (!this.m_background_filename.isEmpty()) {
            input = new InputPdf();
            input.m_filename = this.m_background_filename;
            input.m_role = "background";
            input.m_role_determined = "the background";
            reader = input.add_reader(false, false);
            if (reader == null) {
                return ErrorCode.ERROR;
            }
            mark_p = reader.second;
        }
        if (mark_p == null && !this.m_stamp_filename.isEmpty()) {
            background_b = false;
            input = new InputPdf();
            input.m_filename = this.m_stamp_filename;
            input.m_role = "stamp";
            input.m_role_determined = "the stamp";
            reader = input.add_reader(false, false);
            if (reader == null) {
                return ErrorCode.ERROR;
            }
            mark_p = reader.second;
        }
        if ((ofs_p = pdftk.get_output_stream(this.m_output_filename, this.session.m_ask_about_warnings_b)) == null) {
            return ErrorCode.ERROR;
        }
        PdfReader input_reader_p = this.m_input_pdf.get((int)0).m_readers.get((int)0).second;
        if (this.session.m_output_drop_xfa_b && (catalog_p2 = input_reader_p.catalog) != null && catalog_p2.isDictionary()) {
            PdfObject acro_form_p = PdfReader.getPdfObject(catalog_p2.get(PdfName.ACROFORM));
            if (acro_form_p != null && acro_form_p.isDictionary()) {
                ((PdfDictionary)acro_form_p).remove(PdfName.XFA);
            }
        }
        if (this.session.m_output_drop_xmp_b && (catalog_p2 = input_reader_p.catalog) != null) {
            catalog_p2.remove(PdfName.METADATA);
        }
        PdfStamperImp writer_p = new PdfStamperImp(input_reader_p, ofs_p, '\u0000', false);
        data_import.HashMapMutable more_info = new data_import.HashMapMutable();
        if (this.m_update_info_filename.equals("PROMPT")) {
            this.m_update_info_filename = pdftk.prompt_for_filename("Please enter an Info file filename:");
        }
        if (!this.m_update_info_filename.isEmpty()) {
            if (this.m_update_info_filename.equals("-")) {
                if (!data_import.UpdateInfo(input_reader_p, more_info, System.in, this.session.m_update_info_utf8_b)) {
                    System.err.println("Warning: no Info added to output PDF.");
                    ret_val = ErrorCode.WARNING;
                }
            } else {
                try {
                    FileInputStream ifs = new FileInputStream(this.m_update_info_filename);
                    if (!data_import.UpdateInfo(input_reader_p, more_info, ifs, this.session.m_update_info_utf8_b)) {
                        System.err.println("Warning: no Info added to output PDF.");
                        ret_val = ErrorCode.WARNING;
                    }
                }
                catch (FileNotFoundException e) {
                    System.err.println("Error: unable to open FDF file for input: " + this.m_update_info_filename);
                    return ErrorCode.ERROR;
                }
            }
        }
        if (!this.m_page_seq.isEmpty()) {
            for (ArrayList<PageRef> jt : this.m_page_seq) {
                for (PageRef kt : jt) {
                    TK_Session.apply_rotation_to_page(input_reader_p, kt.m_page_num, kt.m_page_rot.value, kt.m_page_abs);
                }
            }
        }
        if (this.session.m_output_uncompress_b) {
            filter.add_marks_to_pages(input_reader_p);
        } else {
            filter.remove_marks_from_pages(input_reader_p);
        }
        this.session.prepare_writer(writer_p);
        if (fdf_reader_p != null || xfdf_reader_p != null) {
            if (input_reader_p.getAcroForm() != null) {
                AcroFields fields_p = writer_p.getAcroFields();
                fields_p.setGenerateAppearances(true);
                if (fdf_reader_p != null && fields_p.setFields(fdf_reader_p) || xfdf_reader_p != null && fields_p.setFields(xfdf_reader_p)) {
                    this.m_output_need_appearances_b = true;
                }
            } else {
                System.err.println("Warning: input PDF is not an acroform, so its fields were not filled.");
                ret_val = ErrorCode.WARNING;
            }
        }
        writer_p.setFormFlattening(this.session.m_output_flatten_b);
        if (this.m_output_need_appearances_b && (catalog_p = input_reader_p.catalog) != null && catalog_p.isDictionary()) {
            PdfObject acro_form_p = PdfReader.getPdfObject(catalog_p.get(PdfName.ACROFORM));
            if (acro_form_p != null && acro_form_p.isDictionary()) {
                ((PdfDictionary)acro_form_p).put(PdfName.NEEDAPPEARANCES, PdfBoolean.PDFTRUE);
            }
        }
        if (mark_p != null) {
            int mark_num_pages = 1;
            if (this.session.m_multistamp_b || this.session.m_multibackground_b) {
                mark_num_pages = mark_p.getNumberOfPages();
            }
            PdfImportedPage mark_page_p = null;
            Rectangle mark_page_size_p = null;
            int mark_page_rotation = 0;
            int num_pages = input_reader_p.getNumberOfPages();
            int ii = 0;
            while (ii < num_pages) {
                PdfContentByte content_byte_p;
                float v_scale;
                if (++ii <= mark_num_pages) {
                    mark_page_size_p = mark_p.getCropBox(ii);
                    mark_page_rotation = mark_p.getPageRotation(ii);
                    for (int mm = 0; mm < mark_page_rotation; mm += 90) {
                        mark_page_size_p = mark_page_size_p.rotate();
                    }
                    mark_page_p = writer_p.getImportedPage(mark_p, ii);
                }
                Rectangle doc_page_size_p = input_reader_p.getCropBox(ii);
                int doc_page_rotation = input_reader_p.getPageRotation(ii);
                for (int mm = 0; mm < doc_page_rotation; mm += 90) {
                    doc_page_size_p = doc_page_size_p.rotate();
                }
                float h_scale = doc_page_size_p.width() / mark_page_size_p.width();
                float mark_scale = h_scale < (v_scale = doc_page_size_p.height() / mark_page_size_p.height()) ? h_scale : v_scale;
                float h_trans = (float)((double)(doc_page_size_p.left() - mark_page_size_p.left() * mark_scale) + (double)(doc_page_size_p.width() - mark_page_size_p.width() * mark_scale) / 2.0);
                float v_trans = (float)((double)(doc_page_size_p.bottom() - mark_page_size_p.bottom() * mark_scale) + (double)(doc_page_size_p.height() - mark_page_size_p.height() * mark_scale) / 2.0);
                PdfContentByte pdfContentByte = content_byte_p = background_b ? writer_p.getUnderContent(ii) : writer_p.getOverContent(ii);
                if (mark_page_rotation == 0) {
                    content_byte_p.addTemplate(mark_page_p, mark_scale, 0.0f, 0.0f, mark_scale, h_trans, v_trans);
                    continue;
                }
                if (mark_page_rotation == 90) {
                    content_byte_p.addTemplate(mark_page_p, 0.0f, -1.0f * mark_scale, mark_scale, 0.0f, h_trans, v_trans + mark_page_size_p.height() * mark_scale);
                    continue;
                }
                if (mark_page_rotation == 180) {
                    content_byte_p.addTemplate(mark_page_p, -1.0f * mark_scale, 0.0f, 0.0f, -1.0f * mark_scale, h_trans + mark_page_size_p.width() * mark_scale, v_trans + mark_page_size_p.height() * mark_scale);
                    continue;
                }
                if (mark_page_rotation != 270) continue;
                content_byte_p.addTemplate(mark_page_p, 0.0f, mark_scale, -1.0f * mark_scale, 0.0f, h_trans + mark_page_size_p.width() * mark_scale, v_trans);
            }
        }
        if (!this.session.m_input_attach_file_filename.isEmpty()) {
            attachments attachments2 = new attachments(this.session);
            attachments2.attach_files(input_reader_p, writer_p);
        }
        input_reader_p.removeUnusedObjects();
        writer_p.close(more_info.dict);
        return ret_val;
    }
}

