# Apache Ant (1.9.5) completion for Fish Shell.

function __fish_complete_ant_targets -d "Print list of targets from build.xml and imported files"
    function __get_buildfile -d "Get a buildfile that will be used by ant"
        set -l tokens $argv # tokens from 'commandline -co'
        set -l prev $tokens[1]
        set -l buildfile "build.xml"
        for token in $argv[2..-1]
            switch $prev
                case -buildfile -file -f
                    set buildfile (eval echo $token)
            end
            set prev $token
        end
        # return last one
        echo $buildfile
    end
    function __parse_ant_targets_from_projecthelp -d "Parse ant targets from projecthelp"
        set -l buildfile $argv[1] # full path to buildfile
        set -l targets (ant -p -debug -f $buildfile 2> /dev/null | string match -r '^\s[[:graph:]].*$')
        for target in $targets
            # Use [[:graph:]] and [[:print:]] to ignore ANSI escape code
            set -l tokens (string match -r '^\s([[:graph:]]+)(?:\s+([[:print:]]+))?' "$target")
            if [ (count $tokens) -ge 3 ]
                echo $tokens[2]\t$tokens[3]
            else if [ (count $tokens) -ge 2 ]
                echo $tokens[2]
            end
        end
    end
    function __get_ant_targets_from_projecthelp -d "Get ant targets from projecthelp"
        set -l buildfile $argv[1] # full path to buildfile

        set -l xdg_cache_home $XDG_CACHE_HOME[1]
        if [ \( -z $xdg_cache_home \) -o \( ! -d $xdg_cache_home \) ]
            set xdg_cache_home $HOME/.cache
        end

        set -l cache_dir $xdg_cache_home/fish/ant_completions
        mkdir -p $cache_dir

        set -l cache_file $cache_dir/(__fish_md5 -s $buildfile)
        if [ ! -s "$cache_file" ]
            # generate cache file if empty
            __parse_ant_targets_from_projecthelp $buildfile >$cache_file
        end

        cat $cache_file
    end

    set -l tokens $argv
    set -l buildfile (realpath -eq $buildfile (__get_buildfile $tokens))
    if [ $status -ne 0 ]
        return 1 # return nothing if buildfile does not exist
    end

    __get_ant_targets_from_projecthelp $buildfile
end

# completion for ant targets
complete -x -c ant -a "(__fish_complete_ant_targets (commandline -co))"

# Script Options:
complete -f -c ant -l help -l h -d 'print help message and ant help'
complete -f -c ant -l noconfig -d 'suppress sourcing of /etc/ant.conf, $HOME/.ant/ant.conf, and $HOME/.antrc configuration files'
complete -f -c ant -l usejikes -d 'enable use of jikes by default, unless set explicitly in configuration files'
complete -f -c ant -l execdebug -d 'print ant exec line generated by this launch script'
# Options:
complete -f -c ant -o help -s h -d 'print help message and exit'
complete -f -c ant -o projecthelp -s p -d 'print project help information and exit'
complete -f -c ant -o version -d 'print the version information and exit'
complete -f -c ant -o diagnostics -d 'print information that might be helpful to diagnose or report problems and exit'
complete -f -c ant -o quiet -s q -d 'be extra quiet'
complete -f -c ant -o silent -s S -d 'print nothing but task outputs and build failures'
complete -f -c ant -o verbose -s v -d 'be extra verbose'
complete -f -c ant -o debug -s d -d 'print debugging information'
complete -f -c ant -o emacs -s e -d 'produce logging information without adornments'
complete -f -c ant -o noinput -d 'do not allow interactive input'
complete -f -c ant -s D -d 'use value for given property like -D<property>=<value>'
complete -f -c ant -o keep-going -s k -d 'execute all targets that do not depend on failed target(s)'
complete -f -c ant -o nouserlib -d 'Run ant without using the jar files from ${user.home}/.ant/lib'
complete -f -c ant -o noclasspath -d 'Run ant without using CLASSPATH'
complete -f -c ant -o autoproxy -d 'Java1.5+: use the OS proxy settings'
complete -r -c ant -o lib -d 'specifies a path to search for jars and classes'
complete -r -c ant -o logfile -s l -d 'use given file for log'
complete -r -c ant -o logger -d 'the class which is to perform logging'
complete -r -c ant -o listener -d 'add an instance of class as a project listener'
complete -r -c ant -o buildfile -o file -s f -d 'use given buildfile'
complete -r -c ant -o propertyfile -d 'load all properties from file with -D properties taking precedence'
complete -r -c ant -o inputhandler -d 'the class which will handle input requests'
complete -r -c ant -o find -s s -d '(s)earch for buildfile towards the root of the filesystem and use it'
complete -r -c ant -o nice -d 'A niceness value for the main thread: 1 (lowest) to 10 (highest); 5 is the default'
complete -r -c ant -o main -d 'override Ant\'s normal entry point'
