/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.Dictionary;

public abstract class Token {
    private final char[] surfaceForm;
    private final int offset;
    private final int length;
    private final int startOffset;
    private final int endOffset;
    private int posIncr = 1;
    private int posLen = 1;

    public Token(char[] surfaceForm, int offset, int length, int startOffset, int endOffset) {
        this.surfaceForm = surfaceForm;
        this.offset = offset;
        this.length = length;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public char[] getSurfaceForm() {
        return this.surfaceForm;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getSurfaceFormString() {
        return new String(this.surfaceForm, this.offset, this.length);
    }

    public abstract POS.Type getPOSType();

    public abstract POS.Tag getLeftPOS();

    public abstract POS.Tag getRightPOS();

    public abstract String getReading();

    public abstract Dictionary.Morpheme[] getMorphemes();

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setPositionIncrement(int posIncr) {
        this.posIncr = posIncr;
    }

    public int getPositionIncrement() {
        return this.posIncr;
    }

    public void setPositionLength(int posLen) {
        this.posLen = posLen;
    }

    public int getPositionLength() {
        return this.posLen;
    }
}

