/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import com.intellij.util.io.NettyKt;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;
import org.jetbrains.io.webSocket.WebSocketProtocolHandler;

@ChannelHandler.Sharable
final class MessageChannelHandler
extends WebSocketProtocolHandler {
    private final ClientManager clientManager;
    private final MessageServer messageServer;

    MessageChannelHandler(@NotNull ClientManager clientManager, @NotNull MessageServer messageServer) {
        if (clientManager == null) {
            MessageChannelHandler.$$$reportNull$$$0(0);
        }
        if (messageServer == null) {
            MessageChannelHandler.$$$reportNull$$$0(1);
        }
        this.clientManager = clientManager;
        this.messageServer = messageServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeFrameReceived(@NotNull Channel channel2, @NotNull CloseWebSocketFrame message) {
        WebSocketClient client;
        if (channel2 == null) {
            MessageChannelHandler.$$$reportNull$$$0(2);
        }
        if (message == null) {
            MessageChannelHandler.$$$reportNull$$$0(3);
        }
        if ((client = (WebSocketClient)((Object)channel2.attr(ClientManagerKt.getCLIENT()).get())) == null) {
            super.closeFrameReceived(channel2, message);
        } else {
            try {
                this.clientManager.disconnectClient(channel2, client, false);
            }
            finally {
                client.disconnect(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void textFrameReceived(@NotNull Channel channel2, @NotNull TextWebSocketFrame message) {
        String chars;
        if (channel2 == null) {
            MessageChannelHandler.$$$reportNull$$$0(4);
        }
        if (message == null) {
            MessageChannelHandler.$$$reportNull$$$0(5);
        }
        WebSocketClient client = (WebSocketClient)((Object)channel2.attr(ClientManagerKt.getCLIENT()).get());
        try {
            chars = NettyKt.readUtf8((ByteBuf)message.content());
        }
        catch (Throwable e) {
            try {
                message.release();
            }
            finally {
                this.clientManager.getExceptionHandler().exceptionCaught(e);
            }
            return;
        }
        try {
            this.messageServer.messageReceived(client, chars);
        }
        catch (Throwable e) {
            this.clientManager.getExceptionHandler().exceptionCaught(e);
        }
    }

    public void channelInactive(ChannelHandlerContext context) throws Exception {
        Client client = (Client)((Object)context.channel().attr(ClientManagerKt.getCLIENT()).get());
        if (client != null) {
            this.clientManager.disconnectClient(context.channel(), client, false);
        }
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        if (context == null) {
            MessageChannelHandler.$$$reportNull$$$0(6);
        }
        if (cause == null) {
            MessageChannelHandler.$$$reportNull$$$0(7);
        }
        try {
            this.clientManager.getExceptionHandler().exceptionCaught(cause);
        }
        finally {
            super.exceptionCaught(context, cause);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageServer";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/io/webSocket/MessageChannelHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "closeFrameReceived";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "textFrameReceived";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "exceptionCaught";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

