/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.intellij.util.net.NetUtils;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.ConsoleManager;
import org.jetbrains.builtInWebServer.NetService;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001#B\u0019\b\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH$J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J4\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H$J\b\u0010\u001c\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H$J\b\u0010\"\u001a\u00020\u001aH%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lorg/jetbrains/builtInWebServer/NetService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "consoleManager", "Lorg/jetbrains/builtInWebServer/ConsoleManager;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/builtInWebServer/ConsoleManager;)V", "processHandler", "Lorg/jetbrains/concurrency/AsyncValueLoader;", "Lcom/intellij/execution/process/OSProcessHandler;", "getProcessHandler", "()Lorg/jetbrains/concurrency/AsyncValueLoader;", "getProject", "()Lcom/intellij/openapi/project/Project;", "closeProcessConnections", "", "configureConsole", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "connectToProcess", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "port", "", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "createProcessHandler", "dispose", "getAvailableSocketPort", "getConsoleToolWindowActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getConsoleToolWindowIcon", "Ljavax/swing/Icon;", "getConsoleToolWindowId", "MyProcessAdapter", "intellij.platform.builtInServer.impl"})
public abstract class NetService
implements Disposable {
    @NotNull
    private final AsyncValueLoader<OSProcessHandler> processHandler;
    @NotNull
    private final Project project;
    private final ConsoleManager consoleManager;

    @NotNull
    protected final AsyncValueLoader<OSProcessHandler> getProcessHandler() {
        return this.processHandler;
    }

    protected int getAvailableSocketPort() {
        return NetUtils.findAvailableSocketPort();
    }

    @Nullable
    protected abstract OSProcessHandler createProcessHandler(@NotNull Project var1, int var2) throws ExecutionException;

    protected void connectToProcess(@NotNull AsyncPromise<OSProcessHandler> promise, int port, @NotNull OSProcessHandler processHandler2, @NotNull Consumer<String> errorOutputConsumer) {
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        Intrinsics.checkNotNullParameter((Object)processHandler2, (String)"processHandler");
        Intrinsics.checkNotNullParameter(errorOutputConsumer, (String)"errorOutputConsumer");
        promise.setResult((Object)processHandler2);
    }

    protected abstract void closeProcessConnections();

    public void dispose() {
        this.processHandler.reset();
    }

    protected void configureConsole(@NotNull TextConsoleBuilder consoleBuilder) {
        Intrinsics.checkNotNullParameter((Object)consoleBuilder, (String)"consoleBuilder");
    }

    @NonNls
    @NotNull
    protected abstract String getConsoleToolWindowId();

    @NotNull
    protected abstract Icon getConsoleToolWindowIcon();

    @NotNull
    public ActionGroup getConsoleToolWindowActions() {
        return (ActionGroup)new DefaultActionGroup();
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @JvmOverloads
    protected NetService(@NotNull Project project, @NotNull ConsoleManager consoleManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleManager, (String)"consoleManager");
        this.project = project;
        this.consoleManager = consoleManager;
        this.processHandler = (AsyncValueLoader)new AsyncValueLoader<OSProcessHandler>(this){
            final /* synthetic */ NetService this$0;

            protected boolean isCancelOnReject() {
                return true;
            }

            private final OSProcessHandler doGetProcessHandler(int port) {
                try {
                    return this.this$0.createProcessHandler(this.this$0.getProject(), port);
                }
                catch (ExecutionException e) {
                    BuiltInWebServerKt.getLOG().error((Throwable)e);
                    return null;
                }
            }

            @NotNull
            protected Promise<OSProcessHandler> load(@NotNull AsyncPromise<OSProcessHandler> promise) {
                Intrinsics.checkNotNullParameter(promise, (String)"promise");
                int port = this.this$0.getAvailableSocketPort();
                OSProcessHandler processHandler2 = this.doGetProcessHandler(port);
                if (processHandler2 == null) {
                    promise.setError("rejected");
                    return (Promise)promise;
                }
                promise.onError((java.util.function.Consumer)new java.util.function.Consumer<Throwable>(processHandler2){
                    final /* synthetic */ OSProcessHandler $processHandler;

                    public final void accept(@NotNull Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$processHandler.destroyProcess();
                        Promises.errorIfNotMessage((Logger)BuiltInWebServerKt.getLOG(), (Throwable)it);
                    }
                    {
                        this.$processHandler = oSProcessHandler;
                    }
                });
                MyProcessAdapter processListener = this.this$0.new MyProcessAdapter(processHandler2);
                processHandler2.addProcessListener((ProcessListener)processListener);
                processHandler2.startNotify();
                if (Promises.isRejected((Promise)((Promise)promise))) {
                    return (Promise)promise;
                }
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, promise, port, processHandler2, processListener){
                    final /* synthetic */ processHandler.1 this$0;
                    final /* synthetic */ AsyncPromise $promise;
                    final /* synthetic */ int $port;
                    final /* synthetic */ OSProcessHandler $processHandler;
                    final /* synthetic */ MyProcessAdapter $processListener;

                    public final void run() {
                        block3: {
                            if (!Promises.isRejected((Promise)((Promise)this.$promise))) {
                                try {
                                    this.this$0.this$0.connectToProcess((AsyncPromise<OSProcessHandler>)this.$promise, this.$port, this.$processHandler, (Consumer<String>)((Consumer)this.$processListener));
                                }
                                catch (Throwable e) {
                                    if (this.$promise.setError(e)) break block3;
                                    BuiltInWebServerKt.getLOG().error(e);
                                }
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$promise = asyncPromise;
                        this.$port = n;
                        this.$processHandler = oSProcessHandler;
                        this.$processListener = myProcessAdapter;
                    }
                });
                return (Promise)promise;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void disposeResult(@NotNull OSProcessHandler processHandler2) {
                Intrinsics.checkNotNullParameter((Object)processHandler2, (String)"processHandler");
                try {
                    this.this$0.closeProcessConnections();
                }
                finally {
                    processHandler2.destroyProcess();
                }
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public /* synthetic */ NetService(Project project, ConsoleManager consoleManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            consoleManager = new ConsoleManager();
        }
        this(project, consoleManager);
    }

    @JvmOverloads
    protected NetService(@NotNull Project project) {
        this(project, null, 2, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u001c\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/builtInWebServer/NetService$MyProcessAdapter;", "Lcom/intellij/execution/process/ProcessAdapter;", "Lcom/intellij/util/Consumer;", "", "osProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "(Lorg/jetbrains/builtInWebServer/NetService;Lcom/intellij/execution/process/OSProcessHandler;)V", "consume", "", "message", "onTextAvailable", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "print", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "processTerminated", "intellij.platform.builtInServer.impl"})
    private final class MyProcessAdapter
    extends ProcessAdapter
    implements Consumer<String> {
        private final OSProcessHandler osProcessHandler;

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.text");
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(outputType);
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.g\u2026nsoleViewType(outputType)");
            this.print(string, consoleViewContentType);
        }

        private final void print(String text2, ConsoleViewContentType contentType) {
            NetService.this.consoleManager.getConsole(NetService.this).print(text2, contentType);
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            OSProcessHandler result2 = (OSProcessHandler)NetService.this.getProcessHandler().getResultIfFullFilled();
            if (result2 != null && Intrinsics.areEqual((Object)result2, (Object)this.osProcessHandler)) {
                NetService.this.getProcessHandler().reset();
            }
            String string = NetService.this.getConsoleToolWindowId() + " terminated\n";
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
            this.print(string, consoleViewContentType);
        }

        public void consume(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
            this.print(message, consoleViewContentType);
        }

        public MyProcessAdapter(OSProcessHandler osProcessHandler) {
            this.osProcessHandler = osProcessHandler;
        }
    }
}

