/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;

public class DuplicateCharacterInClassInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DuplicateCharacterInClassInspection.$$$reportNull$$$0(0);
        }
        return new DuplicateCharacterInClassVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/DuplicateCharacterInClassInspection", "buildVisitor"));
    }

    private static final class DuplicateCharacterInClassFix
    implements LocalQuickFix {
        private final String myText;

        private DuplicateCharacterInClassFix(RegExpElement predefinedCharacterClass) {
            this.myText = predefinedCharacterClass.getText();
        }

        @NotNull
        public String getName() {
            String string = RegExpBundle.message("inspection.quick.fix.remove.duplicate.0.from.character.class", this.myText);
            if (string == null) {
                DuplicateCharacterInClassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RegExpBundle.message("inspection.quick.fix.remove.duplicate.element.from.character.class", new Object[0]);
            if (string == null) {
                DuplicateCharacterInClassFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                DuplicateCharacterInClassFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                DuplicateCharacterInClassFix.$$$reportNull$$$0(3);
            }
            descriptor2.getPsiElement().delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/DuplicateCharacterInClassInspection$DuplicateCharacterInClassFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/DuplicateCharacterInClassInspection$DuplicateCharacterInClassFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DuplicateCharacterInClassVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        DuplicateCharacterInClassVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                DuplicateCharacterInClassVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpClass(RegExpClass regExpClass) {
            HashSet<Object> seen = new HashSet<Object>();
            for (RegExpClassElement element2 : regExpClass.getElements()) {
                this.checkForDuplicates(element2, seen);
            }
        }

        private void checkForDuplicates(RegExpClassElement element2, Set<Object> seen) {
            RegExpSimpleClass regExpSimpleClass;
            RegExpSimpleClass.Kind kind;
            if (element2 instanceof RegExpChar) {
                RegExpChar regExpChar = (RegExpChar)element2;
                int value2 = regExpChar.getValue();
                if (value2 != -1 && !seen.add(value2)) {
                    this.myHolder.registerProblem((PsiElement)regExpChar, RegExpBundle.message("warning.duplicate.character.0.inside.character.class", regExpChar.getText()), new LocalQuickFix[]{new DuplicateCharacterInClassFix(regExpChar)});
                }
            } else if (element2 instanceof RegExpSimpleClass && !seen.add((Object)(kind = (regExpSimpleClass = (RegExpSimpleClass)element2).getKind()))) {
                String text2 = regExpSimpleClass.getText();
                this.myHolder.registerProblem((PsiElement)regExpSimpleClass, RegExpBundle.message("warning.duplicate.predefined.character.class.0.inside.character.class", text2), new LocalQuickFix[]{new DuplicateCharacterInClassFix(regExpSimpleClass)});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/DuplicateCharacterInClassInspection$DuplicateCharacterInClassVisitor", "<init>"));
        }
    }
}

