/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import org.jetbrains.annotations.NotNull;

final class StorageGuard {
    private int myHolds;
    private int myWaiters;
    private final StorageModeExitHandler myTrueStorageModeExitHandler = new StorageModeExitHandler(){

        @Override
        public void leave() {
            StorageGuard.this.leave(true);
        }
    };
    private final StorageModeExitHandler myFalseStorageModeExitHandler = new StorageModeExitHandler(){

        @Override
        public void leave() {
            StorageGuard.this.leave(false);
        }
    };

    StorageGuard() {
    }

    @NotNull
    synchronized StorageModeExitHandler enter(boolean mode) {
        if (mode) {
            while (this.myHolds < 0) {
                this.doWait();
            }
            ++this.myHolds;
            StorageModeExitHandler storageModeExitHandler = this.myTrueStorageModeExitHandler;
            if (storageModeExitHandler == null) {
                StorageGuard.$$$reportNull$$$0(0);
            }
            return storageModeExitHandler;
        }
        while (this.myHolds > 0) {
            this.doWait();
        }
        --this.myHolds;
        StorageModeExitHandler storageModeExitHandler = this.myFalseStorageModeExitHandler;
        if (storageModeExitHandler == null) {
            StorageGuard.$$$reportNull$$$0(1);
        }
        return storageModeExitHandler;
    }

    private void doWait() {
        try {
            ++this.myWaiters;
            this.wait();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            --this.myWaiters;
        }
    }

    private synchronized void leave(boolean mode) {
        this.myHolds += mode ? -1 : 1;
        if (this.myHolds == 0 && this.myWaiters > 0) {
            this.notifyAll();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/StorageGuard", "enter"));
    }

    public static interface StorageModeExitHandler {
        public void leave();
    }
}

