/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.tree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.TreePopup;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.NextStepHandler;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreePopupImpl
extends WizardPopup
implements TreePopup,
NextStepHandler {
    private static final Logger LOG = Logger.getInstance(TreePopupImpl.class);
    private MyTree myWizardTree;
    private MouseMotionListener myMouseMotionListener;
    private MouseListener myMouseListener;
    private final List<TreePath> mySavedExpanded;
    private TreePath mySavedSelected;
    private TreePath myShowingChildPath;
    private TreePath myPendingChildPath;
    private FilteringTreeBuilder myBuilder;

    public TreePopupImpl(@Nullable Project project, @Nullable JBPopup parent, @NotNull TreePopupStep<Object> aStep, @Nullable Object parentValue) {
        if (aStep == null) {
            TreePopupImpl.$$$reportNull$$$0(0);
        }
        super(project, parent, (PopupStep<Object>)aStep);
        this.mySavedExpanded = new ArrayList<TreePath>();
        this.setParentValue(parentValue);
    }

    @Override
    protected JComponent createContent() {
        this.myWizardTree = new MyTree();
        this.myWizardTree.getAccessibleContext().setAccessibleName("WizardTree");
        this.myBuilder = new FilteringTreeBuilder((Tree)this.myWizardTree, this, this.getTreeStep().getStructure(), (Comparator)AlphaComparator.INSTANCE){

            protected boolean isSelectable(Object nodeObject) {
                return TreePopupImpl.this.getTreeStep().isSelectable(nodeObject, nodeObject);
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myBuilder.updateFromRoot();
        this.myWizardTree.getSelectionModel().setSelectionMode(1);
        Action action2 = this.myWizardTree.getActionMap().get("toggleSelectionPreserveAnchor");
        if (action2 != null) {
            action2.setEnabled(false);
        }
        this.myWizardTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TreePopupImpl.this.toggleExpansion(TreePopupImpl.this.myWizardTree.getAnchorSelectionPath());
                }
            }
        });
        this.myWizardTree.setRootVisible(this.getTreeStep().isRootVisible());
        this.myWizardTree.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myWizardTree));
        this.myWizardTree.setCellRenderer((TreeCellRenderer)((Object)new MyRenderer()));
        this.myMouseMotionListener = new MyMouseMotionListener();
        this.myMouseListener = new MyMouseListener();
        this.registerAction("select", 10, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePopupImpl.this.handleSelect(true, null);
            }
        });
        this.registerAction("toggleExpansion", 32, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePopupImpl.this.toggleExpansion(TreePopupImpl.this.myWizardTree.getSelectionPath());
            }
        });
        final Action oldExpandAction = this.getActionMap().get("selectChild");
        this.getActionMap().put("selectChild", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = TreePopupImpl.this.myWizardTree.getSelectionPath();
                if (path != null && 0 == TreePopupImpl.this.myWizardTree.getModel().getChildCount(path.getLastPathComponent())) {
                    TreePopupImpl.this.handleSelect(false, null);
                    return;
                }
                oldExpandAction.actionPerformed(e);
            }
        });
        final Action oldCollapseAction = this.getActionMap().get("selectParent");
        this.getActionMap().put("selectParent", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = TreePopupImpl.this.myWizardTree.getSelectionPath();
                if (TreePopupImpl.this.shouldHidePopup(path)) {
                    TreePopupImpl.this.goBack();
                    return;
                }
                oldCollapseAction.actionPerformed(e);
            }
        });
        return this.myWizardTree;
    }

    private boolean shouldHidePopup(TreePath path) {
        if (this.getParent() == null) {
            return false;
        }
        if (path == null) {
            return false;
        }
        if (!this.myWizardTree.isCollapsed(path)) {
            return false;
        }
        if (this.myWizardTree.isRootVisible()) {
            return path.getPathCount() == 1;
        }
        return path.getPathCount() == 2;
    }

    @Override
    protected ActionMap getActionMap() {
        return this.myWizardTree.getActionMap();
    }

    @Override
    protected InputMap getInputMap() {
        return this.myWizardTree.getInputMap();
    }

    private void addListeners() {
        this.myWizardTree.addMouseMotionListener(this.myMouseMotionListener);
        this.myWizardTree.addMouseListener(this.myMouseListener);
    }

    @Override
    public void dispose() {
        this.mySavedExpanded.clear();
        Enumeration expanded = this.myWizardTree.getExpandedDescendants(new TreePath(this.myWizardTree.getModel().getRoot()));
        if (expanded != null) {
            while (expanded.hasMoreElements()) {
                this.mySavedExpanded.add((TreePath)expanded.nextElement());
            }
        }
        this.mySavedSelected = this.myWizardTree.getSelectionPath();
        this.myWizardTree.removeMouseMotionListener(this.myMouseMotionListener);
        this.myWizardTree.removeMouseListener(this.myMouseListener);
        super.dispose();
    }

    @Override
    protected boolean beforeShow() {
        this.addListeners();
        this.expandAll();
        this.collapseAll();
        this.restoreExpanded();
        if (this.mySavedSelected != null) {
            this.myWizardTree.setSelectionPath(this.mySavedSelected);
        }
        return super.beforeShow();
    }

    @Override
    protected void afterShow() {
        this.selectFirstSelectableItem();
    }

    private void selectFirstSelectableItem() {
        for (int i2 = 0; i2 < this.myWizardTree.getRowCount(); ++i2) {
            TreePath path = this.myWizardTree.getPathForRow(i2);
            if (!this.getTreeStep().isSelectable(path.getLastPathComponent(), this.extractUserObject(path.getLastPathComponent()))) continue;
            this.myWizardTree.setSelectionPath(path);
            break;
        }
    }

    private void restoreExpanded() {
        if (this.mySavedExpanded.isEmpty()) {
            this.expandAll();
            return;
        }
        for (TreePath each : this.mySavedExpanded) {
            this.myWizardTree.expandPath(each);
        }
    }

    public void expandAll() {
        for (int i2 = 0; i2 < this.myWizardTree.getRowCount(); ++i2) {
            this.myWizardTree.expandRow(i2);
        }
    }

    public void collapseAll() {
        for (int row = this.myWizardTree.getRowCount() - 1; row > 0; --row) {
            this.myWizardTree.collapseRow(row);
        }
    }

    public void scrollToSelection() {
        this.myWizardTree.scrollPathToVisible(this.myWizardTree.getSelectionPath());
    }

    private TreePopupStep getTreeStep() {
        return (TreePopupStep)this.myStep;
    }

    private TreePath getPath(MouseEvent e) {
        return this.myWizardTree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y);
    }

    private void toggleExpansion(TreePath path) {
        if (path == null) {
            return;
        }
        if (this.getTreeStep().isSelectable(path.getLastPathComponent(), this.extractUserObject(path.getLastPathComponent()))) {
            if (this.myWizardTree.isExpanded(path)) {
                this.myWizardTree.collapsePath(path);
            } else {
                this.myWizardTree.expandPath(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSelect(boolean handleFinalChoices, MouseEvent e) {
        boolean pathIsAlreadySelected;
        boolean bl = pathIsAlreadySelected = this.myShowingChildPath != null && this.myShowingChildPath.equals(this.myWizardTree.getSelectionPath());
        if (pathIsAlreadySelected) {
            return;
        }
        this.myPendingChildPath = null;
        Object selected2 = this.myWizardTree.getLastSelectedPathComponent();
        if (selected2 != null) {
            Object userObject = this.extractUserObject(selected2);
            if (this.getTreeStep().isSelectable(selected2, userObject)) {
                PopupStep queriedStep;
                this.disposeChildren();
                boolean hasNextStep = this.myStep.hasSubstep(userObject);
                if (!hasNextStep && !handleFinalChoices) {
                    this.myShowingChildPath = null;
                    return;
                }
                AtomicBoolean insideOnChosen = new AtomicBoolean(true);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (insideOnChosen.get()) {
                        LOG.error("Showing dialogs from popup onChosen can result in focus issues. Please put the handler into BaseStep.doFinalStep or PopupStep.getFinalRunnable.");
                    }
                }, ModalityState.any());
                try {
                    queriedStep = this.myStep.onChosen(userObject, handleFinalChoices);
                }
                finally {
                    insideOnChosen.set(false);
                }
                if (queriedStep == PopupStep.FINAL_CHOICE || !hasNextStep) {
                    this.setFinalRunnable(this.myStep.getFinalRunnable());
                    this.setOk(true);
                    this.disposeAllParents(e);
                } else {
                    this.myShowingChildPath = this.myWizardTree.getSelectionPath();
                    this.handleNextStep(queriedStep, this.myShowingChildPath);
                    this.myShowingChildPath = null;
                }
            }
        }
    }

    @Override
    public void handleNextStep(PopupStep nextStep, Object parentValue) {
        Rectangle pathBounds = this.myWizardTree.getPathBounds(this.myWizardTree.getSelectionPath());
        Point point = new RelativePoint((Component)((Object)this.myWizardTree), new Point(this.getContent().getWidth() + 2, (int)pathBounds.getY())).getScreenPoint();
        this.myChild = this.createPopup(this, nextStep, parentValue);
        this.myChild.show(this.getContent(), point.x - 2, point.y, true);
    }

    @Override
    protected void process(KeyEvent aEvent) {
        this.myWizardTree.processKeyEvent(aEvent);
    }

    private Object extractUserObject(Object aNode) {
        Object object = ((DefaultMutableTreeNode)aNode).getUserObject();
        if (object instanceof FilteringTreeStructure.FilteringNode) {
            return ((FilteringTreeStructure.FilteringNode)object).getDelegate();
        }
        return object;
    }

    @Override
    protected void onAutoSelectionTimer() {
        this.handleSelect(false, null);
    }

    @Override
    protected JComponent getPreferredFocusableComponent() {
        return this.myWizardTree;
    }

    @Override
    protected void onSpeedSearchPatternChanged() {
        this.myBuilder.refilterAsync();
    }

    @Override
    protected void onChildSelectedFor(Object value2) {
        TreePath path = (TreePath)value2;
        if (this.myWizardTree.getSelectionPath() != path) {
            this.myWizardTree.setSelectionPath(path);
        }
    }

    @Override
    public boolean isModalContext() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aStep", "com/intellij/ui/popup/tree/TreePopupImpl", "<init>"));
    }

    private class MyTree
    extends SimpleTree {
        private MyTree() {
        }

        public void processKeyEvent(KeyEvent e) {
            e.setSource((Object)this);
            super.processKeyEvent(e);
        }

        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            return new Dimension(pref.width + 10, pref.height);
        }

        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            Rectangle visibleRect = this.getVisibleRect();
            int rowForLocation = this.getClosestRowForLocation(0, visibleRect.y);
            int limit = rowForLocation + TreeUtil.getVisibleRowCount((JTree)((Object)this)) + 1;
            for (int i2 = rowForLocation; i2 < limit; ++i2) {
                TreePath eachPath = this.getPathForRow(i2);
                if (eachPath == null) continue;
                Object lastPathComponent = eachPath.getLastPathComponent();
                boolean hasNextStep = TreePopupImpl.this.getTreeStep().hasSubstep(TreePopupImpl.this.extractUserObject(lastPathComponent));
                if (!hasNextStep) continue;
                Icon icon2 = AllIcons.Icons.Ide.NextStep;
                Rectangle rec = this.getPathBounds(eachPath);
                int x = this.getSize().width - icon2.getIconWidth() - 1;
                int y = rec.y + (rec.height - icon2.getIconWidth()) / 2;
                icon2.paintIcon((Component)((Object)this), g, x, y);
            }
        }
    }

    private class MyRenderer
    extends NodeRenderer {
        private MyRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            boolean shouldPaintSelected = TreePopupImpl.this.getTreeStep().isSelectable(value2, TreePopupImpl.this.extractUserObject(value2)) && selected2 || TreePopupImpl.this.getTreeStep().isSelectable(value2, TreePopupImpl.this.extractUserObject(value2)) && hasFocus;
            boolean shouldPaintFocus = !TreePopupImpl.this.getTreeStep().isSelectable(value2, TreePopupImpl.this.extractUserObject(value2)) && selected2 || shouldPaintSelected || hasFocus;
            super.customizeCellRenderer(tree, value2, shouldPaintSelected, expanded, leaf, row, shouldPaintFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/popup/tree/TreePopupImpl$MyRenderer", "customizeCellRenderer"));
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TreePath path = TreePopupImpl.this.getPath(e);
            if (path == null) {
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            Object selected2 = path.getLastPathComponent();
            if (TreePopupImpl.this.getTreeStep().isSelectable(selected2, TreePopupImpl.this.extractUserObject(selected2))) {
                TreePopupImpl.this.handleSelect(true, e);
            } else if (!TreeUtil.isLocationInExpandControl((JTree)((Object)TreePopupImpl.this.myWizardTree), (TreePath)path, (int)e.getX(), (int)e.getY())) {
                TreePopupImpl.this.toggleExpansion(path);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private Point myLastMouseLocation;

        private MyMouseMotionListener() {
        }

        private boolean isMouseMoved(Point location) {
            if (this.myLastMouseLocation == null) {
                this.myLastMouseLocation = location;
                return false;
            }
            Point prev = this.myLastMouseLocation;
            this.myLastMouseLocation = location;
            return !prev.equals(location);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.isMouseMoved(e.getLocationOnScreen())) {
                return;
            }
            TreePath path = TreePopupImpl.this.getPath(e);
            if (path != null) {
                TreePopupImpl.this.myWizardTree.setSelectionPath(path);
                TreePopupImpl.this.notifyParentOnChildSelection();
                if (TreePopupImpl.this.getTreeStep().isSelectable(path.getLastPathComponent(), TreePopupImpl.this.extractUserObject(path.getLastPathComponent()))) {
                    TreePopupImpl.this.myWizardTree.setCursor(Cursor.getPredefinedCursor(12));
                    if (TreePopupImpl.this.myPendingChildPath == null || !TreePopupImpl.this.myPendingChildPath.equals(path)) {
                        TreePopupImpl.this.myPendingChildPath = path;
                        TreePopupImpl.this.restartTimer();
                    }
                    return;
                }
            }
            TreePopupImpl.this.myWizardTree.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

