/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.mac.touchbar.BarContainer;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.TouchBar;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StackTouchBars {
    private final ArrayDeque<BarContainer> myContainersStack = new ArrayDeque();
    private final TouchBarHolder myTouchBarHolder = new TouchBarHolder();
    private long myCurrentKeyMask;

    StackTouchBars() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateKeyMask(long newMask) {
        if (this.myCurrentKeyMask != newMask) {
            StackTouchBars stackTouchBars = this;
            synchronized (stackTouchBars) {
                this.myCurrentKeyMask = newMask;
                this._setTouchBarFromTopContainer();
            }
        }
    }

    @Nullable
    synchronized TouchBar getTopTouchBar() {
        BarContainer topContainer = this.myContainersStack.peek();
        return topContainer == null ? null : topContainer.get();
    }

    @Nullable
    synchronized BarContainer findTopProjectContainer(@NotNull Project project) {
        if (project == null) {
            StackTouchBars.$$$reportNull$$$0(0);
        }
        Iterator<BarContainer> it = this.myContainersStack.descendingIterator();
        while (it.hasNext()) {
            BarContainer b = it.next();
            if (b.getProject() != project) continue;
            return b;
        }
        return null;
    }

    synchronized void pop(@Nullable Condition<? super BarContainer> condition) {
        BarContainer top = this.myContainersStack.peek();
        if (top == null) {
            return;
        }
        if (condition != null && !condition.value((Object)top)) {
            return;
        }
        this.myContainersStack.pop();
        this._setTouchBarFromTopContainer();
    }

    synchronized void removeAll(@NotNull Collection<BarContainer> toErase) {
        if (toErase == null) {
            StackTouchBars.$$$reportNull$$$0(1);
        }
        this.myContainersStack.removeAll(toErase);
        this._setTouchBarFromTopContainer();
    }

    synchronized void setTouchBarFromTopContainer() {
        this._setTouchBarFromTopContainer();
    }

    synchronized void showContainer(BarContainer bar2) {
        if (bar2 == null) {
            return;
        }
        BarContainer top = this.myContainersStack.peek();
        if (top == bar2) {
            return;
        }
        this.myContainersStack.remove(bar2);
        this.myContainersStack.push(bar2);
        this._setTouchBarFromTopContainer();
    }

    synchronized void removeContainer(BarContainer tb) {
        if (tb == null || this.myContainersStack.isEmpty()) {
            return;
        }
        tb.onHide();
        BarContainer top = this.myContainersStack.peek();
        if (top == tb) {
            this.myContainersStack.pop();
            this._setTouchBarFromTopContainer();
        } else {
            this.myContainersStack.remove(tb);
        }
    }

    private void _setTouchBarFromTopContainer() {
        if (this.myContainersStack.isEmpty()) {
            this.myTouchBarHolder.setTouchBar(null);
            return;
        }
        BarContainer top = this.myContainersStack.peek();
        top.selectBarByKeyMask(this.myCurrentKeyMask);
        TouchBar tb = top.get();
        if (tb != null && tb.isEmpty()) {
            this.myTouchBarHolder.setTouchBar(null);
            return;
        }
        this.myTouchBarHolder.setTouchBar(tb);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toErase";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/mac/touchbar/StackTouchBars";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTopProjectContainer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TouchBarHolder {
        private TouchBar myCurrentBar;
        private TouchBar myNextBar;

        private TouchBarHolder() {
        }

        synchronized void setTouchBar(TouchBar bar2) {
            @NotNull Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
                return;
            }
            this.myNextBar = bar2;
            Timer timer2 = new Timer(100, event -> this._setNextTouchBar());
            timer2.setRepeats(false);
            timer2.start();
        }

        private synchronized void _setNextTouchBar() {
            if (this.myCurrentBar == this.myNextBar) {
                return;
            }
            if (this.myCurrentBar != null) {
                this.myCurrentBar.onHide();
            }
            this.myCurrentBar = this.myNextBar;
            if (this.myCurrentBar != null) {
                this.myCurrentBar.onBeforeShow();
            }
            NST.setTouchBar(this.myCurrentBar);
        }
    }
}

