/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EditorSelectionLocalSearchScope
extends LocalSearchScope {
    private final Editor myEditor;
    private final Project myProject;
    private PsiElement[] myPsiElements;
    private VirtualFile[] myVirtualFiles;
    private TextRange[] myRanges;
    private final boolean myIgnoreInjectedPsi;
    @NotNull
    @Nls
    private final String myDisplayName;
    private LocalSearchScope myLocalSearchScope;

    private void initVirtualFilesAndRanges() {
        if (this.myRanges != null) {
            return;
        }
        SelectionModel selectionModel = this.myEditor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            this.myVirtualFiles = VirtualFile.EMPTY_ARRAY;
            this.myRanges = TextRange.EMPTY_ARRAY;
            return;
        }
        this.myVirtualFiles = new VirtualFile[]{FileDocumentManager.getInstance().getFile(this.myEditor.getDocument())};
        int[] selectionStarts = selectionModel.getBlockSelectionStarts();
        int[] selectionEnds = selectionModel.getBlockSelectionEnds();
        this.myRanges = new TextRange[selectionStarts.length];
        for (int i2 = 0; i2 < selectionStarts.length; ++i2) {
            this.myRanges[i2] = new TextRange(selectionStarts[i2], selectionEnds[i2]);
        }
    }

    private void init() {
        ReadAction.run(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
            if (psiFile == null) {
                this.myPsiElements = PsiElement.EMPTY_ARRAY;
                return;
            }
            SelectionModel selectionModel = this.myEditor.getSelectionModel();
            if (!selectionModel.hasSelection()) {
                this.myPsiElements = PsiElement.EMPTY_ARRAY;
                return;
            }
            int[] selectionStarts = selectionModel.getBlockSelectionStarts();
            int[] selectionEnds = selectionModel.getBlockSelectionEnds();
            ArrayList<PsiElement> elements2 = new ArrayList<PsiElement>();
            for (int i2 = 0; i2 < selectionStarts.length; ++i2) {
                PsiElement parent;
                int end;
                PsiElement endElement;
                int start2 = selectionStarts[i2];
                PsiElement startElement = psiFile.findElementAt(start2);
                if (startElement == null || (endElement = psiFile.findElementAt(end = selectionEnds[i2])) == null || (parent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement)) == null) continue;
                PsiElement[] children2 = parent.getChildren();
                TextRange selection = new TextRange(start2, end);
                for (PsiElement child2 : children2) {
                    if (child2 instanceof PsiWhiteSpace || child2.getContainingFile() == null || !selection.contains(child2.getTextOffset())) continue;
                    elements2.add(child2);
                }
            }
            this.myPsiElements = elements2.toArray(PsiElement.EMPTY_ARRAY);
        });
    }

    private PsiElement[] getPsiElements() {
        if (this.myPsiElements == null) {
            this.init();
        }
        return this.myPsiElements;
    }

    private TextRange[] getRanges() {
        this.initVirtualFilesAndRanges();
        return this.myRanges;
    }

    public EditorSelectionLocalSearchScope(@NotNull Editor editor, Project project, @NotNull @Nls String displayName) {
        if (editor == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(1);
        }
        this(editor, project, displayName, false);
    }

    public EditorSelectionLocalSearchScope(@NotNull Editor editor, Project project, @NotNull @Nls String displayName, boolean ignoreInjectedPsi) {
        if (editor == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(2);
        }
        if (displayName == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(3);
        }
        super(PsiElement.EMPTY_ARRAY);
        this.myEditor = editor;
        this.myProject = project;
        this.myDisplayName = displayName;
        this.myIgnoreInjectedPsi = ignoreInjectedPsi;
    }

    public boolean isIgnoreInjectedPsi() {
        return this.myIgnoreInjectedPsi;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(4);
        }
        return string;
    }

    public VirtualFile @NotNull [] getVirtualFiles() {
        this.initVirtualFilesAndRanges();
        if (this.myVirtualFiles == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(5);
        }
        return this.myVirtualFiles;
    }

    public boolean equals(Object o) {
        TextRange[] otherRanges;
        if (this == o) {
            return true;
        }
        if (!(o instanceof EditorSelectionLocalSearchScope)) {
            return false;
        }
        EditorSelectionLocalSearchScope other = (EditorSelectionLocalSearchScope)((Object)o);
        VirtualFile[] files2 = this.getVirtualFiles();
        VirtualFile[] otherFiles = other.getVirtualFiles();
        if (!Comparing.equal((Object)files2.length, (Object)otherFiles.length)) {
            return false;
        }
        if (files2.length > 0 && !Comparing.equal((Object)files2[0], (Object)otherFiles[0])) {
            return false;
        }
        TextRange[] ranges = this.getRanges();
        if (ranges.length != (otherRanges = other.getRanges()).length) {
            return false;
        }
        for (int i2 = 0; i2 < ranges.length; ++i2) {
            if (Comparing.equal((Object)ranges[i2], (Object)otherRanges[i2])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        TextRange[] ranges = this.getRanges();
        VirtualFile[] files2 = this.getVirtualFiles();
        if (files2.length > 0) {
            builder2.append(files2[0].toString());
        }
        for (int i2 = 0; i2 < ranges.length; ++i2) {
            if (i2 > 0) {
                builder2.append(',');
            }
            builder2.append('{');
            builder2.append(ranges[i2].toString());
            builder2.append('}');
        }
        return builder2.toString();
    }

    protected int calcHashCode() {
        int result2 = 0;
        TextRange[] ranges = this.getRanges();
        VirtualFile[] files2 = this.getVirtualFiles();
        if (files2.length > 0) {
            result2 += files2[0].hashCode();
        }
        for (TextRange range2 : ranges) {
            result2 += range2.hashCode();
        }
        return result2;
    }

    public boolean containsRange(@NotNull PsiFile file2, @NotNull TextRange range2) {
        TextRange[] ranges;
        VirtualFile[] files2;
        VirtualFile virtualFile;
        if (file2 == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(6);
        }
        if (range2 == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(7);
        }
        if ((virtualFile = file2.getVirtualFile()) == null) {
            virtualFile = file2.getNavigationElement().getContainingFile().getVirtualFile();
        }
        if ((files2 = this.getVirtualFiles()).length == 0) {
            return false;
        }
        if (!files2[0].equals(virtualFile)) {
            return false;
        }
        for (TextRange textRange : ranges = this.getRanges()) {
            if (!textRange.contains(range2)) continue;
            return true;
        }
        return false;
    }

    private void createIfNeeded() {
        if (this.myLocalSearchScope == null) {
            this.myLocalSearchScope = new LocalSearchScope(this.getPsiElements(), this.myDisplayName, this.myIgnoreInjectedPsi);
        }
    }

    public PsiElement @NotNull [] getScope() {
        this.createIfNeeded();
        PsiElement[] psiElementArray = this.myLocalSearchScope.getScope();
        if (psiElementArray == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(8);
        }
        return psiElementArray;
    }

    @NotNull
    public LocalSearchScope intersectWith(@NotNull LocalSearchScope scope2) {
        if (scope2 == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(9);
        }
        this.createIfNeeded();
        LocalSearchScope localSearchScope = this.myLocalSearchScope.intersectWith(scope2);
        if (localSearchScope == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(10);
        }
        return localSearchScope;
    }

    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(11);
        }
        this.createIfNeeded();
        SearchScope searchScope2 = this.myLocalSearchScope.intersectWith(scope2);
        if (searchScope2 == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(12);
        }
        return searchScope2;
    }

    @NotNull
    public SearchScope union(@NotNull SearchScope scope) {
        if (scope == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(13);
        }
        this.createIfNeeded();
        SearchScope searchScope2 = this.myLocalSearchScope.union(scope);
        if (searchScope2 == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(14);
        }
        return searchScope2;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(15);
        }
        this.createIfNeeded();
        return this.myLocalSearchScope.contains(file2);
    }

    public boolean isInScope(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(16);
        }
        this.createIfNeeded();
        return this.myLocalSearchScope.isInScope(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/EditorSelectionLocalSearchScope";
                break;
            }
            case 6: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/EditorSelectionLocalSearchScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsRange";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

