/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class CachesBasedRefSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public CachesBasedRefSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<? super PsiReference> consumer2) {
        PsiMetaData metaData;
        if (p == null) {
            CachesBasedRefSearcher.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            CachesBasedRefSearcher.$$$reportNull$$$0(1);
        }
        PsiElement refElement = p.getElementToSearch();
        boolean caseSensitive = refElement.getLanguage().isCaseSensitive();
        String text2 = null;
        if (refElement instanceof PsiFileSystemItem && !(refElement instanceof SyntheticFileSystemItem)) {
            VirtualFile vFile = ((PsiFileSystemItem)refElement).getVirtualFile();
            if (vFile != null) {
                String fileNameWithoutExtension = vFile.getNameWithoutExtension();
                text2 = fileNameWithoutExtension.isEmpty() ? vFile.getName() : fileNameWithoutExtension;
            }
            caseSensitive = false;
        } else if (refElement instanceof PsiNamedElement) {
            text2 = ((PsiNamedElement)refElement).getName();
            if (refElement instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)refElement).getMetaData()) != null) {
                text2 = metaData.getName();
            }
        }
        if (text2 == null && refElement instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)refElement).getMetaData()) != null) {
            text2 = metaData.getName();
        }
        if (StringUtil.isNotEmpty((String)text2)) {
            SearchScope searchScope2 = p.getEffectiveSearchScope();
            p.getOptimizer().searchWord(text2, searchScope2, caseSensitive, refElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "p";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/search/CachesBasedRefSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

