/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.CoreAwareIconManager;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.BitUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PsiIconUtil;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementBase
extends UserDataHolderBase
implements Iconable {
    private static final Logger LOG = Logger.getInstance(ElementBase.class);
    public static final int FLAGS_LOCKED = 2048;
    private static final Function<ElementIconRequest, Icon> ICON_COMPUTE = request -> {
        PsiElement element2 = ((ElementIconRequest)request).myPointer.getElement();
        if (element2 == null) {
            return null;
        }
        Icon icon2 = ElementBase.computeIconNow(element2, ((ElementIconRequest)request).myFlags);
        Iconable.LastComputedIcon.put((UserDataHolder)element2, (Icon)icon2, (int)((ElementIconRequest)request).myFlags);
        return icon2;
    };
    private static final NotNullLazyValue<Icon> VISIBILITY_ICON_PLACEHOLDER = NotNullLazyValue.createValue(() -> IconManager.getInstance().createEmptyIcon(PlatformIcons.PUBLIC_ICON));

    @Nullable
    public Icon getIcon(int flags) {
        if (!(this instanceof PsiElement)) {
            return null;
        }
        try {
            return this.computeIcon(flags);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private Icon computeIcon(@Iconable.IconFlags int flags) {
        PsiElement psiElement = (PsiElement)this;
        if (!psiElement.isValid()) {
            return null;
        }
        if (Registry.is((String)"psi.deferIconLoading", (boolean)true)) {
            Icon baseIcon = Iconable.LastComputedIcon.get((UserDataHolder)psiElement, (int)flags);
            if (baseIcon == null) {
                baseIcon = (Icon)AstLoadingFilter.disallowTreeLoading(() -> this.computeBaseIcon(flags));
            }
            return baseIcon == null ? null : IconManager.getInstance().createDeferredIcon(baseIcon, (Object)new ElementIconRequest(psiElement, psiElement.getProject(), flags), ICON_COMPUTE);
        }
        return ElementBase.computeIconNow(psiElement, flags);
    }

    @Nullable
    private static Icon computeIconNow(@NotNull PsiElement element2, @Iconable.IconFlags int flags) {
        if (element2 == null) {
            ElementBase.$$$reportNull$$$0(0);
        }
        return (Icon)AstLoadingFilter.disallowTreeLoading(() -> ElementBase.doComputeIconNow(element2, flags));
    }

    private static Icon doComputeIconNow(@NotNull PsiElement element2, @Iconable.IconFlags int flags) {
        Icon providersIcon;
        if (element2 == null) {
            ElementBase.$$$reportNull$$$0(1);
        }
        if ((providersIcon = PsiIconUtil.getProvidersIcon((PsiElement)element2, (int)flags)) != null) {
            if (providersIcon instanceof RowIcon) {
                return providersIcon;
            }
            return IconManager.getInstance().createLayeredIcon((Iconable)element2, providersIcon, flags);
        }
        return ((ElementBase)element2).getElementIcon(flags);
    }

    protected Icon computeBaseIcon(@Iconable.IconFlags int flags) {
        PsiFile file2;
        Icon baseIcon;
        Icon icon2 = baseIcon = this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
        if (this instanceof PsiElement && (file2 = ((PsiElement)this).getContainingFile()) != null) {
            return IconManager.getInstance().createLayeredIcon((Iconable)file2, baseIcon, flags);
        }
        return baseIcon;
    }

    protected Icon getBaseIcon() {
        PsiFile file2;
        if (this instanceof PsiElement && (file2 = ((PsiElement)this).getContainingFile()) != null && !ElementBase.isNativeFileType(file2.getFileType())) {
            return file2.getFileType().getIcon();
        }
        return AllIcons.Nodes.NodePlaceholder;
    }

    public static boolean isNativeFileType(FileType fileType) {
        return fileType instanceof INativeFileType && ((INativeFileType)fileType).useNativeIcon() || fileType instanceof UnknownFileType;
    }

    protected Icon getAdjustedBaseIcon(Icon icon2, @Iconable.IconFlags int flags) {
        if (BitUtil.isSet((int)flags, (int)1)) {
            return IconManager.getInstance().createRowIcon(new Icon[]{icon2, (Icon)VISIBILITY_ICON_PLACEHOLDER.getValue()});
        }
        return icon2;
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    @NotNull
    public static RowIcon buildRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon rowIcon = IconManager.getInstance().createRowIcon(new Icon[]{baseIcon, visibilityIcon});
        if (rowIcon == null) {
            ElementBase.$$$reportNull$$$0(2);
        }
        return rowIcon;
    }

    public static Icon iconWithVisibilityIfNeeded(@Iconable.IconFlags int flags, Icon baseIcon, Icon visibility) {
        return BitUtil.isSet((int)flags, (int)1) ? ElementBase.buildRowIcon(baseIcon, visibility) : baseIcon;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon baseIcon;
        int elementFlags;
        PsiElement element2 = (PsiElement)this;
        if (!element2.isValid()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet((int)flags, (int)2) && !element2.isWritable();
        int n = elementFlags = isLocked ? 2048 : 0;
        if (element2 instanceof ItemPresentation && (baseIcon = ((ItemPresentation)element2).getIcon(false)) != null) {
            return IconManager.getInstance().createLayeredIcon((Iconable)this, baseIcon, elementFlags);
        }
        if (element2 instanceof PsiFile) {
            Icon baseIcon2;
            PsiFile psiFile = (PsiFile)element2;
            VirtualFile vFile = psiFile.getVirtualFile();
            if (vFile == null) {
                baseIcon2 = psiFile.getFileType().getIcon();
            } else {
                IconManager iconManager = IconManager.getInstance();
                if (iconManager instanceof CoreAwareIconManager) {
                    baseIcon2 = ((CoreAwareIconManager)iconManager).getIcon(vFile, flags & 0xFFFFFFFD, psiFile.getProject());
                } else {
                    return null;
                }
            }
            return IconManager.getInstance().createLayeredIcon((Iconable)this, baseIcon2, elementFlags);
        }
        return null;
    }

    public static int transformFlags(PsiElement element2, @Iconable.IconFlags int _flags) {
        boolean isLocked;
        int flags = BitUtil.clear((int)_flags, (int)2);
        boolean bl = isLocked = BitUtil.isSet((int)_flags, (int)2) && !element2.isWritable();
        if (isLocked) {
            flags |= 0x800;
        }
        return flags;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/ElementBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/ElementBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRowIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeIconNow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIconNow";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ElementIconRequest {
        private final SmartPsiElementPointer<?> myPointer;
        @Iconable.IconFlags
        private final int myFlags;

        private ElementIconRequest(@NotNull PsiElement element2, @NotNull Project project, @Iconable.IconFlags int flags) {
            if (element2 == null) {
                ElementIconRequest.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ElementIconRequest.$$$reportNull$$$0(1);
            }
            this.myPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element2);
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementIconRequest)) {
                return false;
            }
            ElementIconRequest request = (ElementIconRequest)o;
            if (this.myFlags != request.myFlags) {
                return false;
            }
            return this.myPointer.equals(request.myPointer);
        }

        public int hashCode() {
            int result2 = this.myPointer.hashCode();
            result2 = 31 * result2 + this.myFlags;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/ElementBase$ElementIconRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

