/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.ui;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.ui.CodeStyleSettingsNameProvider;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractedSettingsDialog
extends DialogWrapper {
    protected CodeStyleSettingsNameProvider myNameProvider;
    protected List<Value> myValues;
    protected DefaultMutableTreeNode myRoot;
    private static final ValueRenderer myValueRenderer = new ValueRenderer();
    private static final ValueEditor myValueEditor = new ValueEditor();
    final TreeCellRenderer myTitleRenderer;

    public ExtractedSettingsDialog(@Nullable Project project, @NotNull CodeStyleSettingsNameProvider nameProvider, @NotNull List<Value> values) {
        if (nameProvider == null) {
            ExtractedSettingsDialog.$$$reportNull$$$0(0);
        }
        if (values == null) {
            ExtractedSettingsDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myTitleRenderer = new CellRenderer();
        this.myNameProvider = nameProvider;
        this.myValues = values;
        this.setModal(true);
        this.init();
        this.setTitle(LangBundle.message((String)"dialog.title.extracted.code.style.settings", (Object[])new Object[0]));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.buildExtractedSettingsTree();
    }

    public boolean valueIsSelectedInTree(@NotNull Value value2) {
        if (value2 == null) {
            ExtractedSettingsDialog.$$$reportNull$$$0(2);
        }
        if (this.myRoot == null) {
            return false;
        }
        return this.valueIsSelectedInTree(this.myRoot, value2);
    }

    protected boolean valueIsSelectedInTree(@NotNull TreeNode startNode, @NotNull Value value2) {
        if (startNode == null) {
            ExtractedSettingsDialog.$$$reportNull$$$0(3);
        }
        if (value2 == null) {
            ExtractedSettingsDialog.$$$reportNull$$$0(4);
        }
        Enumeration<? extends TreeNode> children2 = startNode.children();
        while (children2.hasMoreElements()) {
            TreeNode child2 = children2.nextElement();
            if (child2 instanceof SettingsTreeNode) {
                SettingsTreeNode settingsChild = (SettingsTreeNode)child2;
                if (settingsChild.accepted && value2.equals((Object)settingsChild.myValue)) {
                    return true;
                }
                if (!this.valueIsSelectedInTree(settingsChild, value2)) continue;
                return true;
            }
            if (!(child2 instanceof TreeNode) || !this.valueIsSelectedInTree(child2, value2)) continue;
            return true;
        }
        return false;
    }

    protected static ColumnInfo getTitleColumnInfo() {
        return new ColumnInfo("TITLE"){

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof SettingsTreeNode) {
                    return ((SettingsTreeNode)o).getTitle();
                }
                return o.toString();
            }

            public Class getColumnClass() {
                return TreeTableModel.class;
            }
        };
    }

    protected static ColumnInfo getValueColumnInfo() {
        return new ColumnInfo("VALUE"){

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof SettingsTreeNode) {
                    return ((SettingsTreeNode)o).getValueString();
                }
                return null;
            }

            public TableCellRenderer getRenderer(Object o) {
                return myValueRenderer;
            }

            public TableCellEditor getEditor(Object o) {
                return myValueEditor;
            }

            public boolean isCellEditable(Object o) {
                return o instanceof SettingsTreeNode;
            }
        };
    }

    protected JComponent buildExtractedSettingsTree() {
        HashSet<Value> unusedValues = new HashSet<Value>(this.myValues);
        this.myRoot = new DefaultMutableTreeNode();
        for (Map.Entry<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>> typeEntry : this.myNameProvider.mySettings.entrySet()) {
            DefaultMutableTreeNode settingsNode = null;
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> groupEntry : typeEntry.getValue().entrySet()) {
                CodeStyleSettingPresentation headRep;
                CodeStyleSettingPresentation.SettingsGroup group2 = groupEntry.getKey();
                List<CodeStyleSettingPresentation> representations = groupEntry.getValue();
                List<CodeStyleSettingPresentation> children2 = ContainerUtil.emptyList();
                DefaultMutableTreeNode groupNode = null;
                if (group2.name == null && !representations.isEmpty()) {
                    Value myValue;
                    if (representations.size() > 1) {
                        children2 = representations.subList(1, representations.size());
                    }
                    if ((myValue = CodeStyleSettingsNameProvider.getValue(headRep = representations.get(0), this.myValues)) == null) {
                        groupNode = new SettingsTreeNode(headRep.getUiName());
                    } else {
                        groupNode = new SettingsTreeNode(headRep.getUiName());
                        groupNode.add(new SettingsTreeNode(headRep.getValueUiName(myValue.value), headRep, true, myValue));
                        unusedValues.remove(myValue);
                    }
                } else {
                    children2 = representations;
                }
                headRep = children2.iterator();
                while (headRep.hasNext()) {
                    CodeStyleSettingPresentation representation = headRep.next();
                    Value myValue = CodeStyleSettingsNameProvider.getValue(representation, this.myValues);
                    if (myValue == null) continue;
                    if (groupNode == null) {
                        groupNode = new SettingsTreeNode(group2.name);
                    }
                    groupNode.add(new SettingsTreeNode(representation.getValueUiName(myValue.value), representation, false, myValue));
                    unusedValues.remove(myValue);
                }
                if (groupNode == null || groupNode.isLeaf()) continue;
                if (settingsNode == null) {
                    settingsNode = new SettingsTreeNode(CodeStyleSettingsNameProvider.getSettingsTypeName(typeEntry.getKey()));
                }
                settingsNode.add(groupNode);
            }
            if (settingsNode == null) continue;
            this.myRoot.add(settingsNode);
        }
        final ColumnInfo[] COLUMNS = new ColumnInfo[]{ExtractedSettingsDialog.getTitleColumnInfo(), ExtractedSettingsDialog.getValueColumnInfo()};
        ListTreeTableModel model2 = new ListTreeTableModel((TreeNode)this.myRoot, COLUMNS);
        TreeTable treeTable = new TreeTable((TreeTableModel)model2){

            public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
                TreeTableCellRenderer tableRenderer = super.createTableRenderer(treeTableModel);
                tableRenderer.setRootVisible(false);
                tableRenderer.setShowsRootHandles(true);
                return tableRenderer;
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                TreePath treePath = this.getTree().getPathForRow(row);
                if (treePath == null) {
                    return super.getCellRenderer(row, column);
                }
                Object node = treePath.getLastPathComponent();
                TableCellRenderer renderer2 = COLUMNS[column].getRenderer(node);
                return renderer2 == null ? super.getCellRenderer(row, column) : renderer2;
            }

            public TableCellEditor getCellEditor(int row, int column) {
                TreePath treePath = this.getTree().getPathForRow(row);
                if (treePath == null) {
                    return super.getCellEditor(row, column);
                }
                Object node = treePath.getLastPathComponent();
                TableCellEditor editor = COLUMNS[column].getEditor(node);
                return editor == null ? super.getCellEditor(row, column) : editor;
            }
        };
        new TreeTableSpeedSearch(treeTable).setComparator(new SpeedSearchComparator(false));
        treeTable.setRootVisible(false);
        TreeTableTree tree = treeTable.getTree();
        tree.setCellRenderer(this.myTitleRenderer);
        tree.setShowsRootHandles(true);
        treeTable.setSelectionMode(0);
        treeTable.setTableHeader(null);
        TreeUtil.expandAll((JTree)tree);
        treeTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(1);
        treeTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(1);
        int maxWidth = tree.getPreferredScrollableViewportSize().width + 10;
        TableColumn titleColumn = treeTable.getColumnModel().getColumn(0);
        titleColumn.setPreferredWidth(maxWidth);
        titleColumn.setMinWidth(maxWidth);
        titleColumn.setMaxWidth(maxWidth);
        titleColumn.setResizable(false);
        Dimension valueSize = new JLabel(ApplicationBundle.message((String)"option.table.sizing.text", (Object[])new Object[0])).getPreferredSize();
        treeTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)(maxWidth + valueSize.width + 10), (int)20));
        treeTable.setBackground(UIUtil.getPanelBackground());
        treeTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        Dimension screenSize = treeTable.getToolkit().getScreenSize();
        JBScrollPane scroller = new JBScrollPane((Component)treeTable){

            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        Dimension preferredSize = new Dimension(Math.min(screenSize.width / 2, treeTable.getPreferredSize().width), Math.min(screenSize.height / 2, treeTable.getPreferredSize().height));
        this.getRootPane().setPreferredSize(preferredSize);
        return scroller;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/extractor/ui/ExtractedSettingsDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "valueIsSelectedInTree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CellRenderer
    implements TreeCellRenderer {
        private final JLabel myLabel = new JLabel();

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value2 instanceof SettingsTreeNode) {
                SettingsTreeNode node = (SettingsTreeNode)value2;
                this.myLabel.setText(node.getTitle());
                this.myLabel.setFont(node.isGroupOrTypeNode() ? this.myLabel.getFont().deriveFont(1) : this.myLabel.getFont().deriveFont(0));
            } else {
                this.myLabel.setText(value2.toString());
                this.myLabel.setFont(this.myLabel.getFont().deriveFont(1));
            }
            Color foreground = selected2 ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
            this.myLabel.setForeground(foreground);
            JLabel jLabel = this.myLabel;
            if (jLabel == null) {
                CellRenderer.$$$reportNull$$$0(0);
            }
            return jLabel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/ui/ExtractedSettingsDialog$CellRenderer", "getTreeCellRendererComponent"));
        }
    }

    protected static class ValueEditor
    extends AbstractTableCellEditor {
        private final JLabel myLabel = new JLabel();
        private final JCheckBox myCheckBox = new JCheckBox();
        private final JPanel myPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
        private SettingsTreeNode myCurrentNode;
        private TreeTable myCurrentTree;
        final ActionListener itemChoiceListener;

        protected void updateAncestorsUi(boolean accepted, SettingsTreeNode node) {
            TreeNode parent = node.getParent();
            if (parent instanceof SettingsTreeNode) {
                SettingsTreeNode settingsParent = (SettingsTreeNode)parent;
                settingsParent.accepted = false;
                if (!accepted) {
                    this.updateAncestorsUi(false, settingsParent);
                } else {
                    Enumeration<? extends TreeNode> children2 = parent.children();
                    while (children2.hasMoreElements()) {
                        TreeNode child2 = children2.nextElement();
                        if (!(child2 instanceof SettingsTreeNode) || ((SettingsTreeNode)child2).accepted) continue;
                        return;
                    }
                    settingsParent.accepted = true;
                    this.updateAncestorsUi(true, settingsParent);
                }
            }
        }

        protected void updateChildrenUi(SettingsTreeNode node) {
            Enumeration<TreeNode> children2 = node.children();
            while (children2.hasMoreElements()) {
                TreeNode child2 = children2.nextElement();
                if (!(child2 instanceof SettingsTreeNode)) continue;
                SettingsTreeNode settingsChild = (SettingsTreeNode)child2;
                settingsChild.accepted = node.accepted;
                this.updateChildrenUi(settingsChild);
            }
        }

        public ValueEditor() {
            this.myPanel.add(this.myLabel);
            this.myPanel.add(this.myCheckBox);
            this.itemChoiceListener = new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (myCurrentNode != null) {
                        boolean wasChanged = myCurrentNode.accepted != myCheckBox.isSelected();
                        myCurrentNode.accepted = myCheckBox.isSelected();
                        if (wasChanged) {
                            this.updateAncestorsUi(myCurrentNode.accepted, myCurrentNode);
                            this.updateChildrenUi(myCurrentNode);
                        }
                        if (myCurrentTree != null) {
                            myCurrentTree.repaint();
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/codeStyle/extractor/ui/ExtractedSettingsDialog$ValueEditor$1", "actionPerformed"));
                }
            };
            this.myCheckBox.addActionListener(this.itemChoiceListener);
        }

        public Object getCellEditorValue() {
            return this.myCheckBox.isSelected();
        }

        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)((TreeTable)table).getTree().getPathForRow(row).getLastPathComponent();
            if (treeNode instanceof SettingsTreeNode) {
                this.myCurrentTree = (TreeTable)table;
                this.myCurrentNode = (SettingsTreeNode)treeNode;
                this.myLabel.setText(this.myCurrentNode.getValueString());
                this.myCheckBox.setSelected(this.myCurrentNode.accepted);
            }
            return this.myPanel;
        }
    }

    protected static class ValueRenderer
    implements TableCellRenderer {
        private final JLabel myLabel = new JLabel();
        private final JCheckBox myCheckBox = new JCheckBox();
        private final JPanel myPanel = new JPanel((LayoutManager)new HorizontalLayout(0));

        protected ValueRenderer() {
            this.myPanel.add(this.myLabel);
            this.myPanel.add(this.myCheckBox);
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table instanceof TreeTable) {
                table.setEnabled(true);
                DefaultMutableTreeNode valueNode = (DefaultMutableTreeNode)((TreeTable)table).getTree().getPathForRow(row).getLastPathComponent();
                if (valueNode instanceof SettingsTreeNode) {
                    SettingsTreeNode settingsNode = (SettingsTreeNode)valueNode;
                    this.myLabel.setText(settingsNode.getValueString());
                    this.myCheckBox.setEnabled(true);
                    this.myCheckBox.setSelected(settingsNode.accepted);
                } else {
                    this.myLabel.setBackground(table.getBackground());
                    this.myCheckBox.setEnabled(false);
                }
            }
            JPanel jPanel2 = this.myPanel;
            if (jPanel2 == null) {
                ValueRenderer.$$$reportNull$$$0(0);
            }
            return jPanel2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/ui/ExtractedSettingsDialog$ValueRenderer", "getTableCellRendererComponent"));
        }
    }

    public static class SettingsTreeNode
    extends DefaultMutableTreeNode {
        protected CodeStyleSettingPresentation myRepresentation;
        protected boolean accepted = true;
        @Nls
        protected final String valueString;
        protected final boolean isGroupNode;
        @Nls
        protected final String customTitle;
        protected Value myValue;

        public SettingsTreeNode(@Nls String valueString, CodeStyleSettingPresentation representation, boolean isGroupNode, Value value2) {
            this(valueString, representation, isGroupNode, null, value2);
        }

        public SettingsTreeNode(@Nls String valueString, CodeStyleSettingPresentation representation, boolean isGroupNode, @Nls String customTitle, Value value2) {
            this.valueString = valueString;
            this.myRepresentation = representation;
            this.isGroupNode = isGroupNode;
            this.customTitle = customTitle;
            this.myValue = value2;
        }

        public SettingsTreeNode(@Nls String title) {
            this(title, null, true, null);
        }

        public boolean isGroupOrTypeNode() {
            return this.isGroupNode;
        }

        @NotNull
        @Nls
        public String getTitle() {
            String string = this.customTitle != null ? this.customTitle : (this.myRepresentation == null ? this.valueString : this.myRepresentation.getUiName());
            if (string == null) {
                SettingsTreeNode.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        @Nls
        public String getValueString() {
            return this.myRepresentation == null ? null : this.valueString;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/ui/ExtractedSettingsDialog$SettingsTreeNode", "getTitle"));
        }
    }
}

