/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.filter;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.filter.InspectionsFilter;
import com.intellij.ui.FilterComponent;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class InspectionFilterAction
extends DefaultActionGroup
implements Toggleable,
DumbAware {
    private static final int MIN_LANGUAGE_COUNT_TO_WRAP = 11;
    private final SeverityRegistrar mySeverityRegistrar;
    private final InspectionsFilter myInspectionsFilter;
    @NotNull
    private final FilterComponent myFilterComponent;
    private final String version;
    private final String presentableVersion;

    public InspectionFilterAction(@NotNull InspectionProfileImpl profile, @NotNull InspectionsFilter inspectionsFilter, @NotNull Project project, @NotNull FilterComponent filterComponent) {
        if (profile == null) {
            InspectionFilterAction.$$$reportNull$$$0(0);
        }
        if (inspectionsFilter == null) {
            InspectionFilterAction.$$$reportNull$$$0(1);
        }
        if (project == null) {
            InspectionFilterAction.$$$reportNull$$$0(2);
        }
        if (filterComponent == null) {
            InspectionFilterAction.$$$reportNull$$$0(3);
        }
        super(ActionsBundle.message((String)"action.InspectionFilterAction.filter.inspections.text", (Object[])new Object[0]), true);
        this.version = ApplicationInfo.getInstance().getMajorVersion() + (String)(StringUtil.isEmptyOrSpaces((String)StringUtil.trimStart((String)ApplicationInfo.getInstance().getMinorVersion(), (String)"0")) ? "" : "." + ApplicationInfo.getInstance().getMinorVersion());
        this.presentableVersion = ApplicationNamesInfo.getInstance().getProductName() + " " + this.version;
        this.myInspectionsFilter = inspectionsFilter;
        this.myFilterComponent = filterComponent;
        this.mySeverityRegistrar = profile.getProfileManager().getSeverityRegistrar();
        this.getTemplatePresentation().setIcon(AllIcons.General.Filter);
        this.tune(profile, project);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InspectionFilterAction.$$$reportNull$$$0(4);
        }
        super.update(e);
        Toggleable.setSelected((Presentation)e.getPresentation(), (!this.myInspectionsFilter.isEmptyFilter() ? 1 : 0) != 0);
    }

    private void tune(InspectionProfileImpl profile, Project project) {
        this.addAction((AnAction)new ResetFilterAction());
        this.addSeparator();
        if (ApplicationNamesInfo.getInstance().getProductName().contains("IDEA")) {
            this.addAction(new ShowNewInspectionsAction());
        }
        this.addSeparator();
        this.addAction((AnAction)new ShowEnabledOrDisabledInspectionsAction(true));
        this.addAction((AnAction)new ShowEnabledOrDisabledInspectionsAction(false));
        this.addAction((AnAction)new ShowOnlyModifiedInspectionsAction());
        this.addSeparator();
        for (HighlightSeverity highlightSeverity : LevelChooserAction.getSeverities(this.mySeverityRegistrar)) {
            this.add((AnAction)new ShowWithSpecifiedSeverityInspectionsAction(highlightSeverity));
        }
        this.addSeparator();
        THashSet languageIds = new THashSet();
        for (ScopeToolState scopeToolState : profile.getDefaultStates(project)) {
            String language = scopeToolState.getTool().getLanguage();
            if (language == null) continue;
            languageIds.add(language);
        }
        SmartList smartList = new SmartList();
        for (String id2 : languageIds) {
            Language language;
            if (id2 == null || (language = Language.findLanguageByID((String)id2)) == null || language instanceof MetaLanguage) continue;
            smartList.add(language);
        }
        if (!smartList.isEmpty()) {
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup(ActionsBundle.message((String)"action.InspectionFilterAction.filter.by.language.text", (Object[])new Object[0]), smartList.size() >= 11);
            this.add((AnAction)defaultActionGroup);
            smartList.sort(Comparator.comparing(Language::getDisplayName));
            for (Language language : smartList) {
                defaultActionGroup.add((AnAction)new LanguageFilterAction(language));
            }
            defaultActionGroup.add((AnAction)new LanguageFilterAction(null));
            this.addSeparator();
        }
        this.add((AnAction)new ShowAvailableOnlyOnAnalyzeInspectionsAction());
        this.add((AnAction)new ShowOnlyCleanupInspectionsAction());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ShowOnlyModifiedInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        ShowOnlyModifiedInspectionsAction() {
            super(AnalysisBundle.message((String)"inspections.settings.show.modified.text", (Object[])new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowOnlyModifiedInspectionsAction.$$$reportNull$$$0(0);
            }
            return InspectionFilterAction.this.myInspectionsFilter.isShowOnlyModifiedInspections();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowOnlyModifiedInspectionsAction.$$$reportNull$$$0(1);
            }
            InspectionFilterAction.this.myInspectionsFilter.setShowOnlyModifiedInspections(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction$ShowOnlyModifiedInspectionsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ShowNewInspectionsAction
    extends AnAction
    implements DumbAware {
        private ShowNewInspectionsAction() {
            super(AnalysisBundle.message((String)"inspections.settings.show.new.text", (Object[])new Object[]{InspectionFilterAction.this.presentableVersion}), AnalysisBundle.message((String)"inspections.settings.show.new.description", (Object[])new Object[]{InspectionFilterAction.this.presentableVersion}), AllIcons.Actions.Lightning);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowNewInspectionsAction.$$$reportNull$$$0(0);
            }
            InspectionFilterAction.this.myFilterComponent.setFilter("\"New in " + InspectionFilterAction.this.version + "\"");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction$ShowNewInspectionsAction", "actionPerformed"));
        }
    }

    private class LanguageFilterAction
    extends CheckboxAction
    implements DumbAware {
        private final Language myLanguage;

        LanguageFilterAction(Language language) {
            super(language == null ? AnalysisBundle.message((String)"inspections.settings.language.not.specified.warning", (Object[])new Object[0]) : language.getDisplayName());
            this.myLanguage = language;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                LanguageFilterAction.$$$reportNull$$$0(0);
            }
            return InspectionFilterAction.this.myInspectionsFilter.containsLanguage(this.myLanguage);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                LanguageFilterAction.$$$reportNull$$$0(1);
            }
            if (state) {
                InspectionFilterAction.this.myInspectionsFilter.addLanguage(this.myLanguage);
            } else {
                InspectionFilterAction.this.myInspectionsFilter.removeLanguage(this.myLanguage);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction$LanguageFilterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowEnabledOrDisabledInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        private final Boolean myShowEnabledActions;

        ShowEnabledOrDisabledInspectionsAction(boolean showEnabledActions) {
            super(showEnabledActions ? AnalysisBundle.message((String)"inspections.settings.show.only.enabled.text", (Object[])new Object[0]) : AnalysisBundle.message((String)"inspections.settings.show.only.disabled.text", (Object[])new Object[0]));
            this.myShowEnabledActions = showEnabledActions;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowEnabledOrDisabledInspectionsAction.$$$reportNull$$$0(0);
            }
            return InspectionFilterAction.this.myInspectionsFilter.getSuitableInspectionsStates() == this.myShowEnabledActions;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowEnabledOrDisabledInspectionsAction.$$$reportNull$$$0(1);
            }
            boolean previousState = this.isSelected(e);
            InspectionFilterAction.this.myInspectionsFilter.setSuitableInspectionsStates(previousState ? null : this.myShowEnabledActions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction$ShowEnabledOrDisabledInspectionsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ShowWithSpecifiedSeverityInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        private final HighlightSeverity mySeverity;

        private ShowWithSpecifiedSeverityInspectionsAction(HighlightSeverity severity) {
            super(SingleInspectionProfilePanel.renderSeverity(severity), null, HighlightDisplayLevel.find((HighlightSeverity)severity).getIcon());
            this.mySeverity = severity;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowWithSpecifiedSeverityInspectionsAction.$$$reportNull$$$0(0);
            }
            return InspectionFilterAction.this.myInspectionsFilter.containsSeverity(this.mySeverity);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowWithSpecifiedSeverityInspectionsAction.$$$reportNull$$$0(1);
            }
            if (state) {
                InspectionFilterAction.this.myInspectionsFilter.addSeverity(this.mySeverity);
            } else {
                InspectionFilterAction.this.myInspectionsFilter.removeSeverity(this.mySeverity);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction$ShowWithSpecifiedSeverityInspectionsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowAvailableOnlyOnAnalyzeInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        ShowAvailableOnlyOnAnalyzeInspectionsAction() {
            super(AnalysisBundle.message((String)"inspections.settings.show.only.batch.text", (Object[])new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAvailableOnlyOnAnalyzeInspectionsAction.$$$reportNull$$$0(0);
            }
            return InspectionFilterAction.this.myInspectionsFilter.isAvailableOnlyForAnalyze();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowAvailableOnlyOnAnalyzeInspectionsAction.$$$reportNull$$$0(1);
            }
            InspectionFilterAction.this.myInspectionsFilter.setAvailableOnlyForAnalyze(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction$ShowAvailableOnlyOnAnalyzeInspectionsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowOnlyCleanupInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        ShowOnlyCleanupInspectionsAction() {
            super(AnalysisBundle.message((String)"inspections.settings.show.only.cleanup.text", (Object[])new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowOnlyCleanupInspectionsAction.$$$reportNull$$$0(0);
            }
            return InspectionFilterAction.this.myInspectionsFilter.isShowOnlyCleanupInspections();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowOnlyCleanupInspectionsAction.$$$reportNull$$$0(1);
            }
            InspectionFilterAction.this.myInspectionsFilter.setShowOnlyCleanupInspections(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction$ShowOnlyCleanupInspectionsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ResetFilterAction
    extends DumbAwareAction {
        ResetFilterAction() {
            super(ActionsBundle.messagePointer((String)"action.ResetFilterAction.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetFilterAction.$$$reportNull$$$0(0);
            }
            InspectionFilterAction.this.myInspectionsFilter.reset();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetFilterAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(!InspectionFilterAction.this.myInspectionsFilter.isEmptyFilter());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction$ResetFilterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

