/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates.github;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubTagInfo {
    private final String myName;
    private final String myZipballUrl;
    private Version myVersion;
    private boolean myRecentTag;

    public GithubTagInfo(@NotNull String name, @NotNull String zipballUrl) {
        if (name == null) {
            GithubTagInfo.$$$reportNull$$$0(0);
        }
        if (zipballUrl == null) {
            GithubTagInfo.$$$reportNull$$$0(1);
        }
        this.myRecentTag = false;
        this.myName = name;
        this.myZipballUrl = zipballUrl;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GithubTagInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getZipballUrl() {
        String string = this.myZipballUrl;
        if (string == null) {
            GithubTagInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setRecentTag(boolean recentTag) {
        this.myRecentTag = recentTag;
    }

    public boolean isRecentTag() {
        return this.myRecentTag;
    }

    @NotNull
    public Version getVersion() {
        if (this.myVersion == null) {
            this.myVersion = this.createVersionComponents();
        }
        Version version2 = this.myVersion;
        if (version2 == null) {
            GithubTagInfo.$$$reportNull$$$0(4);
        }
        return version2;
    }

    @NotNull
    private Version createVersionComponents() {
        int lastNonDigitInd;
        int nonDigitInd;
        int ind;
        String tagName = this.myName;
        if (tagName.startsWith("v.")) {
            tagName = tagName.substring(2);
        } else if (StringUtil.startsWithChar((CharSequence)tagName, (char)'v')) {
            tagName = tagName.substring(1);
        }
        TIntArrayList intComponents = new TIntArrayList();
        int startInd = 0;
        while ((ind = tagName.indexOf(46, startInd)) != -1) {
            String s = tagName.substring(startInd, ind);
            try {
                int x = Integer.parseInt(s);
                intComponents.add(x);
                startInd = ind + 1;
            }
            catch (NumberFormatException e) {
                break;
            }
        }
        for (nonDigitInd = startInd; nonDigitInd < tagName.length() && Character.isDigit(tagName.charAt(nonDigitInd)); ++nonDigitInd) {
        }
        String digitStr = tagName.substring(startInd, nonDigitInd);
        if (!digitStr.isEmpty()) {
            intComponents.add(Integer.parseInt(digitStr));
        }
        String labelWithVersion = tagName.substring(nonDigitInd);
        for (lastNonDigitInd = labelWithVersion.length() - 1; lastNonDigitInd >= 0 && Character.isDigit(labelWithVersion.charAt(lastNonDigitInd)); --lastNonDigitInd) {
        }
        String labelVersionStr = labelWithVersion.substring(lastNonDigitInd + 1);
        String label2 = labelWithVersion.substring(0, lastNonDigitInd + 1);
        int labelVersion = Integer.MAX_VALUE;
        if (!labelVersionStr.isEmpty()) {
            labelVersion = Integer.parseInt(labelVersionStr);
        }
        return new Version(intComponents, label2, labelVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GithubTagInfo info = (GithubTagInfo)o;
        return this.myName.equals(info.myName) && this.myZipballUrl.equals(info.myZipballUrl);
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 31 * result2 + this.myZipballUrl.hashCode();
        return result2;
    }

    @Nullable
    public static GithubTagInfo tryCast(@Nullable Object o) {
        return (GithubTagInfo)ObjectUtils.tryCast((Object)o, GithubTagInfo.class);
    }

    public String toString() {
        return this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipballUrl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/github/GithubTagInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/github/GithubTagInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipballUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Version
    implements Comparable<Version> {
        private final TIntArrayList myIntComponents;
        private final String myLabel;
        private final int myLabelVersion;

        public Version(@NotNull TIntArrayList intComponents, @NotNull String label2, int labelVersion) {
            if (intComponents == null) {
                Version.$$$reportNull$$$0(0);
            }
            if (label2 == null) {
                Version.$$$reportNull$$$0(1);
            }
            this.myIntComponents = new TIntArrayList();
            this.myIntComponents.add(intComponents.toNativeArray());
            this.myLabel = label2;
            this.myLabelVersion = labelVersion;
        }

        @Override
        public int compareTo(Version other) {
            int minSize = Math.min(this.myIntComponents.size(), other.myIntComponents.size());
            for (int i2 = 0; i2 < minSize; ++i2) {
                int otherN;
                int thisN = this.myIntComponents.get(i2);
                if (thisN == (otherN = other.myIntComponents.get(i2))) continue;
                return thisN - otherN;
            }
            if (this.myIntComponents.size() != other.myIntComponents.size()) {
                return this.myIntComponents.size() - other.myIntComponents.size();
            }
            int labelCompare = this.myLabel.compareTo(other.myLabel);
            if (labelCompare != 0) {
                if (this.myLabel.isEmpty()) {
                    return 1;
                }
                if (other.myLabel.isEmpty()) {
                    return -1;
                }
                return labelCompare;
            }
            return this.myLabelVersion - other.myLabelVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "intComponents";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "label";
                    break;
                }
            }
            objectArray[1] = "com/intellij/platform/templates/github/GithubTagInfo$Version";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

