/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachListener;
import com.intellij.platform.ModuleAttachProcessorKt;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/ModuleAttachProcessor;", "Lcom/intellij/projectImport/ProjectAttachProcessor;", "()V", "attachToProject", "", "project", "Lcom/intellij/openapi/project/Project;", "projectDir", "Ljava/nio/file/Path;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "beforeDetach", "", "module", "Lcom/intellij/openapi/module/Module;", "Companion", "intellij.platform.lang.impl"})
public final class ModuleAttachProcessor
extends ProjectAttachProcessor {
    public static final Companion Companion = new Companion(null);

    public boolean attachToProject(@NotNull Project project, @NotNull Path projectDir, @Nullable ProjectOpenedCallback callback2) {
        Module module;
        Path dotIdeaDir;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Path path = dotIdeaDir = projectDir.resolve(".idea");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"dotIdeaDir");
        if (!PathKt.exists((Path)path)) {
            module = null;
            Function1 function1 = null;
            Function1 function12 = null;
            boolean bl = false;
            boolean bl2 = false;
            String string = null;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int n = 0;
            int n2 = 0;
            Object var17_18 = null;
            ProjectOpenedCallback projectOpenedCallback = null;
            boolean bl6 = false;
            String string2 = null;
            Project project2 = null;
            boolean bl7 = true;
            boolean bl8 = true;
            OpenProjectTask options2 = new OpenProjectTask(false, null, bl7, bl8, project2, string2, bl6, projectOpenedCallback, var17_18, n2, n, bl5, bl4, bl3, string, bl2, bl, function12, function1, (Function1)module, 1048563, null);
            Project project3 = ProjectManagerEx.getInstanceEx().newProject(projectDir, options2);
            if (project3 == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"ProjectManagerEx.getInst\u2026 options) ?: return false");
            Project newProject = project3;
            PlatformProjectOpenProcessor.Companion.runDirectoryProjectConfigurators(projectDir, newProject, true);
            StoreUtil.Companion.saveSettings$default(StoreUtil.Companion, (ComponentManager)newProject, false, 2, null);
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable<T>(newProject){
                final /* synthetic */ Project $newProject$inlined;
                {
                    this.$newProject$inlined = project;
                }

                public final T compute() {
                    boolean bl = false;
                    Disposer.dispose((Disposable)((Disposable)this.$newProject$inlined));
                    return (T)Unit.INSTANCE;
                }
            });
        }
        try {
            Module module2 = ModuleAttachProcessorKt.access$findMainModule(project, dotIdeaDir);
            if (module2 == null) {
                module2 = ModuleAttachProcessorKt.access$findMainModule(project, projectDir);
            }
            module = module2;
        }
        catch (Exception e) {
            ModuleAttachProcessorKt.access$getLOG$p().info((Throwable)e);
            Messages.showErrorDialog((Project)project, (String)LangBundle.message((String)"module.attach.dialog.message.cannot.attach.project", (Object[])new Object[]{e.getMessage()}), (String)CommonBundle.getErrorTitle());
            return false;
        }
        Module newModule = module;
        LifecycleUsageTriggerCollector.onProjectModuleAttached(project);
        if (newModule != null) {
            ProjectOpenedCallback projectOpenedCallback = callback2;
            if (projectOpenedCallback != null) {
                projectOpenedCallback.projectOpened(project, newModule);
            }
            return true;
        }
        return Messages.showYesNoDialog((Project)project, (String)LangBundle.message((String)"module.attach.dialog.message.project.uses.non.standard.layout", (Object[])new Object[]{projectDir}), (String)LangBundle.message((String)"module.attach.dialog.title.open.project", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0;
    }

    public void beforeDetach(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        ((ModuleAttachListener)project.getMessageBus().syncPublisher(ModuleAttachListener.TOPIC)).beforeDetach(module);
    }

    @JvmStatic
    @Nullable
    public static final Module findModuleInBaseDir(@NotNull Project project) {
        return Companion.findModuleInBaseDir(project);
    }

    @JvmStatic
    @Nullable
    public static final Module getPrimaryModule(@NotNull Project project) {
        return Companion.getPrimaryModule(project);
    }

    @JvmStatic
    @NotNull
    public static final List<Module> getSortedModules(@NotNull Project project) {
        return Companion.getSortedModules(project);
    }

    @JvmStatic
    @NlsSafe
    @Nullable
    public static final String getMultiProjectDisplayName(@NotNull Project project) {
        return Companion.getMultiProjectDisplayName(project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ModuleAttachProcessor$Companion;", "", "()V", "findModuleInBaseDir", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getMultiProjectDisplayName", "", "getPrimaryModule", "getSortedModules", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Module findModuleInBaseDir(@NotNull Project project) {
            Module module;
            block3: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                VirtualFile baseDir = project.getBaseDir();
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray = moduleManager.getModules();
                Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                Module[] $this$firstOrNull$iv = moduleArray;
                boolean $i$f$firstOrNull = false;
                Module[] moduleArray2 = $this$firstOrNull$iv;
                int n = moduleArray2.length;
                for (int j = 0; j < n; ++j) {
                    boolean bl;
                    Module element$iv;
                    block2: {
                        VirtualFile[] $this$any$iv;
                        Module module2 = element$iv = moduleArray2[j];
                        boolean bl2 = false;
                        Module module3 = module2;
                        Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"module");
                        Intrinsics.checkNotNullExpressionValue((Object)ProjectUtil.getRootManager((Module)module3).getContentRoots(), (String)"module.rootManager.contentRoots");
                        boolean $i$f$any = false;
                        VirtualFile[] virtualFileArray = $this$any$iv;
                        int n2 = virtualFileArray.length;
                        for (int k = 0; k < n2; ++k) {
                            VirtualFile element$iv2;
                            VirtualFile it = element$iv2 = virtualFileArray[k];
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)baseDir)) continue;
                            bl = true;
                            break block2;
                        }
                        bl = false;
                    }
                    if (!bl) continue;
                    module = element$iv;
                    break block3;
                }
                module = null;
            }
            return module;
        }

        @JvmStatic
        @Nullable
        public final Module getPrimaryModule(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return ProjectAttachProcessor.canAttachToProject() ? this.findModuleInBaseDir(project) : null;
        }

        @JvmStatic
        @NotNull
        public final List<Module> getSortedModules(@NotNull Project project) {
            ArrayList<Module> result2;
            block2: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Module primaryModule = this.getPrimaryModule(project);
                result2 = new ArrayList<Module>();
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray = moduleManager.getModules();
                Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                Module[] $this$filterTo$iv = moduleArray;
                boolean $i$f$filterTo = false;
                Module[] moduleArray2 = $this$filterTo$iv;
                int n = moduleArray2.length;
                for (int j = 0; j < n; ++j) {
                    Module element$iv;
                    Module it = element$iv = moduleArray2[j];
                    boolean bl = false;
                    if (!(it != primaryModule)) continue;
                    ((Collection)result2).add(element$iv);
                }
                List $this$sortBy$iv = result2;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    boolean bl = false;
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            Module p1 = (Module)a;
                            boolean bl2 = false;
                            Comparable comparable = (Comparable)((Object)p1.getName());
                            p1 = (Module)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            String string = p1.getName();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                        }
                    });
                }
                Module module = primaryModule;
                if (module == null) break block2;
                Module module2 = module;
                boolean bl = false;
                boolean bl2 = false;
                Module it = module2;
                boolean bl3 = false;
                result2.add(0, it);
            }
            return result2;
        }

        @JvmStatic
        @NlsSafe
        @Nullable
        public final String getMultiProjectDisplayName(@NotNull Project project) {
            Module primaryModule;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!ProjectAttachProcessor.canAttachToProject()) {
                return null;
            }
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            Object[] modules2 = moduleManager.getModules();
            if (modules2.length <= 1) {
                return null;
            }
            Module module = this.getPrimaryModule(project);
            if (module == null) {
                Intrinsics.checkNotNullExpressionValue((Object)modules2, (String)"modules");
                module = (Module)ArraysKt.first((Object[])modules2);
            }
            Module module2 = primaryModule = module;
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"primaryModule");
            StringBuilder stringBuilder = new StringBuilder(module2.getName()).append(", ");
            Intrinsics.checkNotNullExpressionValue((Object)modules2, (String)"modules");
            StringBuilder result2 = stringBuilder.append(SequencesKt.first((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])modules2), (Function1)((Function1)new Function1<Module, Boolean>(primaryModule){
                final /* synthetic */ Module $primaryModule;

                public final boolean invoke(Module it) {
                    return it != this.$primaryModule;
                }
                {
                    this.$primaryModule = module;
                    super(1);
                }
            }))));
            if (modules2.length > 2) {
                result2.append("...");
            }
            return result2.toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

