/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.actions.ShowContentAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.ToolWindowEventSource;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.SelectContentStep;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabGroupId;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.ui.content.tabs.TabbedContentAction;
import com.intellij.ui.layout.migLayout.MigLayoutUtilKt;
import com.intellij.ui.layout.migLayout.patched.MigLayout;
import com.intellij.ui.popup.PopupState;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.util.Alarm;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LocationOnDragTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowContentUi
implements ContentUI,
DataProvider {
    @NonNls
    public static final String HIDE_ID_LABEL = "HideIdLabel";
    @NonNls
    private static final String TOOLWINDOW_UI_INSTALLED = "ToolWindowUiInstalled";
    public static final DataKey<BaseLabel> SELECTED_CONTENT_TAB_LABEL = DataKey.create((String)"SELECTED_CONTENT_TAB_LABEL");
    @NotNull
    private final ContentManager contentManager;
    private final JPanel contentComponent;
    final ToolWindowImpl window;
    private final TabbedContentAction.CloseAllAction closeAllAction;
    private final TabbedContentAction.MyNextTabAction nextTabAction;
    private final TabbedContentAction.MyPreviousTabAction previousTabAction;
    private final ShowContentAction showContent;
    private final TabContentLayout tabsLayout;
    private ContentLayout myComboLayout;
    private ToolWindowContentUiType type;
    public Predicate<Point> isResizableArea;
    private final JPanel tabComponent;

    @NotNull
    public ContentManager getContentManager() {
        ContentManager contentManager2 = this.contentManager;
        if (contentManager2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(0);
        }
        return contentManager2;
    }

    @NotNull
    public JPanel getTabComponent() {
        JPanel jPanel2 = this.tabComponent;
        if (jPanel2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(1);
        }
        return jPanel2;
    }

    public ToolWindowContentUi(final @NotNull ToolWindowImpl window, final @NotNull ContentManager contentManager2, final @NotNull JPanel contentComponent) {
        if (window == null) {
            ToolWindowContentUi.$$$reportNull$$$0(2);
        }
        if (contentManager2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(3);
        }
        if (contentComponent == null) {
            ToolWindowContentUi.$$$reportNull$$$0(4);
        }
        this.isResizableArea = __ -> true;
        this.tabComponent = new TabPanel();
        this.contentManager = contentManager2;
        this.type = window.getWindowInfo().getContentUiType();
        this.tabsLayout = new TabContentLayout(this);
        this.window = window;
        this.contentComponent = contentComponent;
        this.getCurrentLayout().init(contentManager2);
        contentManager2.addContentManagerListener(new ContentManagerListener(){
            private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    ToolWindowContentUi.this.update();
                }
            };

            public void contentAdded(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ToolWindowContentUi.this.getCurrentLayout().contentAdded(event);
                event.getContent().addPropertyChangeListener(this.propertyChangeListener);
                ToolWindowContentUi.this.rebuild();
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                event.getContent().removePropertyChangeListener(this.propertyChangeListener);
                ToolWindowContentUi.this.getCurrentLayout().contentRemoved(event);
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.rebuild();
                if (contentManager2.getContentCount() == 0 && window.isToHideOnEmptyContent()) {
                    window.hide(null);
                }
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.update();
                contentComponent.revalidate();
                contentComponent.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ToolWindowContentUi.initMouseListeners(this.tabComponent, this, true);
        this.closeAllAction = new TabbedContentAction.CloseAllAction(contentManager2);
        this.nextTabAction = new TabbedContentAction.MyNextTabAction(contentManager2);
        this.previousTabAction = new TabbedContentAction.MyPreviousTabAction(contentManager2);
        this.showContent = new ShowContentAction(window, contentComponent, (Disposable)contentManager2);
    }

    @NotNull
    public String getToolWindowId() {
        String string = this.window.getId();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(5);
        }
        return string;
    }

    private boolean isResizeable() {
        if (this.window.getType() == ToolWindowType.FLOATING || this.window.getType() == ToolWindowType.WINDOWED) {
            return false;
        }
        if (this.window.getAnchor() == ToolWindowAnchor.BOTTOM) {
            return true;
        }
        if (this.window.getAnchor() == ToolWindowAnchor.TOP || !this.window.isSplitMode()) {
            return false;
        }
        ToolWindowManagerImpl manager = this.window.getToolWindowManager();
        for (String id2 : manager.getIdsOn(this.window.getAnchor())) {
            ToolWindow window;
            if (id2.equals(this.window.getId()) || (window = manager.getToolWindow(id2)) == null || !window.isVisible() || window.getType() != ToolWindowType.DOCKED && window.getType() != ToolWindowType.SLIDING) continue;
            return true;
        }
        return false;
    }

    private boolean isResizeable(@NotNull Point point) {
        if (point == null) {
            ToolWindowContentUi.$$$reportNull$$$0(6);
        }
        return this.isResizableArea.test(point);
    }

    public void setType(@NotNull ToolWindowContentUiType type) {
        if (type == null) {
            ToolWindowContentUi.$$$reportNull$$$0(7);
        }
        if (this.type == type) {
            return;
        }
        if (this.type != null) {
            this.getCurrentLayout().reset();
        }
        this.type = type;
        this.getCurrentLayout().init(this.contentManager);
        this.rebuild();
    }

    @NotNull
    private ContentLayout getCurrentLayout() {
        if (this.type == ToolWindowContentUiType.TABBED) {
            TabContentLayout tabContentLayout = this.tabsLayout;
            if (tabContentLayout == null) {
                ToolWindowContentUi.$$$reportNull$$$0(8);
            }
            return tabContentLayout;
        }
        if (this.myComboLayout == null) {
            this.myComboLayout = new ComboContentLayout(this);
        }
        ContentLayout contentLayout = this.myComboLayout;
        if (contentLayout == null) {
            ToolWindowContentUi.$$$reportNull$$$0(9);
        }
        return contentLayout;
    }

    public JComponent getComponent() {
        return this.contentComponent;
    }

    public void setManager(@NotNull ContentManager manager) {
        if (manager == null) {
            ToolWindowContentUi.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException();
    }

    private void ensureSelectedContentVisible() {
        Component visible;
        Content selected2 = this.contentManager.getSelectedContent();
        if (selected2 == null) {
            this.contentComponent.removeAll();
            return;
        }
        if (this.contentComponent.getComponentCount() == 1 && (visible = this.contentComponent.getComponent(0)) == selected2.getComponent()) {
            return;
        }
        this.contentComponent.removeAll();
        this.contentComponent.add((Component)selected2.getComponent(), "Center");
        this.contentComponent.revalidate();
        this.contentComponent.repaint();
    }

    public void dropCaches() {
        this.tabsLayout.dropCaches();
    }

    @ApiStatus.Internal
    public void rebuild() {
        this.getCurrentLayout().rebuild();
        this.getCurrentLayout().update();
        this.tabComponent.revalidate();
        this.tabComponent.repaint();
    }

    public void update() {
        this.getCurrentLayout().update();
        this.getCurrentLayout().layout();
        this.tabComponent.revalidate();
        this.tabComponent.repaint();
    }

    public boolean isSingleSelection() {
        return true;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return false;
    }

    public boolean canChangeSelectionTo(@NotNull Content content2, boolean implicit) {
        if (content2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(11);
        }
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        String string = this.getCurrentLayout().getCloseActionName();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = this.getCurrentLayout().getCloseAllButThisActionName();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string = this.getCurrentLayout().getPreviousContentActionName();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getNextContentActionName() {
        String string = this.getCurrentLayout().getNextContentActionName();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void setTabDoubleClickActions(@NotNull List<AnAction> actions) {
        if (actions == null) {
            ToolWindowContentUi.$$$reportNull$$$0(16);
        }
        this.tabsLayout.setTabDoubleClickActions(actions);
    }

    public static void initMouseListeners(final @NotNull JComponent c, final @NotNull ToolWindowContentUi ui, final boolean allowResize) {
        if (c == null) {
            ToolWindowContentUi.$$$reportNull$$$0(17);
        }
        if (ui == null) {
            ToolWindowContentUi.$$$reportNull$$$0(18);
        }
        if (c.getClientProperty(TOOLWINDOW_UI_INSTALLED) != null) {
            return;
        }
        MouseAdapter mouseAdapter2 = new MouseAdapter(){
            final Ref<Point> myLastPoint = Ref.create();
            final Ref<Point> myPressPoint = Ref.create();
            final Ref<Integer> myInitialHeight = Ref.create((Object)0);
            final Ref<Boolean> myIsLastComponent = Ref.create();
            final Ref<LocationOnDragTracker> myDragTracker = Ref.create();

            private Component getActualSplitter() {
                if (!allowResize || !ui.isResizeable()) {
                    return null;
                }
                Container component2 = c;
                for (Container parent = component2.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent instanceof ThreeComponentsSplitter && ((ThreeComponentsSplitter)parent).getOrientation() && component2 != ((ThreeComponentsSplitter)parent).getFirstComponent()) {
                        return parent;
                    }
                    if (parent instanceof Splitter && ((Splitter)parent).isVertical() && ((Splitter)parent).getSecondComponent() == component2 && ((Splitter)parent).getFirstComponent() != null) {
                        return parent;
                    }
                    component2 = parent;
                }
                return null;
            }

            private void arm(Component c2) {
                Component component2;
                Component component3 = component2 = c2 != null ? this.getActualSplitter() : null;
                if (component2 instanceof ThreeComponentsSplitter) {
                    ThreeComponentsSplitter splitter = (ThreeComponentsSplitter)component2;
                    this.myIsLastComponent.set((Object)SwingUtilities.isDescendingFrom(c2, splitter.getLastComponent()));
                    this.myInitialHeight.set((Object)((Boolean)this.myIsLastComponent.get() != false ? splitter.getLastSize() : splitter.getFirstSize()));
                    return;
                }
                if (component2 instanceof Splitter) {
                    Splitter splitter = (Splitter)component2;
                    this.myIsLastComponent.set((Object)true);
                    this.myInitialHeight.set((Object)splitter.getSecondComponent().getHeight());
                    return;
                }
                this.myIsLastComponent.set(null);
                this.myInitialHeight.set(null);
                this.myPressPoint.set(null);
                this.myDragTracker.set(null);
            }

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                PointerInfo info = MouseInfo.getPointerInfo();
                if (!e.isPopupTrigger() && !UIUtil.isCloseClick((MouseEvent)e)) {
                    this.myLastPoint.set((Object)(info != null ? info.getLocation() : e.getLocationOnScreen()));
                    this.myPressPoint.set((Object)((Point)this.myLastPoint.get()));
                    this.myDragTracker.set((Object)LocationOnDragTracker.startDrag((MouseEvent)e));
                    if (allowResize && ui.isResizeable()) {
                        this.arm(c.getComponentAt(e.getPoint()) == c && ui.isResizeable(e.getPoint()) ? c : null);
                    }
                    ui.window.fireActivated(ToolWindowEventSource.Content);
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!e.isPopupTrigger()) {
                    if (UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                        ui.processHide(e);
                    }
                    this.arm(null);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                c.setCursor(allowResize && ui.isResizeable() && this.getActualSplitter() != null && c.getComponentAt(e.getPoint()) == c && ui.isResizeable(e.getPoint()) ? Cursor.getPredefinedCursor(8) : Cursor.getDefaultCursor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                c.setCursor(null);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ThreeComponentsSplitter splitter;
                if (this.myLastPoint.isNull() || this.myPressPoint.isNull() || this.myDragTracker.isNull()) {
                    return;
                }
                PointerInfo info = MouseInfo.getPointerInfo();
                if (info == null) {
                    return;
                }
                Point newMouseLocation = info.getLocation();
                Window window = SwingUtilities.windowForComponent(c);
                if (!(window instanceof IdeFrame)) {
                    ((LocationOnDragTracker)this.myDragTracker.get()).updateLocationOnDrag((Component)window);
                }
                this.myLastPoint.set((Object)newMouseLocation);
                Component component2 = this.getActualSplitter();
                if (component2 instanceof ThreeComponentsSplitter) {
                    splitter = (ThreeComponentsSplitter)component2;
                    if (this.myIsLastComponent.get() == Boolean.TRUE) {
                        splitter.setLastSize((Integer)this.myInitialHeight.get() + ((Point)this.myPressPoint.get()).y - ((Point)this.myLastPoint.get()).y);
                    } else {
                        splitter.setFirstSize((Integer)this.myInitialHeight.get() + ((Point)this.myLastPoint.get()).y - ((Point)this.myPressPoint.get()).y);
                    }
                }
                if (component2 instanceof Splitter) {
                    splitter = (Splitter)component2;
                    splitter.setProportion(Math.max(0.0f, Math.min(1.0f, 1.0f - (float)((Integer)this.myInitialHeight.get() + ((Point)this.myPressPoint.get()).y - ((Point)this.myLastPoint.get()).y) / (float)splitter.getHeight())));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        c.addMouseMotionListener(mouseAdapter2);
        c.addMouseListener(mouseAdapter2);
        c.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                Content content2 = c instanceof BaseLabel ? ((BaseLabel)c).getContent() : null;
                ui.showContextMenu(comp, x, y, ui.window.getPopupGroup(), content2);
            }
        });
        c.putClientProperty(TOOLWINDOW_UI_INSTALLED, Boolean.TRUE);
    }

    private void initActionGroup(@NotNull DefaultActionGroup group2, @Nullable Content content2) {
        TabGroupId groupId2;
        if (group2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(19);
        }
        if (content2 == null) {
            return;
        }
        group2.addSeparator();
        group2.add((AnAction)new TabbedContentAction.CloseAction(content2));
        group2.add((AnAction)this.closeAllAction);
        group2.add((AnAction)new TabbedContentAction.CloseAllButThisAction(content2));
        group2.addSeparator();
        if (content2.isPinnable()) {
            group2.add(PinToolwindowTabAction.getPinAction());
            group2.addSeparator();
        }
        group2.add((AnAction)this.nextTabAction);
        group2.add((AnAction)this.previousTabAction);
        group2.add((AnAction)this.showContent);
        if (content2 instanceof TabbedContent && ((TabbedContent)content2).hasMultipleTabs()) {
            group2.addAction(ToolWindowContentUi.createSplitTabsAction((TabbedContent)content2));
        }
        if (Boolean.TRUE == content2.getUserData(Content.TABBED_CONTENT_KEY) && (groupId2 = (TabGroupId)content2.getUserData(Content.TAB_GROUP_ID_KEY)) != null) {
            group2.addAction(ToolWindowContentUi.createMergeTabsAction(this.contentManager, groupId2));
        }
        group2.addSeparator();
    }

    public void showContextMenu(Component comp, int x, int y, ActionGroup toolWindowGroup, @Nullable Content selectedContent) {
        if (selectedContent == null && toolWindowGroup == null) {
            return;
        }
        DefaultActionGroup configuredGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("ToolWindowContextMenu");
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.copyFromGroup(configuredGroup);
        if (selectedContent != null) {
            this.initActionGroup(group2, selectedContent);
        }
        if (toolWindowGroup != null) {
            group2.addAll(toolWindowGroup);
        }
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", (ActionGroup)group2);
        popupMenu.getComponent().show(comp, x, y);
    }

    @NotNull
    private static AnAction createSplitTabsAction(final @NotNull TabbedContent content2) {
        if (content2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(20);
        }
        return new DumbAwareAction(IdeBundle.message((String)"action.text.split.group", (Object[])new Object[]{content2.getTitlePrefix()})){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                content2.split();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$4", "actionPerformed"));
            }
        };
    }

    @NotNull
    private static AnAction createMergeTabsAction(final @NotNull ContentManager manager, final @NotNull TabGroupId groupId2) {
        if (manager == null) {
            ToolWindowContentUi.$$$reportNull$$$0(21);
        }
        if (groupId2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(22);
        }
        return new DumbAwareAction(IdeBundle.message((String)"action.text.merge.tabs.to.group", (Object[])new Object[]{groupId2.getDisplayName()})){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                ContentUtilEx.mergeTabs(manager, groupId2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$5", "actionPerformed"));
            }
        };
    }

    private void processHide(@NotNull MouseEvent e) {
        if (e == null) {
            ToolWindowContentUi.$$$reportNull$$$0(23);
        }
        IdeEventQueue.getInstance().blockNextEvents(e);
        Component c = e.getComponent();
        if (c instanceof BaseLabel) {
            BaseLabel tab = (BaseLabel)c;
            if (tab.getContent() != null) {
                if (this.contentManager.canCloseContents() && tab.getContent().isCloseable()) {
                    this.contentManager.removeContent(tab.getContent(), true, true, true);
                } else if (this.contentManager.getContentCount() == 1) {
                    this.hideWindow(e);
                }
            } else {
                this.hideWindow(e);
            }
        } else {
            this.hideWindow(e);
        }
    }

    private void hideWindow(@NotNull MouseEvent e) {
        if (e == null) {
            ToolWindowContentUi.$$$reportNull$$$0(24);
        }
        if (e.isControlDown()) {
            this.window.fireHiddenSide(ToolWindowEventSource.ToolWindowHeaderAltClick);
        } else {
            this.window.fireHidden(ToolWindowEventSource.ToolWindowHeader);
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ToolWindowContentUi.$$$reportNull$$$0(25);
        }
        if (PlatformDataKeys.TOOL_WINDOW.is(dataId)) {
            return this.window;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.window.getToolWindowManager().getProject();
        }
        if (CloseAction.CloseTarget.KEY.is(dataId)) {
            return this.computeCloseTarget();
        }
        if (MorePopupAware.KEY.is(dataId)) {
            ContentLayout layout = this.getCurrentLayout();
            return layout instanceof TabContentLayout ? layout : null;
        }
        if (SELECTED_CONTENT_TAB_LABEL.is(dataId) && this.type == ToolWindowContentUiType.TABBED) {
            return this.tabsLayout.findTabLabelByContent(this.contentManager.getSelectedContent());
        }
        return null;
    }

    @NotNull
    private CloseAction.CloseTarget computeCloseTarget() {
        Content selected2;
        if (this.contentManager.canCloseContents() && (selected2 = this.contentManager.getSelectedContent()) != null && selected2.isCloseable()) {
            return new CloseContentTarget(selected2);
        }
        return new HideToolwindowTarget();
    }

    boolean isCurrent(ContentLayout layout) {
        return this.getCurrentLayout() == layout;
    }

    public static void toggleContentPopup(@NotNull ToolWindowContentUi content2, @NotNull ContentManager contentManager2) {
        if (content2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(26);
        }
        if (contentManager2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(27);
        }
        ToolWindowContentUi.toggleContentPopup(content2, contentManager2, null);
    }

    static void toggleContentPopup(@NotNull ToolWindowContentUi content2, @NotNull ContentManager contentManager2, @Nullable PopupState<JBPopup> popupState) {
        if (content2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(28);
        }
        if (contentManager2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(29);
        }
        SelectContentStep step = new SelectContentStep(contentManager2.getContents());
        Content selectedContent = contentManager2.getSelectedContent();
        if (selectedContent != null) {
            step.setDefaultOptionIndex(contentManager2.getIndexOfContent(selectedContent));
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        if (popupState != null) {
            popupState.prepareToShow((Object)popup2);
        }
        content2.getCurrentLayout().showContentPopup(popup2);
        if (selectedContent instanceof TabbedContent) {
            new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)popup2).addRequest(() -> popup2.handleSelect(false), 50);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/ToolWindowContentUi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 3: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 11: 
            case 20: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabComponent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/ToolWindowContentUi";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowId";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLayout";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseActionName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseAllButThisActionName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousContentActionName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextContentActionName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResizeable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setManager";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canChangeSelectionTo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setTabDoubleClickActions";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "initMouseListeners";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "initActionGroup";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createSplitTabsAction";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createMergeTabsAction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processHide";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hideWindow";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "toggleContentPopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class TabPanel
    extends JPanel
    implements UISettingsListener {
        private TabPanel() {
            super(new MigLayout(MigLayoutUtilKt.createLayoutConstraints(0, 0).noVisualPadding().fillY()));
            this.setOpaque(false);
            this.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        }

        public void uiSettingsChanged(@NotNull UISettings uiSettings) {
            if (uiSettings == null) {
                TabPanel.$$$reportNull$$$0(0);
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        public void doLayout() {
            ToolWindowContentUi.this.getCurrentLayout().layout();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ToolWindowContentUi.this.getCurrentLayout().paintComponent(g);
        }

        @Override
        public Dimension getMinimumSize() {
            Insets insets = this.getInsets();
            return new Dimension(insets.left + insets.right + ToolWindowContentUi.this.getCurrentLayout().getMinimumWidth(), super.getMinimumSize().height);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = new Dimension();
            size.height = 0;
            size.width = 4 + this.getInsets().left + this.getInsets().right;
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                Component each = this.getComponent(i2);
                if (!each.isVisible()) continue;
                size.height = Math.max(each.getPreferredSize().height, size.height);
                size.width += each.getPreferredSize().width;
            }
            size.width = Math.max(size.width, this.getMinimumSize().width);
            return size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiSettings", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$TabPanel", "uiSettingsChanged"));
        }
    }

    private final class CloseContentTarget
    implements CloseAction.CloseTarget {
        private final Content myContent;

        private CloseContentTarget(Content content2) {
            this.myContent = content2;
        }

        @Override
        public void close() {
            ToolWindowContentUi.this.contentManager.removeContent(this.myContent, true, true, true);
        }
    }

    private final class HideToolwindowTarget
    implements CloseAction.CloseTarget {
        private HideToolwindowTarget() {
        }

        @Override
        public void close() {
            ToolWindowContentUi.this.window.fireHidden(ToolWindowEventSource.CloseAction);
        }
    }
}

