/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.IdeLeftToolbar;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.Surface;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.ToolWindowPaneState;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.reference.SoftReference;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowsPane
extends JBLayeredPane
implements UISettingsListener {
    private static final Logger LOG = Logger.getInstance(ToolWindowsPane.class);
    @NonNls
    public static final String TEMPORARY_ADDED = "TEMPORARY_ADDED";
    private final JFrame frame;
    private ToolWindowPaneState state;
    private final MyLayeredPane layeredPane;
    private final ThreeComponentsSplitter verticalSplitter;
    private final ThreeComponentsSplitter horizontalSplitter;
    private final Stripe leftStripe;
    private final Stripe rightStripe;
    private final Stripe bottomStripe;
    private final Stripe topStripe;
    private final Stripe newStripe;
    private final List<Stripe> stripes;
    private boolean isWideScreen;
    private boolean leftHorizontalSplit;
    private boolean rightHorizontalSplit;

    ToolWindowsPane(@NotNull JFrame frame, @NotNull Disposable parentDisposable) {
        if (frame == null) {
            ToolWindowsPane.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ToolWindowsPane.$$$reportNull$$$0(1);
        }
        this.state = new ToolWindowPaneState();
        this.stripes = new ArrayList<Stripe>(4);
        this.setOpaque(false);
        this.frame = frame;
        this.verticalSplitter = new ThreeComponentsSplitter(true, parentDisposable);
        RegistryValue registryValue = Registry.get((String)"ide.mainSplitter.min.size");
        registryValue.addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ToolWindowsPane.this.updateInnerMinSize(value2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/wm/impl/ToolWindowsPane$1", "afterValueChanged"));
            }
        }, parentDisposable);
        this.verticalSplitter.setDividerWidth(0);
        this.verticalSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.verticalSplitter.setBackground(Color.gray);
        this.horizontalSplitter = new ThreeComponentsSplitter(false, parentDisposable);
        this.horizontalSplitter.setDividerWidth(0);
        this.horizontalSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.horizontalSplitter.setBackground(Color.gray);
        this.updateInnerMinSize(registryValue);
        UISettings uiSettings = UISettings.getInstance();
        this.isWideScreen = uiSettings.getWideScreenSupport();
        this.leftHorizontalSplit = uiSettings.getLeftHorizontalSplit();
        this.rightHorizontalSplit = uiSettings.getRightHorizontalSplit();
        if (this.isWideScreen) {
            this.horizontalSplitter.setInnerComponent((JComponent)this.verticalSplitter);
        } else {
            this.verticalSplitter.setInnerComponent((JComponent)this.horizontalSplitter);
        }
        this.topStripe = new Stripe(1);
        this.stripes.add(this.topStripe);
        this.leftStripe = new Stripe(2);
        this.stripes.add(this.leftStripe);
        this.bottomStripe = new Stripe(3);
        this.stripes.add(this.bottomStripe);
        this.rightStripe = new Stripe(4);
        this.stripes.add(this.rightStripe);
        this.newStripe = new IdeLeftToolbar();
        this.updateToolStripesVisibility(uiSettings);
        this.layeredPane = new MyLayeredPane((JComponent)(this.isWideScreen ? this.horizontalSplitter : this.verticalSplitter));
        this.add(this.topStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.leftStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.bottomStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.rightStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.newStripe, JLayeredPane.POPUP_LAYER);
        this.add((Component)((Object)this.layeredPane), JLayeredPane.DEFAULT_LAYER);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    void initDocumentComponent(@NotNull Project project) {
        if (project == null) {
            ToolWindowsPane.$$$reportNull$$$0(2);
        }
        JComponent editorComponent = FileEditorManagerEx.getInstanceEx(project).getComponent();
        editorComponent.setFocusable(false);
        this.setDocumentComponent(editorComponent);
    }

    private void updateInnerMinSize(@NotNull RegistryValue value2) {
        if (value2 == null) {
            ToolWindowsPane.$$$reportNull$$$0(3);
        }
        int minSize = Math.max(0, Math.min(100, value2.asInteger()));
        this.verticalSplitter.setMinSize(JBUIScale.scale((int)minSize));
        this.horizontalSplitter.setMinSize(JBUIScale.scale((int)minSize));
    }

    public void doLayout() {
        Dimension size = this.getSize();
        if (!this.topStripe.isVisible()) {
            this.topStripe.setBounds(0, 0, 0, 0);
            this.bottomStripe.setBounds(0, 0, 0, 0);
            this.leftStripe.setBounds(0, 0, 0, 0);
            this.rightStripe.setBounds(0, 0, 0, 0);
            if (Registry.is((String)"ide.new.stripes.ui")) {
                this.newStripe.setBounds(0, 0, this.newStripe.getPreferredSize().width, size.height);
                this.layeredPane.setBounds(this.newStripe.getPreferredSize().width, 0, this.getWidth() - this.newStripe.getPreferredSize().width, this.getHeight());
            } else {
                this.layeredPane.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        } else {
            Dimension topSize = this.topStripe.getPreferredSize();
            Dimension bottomSize = this.bottomStripe.getPreferredSize();
            Dimension leftSize = this.leftStripe.getPreferredSize();
            Dimension rightSize = this.rightStripe.getPreferredSize();
            this.topStripe.setBounds(0, 0, size.width, topSize.height);
            int height = size.height - topSize.height - bottomSize.height;
            this.leftStripe.setBounds(0, topSize.height, leftSize.width, height);
            this.rightStripe.setBounds(size.width - rightSize.width, topSize.height, rightSize.width, height);
            this.bottomStripe.setBounds(0, size.height - bottomSize.height, size.width, bottomSize.height);
            UISettings uiSettings = UISettings.getInstance();
            if (uiSettings.getHideToolStripes() || uiSettings.getPresentationMode()) {
                this.layeredPane.setBounds(0, 0, size.width, size.height);
            } else {
                int width = size.width - leftSize.width - rightSize.width;
                this.layeredPane.setBounds(leftSize.width, topSize.height, width, height);
            }
        }
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            ToolWindowsPane.$$$reportNull$$$0(4);
        }
        this.updateToolStripesVisibility(uiSettings);
        this.updateLayout(uiSettings);
    }

    final void addDecorator(@NotNull JComponent decorator, @NotNull WindowInfo info, boolean dirtyMode, @NotNull ToolWindowManagerImpl manager) {
        if (decorator == null) {
            ToolWindowsPane.$$$reportNull$$$0(5);
        }
        if (info == null) {
            ToolWindowsPane.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            ToolWindowsPane.$$$reportNull$$$0(7);
        }
        if (info.isDocked()) {
            boolean side = !info.isSplit();
            WindowInfo sideInfo = manager.getDockedInfoAt(info.getAnchor(), side);
            if (sideInfo == null) {
                ToolWindowAnchor anchor2 = info.getAnchor();
                this.setComponent(decorator, anchor2, ToolWindowsPane.normalizeWeigh(info.getWeight()));
                if (!dirtyMode) {
                    this.layeredPane.validate();
                    this.layeredPane.repaint();
                }
            } else {
                this.addAndSplitDockedComponentCmd(decorator, info, dirtyMode, manager);
            }
        } else if (info.getType() == ToolWindowType.SLIDING) {
            this.addSlidingComponent(decorator, info, dirtyMode);
        } else {
            throw new IllegalArgumentException("Unknown window type: " + info.getType());
        }
    }

    void removeDecorator(@NotNull WindowInfo info, @Nullable JComponent component2, boolean dirtyMode, @NotNull ToolWindowManagerImpl manager) {
        if (info == null) {
            ToolWindowsPane.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            ToolWindowsPane.$$$reportNull$$$0(9);
        }
        if (info.getType() == ToolWindowType.DOCKED) {
            WindowInfo sideInfo = manager.getDockedInfoAt(info.getAnchor(), !info.isSplit());
            if (sideInfo == null) {
                this.setComponent(null, info.getAnchor(), 0.0f);
            } else {
                ToolWindowAnchor anchor2 = info.getAnchor();
                JComponent c = this.getComponentAt(anchor2);
                if (c instanceof Splitter) {
                    Splitter splitter = (Splitter)c;
                    InternalDecorator component1 = (InternalDecorator)(info.isSplit() ? splitter.getFirstComponent() : splitter.getSecondComponent());
                    this.state.addSplitProportion(info, component1, splitter);
                    this.setComponent(component1, anchor2, component1 == null ? 0.0f : ToolWindowManagerImpl.getRegisteredMutableInfoOrLogError(component1).getWeight());
                } else {
                    this.setComponent(null, anchor2, 0.0f);
                }
            }
            if (!dirtyMode) {
                this.layeredPane.validate();
                this.layeredPane.repaint();
            }
        } else if (info.getType() == ToolWindowType.SLIDING && component2 != null) {
            this.removeSlidingComponent(component2, info, dirtyMode);
        }
    }

    @NotNull
    public final JComponent getLayeredPane() {
        MyLayeredPane myLayeredPane = this.layeredPane;
        if (myLayeredPane == null) {
            ToolWindowsPane.$$$reportNull$$$0(10);
        }
        return myLayeredPane;
    }

    public void validateAndRepaint() {
        this.layeredPane.validate();
        this.layeredPane.repaint();
        for (Stripe stripe : this.stripes) {
            stripe.revalidate();
            stripe.repaint();
        }
    }

    public void revalidateNotEmptyStripes() {
        for (Stripe stripe : this.stripes) {
            if (stripe.isEmpty()) continue;
            stripe.revalidate();
        }
    }

    private void setComponent(@Nullable JComponent component2, @NotNull ToolWindowAnchor anchor2, float weight2) {
        if (anchor2 == null) {
            ToolWindowsPane.$$$reportNull$$$0(11);
        }
        if (ToolWindowAnchor.TOP == anchor2) {
            this.verticalSplitter.setFirstComponent(component2);
            this.verticalSplitter.setFirstSize((int)((float)this.layeredPane.getHeight() * weight2));
        } else if (ToolWindowAnchor.LEFT == anchor2) {
            this.horizontalSplitter.setFirstComponent(component2);
            this.horizontalSplitter.setFirstSize((int)((float)this.layeredPane.getWidth() * weight2));
        } else if (ToolWindowAnchor.BOTTOM == anchor2) {
            this.verticalSplitter.setLastComponent(component2);
            this.verticalSplitter.setLastSize((int)((float)this.layeredPane.getHeight() * weight2));
        } else if (ToolWindowAnchor.RIGHT == anchor2) {
            this.horizontalSplitter.setLastComponent(component2);
            this.horizontalSplitter.setLastSize((int)((float)this.layeredPane.getWidth() * weight2));
        } else {
            LOG.error("unknown anchor: " + anchor2);
        }
    }

    private JComponent getComponentAt(@NotNull ToolWindowAnchor anchor2) {
        if (anchor2 == null) {
            ToolWindowsPane.$$$reportNull$$$0(12);
        }
        if (ToolWindowAnchor.TOP == anchor2) {
            return this.verticalSplitter.getFirstComponent();
        }
        if (ToolWindowAnchor.LEFT == anchor2) {
            return this.horizontalSplitter.getFirstComponent();
        }
        if (ToolWindowAnchor.BOTTOM == anchor2) {
            return this.verticalSplitter.getLastComponent();
        }
        if (ToolWindowAnchor.RIGHT == anchor2) {
            return this.horizontalSplitter.getLastComponent();
        }
        LOG.error("unknown anchor: " + anchor2);
        return null;
    }

    private void setDocumentComponent(@Nullable JComponent component2) {
        (this.isWideScreen ? this.verticalSplitter : this.horizontalSplitter).setInnerComponent(component2);
    }

    private void updateToolStripesVisibility(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            ToolWindowsPane.$$$reportNull$$$0(13);
        }
        boolean oldVisible = this.leftStripe.isVisible();
        boolean showButtons = !uiSettings.getHideToolStripes() && !uiSettings.getPresentationMode();
        boolean visible = (showButtons || this.state.isStripesOverlaid()) && !Registry.is((String)"ide.new.stripes.ui");
        this.leftStripe.setVisible(visible);
        this.rightStripe.setVisible(visible);
        this.topStripe.setVisible(visible);
        this.bottomStripe.setVisible(visible);
        boolean overlayed = !showButtons && this.state.isStripesOverlaid();
        this.leftStripe.setOverlayed(overlayed);
        this.rightStripe.setOverlayed(overlayed);
        this.topStripe.setOverlayed(overlayed);
        this.bottomStripe.setOverlayed(overlayed);
        if (oldVisible != visible) {
            this.revalidate();
            this.repaint();
        }
    }

    public int getBottomHeight() {
        return this.bottomStripe.isVisible() ? this.bottomStripe.getHeight() : 0;
    }

    public boolean isBottomSideToolWindowsVisible() {
        return this.getComponentAt(ToolWindowAnchor.BOTTOM) != null;
    }

    @NotNull
    Stripe getStripeFor(@NotNull ToolWindowAnchor anchor2) {
        if (anchor2 == null) {
            ToolWindowsPane.$$$reportNull$$$0(14);
        }
        if (ToolWindowAnchor.TOP == anchor2) {
            Stripe stripe = this.topStripe;
            if (stripe == null) {
                ToolWindowsPane.$$$reportNull$$$0(15);
            }
            return stripe;
        }
        if (ToolWindowAnchor.BOTTOM == anchor2) {
            Stripe stripe = this.bottomStripe;
            if (stripe == null) {
                ToolWindowsPane.$$$reportNull$$$0(16);
            }
            return stripe;
        }
        if (ToolWindowAnchor.LEFT == anchor2) {
            Stripe stripe = this.leftStripe;
            if (stripe == null) {
                ToolWindowsPane.$$$reportNull$$$0(17);
            }
            return stripe;
        }
        if (ToolWindowAnchor.RIGHT == anchor2) {
            Stripe stripe = this.rightStripe;
            if (stripe == null) {
                ToolWindowsPane.$$$reportNull$$$0(18);
            }
            return stripe;
        }
        throw new IllegalArgumentException("Anchor=" + anchor2);
    }

    @Nullable
    Stripe getStripeFor(@NotNull Rectangle screenRectangle, @NotNull Stripe preferred) {
        if (screenRectangle == null) {
            ToolWindowsPane.$$$reportNull$$$0(19);
        }
        if (preferred == null) {
            ToolWindowsPane.$$$reportNull$$$0(20);
        }
        if (preferred.containsScreen(screenRectangle)) {
            return preferred;
        }
        for (Stripe stripe : this.stripes) {
            if (!stripe.containsScreen(screenRectangle)) continue;
            return stripe;
        }
        return null;
    }

    void startDrag() {
        for (Stripe each : this.stripes) {
            each.startDrag();
        }
    }

    void stopDrag() {
        for (Stripe stripe : this.stripes) {
            stripe.stopDrag();
        }
    }

    void stretchWidth(@NotNull ToolWindow window, int value2) {
        if (window == null) {
            ToolWindowsPane.$$$reportNull$$$0(21);
        }
        this.stretch(window, value2);
    }

    void stretchHeight(@NotNull ToolWindow window, int value2) {
        if (window == null) {
            ToolWindowsPane.$$$reportNull$$$0(22);
        }
        this.stretch(window, value2);
    }

    private void stretch(@NotNull ToolWindow wnd, int value2) {
        Pair<Resizer, Component> pair;
        if (wnd == null) {
            ToolWindowsPane.$$$reportNull$$$0(23);
        }
        if ((pair = this.findResizerAndComponent(wnd)) == null) {
            return;
        }
        boolean vertical = wnd.getAnchor() == ToolWindowAnchor.TOP || wnd.getAnchor() == ToolWindowAnchor.BOTTOM;
        int actualSize = (vertical ? ((Component)pair.second).getHeight() : ((Component)pair.second).getWidth()) + value2;
        boolean first = wnd.getAnchor() == ToolWindowAnchor.LEFT || wnd.getAnchor() == ToolWindowAnchor.TOP;
        int maxValue = vertical ? this.verticalSplitter.getMaxSize(first) : this.horizontalSplitter.getMaxSize(first);
        int minValue = vertical ? this.verticalSplitter.getMinSize(first) : this.horizontalSplitter.getMinSize(first);
        ((Resizer)pair.first).setSize(Math.max(minValue, Math.min(maxValue, actualSize)));
    }

    @Nullable
    private Pair<Resizer, Component> findResizerAndComponent(@NotNull ToolWindow window) {
        if (window == null) {
            ToolWindowsPane.$$$reportNull$$$0(24);
        }
        if (!window.isVisible()) {
            return null;
        }
        Resizer resizer = null;
        Container component2 = null;
        if (window.getType() == ToolWindowType.DOCKED) {
            component2 = this.getComponentAt(window.getAnchor());
            if (component2 != null) {
                resizer = window.getAnchor().isHorizontal() ? (this.verticalSplitter.getFirstComponent() == component2 ? new Resizer.Splitter.FirstComponent(this.verticalSplitter) : new Resizer.Splitter.LastComponent(this.verticalSplitter)) : (this.horizontalSplitter.getFirstComponent() == component2 ? new Resizer.Splitter.FirstComponent(this.horizontalSplitter) : new Resizer.Splitter.LastComponent(this.horizontalSplitter));
            }
        } else if (window.getType() == ToolWindowType.SLIDING) {
            for (component2 = window.getComponent(); component2 != null && component2.getParent() != this.layeredPane; component2 = component2.getParent()) {
            }
            if (component2 != null) {
                if (window.getAnchor() == ToolWindowAnchor.TOP) {
                    resizer = new Resizer.LayeredPane.Top(component2);
                } else if (window.getAnchor() == ToolWindowAnchor.BOTTOM) {
                    resizer = new Resizer.LayeredPane.Bottom(component2);
                } else if (window.getAnchor() == ToolWindowAnchor.LEFT) {
                    resizer = new Resizer.LayeredPane.Left(component2);
                } else if (window.getAnchor() == ToolWindowAnchor.RIGHT) {
                    resizer = new Resizer.LayeredPane.Right(component2);
                }
            }
        }
        return resizer != null ? Pair.create(resizer, (Object)component2) : null;
    }

    private void updateLayout(@NotNull UISettings uiSettings) {
        WindowInfoImpl secondInfo;
        WindowInfoImpl firstInfo;
        Splitter splitter;
        JComponent component2;
        if (uiSettings == null) {
            ToolWindowsPane.$$$reportNull$$$0(25);
        }
        if (this.isWideScreen != uiSettings.getWideScreenSupport()) {
            JComponent documentComponent = (this.isWideScreen ? this.verticalSplitter : this.horizontalSplitter).getInnerComponent();
            this.isWideScreen = uiSettings.getWideScreenSupport();
            if (this.isWideScreen) {
                this.verticalSplitter.setInnerComponent(null);
                this.horizontalSplitter.setInnerComponent((JComponent)this.verticalSplitter);
            } else {
                this.horizontalSplitter.setInnerComponent(null);
                this.verticalSplitter.setInnerComponent((JComponent)this.horizontalSplitter);
            }
            this.layeredPane.remove((Component)(this.isWideScreen ? this.verticalSplitter : this.horizontalSplitter));
            this.layeredPane.add((Component)(this.isWideScreen ? this.horizontalSplitter : this.verticalSplitter), DEFAULT_LAYER);
            this.setDocumentComponent(documentComponent);
        }
        if (this.leftHorizontalSplit != uiSettings.getLeftHorizontalSplit()) {
            component2 = this.getComponentAt(ToolWindowAnchor.LEFT);
            if (component2 instanceof Splitter) {
                splitter = (Splitter)component2;
                firstInfo = ToolWindowManagerImpl.getRegisteredMutableInfoOrLogError((InternalDecorator)splitter.getFirstComponent());
                secondInfo = ToolWindowManagerImpl.getRegisteredMutableInfoOrLogError((InternalDecorator)splitter.getSecondComponent());
                this.setComponent((JComponent)splitter, ToolWindowAnchor.LEFT, ToolWindowAnchor.LEFT.isSplitVertically() ? firstInfo.getWeight() : firstInfo.getWeight() + secondInfo.getWeight());
            }
            this.leftHorizontalSplit = uiSettings.getLeftHorizontalSplit();
        }
        if (this.rightHorizontalSplit != uiSettings.getRightHorizontalSplit()) {
            component2 = this.getComponentAt(ToolWindowAnchor.RIGHT);
            if (component2 instanceof Splitter) {
                splitter = (Splitter)component2;
                firstInfo = ToolWindowManagerImpl.getRegisteredMutableInfoOrLogError((InternalDecorator)splitter.getFirstComponent());
                secondInfo = ToolWindowManagerImpl.getRegisteredMutableInfoOrLogError((InternalDecorator)splitter.getSecondComponent());
                this.setComponent((JComponent)splitter, ToolWindowAnchor.RIGHT, ToolWindowAnchor.RIGHT.isSplitVertically() ? firstInfo.getWeight() : firstInfo.getWeight() + secondInfo.getWeight());
            }
            this.rightHorizontalSplit = uiSettings.getRightHorizontalSplit();
        }
    }

    public boolean isMaximized(@NotNull ToolWindow window) {
        if (window == null) {
            ToolWindowsPane.$$$reportNull$$$0(26);
        }
        return this.state.isMaximized(window);
    }

    void setMaximized(@NotNull ToolWindow toolWindow, boolean maximized) {
        Pair<Resizer, Component> resizerAndComponent;
        if (toolWindow == null) {
            ToolWindowsPane.$$$reportNull$$$0(27);
        }
        if ((resizerAndComponent = this.findResizerAndComponent(toolWindow)) == null) {
            return;
        }
        if (maximized) {
            int size = toolWindow.getAnchor().isHorizontal() ? ((Component)resizerAndComponent.second).getHeight() : ((Component)resizerAndComponent.second).getWidth();
            this.stretch(toolWindow, Short.MAX_VALUE);
            this.state.setMaximizedProportion((Pair<ToolWindow, Integer>)Pair.create((Object)toolWindow, (Object)size));
        } else {
            Pair<ToolWindow, Integer> maximizedProportion = this.state.getMaximizedProportion();
            LOG.assertTrue(maximizedProportion != null);
            ToolWindow maximizedWindow = (ToolWindow)maximizedProportion.first;
            assert (maximizedWindow == toolWindow);
            ((Resizer)resizerAndComponent.first).setSize((Integer)maximizedProportion.second);
            this.state.setMaximizedProportion(null);
        }
        this.doLayout();
    }

    void reset() {
        for (Stripe stripe : this.stripes) {
            stripe.reset();
        }
        this.state = new ToolWindowPaneState();
        this.revalidate();
    }

    public void onStripeButtonAdded(@NotNull StripeButton button2) {
        if (button2 == null) {
            ToolWindowsPane.$$$reportNull$$$0(28);
        }
        if (button2.toolWindow.isAvailable() && button2.toolWindow.getIcon() != null && Registry.is((String)"ide.new.stripes.ui")) {
            this.newStripe.addButton(button2, (o1, o2) -> 0);
        }
    }

    private void addAndSplitDockedComponentCmd(@NotNull JComponent newComponent, @NotNull WindowInfo info, boolean dirtyMode, @NotNull ToolWindowManagerImpl manager) {
        float newWeight;
        JComponent c;
        if (newComponent == null) {
            ToolWindowsPane.$$$reportNull$$$0(29);
        }
        if (info == null) {
            ToolWindowsPane.$$$reportNull$$$0(30);
        }
        if (manager == null) {
            ToolWindowsPane.$$$reportNull$$$0(31);
        }
        final ToolWindowAnchor anchor2 = info.getAnchor();
        final class MySplitter
        extends OnePixelSplitter
        implements UISettingsListener {
            MySplitter() {
            }

            public void uiSettingsChanged(@NotNull UISettings uiSettings) {
                if (uiSettings == null) {
                    MySplitter.$$$reportNull$$$0(0);
                }
                if (anchor2 == ToolWindowAnchor.LEFT) {
                    this.setOrientation(!uiSettings.getLeftHorizontalSplit());
                } else if (anchor2 == ToolWindowAnchor.RIGHT) {
                    this.setOrientation(!uiSettings.getRightHorizontalSplit());
                }
            }

            public String toString() {
                return "[" + this.getFirstComponent() + "|" + this.getSecondComponent() + "]";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiSettings", "com/intellij/openapi/wm/impl/ToolWindowsPane$1MySplitter", "uiSettingsChanged"));
            }
        }
        MySplitter splitter = new MySplitter();
        splitter.setOrientation(anchor2.isSplitVertically());
        if (!anchor2.isHorizontal()) {
            splitter.setAllowSwitchOrientationByMouseClick(true);
            splitter.addPropertyChangeListener(arg_0 -> ToolWindowsPane.lambda$addAndSplitDockedComponentCmd$1((Splitter)splitter, anchor2, arg_0));
        }
        if ((c = this.getComponentAt(anchor2)) == null) {
            List<ToolWindowEx> toolWindows = manager.getToolWindowsOn(anchor2, Objects.requireNonNull(info.getId()));
            toolWindows.removeIf(window -> window == null || window.isSplitMode() == info.isSplit() || !window.isVisible());
            if (!toolWindows.isEmpty()) {
                c = ((ToolWindowImpl)toolWindows.get(0)).getDecoratorComponent();
            }
            if (c == null) {
                LOG.error("Empty splitter @ " + anchor2 + " during AddAndSplitDockedComponentCmd for " + info.getId());
            }
        }
        if (c instanceof InternalDecorator) {
            InternalDecorator oldComponent = (InternalDecorator)c;
            WindowInfoImpl oldInfo = ToolWindowManagerImpl.getRegisteredMutableInfoOrLogError(oldComponent);
            IJSwingUtilities.updateComponentTreeUI(oldComponent);
            IJSwingUtilities.updateComponentTreeUI(newComponent);
            if (info.isSplit()) {
                splitter.setFirstComponent(oldComponent);
                splitter.setSecondComponent(newComponent);
                float proportion = this.state.getPreferredSplitProportion(Objects.requireNonNull(oldInfo.getId()), ToolWindowsPane.normalizeWeigh(oldInfo.getSideWeight() / (oldInfo.getSideWeight() + info.getSideWeight())));
                splitter.setProportion(proportion);
                newWeight = !anchor2.isHorizontal() && !anchor2.isSplitVertically() ? ToolWindowsPane.normalizeWeigh(oldInfo.getWeight() + info.getWeight()) : ToolWindowsPane.normalizeWeigh(oldInfo.getWeight());
            } else {
                splitter.setFirstComponent(newComponent);
                splitter.setSecondComponent(oldComponent);
                splitter.setProportion(ToolWindowsPane.normalizeWeigh(info.getSideWeight()));
                newWeight = !anchor2.isHorizontal() && !anchor2.isSplitVertically() ? ToolWindowsPane.normalizeWeigh(oldInfo.getWeight() + info.getWeight()) : ToolWindowsPane.normalizeWeigh(info.getWeight());
            }
        } else {
            newWeight = ToolWindowsPane.normalizeWeigh(info.getWeight());
        }
        this.setComponent((JComponent)((Object)splitter), anchor2, newWeight);
        if (!dirtyMode) {
            this.layeredPane.validate();
            this.layeredPane.repaint();
        }
    }

    private void addSlidingComponent(@NotNull JComponent component2, @NotNull WindowInfo info, boolean dirtyMode) {
        if (component2 == null) {
            ToolWindowsPane.$$$reportNull$$$0(32);
        }
        if (info == null) {
            ToolWindowsPane.$$$reportNull$$$0(33);
        }
        if (dirtyMode || !UISettings.getInstance().getAnimateWindows() || RemoteDesktopService.isRemoteSession()) {
            this.layeredPane.add(component2, JLayeredPane.PALETTE_LAYER);
            this.layeredPane.setBoundsInPaletteLayer(component2, info.getAnchor(), info.getWeight());
        } else {
            Image topImage = this.layeredPane.getTopImage();
            Rectangle bounds2 = component2.getBounds();
            UIUtil.useSafely((Graphics)topImage.getGraphics(), topGraphics -> {
                component2.putClientProperty(TEMPORARY_ADDED, Boolean.TRUE);
                try {
                    this.layeredPane.add(component2, JLayeredPane.PALETTE_LAYER);
                    this.layeredPane.moveToFront(component2);
                    this.layeredPane.setBoundsInPaletteLayer(component2, info.getAnchor(), info.getWeight());
                    component2.paint((Graphics)topGraphics);
                    this.layeredPane.remove(component2);
                }
                finally {
                    component2.putClientProperty(TEMPORARY_ADDED, null);
                }
            });
            Image bottomImage = this.layeredPane.getBottomImage();
            Point2D bottomImageOffset = PaintUtil.getFractOffsetInRootPane((JComponent)((Object)this.layeredPane));
            UIUtil.useSafely((Graphics)bottomImage.getGraphics(), bottomGraphics -> {
                bottomGraphics.setClip(0, 0, bounds2.width, bounds2.height);
                bottomGraphics.translate(bottomImageOffset.getX() - (double)bounds2.x, bottomImageOffset.getY() - (double)bounds2.y);
                this.layeredPane.paint((Graphics)bottomGraphics);
            });
            Surface surface = new Surface(topImage, bottomImage, PaintUtil.negate((Point2D)bottomImageOffset), 1, info.getAnchor(), 300);
            this.layeredPane.add(surface, JLayeredPane.PALETTE_LAYER);
            surface.setBounds(bounds2);
            this.layeredPane.validate();
            this.layeredPane.repaint();
            surface.runMovement();
            this.layeredPane.remove(surface);
            this.layeredPane.add(component2, JLayeredPane.PALETTE_LAYER);
        }
        if (!dirtyMode) {
            this.layeredPane.validate();
            this.layeredPane.repaint();
        }
    }

    private void removeSlidingComponent(@NotNull Component component2, @NotNull WindowInfo info, boolean dirtyMode) {
        if (component2 == null) {
            ToolWindowsPane.$$$reportNull$$$0(34);
        }
        if (info == null) {
            ToolWindowsPane.$$$reportNull$$$0(35);
        }
        UISettings uiSettings = UISettings.getInstance();
        if (!dirtyMode && uiSettings.getAnimateWindows() && !RemoteDesktopService.isRemoteSession()) {
            Rectangle bounds2 = component2.getBounds();
            Image topImage = this.layeredPane.getTopImage();
            UIUtil.useSafely((Graphics)topImage.getGraphics(), component2::paint);
            Image bottomImage = this.layeredPane.getBottomImage();
            Point2D bottomImageOffset = PaintUtil.getFractOffsetInRootPane((JComponent)((Object)this.layeredPane));
            UIUtil.useSafely((Graphics)bottomImage.getGraphics(), bottomGraphics -> {
                this.layeredPane.remove(component2);
                bottomGraphics.clipRect(0, 0, bounds2.width, bounds2.height);
                bottomGraphics.translate(bottomImageOffset.getX() - (double)bounds2.x, bottomImageOffset.getY() - (double)bounds2.y);
                this.layeredPane.paint((Graphics)bottomGraphics);
            });
            Surface surface = new Surface(topImage, bottomImage, PaintUtil.negate((Point2D)bottomImageOffset), -1, info.getAnchor(), 300);
            this.layeredPane.add(surface, JLayeredPane.PALETTE_LAYER);
            surface.setBounds(bounds2);
            this.layeredPane.validate();
            this.layeredPane.repaint();
            surface.runMovement();
            this.layeredPane.remove(surface);
        } else {
            this.layeredPane.remove(component2);
        }
        if (!dirtyMode) {
            this.layeredPane.validate();
            this.layeredPane.repaint();
        }
    }

    void setStripesOverlayed(boolean value2) {
        this.state.setStripesOverlaid(value2);
        this.updateToolStripesVisibility(UISettings.getInstance());
    }

    private static float normalizeWeigh(float weight2) {
        if (weight2 <= 0.0f) {
            return 0.33f;
        }
        if (weight2 >= 1.0f) {
            return 0.66999996f;
        }
        return weight2;
    }

    private static /* synthetic */ void lambda$addAndSplitDockedComponentCmd$1(Splitter splitter, ToolWindowAnchor anchor2, PropertyChangeEvent evt) {
        if (!"orientation".equals(evt.getPropertyName())) {
            return;
        }
        boolean isSplitterHorizontalNow = !splitter.isVertical();
        UISettings settings = UISettings.getInstance();
        if (anchor2 == ToolWindowAnchor.LEFT && settings.getLeftHorizontalSplit() != isSplitterHorizontalNow) {
            settings.setLeftHorizontalSplit(isSplitterHorizontalNow);
            settings.fireUISettingsChanged();
        }
        if (anchor2 == ToolWindowAnchor.RIGHT && settings.getRightHorizontalSplit() != isSplitterHorizontalNow) {
            settings.setRightHorizontalSplit(isSplitterHorizontalNow);
            settings.fireUISettingsChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 6: 
            case 8: 
            case 30: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: 
            case 9: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/ToolWindowsPane";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenRectangle";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferred";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wnd";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newComponent";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayeredPane";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getStripeFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initDocumentComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateInnerMinSize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDecorator";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeDecorator";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAt";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateToolStripesVisibility";
                break;
            }
            case 14: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getStripeFor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "stretchWidth";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "stretchHeight";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "stretch";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findResizerAndComponent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updateLayout";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isMaximized";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setMaximized";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "onStripeButtonAdded";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addAndSplitDockedComponentCmd";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addSlidingComponent";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeSlidingComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyLayeredPane
    extends JBLayeredPane {
        private final Function<ScaleContext, ImageRef> myImageProvider;
        private final ImageCache myBottomImageCache;
        private final ImageCache myTopImageCache;

        MyLayeredPane(JComponent splitter) {
            if (splitter == null) {
                MyLayeredPane.$$$reportNull$$$0(0);
            }
            this.myImageProvider = __ -> {
                int width = Math.max(Math.max(1, this.getWidth()), ToolWindowsPane.this.frame.getWidth());
                int height = Math.max(Math.max(1, this.getHeight()), ToolWindowsPane.this.frame.getHeight());
                return new ImageRef(ImageUtil.createImage((GraphicsConfiguration)this.getGraphicsConfiguration(), (int)width, (int)height, (int)1));
            };
            this.myBottomImageCache = new ImageCache(this.myImageProvider);
            this.myTopImageCache = new ImageCache(this.myImageProvider);
            this.setOpaque(false);
            this.add(splitter, JLayeredPane.DEFAULT_LAYER);
        }

        final Image getBottomImage() {
            return this.myBottomImageCache.get(ScaleContext.create((Component)((Object)this)));
        }

        final Image getTopImage() {
            return this.myTopImageCache.get(ScaleContext.create((Component)((Object)this)));
        }

        public void doLayout() {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width < 0 || height < 0) {
                return;
            }
            Component[] components = this.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            LOG.assertTrue(components.length <= 1);
            for (Component component2 : components) {
                component2.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
            for (Component component2 : components = this.getComponentsInLayer(JLayeredPane.PALETTE_LAYER)) {
                if (!(component2 instanceof InternalDecorator)) continue;
                WindowInfo info = ((InternalDecorator)component2).getToolWindow().getWindowInfo();
                float weight2 = info.getAnchor().isHorizontal() ? (float)component2.getHeight() / (float)this.getHeight() : (float)component2.getWidth() / (float)this.getWidth();
                this.setBoundsInPaletteLayer(component2, info.getAnchor(), weight2);
            }
        }

        final void setBoundsInPaletteLayer(@NotNull Component component2, @NotNull ToolWindowAnchor anchor2, float weight2) {
            if (component2 == null) {
                MyLayeredPane.$$$reportNull$$$0(1);
            }
            if (anchor2 == null) {
                MyLayeredPane.$$$reportNull$$$0(2);
            }
            if (weight2 < 0.0f) {
                weight2 = 0.33f;
            } else if (weight2 > 1.0f) {
                weight2 = 1.0f;
            }
            if (ToolWindowAnchor.TOP == anchor2) {
                component2.setBounds(0, 0, this.getWidth(), (int)((float)this.getHeight() * weight2 + 0.5f));
            } else if (ToolWindowAnchor.LEFT == anchor2) {
                component2.setBounds(0, 0, (int)((float)this.getWidth() * weight2 + 0.5f), this.getHeight());
            } else if (ToolWindowAnchor.BOTTOM == anchor2) {
                int height = (int)((float)this.getHeight() * weight2 + 0.5f);
                component2.setBounds(0, this.getHeight() - height, this.getWidth(), height);
            } else if (ToolWindowAnchor.RIGHT == anchor2) {
                int width = (int)((float)this.getWidth() * weight2 + 0.5f);
                component2.setBounds(this.getWidth() - width, 0, width, this.getHeight());
            } else {
                LOG.error("unknown anchor " + anchor2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "splitter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane$MyLayeredPane";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setBoundsInPaletteLayer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ImageCache
    extends ScaleContext.Cache<ImageRef> {
        ImageCache(@NotNull Function<? super ScaleContext, ImageRef> imageProvider) {
            if (imageProvider == null) {
                ImageCache.$$$reportNull$$$0(0);
            }
            super(imageProvider);
        }

        public BufferedImage get(@NotNull ScaleContext ctx) {
            ImageRef ref;
            BufferedImage image;
            if (ctx == null) {
                ImageCache.$$$reportNull$$$0(1);
            }
            if ((image = (BufferedImage)SoftReference.dereference((Reference)((Object)(ref = (ImageRef)((Object)this.getOrProvide((UserScaleContext)ctx)))))) != null) {
                return image;
            }
            this.clear();
            return this.get(ctx);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "imageProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane$ImageCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ImageRef
    extends SoftReference<BufferedImage> {
        @Nullable
        private BufferedImage myStrongRef;

        ImageRef(@NotNull BufferedImage image) {
            if (image == null) {
                ImageRef.$$$reportNull$$$0(0);
            }
            super((Object)image);
            this.myStrongRef = image;
        }

        public BufferedImage get() {
            if (this.myStrongRef != null) {
                BufferedImage img = this.myStrongRef;
                this.myStrongRef = null;
                return img;
            }
            return (BufferedImage)super.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/intellij/openapi/wm/impl/ToolWindowsPane$ImageRef", "<init>"));
        }
    }

    @FunctionalInterface
    static interface Resizer {
        public void setSize(int var1);

        public static abstract class LayeredPane
        implements Resizer {
            Component myComponent;

            LayeredPane(@NotNull Component component2) {
                if (component2 == null) {
                    LayeredPane.$$$reportNull$$$0(0);
                }
                this.myComponent = component2;
            }

            @Override
            public final void setSize(int size) {
                this._setSize(size);
                if (this.myComponent.getParent() instanceof JComponent) {
                    JComponent parent = (JComponent)this.myComponent;
                    parent.revalidate();
                    parent.repaint();
                }
            }

            abstract void _setSize(int var1);

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$LayeredPane", "<init>"));
            }

            static class Bottom
            extends LayeredPane {
                Bottom(@NotNull Component component2) {
                    if (component2 == null) {
                        Bottom.$$$reportNull$$$0(0);
                    }
                    super(component2);
                }

                @Override
                public void _setSize(int size) {
                    Rectangle bounds2 = this.myComponent.getBounds();
                    int delta = size - bounds2.height;
                    bounds2.y -= delta;
                    bounds2.height += delta;
                    this.myComponent.setBounds(bounds2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$LayeredPane$Bottom", "<init>"));
                }
            }

            static class Top
            extends LayeredPane {
                Top(@NotNull Component component2) {
                    if (component2 == null) {
                        Top.$$$reportNull$$$0(0);
                    }
                    super(component2);
                }

                @Override
                public void _setSize(int size) {
                    this.myComponent.setSize(this.myComponent.getWidth(), size);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$LayeredPane$Top", "<init>"));
                }
            }

            static final class Right
            extends LayeredPane {
                Right(@NotNull Component component2) {
                    if (component2 == null) {
                        Right.$$$reportNull$$$0(0);
                    }
                    super(component2);
                }

                @Override
                public void _setSize(int size) {
                    Rectangle bounds2 = this.myComponent.getBounds();
                    int delta = size - bounds2.width;
                    bounds2.x -= delta;
                    bounds2.width += delta;
                    this.myComponent.setBounds(bounds2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$LayeredPane$Right", "<init>"));
                }
            }

            static final class Left
            extends LayeredPane {
                Left(@NotNull Component component2) {
                    if (component2 == null) {
                        Left.$$$reportNull$$$0(0);
                    }
                    super(component2);
                }

                @Override
                public void _setSize(int size) {
                    this.myComponent.setSize(size, this.myComponent.getHeight());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$LayeredPane$Left", "<init>"));
                }
            }
        }

        public static abstract class Splitter
        implements Resizer {
            ThreeComponentsSplitter mySplitter;

            Splitter(@NotNull ThreeComponentsSplitter splitter) {
                if (splitter == null) {
                    Splitter.$$$reportNull$$$0(0);
                }
                this.mySplitter = splitter;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$Splitter", "<init>"));
            }

            static final class LastComponent
            extends Splitter {
                LastComponent(@NotNull ThreeComponentsSplitter splitter) {
                    if (splitter == null) {
                        LastComponent.$$$reportNull$$$0(0);
                    }
                    super(splitter);
                }

                @Override
                public void setSize(int size) {
                    this.mySplitter.setLastSize(size);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$Splitter$LastComponent", "<init>"));
                }
            }

            static final class FirstComponent
            extends Splitter {
                FirstComponent(@NotNull ThreeComponentsSplitter splitter) {
                    if (splitter == null) {
                        FirstComponent.$$$reportNull$$$0(0);
                    }
                    super(splitter);
                }

                @Override
                public void setSize(int size) {
                    this.mySplitter.setFirstSize(size);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$Splitter$FirstComponent", "<init>"));
                }
            }
        }
    }
}

