/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

final class WatchRootsUtil {
    WatchRootsUtil() {
    }

    static boolean isCoveredRecursively(@NotNull NavigableSet<String> recursiveRoots, @NotNull String path) {
        String recursiveRoot;
        if (recursiveRoots == null) {
            WatchRootsUtil.$$$reportNull$$$0(0);
        }
        if (path == null) {
            WatchRootsUtil.$$$reportNull$$$0(1);
        }
        return (recursiveRoot = recursiveRoots.floor(path)) != null && OSAgnosticPathUtil.startsWith((String)path, (String)recursiveRoot);
    }

    static <T> void collectByPrefix(@NotNull NavigableMap<String, T> paths, @NotNull String prefix, @NotNull Consumer<? super Map.Entry<String, T>> collector) {
        if (paths == null) {
            WatchRootsUtil.$$$reportNull$$$0(2);
        }
        if (prefix == null) {
            WatchRootsUtil.$$$reportNull$$$0(3);
        }
        if (collector == null) {
            WatchRootsUtil.$$$reportNull$$$0(4);
        }
        for (Map.Entry entry : paths.tailMap(prefix, false).entrySet()) {
            if (!OSAgnosticPathUtil.startsWith((String)((String)entry.getKey()), (String)prefix)) break;
            collector.accept(entry);
        }
    }

    static void insertRecursivePath(@NotNull NavigableSet<String> recursiveRoots, @NotNull String path) {
        if (recursiveRoots == null) {
            WatchRootsUtil.$$$reportNull$$$0(5);
        }
        if (path == null) {
            WatchRootsUtil.$$$reportNull$$$0(6);
        }
        if (!WatchRootsUtil.isCoveredRecursively(recursiveRoots, path)) {
            String higher;
            recursiveRoots.add(path);
            while ((higher = recursiveRoots.higher(path)) != null && OSAgnosticPathUtil.startsWith((String)higher, (String)path)) {
                recursiveRoots.remove(higher);
            }
        }
    }

    static void forEachPathSegment(@NotNull String path, char separator, @NotNull Predicate<? super String> consumer2) {
        if (path == null) {
            WatchRootsUtil.$$$reportNull$$$0(7);
        }
        if (consumer2 == null) {
            WatchRootsUtil.$$$reportNull$$$0(8);
        }
        int position = path.indexOf(separator);
        int length = path.length();
        while (position >= 0 && position < length) {
            String subPath = path.substring(0, position);
            if (!consumer2.test(subPath)) {
                return;
            }
            position = path.indexOf(separator, position + 1);
        }
        consumer2.test(path);
    }

    @NotNull
    static NavigableSet<String> optimizeFlatRoots(@NotNull Collection<String> flatRoots, @NotNull NavigableSet<String> recursiveRoots, boolean convertToForwardSlashes) {
        if (flatRoots == null) {
            WatchRootsUtil.$$$reportNull$$$0(9);
        }
        if (recursiveRoots == null) {
            WatchRootsUtil.$$$reportNull$$$0(10);
        }
        NavigableSet<String> result2 = WatchRootsUtil.createFileNavigableSet();
        if (convertToForwardSlashes) {
            for (String flatRoot : flatRoots) {
                if (WatchRootsUtil.isCoveredRecursively(recursiveRoots, flatRoot = flatRoot.replace('/', '\\'))) continue;
                result2.add(flatRoot);
            }
        } else {
            for (String flatRoot : flatRoots) {
                if (WatchRootsUtil.isCoveredRecursively(recursiveRoots, flatRoot)) continue;
                result2.add(flatRoot);
            }
        }
        NavigableSet<String> navigableSet = result2;
        if (navigableSet == null) {
            WatchRootsUtil.$$$reportNull$$$0(11);
        }
        return navigableSet;
    }

    @NotNull
    static NavigableSet<String> createFileNavigableSet() {
        return new TreeSet<String>(OSAgnosticPathUtil.COMPARATOR);
    }

    @NotNull
    static <T> NavigableMap<String, T> createFileNavigableMap() {
        return new TreeMap(OSAgnosticPathUtil.COMPARATOR);
    }

    @NotNull
    static NavigableSet<Pair<String, String>> createMappingsNavigableSet() {
        return new TreeSet<Pair<String, String>>((a, b) -> OSAgnosticPathUtil.COMPARATOR.compare((String)a.first, (String)b.first));
    }

    static boolean removeRecursivePath(@NotNull NavigableSet<String> optimizedRecursiveRoots, @NotNull NavigableMap<String, ?> sourceRecursiveRoots, @NotNull String path) {
        if (optimizedRecursiveRoots == null) {
            WatchRootsUtil.$$$reportNull$$$0(12);
        }
        if (sourceRecursiveRoots == null) {
            WatchRootsUtil.$$$reportNull$$$0(13);
        }
        if (path == null) {
            WatchRootsUtil.$$$reportNull$$$0(14);
        }
        if (!optimizedRecursiveRoots.remove(path)) {
            return false;
        }
        Ref lastPathRef = new Ref();
        WatchRootsUtil.collectByPrefix(sourceRecursiveRoots, path, entry -> {
            String lastPath = (String)lastPathRef.get();
            String childPath = (String)entry.getKey();
            if (lastPath == null || !OSAgnosticPathUtil.startsWith((String)childPath, (String)lastPath)) {
                optimizedRecursiveRoots.add(childPath);
                lastPathRef.set((Object)childPath);
            }
        });
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursiveRoots";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatRoots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/WatchRootsUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimizedRecursiveRoots";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRecursiveRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/WatchRootsUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeFlatRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCoveredRecursively";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectByPrefix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertRecursivePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forEachPathSegment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "optimizeFlatRoots";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeRecursivePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

