/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.encoding.IncompatibleEncodingDialog;
import com.intellij.util.Function;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeFileEncodingAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    private final boolean allowDirectories;

    public ChangeFileEncodingAction() {
        this(false);
    }

    public ChangeFileEncodingAction(boolean allowDirectories) {
        this.allowDirectories = allowDirectories;
    }

    private boolean checkEnabled(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(0);
        }
        if (this.allowDirectories && virtualFile.isDirectory()) {
            return true;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (document == null) {
            return false;
        }
        return EncodingUtil.checkCanConvert(virtualFile) == null || EncodingUtil.checkCanReload(virtualFile, null) == null;
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile myFile;
        if (e == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(1);
        }
        boolean enabled = (myFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null && this.checkEnabled(myFile);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(myFile != null);
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext;
        ListPopup popup2;
        if (e == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(2);
        }
        if ((popup2 = this.createPopup(dataContext = e.getDataContext())) != null) {
            popup2.showInBestPositionFor(dataContext);
        }
    }

    @Nullable
    public ListPopup createPopup(@NotNull DataContext dataContext) {
        byte[] bytes;
        VirtualFile virtualFile;
        if (dataContext == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(3);
        }
        if ((virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) == null) {
            return null;
        }
        boolean enabled = this.checkEnabled(virtualFile);
        if (!enabled) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (!this.allowDirectories && virtualFile.isDirectory() || document == null && !virtualFile.isDirectory()) {
            return null;
        }
        try {
            bytes = virtualFile.isDirectory() ? null : VfsUtilCore.loadBytes((VirtualFile)virtualFile);
        }
        catch (IOException e) {
            return null;
        }
        DefaultActionGroup group2 = this.createActionGroup(virtualFile, editor, document, bytes, null);
        return JBPopupFactory.getInstance().createActionGroupPopup(this.getTemplatePresentation().getText(), (ActionGroup)group2, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    @NotNull
    public DefaultActionGroup createActionGroup(@Nullable VirtualFile myFile, final Editor editor, final Document document, final byte[] bytes, final @Nullable @NlsActions.ActionText String clearItemText) {
        DefaultActionGroup defaultActionGroup = new ChooseFileEncodingAction(myFile){

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
                DefaultActionGroup defaultActionGroup = this.createCharsetsActionGroup(clearItemText, null, (Function<? super Charset, String>)((Function)charset -> IdeBundle.message((String)"action.text.change.encoding", (Object[])new Object[]{charset.displayName()})));
                if (defaultActionGroup == null) {
                    1.$$$reportNull$$$0(1);
                }
                return defaultActionGroup;
            }

            @Override
            protected void chosen(@Nullable VirtualFile virtualFile, @NotNull Charset charset) {
                if (charset == null) {
                    1.$$$reportNull$$$0(2);
                }
                ChangeFileEncodingAction.this.chosen(document, editor, virtualFile, bytes, charset);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "charset";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPopupActionGroup";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "chosen";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.createPopupActionGroup(null);
        if (defaultActionGroup == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(4);
        }
        return defaultActionGroup;
    }

    protected boolean chosen(Document document, Editor editor, @Nullable VirtualFile virtualFile, byte[] bytes, @NotNull Charset charset) {
        Project project;
        if (charset == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            return false;
        }
        String text2 = document.getText();
        EncodingUtil.Magic8 isSafeToConvert = EncodingUtil.isSafeToConvertTo(virtualFile, text2, bytes, charset);
        EncodingUtil.Magic8 isSafeToReload = EncodingUtil.isSafeToReloadIn(virtualFile, text2, bytes, charset);
        Project project2 = project = editor == null ? null : editor.getProject();
        if (project == null) {
            project = ProjectLocator.getInstance().guessProjectForFile(virtualFile);
        }
        return ChangeFileEncodingAction.changeTo(Objects.requireNonNull(project), document, editor, virtualFile, charset, isSafeToConvert, isSafeToReload);
    }

    public static boolean changeTo(final @NotNull Project project, @NotNull Document document, Editor editor, @NotNull VirtualFile virtualFile, @NotNull Charset charset, @NotNull EncodingUtil.Magic8 isSafeToConvert, @NotNull EncodingUtil.Magic8 isSafeToReload) {
        Runnable redo;
        Runnable undo;
        if (project == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(6);
        }
        if (document == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(8);
        }
        if (charset == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(9);
        }
        if (isSafeToConvert == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(10);
        }
        if (isSafeToReload == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(11);
        }
        Charset oldCharset = virtualFile.getCharset();
        if (isSafeToConvert == EncodingUtil.Magic8.ABSOLUTELY && isSafeToReload == EncodingUtil.Magic8.ABSOLUTELY) {
            EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)project);
            undo = () -> ChangeFileEncodingAction.lambda$changeTo$0((EncodingManager)encodingManager, virtualFile, oldCharset);
            redo = () -> ChangeFileEncodingAction.lambda$changeTo$1((EncodingManager)encodingManager, virtualFile, charset);
        } else {
            IncompatibleEncodingDialog dialog2 = new IncompatibleEncodingDialog(virtualFile, charset, isSafeToReload, isSafeToConvert);
            dialog2.show();
            if (dialog2.getExitCode() == 10) {
                undo = () -> EncodingUtil.reloadIn(virtualFile, oldCharset, project);
                redo = () -> EncodingUtil.reloadIn(virtualFile, charset, project);
            } else if (dialog2.getExitCode() == 20) {
                undo = () -> EncodingUtil.saveIn(project, document, editor, virtualFile, oldCharset);
                redo = () -> EncodingUtil.saveIn(project, document, editor, virtualFile, charset);
            } else {
                return false;
            }
        }
        GlobalUndoableAction action2 = new GlobalUndoableAction(new VirtualFile[]{virtualFile}){

            public void undo() {
                Application application = ApplicationManager.getApplication();
                application.invokeLater(undo, ModalityState.NON_MODAL, project.getDisposed());
            }

            public void redo() {
                Application application = ApplicationManager.getApplication();
                application.invokeLater(redo, ModalityState.NON_MODAL, project.getDisposed());
            }
        };
        redo.run();
        CommandProcessor.getInstance().executeCommand(project, () -> ChangeFileEncodingAction.lambda$changeTo$6(project, (UndoableAction)action2), IdeBundle.message((String)"change.encoding.command.name", (Object[])new Object[]{virtualFile.getName()}), null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        return true;
    }

    private static /* synthetic */ void lambda$changeTo$6(Project project, UndoableAction action2) {
        UndoManager undoManager = UndoManager.getInstance((Project)project);
        undoManager.undoableActionPerformed(action2);
    }

    private static /* synthetic */ void lambda$changeTo$1(EncodingManager encodingManager, VirtualFile virtualFile, Charset charset) {
        encodingManager.setEncoding(virtualFile, charset);
    }

    private static /* synthetic */ void lambda$changeTo$0(EncodingManager encodingManager, VirtualFile virtualFile, Charset oldCharset) {
        encodingManager.setEncoding(virtualFile, oldCharset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isSafeToConvert";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isSafeToReload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "chosen";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "changeTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

