/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.FragmentedEditorHighlighter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusMarkerPopupPanel
extends JPanel {
    @Nullable
    private final JComponent myEditorComponent;
    @NotNull
    private final Editor myEditor;

    private LineStatusMarkerPopupPanel(final @NotNull Editor editor, @NotNull ActionToolbar toolbar, @Nullable JComponent editorComponent, @Nullable JComponent additionalInfo) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(0);
        }
        if (toolbar == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.setOpaque(false);
        this.myEditor = editor;
        this.myEditorComponent = editorComponent;
        boolean isEditorVisible = this.myEditorComponent != null;
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setBorder(null);
        BorderLayoutPanel toolbarPanel = JBUI.Panels.simplePanel((Component)toolbarComponent);
        Border outsideToolbarBorder = JBUI.Borders.customLine((Color)LineStatusMarkerPopupPanel.getBorderColor(), (int)1, (int)1, (int)(isEditorVisible ? 0 : 1), (int)1);
        JBEmptyBorder insideToolbarBorder = JBUI.Borders.empty((int)1, (int)5);
        toolbarPanel.setBorder(BorderFactory.createCompoundBorder(outsideToolbarBorder, (Border)insideToolbarBorder));
        if (additionalInfo != null) {
            toolbarPanel.add((Component)additionalInfo, "East");
        }
        JPanel emptyPanel = new JPanel();
        emptyPanel.setOpaque(false);
        emptyPanel.setPreferredSize(new Dimension());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setOpaque(false);
        topPanel.add((Component)toolbarPanel, "West");
        topPanel.add((Component)emptyPanel, "Center");
        this.add((Component)topPanel, "North");
        if (this.myEditorComponent != null) {
            this.add((Component)this.myEditorComponent, "Center");
        }
        MouseAdapter listener2 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LineStatusMarkerPopupPanel.transferEvent(e, editor);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                LineStatusMarkerPopupPanel.transferEvent(e, editor);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                LineStatusMarkerPopupPanel.transferEvent(e, editor);
            }
        };
        emptyPanel.addMouseListener(listener2);
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(2);
        }
        return editor;
    }

    private static void transferEvent(MouseEvent e, Editor editor) {
        editor.getContentComponent().dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, editor.getContentComponent()));
    }

    int getEditorTextOffset() {
        return EditorFragmentComponent.createEditorFragmentBorder((Editor)this.myEditor).getBorderInsets((Component)this.myEditorComponent).left;
    }

    @Override
    public Dimension getPreferredSize() {
        int gap = JBUI.scale((int)10);
        Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Component)this.myEditor.getComponent());
        Rectangle maxSize2 = new Rectangle(screenRectangle.width - gap, screenRectangle.height - gap);
        Dimension size = super.getPreferredSize();
        if (size.width > maxSize2.width) {
            size.width = maxSize2.width;
            size.height += JBUI.scale((int)20);
        }
        if (size.height > maxSize2.height) {
            size.height = maxSize2.height;
        }
        return size;
    }

    public static void showPopupAt(@NotNull Editor editor, @NotNull ActionToolbar toolbar, @Nullable JComponent editorComponent, @Nullable JComponent additionalInfoPanel, @Nullable Point mousePosition, @NotNull Disposable childDisposable, @Nullable DataProvider dataProvider) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(3);
        }
        if (toolbar == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(4);
        }
        if (childDisposable == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(5);
        }
        LineStatusMarkerPopupPanel popupPanel = new LineStatusMarkerPopupPanel(editor, toolbar, editorComponent, additionalInfoPanel);
        if (dataProvider != null) {
            DataManager.registerDataProvider((JComponent)popupPanel, (DataProvider)dataProvider);
        }
        toolbar.setTargetComponent((JComponent)popupPanel);
        toolbar.updateActionsImmediately();
        LightweightHint hint = new LightweightHint(popupPanel);
        HintListener closeListener = __ -> Disposer.dispose((Disposable)childDisposable);
        hint.addHintListener(closeListener);
        int line = editor.getCaretModel().getLogicalPosition().line;
        Point point = HintManagerImpl.getHintPosition(hint, editor, new LogicalPosition(line, 0), (short)2);
        if (mousePosition != null) {
            int lineHeight = editor.getLineHeight();
            int delta = (point.y - mousePosition.y) % lineHeight;
            if (delta < 0) {
                delta += lineHeight;
            }
            point.y = mousePosition.y + delta;
        }
        point.x -= popupPanel.getEditorTextOffset();
        int flags = 1064;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point, flags, -1, false, new HintHint(editor, point));
        ApplicationManager.getApplication().getMessageBus().connect(childDisposable).subscribe(EditorHintListener.TOPIC, (project, newHint, newHintFlags) -> {
            LineStatusMarkerPopupPanel newPopupPanel;
            if (newHint.getComponent() instanceof LineStatusMarkerPopupPanel && (newPopupPanel = (LineStatusMarkerPopupPanel)newHint.getComponent()).getEditor().equals(editor)) {
                hint.hide();
            }
        });
        if (!hint.isVisible()) {
            closeListener.hintHidden(new EventObject(hint));
        }
    }

    @NotNull
    public static EditorTextField createTextField(@NotNull Editor editor, @NotNull String content2) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(6);
        }
        if (content2 == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(7);
        }
        EditorTextField field = new EditorTextField(content2);
        field.setBorder(null);
        field.setOneLineMode(false);
        field.ensureWillComputePreferredSize();
        field.setFontInheritedFromLAF(false);
        field.addSettingsProvider(uEditor -> {
            uEditor.setVerticalScrollbarVisible(true);
            uEditor.setHorizontalScrollbarVisible(true);
            uEditor.setRendererMode(true);
            uEditor.setBorder(null);
            uEditor.setColorsScheme(editor.getColorsScheme());
            uEditor.setBackgroundColor(LineStatusMarkerPopupPanel.getEditorBackgroundColor(editor));
            uEditor.getSettings().setCaretRowShown(false);
            uEditor.getSettings().setTabSize(editor.getSettings().getTabSize(editor.getProject()));
            uEditor.getSettings().setUseTabCharacter(editor.getSettings().isUseTabCharacter(editor.getProject()));
        });
        DataManager.registerDataProvider((JComponent)((Object)field), data2 -> {
            if (CommonDataKeys.HOST_EDITOR.is(data2)) {
                return field.getEditor();
            }
            return null;
        });
        EditorTextField editorTextField = field;
        if (editorTextField == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(8);
        }
        return editorTextField;
    }

    @NotNull
    public static JComponent createEditorComponent(@NotNull Editor editor, @NotNull EditorTextField textField2) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(9);
        }
        if (textField2 == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(10);
        }
        BorderLayoutPanel editorComponent = JBUI.Panels.simplePanel((Component)((Object)textField2));
        editorComponent.setBorder(LineStatusMarkerPopupPanel.createEditorFragmentBorder());
        editorComponent.setBackground(LineStatusMarkerPopupPanel.getEditorBackgroundColor(editor));
        BorderLayoutPanel borderLayoutPanel = editorComponent;
        if (borderLayoutPanel == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(11);
        }
        return borderLayoutPanel;
    }

    @NotNull
    public static Border createEditorFragmentBorder() {
        Border outsideEditorBorder = JBUI.Borders.customLine((Color)LineStatusMarkerPopupPanel.getBorderColor(), (int)1);
        Border insideEditorBorder = JBUI.Borders.empty((int)2);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outsideEditorBorder, insideEditorBorder);
        if (compoundBorder == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(12);
        }
        return compoundBorder;
    }

    public static Color getEditorBackgroundColor(@NotNull Editor editor) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(13);
        }
        return EditorFragmentComponent.getBackgroundColor(editor, true);
    }

    @NotNull
    public static Color getBorderColor() {
        return new JBColor((Color)Gray._206, (Color)Gray._75);
    }

    @NotNull
    public static ActionToolbar buildToolbar(@NotNull Editor editor, @NotNull List<AnAction> actions, @NotNull Disposable parentDisposable) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(14);
        }
        if (actions == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(15);
        }
        if (parentDisposable == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(16);
        }
        JComponent editorComponent = editor.getComponent();
        for (AnAction action2 : actions) {
            DiffUtil.registerAction(action2, editorComponent);
        }
        Disposer.register((Disposable)parentDisposable, () -> ActionUtil.getActions((JComponent)editorComponent).removeAll(actions));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(actions), true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(17);
        }
        return actionToolbar;
    }

    public static void installBaseEditorSyntaxHighlighters(@Nullable Project project, @NotNull EditorTextField textField2, @NotNull Document vcsDocument, TextRange vcsTextRange, @NotNull FileType fileType) {
        if (textField2 == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(18);
        }
        if (vcsDocument == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(19);
        }
        if (fileType == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(20);
        }
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, fileType);
        highlighter.setText(vcsDocument.getImmutableCharSequence());
        FragmentedEditorHighlighter fragmentedHighlighter = new FragmentedEditorHighlighter(highlighter, vcsTextRange);
        textField2.addSettingsProvider(uEditor -> uEditor.setHighlighter((EditorHighlighter)fragmentedHighlighter));
    }

    public static void installPopupEditorWordHighlighters(@NotNull EditorTextField textField2, @Nullable List<? extends DiffFragment> wordDiff) {
        if (textField2 == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(21);
        }
        if (wordDiff == null) {
            return;
        }
        textField2.addSettingsProvider(uEditor -> {
            for (DiffFragment fragment : wordDiff) {
                int vcsStart = fragment.getStartOffset1();
                int vcsEnd = fragment.getEndOffset1();
                TextDiffType type = DiffUtil.getDiffType(fragment);
                DiffDrawUtil.createInlineHighlighter(uEditor, vcsStart, vcsEnd, type);
            }
        });
    }

    public static void installMasterEditorWordHighlighters(@NotNull Editor editor, int currentStartOffset, @NotNull List<? extends DiffFragment> wordDiff, @NotNull Disposable parentDisposable) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(22);
        }
        if (wordDiff == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(23);
        }
        if (parentDisposable == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(24);
        }
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        for (DiffFragment diffFragment : wordDiff) {
            int currentStart = currentStartOffset + diffFragment.getStartOffset2();
            int currentEnd = currentStartOffset + diffFragment.getEndOffset2();
            TextDiffType type = DiffUtil.getDiffType(diffFragment);
            highlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, currentStart, currentEnd, type));
        }
        Disposer.register((Disposable)parentDisposable, () -> highlighters.forEach(RangeMarker::dispose));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childDisposable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDocument";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wordDiff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextField";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorFragmentBorder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "buildToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 17: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showPopupAt";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTextField";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEditorComponent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEditorBackgroundColor";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildToolbar";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "installBaseEditorSyntaxHighlighters";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "installPopupEditorWordHighlighters";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "installMasterEditorWordHighlighters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

