/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateResult;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JComponent;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0002J(\u0010\u001f\u001a\u00020 2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0007J\u001e\u0010%\u001a\u00020$2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J#\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070'2\u0006\u0010(\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010)J)\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070'2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010+R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006,"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateInstaller;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PATCH_FILE_NAME", "", "UPDATER_ENTRY", "UPDATER_MAIN_CLASS", "patchesUrl", "Ljava/net/URL;", "getPatchesUrl", "()Ljava/net/URL;", "cleanupPatch", "", "downloadPatchChain", "", "Ljava/io/File;", "chain", "Lcom/intellij/openapi/util/BuildNumber;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadPluginUpdates", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "downloaders", "", "findLib", "libName", "getJdkSuffix", "getTempDir", "installDownloadedPluginUpdates", "Lcom/intellij/openapi/updateSettings/impl/PluginUpdateResult;", "ownerComponent", "Ljavax/swing/JComponent;", "allowInstallWithoutRestart", "", "installPluginUpdates", "preparePatchCommand", "", "patchFile", "(Ljava/io/File;Lcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "patchFiles", "(Ljava/util/List;Lcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "intellij.platform.ide.impl"})
public final class UpdateInstaller {
    @NotNull
    public static final String UPDATER_MAIN_CLASS = "com.intellij.updater.Runner";
    private static final Logger LOG;
    private static final String PATCH_FILE_NAME = "patch-file.zip";
    private static final String UPDATER_ENTRY = "com/intellij/updater/Runner.class";
    public static final UpdateInstaller INSTANCE;

    private final URL getPatchesUrl() {
        String string = System.getProperty("idea.patches.url");
        if (string == null) {
            ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
            ApplicationInfoEx.UpdateUrls updateUrls = applicationInfoEx.getUpdateUrls();
            Intrinsics.checkNotNull((Object)updateUrls);
            Intrinsics.checkNotNullExpressionValue((Object)updateUrls, (String)"ApplicationInfoEx.getInstanceEx().updateUrls!!");
            string = updateUrls.getPatchesUrl();
        }
        return new URL(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<File> downloadPatchChain(@NotNull List<BuildNumber> chain, @NotNull ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.setText(IdeBundle.message((String)"update.downloading.patch.progress", (Object[])new Object[0]));
        boolean bl = false;
        List files2 = new ArrayList();
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        String string = buildNumber.getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationInfo.getInstance().build.productCode");
        String product = string;
        String jdk = INSTANCE.getJdkSuffix();
        double share = 1.0 / (double)(chain.size() - 1);
        int n = 1;
        int n2 = chain.size();
        while (n < n2) {
            boolean bl2;
            Object object;
            String url;
            String to;
            String from;
            void i2;
            Intrinsics.checkNotNullExpressionValue((Object)chain.get((int)(i2 - true)).withoutProductCode().asString(), (String)"chain[i - 1].withoutProductCode().asString()");
            Intrinsics.checkNotNullExpressionValue((Object)chain.get((int)i2).withoutProductCode().asString(), (String)"chain[i].withoutProductCode().asString()");
            String patchName = product + '-' + from + '-' + to + "-patch" + jdk + '-' + PatchInfo.Companion.getOS_SUFFIX() + ".jar";
            File patchFile = new File(INSTANCE.getTempDir(), patchName);
            Intrinsics.checkNotNullExpressionValue((Object)new URL(INSTANCE.getPatchesUrl(), patchName).toString(), (String)"URL(patchesUrl, patchName).toString()");
            DelegatingProgressIndicator partIndicator2 = new DelegatingProgressIndicator((int)i2, share, indicator, indicator){
                final /* synthetic */ int $i;
                final /* synthetic */ double $share;
                final /* synthetic */ ProgressIndicator $indicator;

                public void setFraction(double fraction) {
                    super.setFraction((double)(this.$i - 1) * this.$share + fraction / this.$share);
                }
                {
                    this.$i = $captured_local_variable$0;
                    this.$share = $captured_local_variable$1;
                    this.$indicator = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            };
            LOG.info("downloading " + url);
            HttpRequests.request((String)url).gzip(false).saveToFile(patchFile, (ProgressIndicator)partIndicator2);
            try {
                object = new ZipFile(patchFile);
                bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    ZipFile it = (ZipFile)object;
                    boolean bl4 = false;
                    if (it.getEntry(PATCH_FILE_NAME) == null || it.getEntry(UPDATER_ENTRY) == null) {
                        throw (Throwable)new IOException("Corrupted patch file: " + patchFile.getName());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (ZipException e) {
                throw (Throwable)new IOException("Corrupted patch file: " + patchFile.getName(), e);
            }
            object = files2;
            bl2 = false;
            object.add(patchFile);
            ++i2;
        }
        return files2;
    }

    @JvmStatic
    @NotNull
    public static final List<PluginDownloader> downloadPluginUpdates(@NotNull Collection<PluginDownloader> downloaders, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter(downloaders, (String)"downloaders");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.setText(IdeBundle.message((String)"update.downloading.plugins.progress", (Object[])new Object[0]));
        UpdateChecker.saveDisabledToUpdatePlugins();
        Set<PluginId> disabledToUpdate = UpdateChecker.getDisabledToUpdate();
        boolean bl = false;
        List readyToInstall = new ArrayList();
        for (PluginDownloader downloader : downloaders) {
            try {
                if (!disabledToUpdate.contains(downloader.getId()) && downloader.prepareToInstall(indicator)) {
                    Collection collection = readyToInstall;
                    boolean bl2 = false;
                    collection.add(downloader);
                }
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Exception e) {
                Logger.getInstance(UpdateChecker.class).info((Throwable)e);
            }
        }
        return readyToInstall;
    }

    @JvmStatic
    @NotNull
    public static final PluginUpdateResult installDownloadedPluginUpdates(@NotNull Collection<PluginDownloader> downloaders, @Nullable JComponent ownerComponent, boolean allowInstallWithoutRestart) {
        Intrinsics.checkNotNullParameter(downloaders, (String)"downloaders");
        boolean bl = false;
        List pluginsInstalled = new ArrayList();
        boolean restartRequired = false;
        for (PluginDownloader downloader : downloaders) {
            try {
                if (!allowInstallWithoutRestart || !downloader.tryInstallWithoutRestart(ownerComponent)) {
                    downloader.install();
                    restartRequired = true;
                }
                IdeaPluginDescriptor ideaPluginDescriptor = downloader.getDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"downloader.descriptor");
                pluginsInstalled.add(ideaPluginDescriptor);
            }
            catch (Exception e) {
                Logger.getInstance(UpdateChecker.class).info((Throwable)e);
            }
        }
        return new PluginUpdateResult(pluginsInstalled, restartRequired);
    }

    @JvmStatic
    public static final boolean installPluginUpdates(@NotNull Collection<PluginDownloader> downloaders, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter(downloaders, (String)"downloaders");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        List<PluginDownloader> downloadedPluginUpdates = UpdateInstaller.downloadPluginUpdates(downloaders, indicator);
        PluginUpdateResult result2 = (PluginUpdateResult)ProgressManager.getInstance().computeInNonCancelableSection((ThrowableComputable)new ThrowableComputable<PluginUpdateResult, RuntimeException>(downloadedPluginUpdates){
            final /* synthetic */ List $downloadedPluginUpdates;

            public final PluginUpdateResult compute() {
                return UpdateInstaller.installDownloadedPluginUpdates(this.$downloadedPluginUpdates, null, false);
            }
            {
                this.$downloadedPluginUpdates = list2;
            }
        });
        Collection collection = result2.getPluginsInstalled();
        boolean bl = false;
        return !collection.isEmpty();
    }

    @JvmStatic
    public static final void cleanupPatch() {
        File tempDir = INSTANCE.getTempDir();
        if (tempDir.exists()) {
            FileUtil.delete((File)tempDir);
        }
    }

    @JvmStatic
    @NotNull
    public static final String[] preparePatchCommand(@NotNull File patchFile, @NotNull ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)patchFile, (String)"patchFile");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return UpdateInstaller.preparePatchCommand(CollectionsKt.listOf((Object)patchFile), indicator);
    }

    @JvmStatic
    @NotNull
    public static final String[] preparePatchCommand(@NotNull List<? extends File> patchFiles, @NotNull ProgressIndicator indicator) throws IOException {
        Number number;
        Object elevator;
        Path idePath;
        Intrinsics.checkNotNullParameter(patchFiles, (String)"patchFiles");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.setText(IdeBundle.message((String)"update.preparing.patch.progress", (Object[])new Object[0]));
        File log4j = INSTANCE.findLib("log4j.jar");
        File jna = INSTANCE.findLib("jna.jar");
        File jnaUtils = INSTANCE.findLib("jna-platform.jar");
        File tempDir = INSTANCE.getTempDir();
        if (FileUtil.isAncestor((String)PathManager.getHomePath(), (String)tempDir.getPath(), (boolean)true)) {
            throw (Throwable)new IOException("Temp directory inside installation: " + tempDir);
        }
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw (Throwable)new IOException("Cannot create temp directory: " + tempDir);
        }
        File log4jCopy = FilesKt.copyTo$default((File)log4j, (File)new File(tempDir, log4j.getName()), (boolean)true, (int)0, (int)4, null);
        File jnaCopy = FilesKt.copyTo$default((File)jna, (File)new File(tempDir, jna.getName()), (boolean)true, (int)0, (int)4, null);
        File jnaUtilsCopy = FilesKt.copyTo$default((File)jnaUtils, (File)new File(tempDir, jnaUtils.getName()), (boolean)true, (int)0, (int)4, null);
        String java = System.getProperty("java.home");
        Path jrePath = Paths.get(java, new String[0]);
        if (jrePath.startsWith(idePath = Paths.get(PathManager.getHomePath(), new String[0]).toRealPath(new LinkOption[0]))) {
            File javaCopy = new File(tempDir, "jre");
            if (javaCopy.exists()) {
                FileUtil.delete((File)javaCopy);
            }
            FileUtil.copyDir((File)new File(java), (File)javaCopy);
            File jnf = new File(java, "../Frameworks/JavaNativeFoundation.framework");
            if (jnf.isDirectory()) {
                File jnfCopy = new File(tempDir, "Frameworks/JavaNativeFoundation.framework");
                if (jnfCopy.exists()) {
                    FileUtil.delete((File)jnfCopy);
                }
                FileUtil.copyDir((File)jnf, (File)jnfCopy);
            }
            java = javaCopy.getPath();
        }
        boolean jnf = false;
        List args = new ArrayList();
        if (SystemInfo.isWindows && !Files.isWritable(Paths.get(PathManager.getHomePath(), new String[0]))) {
            Path launcher = PathManager.findBinFile((String)"launcher.exe");
            elevator = PathManager.findBinFile((String)"elevator.exe");
            if (launcher != null && elevator != null && Files.isExecutable(launcher) && Files.isExecutable((Path)elevator)) {
                Path path = tempDir.toPath().resolve(launcher.getFileName());
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempDir.toPath().resolve(launcher.fileName)");
                args.add(((Object)PathKt.copy((Path)launcher, (Path)path)).toString());
                Path path2 = tempDir.toPath().resolve(elevator.getFileName());
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"tempDir.toPath().resolve(elevator.fileName)");
                PathKt.copy((Path)elevator, (Path)path2);
            }
        }
        String string = System.getProperty("idea.updater.heap");
        if (string != null) {
            elevator = string;
            boolean bl = false;
            number = Integer.parseInt((String)elevator);
        } else {
            number = SystemInfo.is32Bit ? Runtime.getRuntime().maxMemory() >> 20 : 2000L;
        }
        Number mx = number;
        elevator = args;
        String string2 = new File(java, SystemInfo.isWindows ? "bin\\java.exe" : "bin/java").getPath();
        boolean bl = false;
        elevator.add(string2);
        elevator = args;
        string2 = "-Xmx" + mx + 'm';
        bl = false;
        elevator.add(string2);
        elevator = args;
        string2 = "-cp";
        bl = false;
        elevator.add(string2);
        elevator = args;
        Object[] objectArray = new String[]{((File)CollectionsKt.last(patchFiles)).getPath(), log4jCopy.getPath(), jnaCopy.getPath(), jnaUtilsCopy.getPath()};
        String string3 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"File.pathSeparator");
        string2 = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null);
        bl = false;
        elevator.add(string2);
        elevator = args;
        string2 = "-Djna.nosys=true";
        bl = false;
        elevator.add(string2);
        elevator = args;
        string2 = "-Djna.boot.library.path=";
        bl = false;
        elevator.add(string2);
        elevator = args;
        string2 = "-Djna.debug_load=true";
        bl = false;
        elevator.add(string2);
        elevator = args;
        string2 = "-Djna.debug_load.jna=true";
        bl = false;
        elevator.add(string2);
        elevator = args;
        string2 = "-Djava.io.tmpdir=" + tempDir.getPath();
        bl = false;
        elevator.add(string2);
        elevator = args;
        string2 = "-Didea.updater.log=" + PathManager.getLogPath();
        bl = false;
        elevator.add(string2);
        elevator = args;
        string2 = "-Dswing.defaultlaf=" + UIManager.getSystemLookAndFeelClassName();
        bl = false;
        elevator.add(string2);
        elevator = args;
        string2 = UPDATER_MAIN_CLASS;
        bl = false;
        elevator.add(string2);
        elevator = args;
        string2 = patchFiles.size() == 1 ? "install" : "batch-install";
        bl = false;
        elevator.add(string2);
        elevator = args;
        string2 = PathManager.getHomePath();
        bl = false;
        elevator.add(string2);
        if (patchFiles.size() > 1) {
            elevator = args;
            Iterable iterable = patchFiles;
            String string4 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"File.pathSeparator");
            string2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string4, null, null, (int)0, null, null, (int)62, null);
            bl = false;
            elevator.add(string2);
        }
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    private final File findLib(String libName) {
        File libFile = new File(PathManager.getLibPath(), libName);
        if (!libFile.exists()) {
            throw (Throwable)new IOException("Missing: " + libFile);
        }
        return libFile;
    }

    private final File getTempDir() {
        return new File(PathManager.getTempPath(), "patch-update");
    }

    private final String getJdkSuffix() {
        return SystemInfo.isMac && SystemInfo.isArm64 ? "-jbr11-aarch64" : (!SystemInfo.isMac && Files.isDirectory(Paths.get(PathManager.getHomePath(), "jbr-x86"), new LinkOption[0]) ? "-jbr11-x86" : (Files.isDirectory(Paths.get(PathManager.getHomePath(), "jbr"), new LinkOption[0]) ? "-jbr11" : "-no-jbr"));
    }

    private UpdateInstaller() {
    }

    static {
        UpdateInstaller updateInstaller;
        INSTANCE = updateInstaller = new UpdateInstaller();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UpdateInstaller.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

