/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPackageType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkProduct;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkListParser;", "", "()V", "parseJdkItem", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "item", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "filters", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate;", "parseJdkList", "", "tree", "readTree", "rawData", "", "intellij.platform.lang.impl"})
public final class JdkListParser {
    public static final JdkListParser INSTANCE;

    @NotNull
    public final ObjectNode readTree(@NotNull byte[] rawData) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        JsonNode jsonNode = new ObjectMapper().readTree(rawData);
        if (!(jsonNode instanceof ObjectNode)) {
            jsonNode = null;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        if (objectNode == null) {
            String string = "Unexpected JSON data";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return objectNode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JdkItem> parseJdkList(@NotNull ObjectNode tree, @NotNull JdkPredicate filters) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        JsonNode jsonNode = tree.get("jdks");
        if (!(jsonNode instanceof ArrayNode)) {
            jsonNode = null;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        if (arrayNode == null) {
            String string = "`jdks` element is missing";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ArrayNode items = arrayNode;
        boolean bl = false;
        List result2 = new ArrayList();
        Iterable $this$filterIsInstance$iv = (Iterable)items;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ObjectNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ObjectNode item : (List)destination$iv$iv) {
            JdkItem jdkItem;
            Collection collection = result2;
            if (this.parseJdkItem(item, filters) == null) {
                continue;
            }
            boolean bl2 = false;
            collection.add(jdkItem);
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JdkItem parseJdkItem(@NotNull ObjectNode item, @NotNull JdkPredicate filters) {
        List list2;
        Object object;
        JdkPackageType jdkPackageType;
        int n;
        Object object2;
        String string;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        String string2;
        Object object8;
        int n2;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        JdkProduct jdkProduct;
        JdkProduct jdkProduct2;
        byte[] contents;
        ObjectNode pkg;
        Object $this$filterIsInstanceTo$iv$iv;
        block33: {
            block32: {
                void p1;
                Object v2;
                block31: {
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
                    if (!filters.testJdkProduct(item)) {
                        return null;
                    }
                    JsonNode jsonNode = item.get("packages");
                    if (!(jsonNode instanceof ArrayNode)) {
                        jsonNode = null;
                    }
                    ArrayNode arrayNode = (ArrayNode)jsonNode;
                    if (arrayNode == null) {
                        return null;
                    }
                    ArrayNode packages = arrayNode;
                    Iterable $this$filterIsInstance$iv = (Iterable)packages;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof ObjectNode)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ObjectNode p12 = (ObjectNode)element$iv;
                        boolean bl5 = false;
                        if (!filters.testJdkPackage(p12)) continue;
                        v2 = element$iv;
                        break block31;
                    }
                    v2 = null;
                }
                ObjectNode objectNode = v2;
                if (objectNode == null) {
                    return null;
                }
                pkg = objectNode;
                Object object9 = item.get("vendor");
                if (object9 == null || (object9 = object9.asText()) == null) {
                    return null;
                }
                JsonNode jsonNode = item.get("product");
                JsonNode jsonNode2 = item.get("flavour");
                JdkProduct product = new JdkProduct((String)object9, jsonNode != null ? jsonNode.asText() : null, jsonNode2 != null ? jsonNode2.asText() : null);
                contents = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)item);
                jdkProduct2 = product;
                JsonNode jsonNode3 = item.get("default");
                if (jsonNode3 != null) {
                    void it;
                    $this$filterIsInstanceTo$iv$iv = jsonNode3;
                    boolean element$iv = false;
                    boolean p12 = false;
                    JsonNode bl5 = $this$filterIsInstanceTo$iv$iv;
                    jdkProduct = jdkProduct2;
                    boolean bl6 = false;
                    bl4 = Intrinsics.areEqual((Object)filters.testPredicate((JsonNode)it), (Object)true);
                    jdkProduct2 = jdkProduct;
                    bl3 = bl4;
                } else {
                    bl3 = false;
                }
                JsonNode jsonNode4 = item.get("listed");
                if (jsonNode4 != null) {
                    $this$filterIsInstanceTo$iv$iv = jsonNode4;
                    boolean element$iv = false;
                    boolean p12 = false;
                    JsonNode it = $this$filterIsInstanceTo$iv$iv;
                    bl4 = bl3;
                    jdkProduct = jdkProduct2;
                    boolean bl7 = false;
                    bl2 = Intrinsics.areEqual((Object)filters.testPredicate(it), (Object)true);
                    jdkProduct2 = jdkProduct;
                    bl3 = bl4;
                    bl = bl2;
                } else {
                    bl = true;
                }
                JsonNode jsonNode5 = item.get("jdk_version_major");
                if (jsonNode5 == null) {
                    return null;
                }
                n2 = jsonNode5.asInt();
                object8 = item.get("jdk_version");
                if (object8 == null || (object8 = object8.asText()) == null) {
                    return null;
                }
                JsonNode jsonNode6 = item.get("jdk_vendor_version");
                string2 = jsonNode6 != null ? jsonNode6.asText() : null;
                object7 = item.get("suggested_sdk_name");
                if (object7 == null || (object7 = object7.asText()) == null) {
                    return null;
                }
                object6 = pkg.get("arch");
                if (object6 == null || (object6 = object6.asText()) == null) {
                    return null;
                }
                object5 = pkg.get("package_type");
                if (object5 == null || (object5 = object5.asText()) == null) break block32;
                $this$filterIsInstanceTo$iv$iv = object5;
                JdkPackageType.Companion element$iv = JdkPackageType.Companion;
                boolean p12 = false;
                boolean it = false;
                JsonNode bl7 = $this$filterIsInstanceTo$iv$iv;
                object4 = object6;
                object3 = object7;
                string = string2;
                object2 = object8;
                n = n2;
                bl2 = bl;
                bl4 = bl3;
                jdkProduct = jdkProduct2;
                boolean bl8 = false;
                jdkPackageType = element$iv.findType((String)p1);
                jdkProduct2 = jdkProduct;
                bl3 = bl4;
                bl = bl2;
                n2 = n;
                object8 = object2;
                string2 = string;
                object7 = object3;
                object6 = object4;
                object5 = jdkPackageType;
                if (object5 != null) break block33;
            }
            return null;
        }
        Object object10 = pkg.get("url");
        if (object10 == null || (object10 = object10.asText()) == null) {
            return null;
        }
        Object object11 = pkg.get("sha256");
        if (object11 == null || (object11 = object11.asText()) == null) {
            return null;
        }
        JsonNode jsonNode = pkg.get("archive_size");
        if (jsonNode == null) {
            return null;
        }
        long l = jsonNode.asLong();
        Object object12 = pkg.get("archive_file_name");
        if (object12 == null || (object12 = object12.asText()) == null) {
            return null;
        }
        Object object13 = pkg.get("package_root_prefix");
        if (object13 == null || (object13 = object13.asText()) == null) {
            return null;
        }
        Object object14 = pkg.get("package_to_java_home_prefix");
        if (object14 == null || (object14 = object14.asText()) == null) {
            return null;
        }
        JsonNode jsonNode7 = pkg.get("unpacked_size");
        if (jsonNode7 == null) {
            return null;
        }
        long l2 = jsonNode7.asLong();
        Object object15 = pkg.get("install_folder_name");
        if (object15 == null || (object15 = object15.asText()) == null) {
            return null;
        }
        JsonNode jsonNode8 = item.get("shared_index_aliases");
        if (!(jsonNode8 instanceof ArrayNode)) {
            jsonNode8 = null;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode8;
        if (arrayNode != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            $this$filterIsInstanceTo$iv$iv = (Iterable)arrayNode;
            Object object16 = object15;
            long l3 = l2;
            Object object17 = object14;
            Object object18 = object13;
            Object object19 = object12;
            long l4 = l;
            Object object20 = object11;
            Object object21 = object10;
            jdkPackageType = object5;
            object4 = object6;
            object3 = object7;
            string = string2;
            object2 = object8;
            n = n2;
            bl2 = bl;
            bl4 = bl3;
            jdkProduct = jdkProduct2;
            boolean $i$f$mapNotNull = false;
            void p12 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                String string3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl9 = false;
                JsonNode it = (JsonNode)element$iv$iv;
                boolean bl10 = false;
                if (it.asText() == null) continue;
                boolean bl11 = false;
                boolean bl12 = false;
                String it$iv$iv = string3;
                boolean bl13 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            jdkProduct2 = jdkProduct;
            bl3 = bl4;
            bl = bl2;
            n2 = n;
            object8 = object2;
            string2 = string;
            object7 = object3;
            object6 = object4;
            object5 = jdkPackageType;
            object10 = object21;
            object11 = object20;
            l = l4;
            object12 = object19;
            object13 = object18;
            object14 = object17;
            l2 = l3;
            object15 = object16;
            list2 = list3;
        } else {
            boolean bl14 = false;
            list2 = CollectionsKt.emptyList();
        }
        Function1 function1 = (Function1)new Function1<Path, Unit>(contents){
            final /* synthetic */ byte[] $contents;

            public final void invoke(@NotNull Path file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullExpressionValue((Object)this.$contents, (String)"contents");
                PathKt.write$default((Path)file2, (byte[])this.$contents, (int)0, (int)0, (int)6, null);
            }
            {
                this.$contents = byArray;
                super(1);
            }
        };
        List list4 = list2;
        Object object22 = object15;
        long l5 = l2;
        Object object23 = object14;
        Object object24 = object13;
        object = object12;
        Function1 function12 = function1;
        List list5 = list4;
        Object object25 = object22;
        Object object26 = object;
        Object object27 = object23;
        Object object28 = object24;
        long l6 = l5;
        long l7 = l;
        Object object29 = object11;
        Object object30 = object10;
        Object object31 = object5;
        Object object32 = object6;
        Object object33 = object7;
        String string4 = string2;
        Object object34 = object8;
        int n3 = n2;
        boolean bl15 = bl;
        boolean bl16 = bl3;
        JdkProduct jdkProduct3 = jdkProduct2;
        return new JdkItem(jdkProduct3, bl16, bl15, n3, (String)object34, string4, (String)object33, (String)object32, (JdkPackageType)((Object)object31), (String)object30, (String)object29, l7, l6, (String)object28, (String)object27, (String)object26, (String)object25, list5, (Function1<? super Path, Unit>)function12);
    }

    private JdkListParser() {
    }

    static {
        JdkListParser jdkListParser;
        INSTANCE = jdkListParser = new JdkListParser();
    }
}

