/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JarSdkConfigurator;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAuto;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoHint;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoHintService;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoHints;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderBase;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListDownloader;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkRequirement;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkRequirements;
import com.intellij.openapi.roots.ui.configuration.SdkDetector;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkFixConfigurator;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTask;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkAuto;", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkResolver;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderBase;", "()V", "createResolver", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkResolver$UnknownSdkLookup;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createResolverImpl", "supportsResolution", "", "sdkTypeId", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "JavaLocalSdkFix", "intellij.platform.lang.impl"})
public final class JdkAuto
implements UnknownSdkResolver,
JdkDownloaderBase {
    @Override
    public boolean supportsResolution(@NotNull SdkTypeId sdkTypeId) {
        Intrinsics.checkNotNullParameter((Object)sdkTypeId, (String)"sdkTypeId");
        return SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType().value((Object)sdkTypeId);
    }

    @Override
    @Nullable
    public UnknownSdkResolver.UnknownSdkLookup createResolver(@Nullable Project project, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!Registry.is((String)"jdk.auto.setup")) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return null;
        }
        return this.createResolverImpl(project, indicator);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final UnknownSdkResolver.UnknownSdkLookup createResolverImpl(@Nullable Project project, @NotNull ProgressIndicator indicator) {
        Object v1;
        block3: {
            void $this$singleOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            SdkType[] sdkTypeArray = SdkType.getAllTypes();
            Intrinsics.checkNotNullExpressionValue((Object)sdkTypeArray, (String)"SdkType.getAllTypes()");
            SdkType[] sdkTypeArray2 = sdkTypeArray;
            Condition condition = SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (void element$iv : $this$singleOrNull$iv) {
                SdkTypeId p1 = (SdkTypeId)element$iv;
                boolean bl = false;
                if (!condition.value((Object)p1)) continue;
                if (found$iv) {
                    v1 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        if (v1 == null) {
            return null;
        }
        Object sdkType = v1;
        return new UnknownSdkResolver.UnknownSdkLookup(this, sdkType, project, indicator){
            @NotNull
            private final Lazy lazyDownloadModel$delegate;
            @NotNull
            private final Lazy lazyLocalJdks$delegate;
            final /* synthetic */ JdkAuto this$0;
            final /* synthetic */ SdkType $sdkType;
            final /* synthetic */ Project $project;
            final /* synthetic */ ProgressIndicator $indicator;

            @NotNull
            public final List<JdkItem> getLazyDownloadModel() {
                Lazy lazy = this.lazyDownloadModel$delegate;
                createResolverImpl.1 var2_2 = this;
                Object var3_3 = null;
                boolean bl = false;
                return (List)lazy.getValue();
            }

            private final JdkAutoHint resolveHint(UnknownSdk sdk2) {
                Object v1;
                block5: {
                    if (Intrinsics.areEqual((Object)sdk2.getSdkType(), (Object)this.$sdkType) ^ true) {
                        return null;
                    }
                    if (this.$project == null) {
                        return null;
                    }
                    String string = sdk2.getSdkName();
                    if (string == null) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.sdkName ?: return null");
                    String sdkName = string;
                    Iterable $this$singleOrNull$iv = ((JdkAutoHints)JdkAutoHintService.Companion.getInstance(this.$project).getState()).getJdks();
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        JdkAutoHint it = (JdkAutoHint)((Object)element$iv);
                        boolean bl = false;
                        if (!StringsKt.equals((String)it.getName(), (String)sdkName, (boolean)true)) continue;
                        if (found$iv) {
                            v1 = null;
                            break block5;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                return v1;
            }

            private final JdkRequirement parseSdkRequirement(UnknownSdk sdk2) {
                Object object;
                Object object2;
                block7: {
                    block6: {
                        JdkAutoHint hint = this.resolveHint(sdk2);
                        object2 = hint;
                        if (object2 == null || (object2 = object2.getVersion()) == null) break block6;
                        Object object3 = object2;
                        boolean bl = false;
                        Object object4 = object3;
                        if (object4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        object2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object4))).toString();
                        if (object2 == null) break block6;
                        object3 = object2;
                        bl = false;
                        Object object5 = object3;
                        if (object5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string = ((String)object5).toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
                        object2 = string;
                        if (string != null && (object2 = StringKt.nullize((String)object2, (boolean)true)) != null) break block7;
                    }
                    JavaVersion javaVersion = JavaVersion.tryParse((String)sdk2.getExpectedVersionString());
                    object2 = object = javaVersion != null ? javaVersion.toFeatureMinorUpdateString() : null;
                }
                if (object2 == null) {
                    object = sdk2.getSdkName();
                }
                Object namePredicate = object;
                return JdkRequirements.INSTANCE.parseRequirement((String)namePredicate, sdk2.getSdkVersionStringPredicate(), sdk2.getSdkHomePredicate());
            }

            private final UnknownSdkLocalSdkFix resolveHintPath(UnknownSdk sdk2, ProgressIndicator indicator) {
                Object object;
                JdkAutoHint hint = this.resolveHint(sdk2);
                Object object2 = hint;
                if (object2 == null || (object2 = object2.getPath()) == null) {
                    return null;
                }
                Object path = object2;
                indicator.setText(ProjectBundle.message((String)"progress.text.resolving.hint.path", (Object[])new Object[]{path}));
                if (!new File((String)path).isDirectory()) {
                    return null;
                }
                createResolverImpl.1 var6_5 = this;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    createResolverImpl.1 $this$runCatching = var6_5;
                    boolean bl2 = false;
                    String string = this.$sdkType.getVersionString(hint.getPath());
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)string);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                var6_5 = object;
                bl = false;
                String string = (String)((Object)(Result.isFailure-impl((Object)var6_5) ? null : var6_5));
                if (string == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runCatching {\n          \u2026etOrNull() ?: return null");
                String version2 = string;
                return new UnknownSdkLocalSdkFix(this, (String)path, version2, hint){
                    private final /* synthetic */ JarSdkConfigurator $$delegate_0;
                    final /* synthetic */ createResolverImpl.1 this$0;
                    final /* synthetic */ String $path;
                    final /* synthetic */ String $version;
                    final /* synthetic */ JdkAutoHint $hint;

                    @NotNull
                    public String getExistingSdkHome() {
                        return this.$path;
                    }

                    @NotNull
                    public String getVersionString() {
                        return this.$version;
                    }

                    @NotNull
                    public String getSuggestedSdkName() {
                        String string = this.this$0.$sdkType.suggestSdkName(null, this.$hint.getPath());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdkType.suggestSdkName(null, hint.path)");
                        return string;
                    }

                    @NotNull
                    public String toString() {
                        return "resolved to hint " + this.$version + ", " + this.$path;
                    }
                    {
                        this.this$0 = this$0;
                        this.$path = $captured_local_variable$1;
                        this.$version = $captured_local_variable$2;
                        this.$hint = $captured_local_variable$3;
                        this.$$delegate_0 = new JarSdkConfigurator($captured_local_variable$3.getIncludeJars());
                    }

                    public void configureSdk(@NotNull Sdk sdk2) {
                        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                        this.$$delegate_0.configureSdk(sdk2);
                    }
                };
            }

            @Nullable
            public UnknownSdkDownloadableSdkFix proposeDownload(@NotNull UnknownSdk sdk2, @NotNull ProgressIndicator indicator) {
                Object object;
                Object v4;
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (Intrinsics.areEqual((Object)sdk2.getSdkType(), (Object)this.$sdkType) ^ true) {
                    return null;
                }
                JdkRequirement jdkRequirement = this.parseSdkRequirement(sdk2);
                if (jdkRequirement == null) {
                    return null;
                }
                JdkRequirement req = jdkRequirement;
                Logger logger = JdkAutoKt.access$getLOG$p();
                StringBuilder stringBuilder = new StringBuilder().append("Looking for a possible download for ");
                SdkType sdkType = sdk2.getSdkType();
                Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"sdk.sdkType");
                logger.info(stringBuilder.append(sdkType.getPresentableName()).append(" with name ").append(sdk2).toString());
                Sequence $this$maxBy$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getLazyDownloadModel()), (Function1)((Function1)new Function1<JdkItem, Boolean>(req){
                    final /* synthetic */ JdkRequirement $req;

                    public final boolean invoke(@NotNull JdkItem it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$req.matches(it);
                    }
                    {
                        this.$req = jdkRequirement;
                        super(1);
                    }
                })), (Function1)createResolverImpl.proposeDownload.jdkToDownload.2.INSTANCE);
                boolean $i$f$maxBy = false;
                Sequence $this$maxByOrNull$iv$iv = $this$maxBy$iv;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv$iv = $this$maxByOrNull$iv$iv.iterator();
                if (!iterator$iv$iv.hasNext()) {
                    v4 = null;
                } else {
                    E maxElem$iv$iv = iterator$iv$iv.next();
                    if (!iterator$iv$iv.hasNext()) {
                        v4 = maxElem$iv$iv;
                    } else {
                        Pair it = (Pair)maxElem$iv$iv;
                        boolean bl = false;
                        Comparable maxValue$iv$iv = (Comparable)((JavaVersion)it.getSecond());
                        do {
                            E e$iv$iv = iterator$iv$iv.next();
                            Pair it2 = (Pair)e$iv$iv;
                            $i$a$-maxBy-JdkAuto$createResolverImpl$1$proposeDownload$jdkToDownload$3 = false;
                            Comparable v$iv$iv = (Comparable)((JavaVersion)it2.getSecond());
                            if (maxValue$iv$iv.compareTo(v$iv$iv) >= 0) continue;
                            maxElem$iv$iv = e$iv$iv;
                            maxValue$iv$iv = v$iv$iv;
                        } while (iterator$iv$iv.hasNext());
                        v4 = maxElem$iv$iv;
                    }
                }
                if ((object = (Pair)v4) == null || (object = (JdkItem)object.getFirst()) == null) {
                    return null;
                }
                Object jdkToDownload2 = object;
                Object object2 = this.resolveHint(sdk2);
                if (object2 == null || (object2 = object2.getIncludeJars()) == null) {
                    boolean bl = false;
                    object2 = CollectionsKt.emptyList();
                }
                JarSdkConfigurator jarConfigurator = new JarSdkConfigurator((List<String>)object2);
                return new UnknownSdkDownloadableSdkFix(this, (JdkItem)jdkToDownload2, jarConfigurator){
                    private final /* synthetic */ JarSdkConfigurator $$delegate_0;
                    final /* synthetic */ createResolverImpl.1 this$0;
                    final /* synthetic */ JdkItem $jdkToDownload;
                    final /* synthetic */ JarSdkConfigurator $jarConfigurator;

                    @NotNull
                    public String getVersionString() {
                        return this.$jdkToDownload.getVersionString();
                    }

                    @NotNull
                    public String getPresentableVersionString() {
                        return this.$jdkToDownload.getPresentableVersionString();
                    }

                    @NotNull
                    public String getDownloadDescription() {
                        return this.$jdkToDownload.getFullPresentationText();
                    }

                    @NotNull
                    public SdkDownloadTask createTask(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        JdkInstaller jdkInstaller = JdkInstaller.Companion.getInstance();
                        Path homeDir = jdkInstaller.defaultInstallDir(this.$jdkToDownload);
                        JdkInstallRequest request = jdkInstaller.prepareJdkInstallation(this.$jdkToDownload, homeDir);
                        return this.this$0.this$0.newDownloadTask(request, this.this$0.$project);
                    }
                    {
                        this.this$0 = this$0;
                        this.$jdkToDownload = $captured_local_variable$1;
                        this.$jarConfigurator = $captured_local_variable$2;
                        this.$$delegate_0 = $captured_local_variable$2;
                    }

                    public void configureSdk(@NotNull Sdk sdk2) {
                        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                        this.$$delegate_0.configureSdk(sdk2);
                    }
                };
            }

            @NotNull
            public final List<JavaLocalSdkFix> getLazyLocalJdks() {
                Lazy lazy = this.lazyLocalJdks$delegate;
                createResolverImpl.1 var2_2 = this;
                Object var3_3 = null;
                boolean bl = false;
                return (List)lazy.getValue();
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public UnknownSdkLocalSdkFix proposeLocalFix(@NotNull UnknownSdk sdk2, @NotNull ProgressIndicator indicator) {
                JavaLocalSdkFix javaLocalSdkFix;
                JavaLocalSdkFix localSdkFix;
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (Intrinsics.areEqual((Object)sdk2.getSdkType(), (Object)this.$sdkType) ^ true) {
                    return null;
                }
                UnknownSdkLocalSdkFix hintMatch = this.resolveHintPath(sdk2, indicator);
                if (hintMatch != null) {
                    return hintMatch;
                }
                JdkRequirement jdkRequirement = this.parseSdkRequirement(sdk2);
                if (jdkRequirement == null) {
                    return null;
                }
                JdkRequirement req = jdkRequirement;
                Logger logger = JdkAutoKt.access$getLOG$p();
                StringBuilder stringBuilder = new StringBuilder().append("Looking for a local SDK for ");
                SdkType sdkType = sdk2.getSdkType();
                Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"sdk.sdkType");
                logger.info(stringBuilder.append(sdkType.getPresentableName()).append(" with name ").append(sdk2).toString());
                createResolverImpl.proposeLocalFix.1 $fun$pickBestMatch$1 = createResolverImpl.proposeLocalFix.1.INSTANCE;
                SdkType sdkType2 = sdk2.getSdkType();
                Intrinsics.checkNotNullExpressionValue((Object)sdkType2, (String)"sdk.sdkType");
                JavaLocalSdkFix javaLocalSdkFix2 = $fun$pickBestMatch$1.invoke(this.tryUsingExistingSdk(req, sdkType2, indicator));
                if (javaLocalSdkFix2 == null) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable = this.getLazyLocalJdks();
                    createResolverImpl.proposeLocalFix.1 var16_8 = $fun$pickBestMatch$1;
                    boolean $i$f$filter = false;
                    void var9_10 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        JavaLocalSdkFix it = (JavaLocalSdkFix)element$iv$iv;
                        boolean bl = false;
                        if (!req.matches(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv;
                    javaLocalSdkFix2 = var16_8.invoke(list2);
                }
                JavaLocalSdkFix javaLocalSdkFix3 = localSdkFix = javaLocalSdkFix2;
                if (javaLocalSdkFix3 != null) {
                    Object object = this.resolveHint(sdk2);
                    if (object == null || (object = object.getIncludeJars()) == null) {
                        boolean bl = false;
                        object = CollectionsKt.emptyList();
                    }
                    javaLocalSdkFix = JavaLocalSdkFix.copy$default(javaLocalSdkFix3, null, null, null, (List)object, null, 23, null);
                } else {
                    javaLocalSdkFix = null;
                }
                return javaLocalSdkFix;
            }

            private final List<JavaLocalSdkFix> tryUsingExistingSdk(JdkRequirement req, SdkType sdkType, ProgressIndicator indicator) {
                indicator.setText(ProjectBundle.message((String)"progress.text.checking.existing.jdks", (Object[])new Object[0]));
                boolean bl = false;
                List result2 = new ArrayList<E>();
                boolean $i$f$runReadAction = false;
                Sdk[] sdkArray = (Sdk[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(){

                    public final T compute() {
                        boolean bl = false;
                        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)projectJdkTable, (String)"ProjectJdkTable.getInstance()");
                        return (T)projectJdkTable.getAllJdks();
                    }
                });
                int n = sdkArray.length;
                for (int j = 0; j < n; ++j) {
                    String suggestedName;
                    boolean bl2;
                    Object $this$runCatching5;
                    JavaVersion version2;
                    Object object;
                    String versionString;
                    Object object2;
                    String homeDir;
                    Object object3;
                    Object object4;
                    Sdk it;
                    Sdk sdk2 = it = sdkArray[j];
                    Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"it");
                    if (Intrinsics.areEqual((Object)sdk2.getSdkType(), (Object)sdkType) ^ true) continue;
                    createResolverImpl.1 var10_11 = this;
                    boolean bl3 = false;
                    try {
                        object4 = Result.Companion;
                        createResolverImpl.1 $this$runCatching2 = var10_11;
                        boolean bl4 = false;
                        object3 = it.getHomePath();
                        bl4 = false;
                        object4 = Result.constructor-impl((Object)object3);
                    }
                    catch (Throwable throwable) {
                        Result.Companion bl4 = Result.Companion;
                        boolean bl5 = false;
                        object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    var10_11 = object4;
                    bl3 = false;
                    if ((String)((Object)(Result.isFailure-impl((Object)var10_11) ? null : var10_11)) == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)homeDir, (String)"runCatching { it.homePat\u2026}.getOrNull() ?: continue");
                    Object object5 = this;
                    boolean bl6 = false;
                    try {
                        object3 = Result.Companion;
                        createResolverImpl.1 $this$runCatching3 = object5;
                        boolean bl7 = false;
                        object2 = it.getVersionString();
                        bl7 = false;
                        object3 = Result.constructor-impl((Object)object2);
                    }
                    catch (Throwable throwable) {
                        Result.Companion bl7 = Result.Companion;
                        boolean bl8 = false;
                        object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object5 = object3;
                    bl6 = false;
                    if ((String)(Result.isFailure-impl((Object)object5) ? null : object5) == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)versionString, (String)"runCatching { it.version\u2026}.getOrNull() ?: continue");
                    Object object6 = this;
                    boolean bl9 = false;
                    try {
                        object2 = Result.Companion;
                        createResolverImpl.1 $this$runCatching4 = object6;
                        boolean bl10 = false;
                        object = JavaVersion.tryParse((String)versionString);
                        bl10 = false;
                        object2 = Result.constructor-impl((Object)object);
                    }
                    catch (Throwable throwable) {
                        Result.Companion bl10 = Result.Companion;
                        boolean bl11 = false;
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object6 = object2;
                    bl9 = false;
                    if ((JavaVersion)(Result.isFailure-impl((Object)object6) ? null : object6) == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"runCatching { JavaVersio\u2026}.getOrNull() ?: continue");
                    Object object7 = this;
                    boolean bl12 = false;
                    try {
                        object = Result.Companion;
                        $this$runCatching5 = object7;
                        boolean bl13 = false;
                        $this$runCatching5 = JdkUtil.suggestJdkName((String)versionString);
                        bl13 = false;
                        object = Result.constructor-impl((Object)$this$runCatching5);
                    }
                    catch (Throwable $this$runCatching5) {
                        Result.Companion bl13 = Result.Companion;
                        bl2 = false;
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching5));
                    }
                    object7 = object;
                    bl12 = false;
                    if ((String)(Result.isFailure-impl((Object)object7) ? null : object7) == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)suggestedName, (String)"runCatching { JdkUtil.su\u2026}.getOrNull() ?: continue");
                    if (!(it instanceof MockSdk)) {
                        object7 = this;
                        bl12 = false;
                        try {
                            object = Result.Companion;
                            $this$runCatching5 = object7;
                            boolean bl14 = false;
                            $this$runCatching5 = sdkType.isValidSdkHome(it.getHomePath());
                            bl14 = false;
                            object = Result.constructor-impl((Object)$this$runCatching5);
                        }
                        catch (Throwable $this$runCatching6) {
                            Result.Companion bl14 = Result.Companion;
                            bl2 = false;
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching6));
                        }
                        object7 = object;
                        bl12 = false;
                        if (Intrinsics.areEqual((Object)((Boolean)(Result.isFailure-impl((Object)object7) ? null : object7)), (Object)true) ^ true) continue;
                    }
                    object7 = this;
                    bl12 = false;
                    try {
                        object = Result.Companion;
                        $this$runCatching5 = object7;
                        boolean bl15 = false;
                        Boolean bl16 = req.matches(it);
                        boolean bl17 = false;
                        object = Result.constructor-impl((Object)bl16);
                    }
                    catch (Throwable throwable) {
                        Result.Companion companion = Result.Companion;
                        bl2 = false;
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object7 = object;
                    bl12 = false;
                    if (Intrinsics.areEqual((Object)((Boolean)(Result.isFailure-impl((Object)object7) ? null : object7)), (Object)true) ^ true) continue;
                    object7 = result2;
                    JavaLocalSdkFix javaLocalSdkFix = new JavaLocalSdkFix(homeDir, version2, suggestedName, null, it, 8, null);
                    boolean bl18 = false;
                    object7.add(javaLocalSdkFix);
                }
                return result2;
            }
            {
                this.this$0 = this$0;
                this.$sdkType = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$indicator = $captured_local_variable$3;
                this.lazyDownloadModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends JdkItem>>(this){
                    final /* synthetic */ createResolverImpl.1 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public final List<JdkItem> invoke() {
                        List list2;
                        this.this$0.$indicator.pushState();
                        this.this$0.$indicator.setText(ProjectBundle.message((String)"progress.text.downloading.jdk.list", (Object[])new Object[0]));
                        try {
                            list2 = JdkListDownloader.Companion.getInstance().downloadModelForJdkInstaller(this.this$0.$indicator);
                        }
                        catch (ProcessCanceledException e) {
                            throw (Throwable)e;
                        }
                        catch (Throwable t) {
                            JdkAutoKt.access$getLOG$p().warn("JdkAuto has failed to download the list of available JDKs. " + t.getMessage(), t);
                            boolean bl = false;
                            list2 = CollectionsKt.emptyList();
                        }
                        finally {
                            this.this$0.$indicator.popState();
                        }
                        return list2;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
                this.lazyLocalJdks$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<JavaLocalSdkFix>>(this){
                    final /* synthetic */ createResolverImpl.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<JavaLocalSdkFix> invoke() {
                        void var1_2;
                        this.this$0.$indicator.setText(ProjectBundle.message((String)"progress.text.detecting.local.jdks", (Object[])new Object[0]));
                        boolean bl = false;
                        List result2 = new ArrayList<E>();
                        SdkDetector.getInstance().detectSdks(this.this$0.$sdkType, this.this$0.$indicator, new SdkDetector.DetectedSdkListener(result2){
                            final /* synthetic */ List $result;

                            public void onSdkDetected(@NotNull SdkType type, @NotNull String version2, @NotNull String home) {
                                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                                Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                                Intrinsics.checkNotNullParameter((Object)home, (String)"home");
                                JavaVersion javaVersion = JavaVersion.tryParse((String)version2);
                                if (javaVersion == null) {
                                    return;
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return");
                                JavaVersion javaVersion2 = javaVersion;
                                String string = JdkUtil.suggestJdkName((String)version2);
                                if (string == null) {
                                    return;
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JdkUtil.suggestJdkName(version) ?: return");
                                String suggestedName = string;
                                Collection collection = this.$result;
                                JavaLocalSdkFix javaLocalSdkFix = new JavaLocalSdkFix(home, javaVersion2, suggestedName, null, null, 24, null);
                                boolean bl = false;
                                collection.add(javaLocalSdkFix);
                            }
                            {
                                this.$result = $captured_local_variable$0;
                            }
                        });
                        return var1_2;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
        };
    }

    @Override
    @NotNull
    public SdkDownloadTask newDownloadTask(@NotNull JdkInstallRequest request, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return JdkDownloaderBase.DefaultImpls.newDownloadTask(this, request, project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u0018\u0010\u001b\u001a\u00020\u001c2\r\b\u0001\u0010\u001d\u001a\u00070\u000b\u00a2\u0006\u0002\b\u001eH\u0096\u0001JC\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\b\u0010$\u001a\u00020\u0004H\u0016J\r\u0010%\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001eH\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010'\u001a\u00020\u0004H\u0016J\r\u0010(\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001eH\u0016J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkAuto$JavaLocalSdkFix;", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkLocalSdkFix;", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkFixConfigurator;", "homeDir", "", "version", "Lcom/intellij/util/lang/JavaVersion;", "suggestedName", "includeJars", "", "prototype", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Ljava/lang/String;Lcom/intellij/util/lang/JavaVersion;Ljava/lang/String;Ljava/util/List;Lcom/intellij/openapi/projectRoots/Sdk;)V", "getHomeDir", "()Ljava/lang/String;", "getIncludeJars", "()Ljava/util/List;", "getPrototype", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getSuggestedName", "getVersion", "()Lcom/intellij/util/lang/JavaVersion;", "component1", "component2", "component3", "component4", "component5", "configureSdk", "", "sdk", "Lorg/jetbrains/annotations/NotNull;", "copy", "equals", "", "other", "", "getExistingSdkHome", "getPresentableVersionString", "getRegisteredSdkPrototype", "getSuggestedSdkName", "getVersionString", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    private static final class JavaLocalSdkFix
    implements UnknownSdkLocalSdkFix,
    UnknownSdkFixConfigurator {
        @NotNull
        private final String homeDir;
        @NotNull
        private final JavaVersion version;
        @NotNull
        private final String suggestedName;
        @NotNull
        private final List<String> includeJars;
        @Nullable
        private final Sdk prototype;
        private final /* synthetic */ JarSdkConfigurator $$delegate_0;

        @Override
        @NotNull
        public String getExistingSdkHome() {
            return this.homeDir;
        }

        @Override
        @NotNull
        public String getVersionString() {
            String string = JdkVersionDetector.formatVersionString((JavaVersion)this.version);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JdkVersionDetector.formatVersionString(version)");
            return string;
        }

        @Override
        @NotNull
        public String getPresentableVersionString() {
            String string = this.version.toFeatureMinorUpdateString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"version.toFeatureMinorUpdateString()");
            return string;
        }

        @Override
        @NotNull
        public String getSuggestedSdkName() {
            return this.suggestedName;
        }

        @Override
        @Nullable
        public Sdk getRegisteredSdkPrototype() {
            return this.prototype;
        }

        @NotNull
        public final String getHomeDir() {
            return this.homeDir;
        }

        @NotNull
        public final JavaVersion getVersion() {
            return this.version;
        }

        @NotNull
        public final String getSuggestedName() {
            return this.suggestedName;
        }

        @NotNull
        public final List<String> getIncludeJars() {
            return this.includeJars;
        }

        @Nullable
        public final Sdk getPrototype() {
            return this.prototype;
        }

        public JavaLocalSdkFix(@NotNull String homeDir, @NotNull JavaVersion version2, @NotNull String suggestedName, @NotNull List<String> includeJars, @Nullable Sdk prototype) {
            Intrinsics.checkNotNullParameter((Object)homeDir, (String)"homeDir");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            Intrinsics.checkNotNullParameter((Object)suggestedName, (String)"suggestedName");
            Intrinsics.checkNotNullParameter(includeJars, (String)"includeJars");
            this.$$delegate_0 = new JarSdkConfigurator(includeJars);
            this.homeDir = homeDir;
            this.version = version2;
            this.suggestedName = suggestedName;
            this.includeJars = includeJars;
            this.prototype = prototype;
        }

        public /* synthetic */ JavaLocalSdkFix(String string, JavaVersion javaVersion, String string2, List list2, Sdk sdk2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 0x10) != 0) {
                sdk2 = null;
            }
            this(string, javaVersion, string2, list2, sdk2);
        }

        @Override
        public void configureSdk(@NotNull Sdk sdk2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            this.$$delegate_0.configureSdk(sdk2);
        }

        @NotNull
        public final String component1() {
            return this.homeDir;
        }

        @NotNull
        public final JavaVersion component2() {
            return this.version;
        }

        @NotNull
        public final String component3() {
            return this.suggestedName;
        }

        @NotNull
        public final List<String> component4() {
            return this.includeJars;
        }

        @Nullable
        public final Sdk component5() {
            return this.prototype;
        }

        @NotNull
        public final JavaLocalSdkFix copy(@NotNull String homeDir, @NotNull JavaVersion version2, @NotNull String suggestedName, @NotNull List<String> includeJars, @Nullable Sdk prototype) {
            Intrinsics.checkNotNullParameter((Object)homeDir, (String)"homeDir");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            Intrinsics.checkNotNullParameter((Object)suggestedName, (String)"suggestedName");
            Intrinsics.checkNotNullParameter(includeJars, (String)"includeJars");
            return new JavaLocalSdkFix(homeDir, version2, suggestedName, includeJars, prototype);
        }

        public static /* synthetic */ JavaLocalSdkFix copy$default(JavaLocalSdkFix javaLocalSdkFix, String string, JavaVersion javaVersion, String string2, List list2, Sdk sdk2, int n, Object object) {
            if ((n & 1) != 0) {
                string = javaLocalSdkFix.homeDir;
            }
            if ((n & 2) != 0) {
                javaVersion = javaLocalSdkFix.version;
            }
            if ((n & 4) != 0) {
                string2 = javaLocalSdkFix.suggestedName;
            }
            if ((n & 8) != 0) {
                list2 = javaLocalSdkFix.includeJars;
            }
            if ((n & 0x10) != 0) {
                sdk2 = javaLocalSdkFix.prototype;
            }
            return javaLocalSdkFix.copy(string, javaVersion, string2, list2, sdk2);
        }

        @NotNull
        public String toString() {
            return "JavaLocalSdkFix(homeDir=" + this.homeDir + ", version=" + this.version + ", suggestedName=" + this.suggestedName + ", includeJars=" + this.includeJars + ", prototype=" + this.prototype + ")";
        }

        public int hashCode() {
            String string = this.homeDir;
            JavaVersion javaVersion = this.version;
            String string2 = this.suggestedName;
            List<String> list2 = this.includeJars;
            Sdk sdk2 = this.prototype;
            return ((((string != null ? string.hashCode() : 0) * 31 + (javaVersion != null ? javaVersion.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (sdk2 != null ? sdk2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JavaLocalSdkFix)) break block3;
                    JavaLocalSdkFix javaLocalSdkFix = (JavaLocalSdkFix)object;
                    if (!Intrinsics.areEqual((Object)this.homeDir, (Object)javaLocalSdkFix.homeDir) || !Intrinsics.areEqual((Object)this.version, (Object)javaLocalSdkFix.version) || !Intrinsics.areEqual((Object)this.suggestedName, (Object)javaLocalSdkFix.suggestedName) || !Intrinsics.areEqual(this.includeJars, javaLocalSdkFix.includeJars) || !Intrinsics.areEqual((Object)this.prototype, (Object)javaLocalSdkFix.prototype)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

