/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurerKt;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.DefaultProjectUiFrameManager;
import com.intellij.openapi.project.impl.ProjectFrameAllocator;
import com.intellij.openapi.project.impl.ProjectFrameAllocatorKt;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.ProjectUiFrameAllocator;
import com.intellij.openapi.project.impl.ProjectUiFrameManager;
import com.intellij.openapi.project.impl.SingleProjectUiFrameManager;
import com.intellij.openapi.project.impl.SplashProjectUiFrameManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.ui.IdeUICustomization;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0003J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J)\u0010!\u001a\u0004\u0018\u0001H\"\"\b\b\u0000\u0010\"*\u00020#2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\"0%H\u0016\u00a2\u0006\u0002\u0010&R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/intellij/openapi/project/impl/ProjectUiFrameAllocator;", "Lcom/intellij/openapi/project/impl/ProjectFrameAllocator;", "options", "Lcom/intellij/ide/impl/OpenProjectTask;", "projectStoreBaseDir", "Ljava/nio/file/Path;", "(Lcom/intellij/ide/impl/OpenProjectTask;Ljava/nio/file/Path;)V", "<set-?>", "", "cancelled", "getCancelled", "()Z", "frameManager", "Lcom/intellij/openapi/project/impl/ProjectUiFrameManager;", "getFrameManager", "()Lcom/intellij/openapi/project/impl/ProjectUiFrameManager;", "setFrameManager", "(Lcom/intellij/openapi/project/impl/ProjectUiFrameManager;)V", "getOptions", "()Lcom/intellij/ide/impl/OpenProjectTask;", "getProjectStoreBaseDir", "()Ljava/nio/file/Path;", "createFrameManager", "getProgressTitle", "", "projectLoaded", "", "project", "Lcom/intellij/openapi/project/Project;", "projectNotLoaded", "error", "Lcom/intellij/conversion/CannotConvertException;", "projectOpened", "run", "T", "", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
public final class ProjectUiFrameAllocator
extends ProjectFrameAllocator {
    @Nullable
    private ProjectUiFrameManager frameManager;
    private volatile boolean cancelled;
    @NotNull
    private final OpenProjectTask options;
    @NotNull
    private final Path projectStoreBaseDir;

    @Nullable
    public final ProjectUiFrameManager getFrameManager() {
        return this.frameManager;
    }

    public final void setFrameManager(@Nullable ProjectUiFrameManager projectUiFrameManager) {
        this.frameManager = projectUiFrameManager;
    }

    public final boolean getCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public <T> T run(@NotNull Function0<? extends T> task2) {
        void result2;
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        if (this.options.isNewProject() && this.options.getUseDefaultProjectAsTemplate() && this.options.getProject() == null) {
            ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)run.1.INSTANCE, (int)1, null);
        }
        this.frameManager = this.createFrameManager();
        Runnable progressTask2 = new Runnable(this, (Ref.ObjectRef)result2, task2){
            final /* synthetic */ ProjectUiFrameAllocator this$0;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ Function0 $task;

            public final void run() {
                ProjectUiFrameManager projectUiFrameManager = this.this$0.getFrameManager();
                Intrinsics.checkNotNull((Object)projectUiFrameManager);
                projectUiFrameManager.init(this.this$0);
                try {
                    this.$result.element = this.$task.invoke();
                }
                catch (ProcessCanceledException e) {
                    throw (Throwable)e;
                }
                catch (Exception e) {
                    if (e instanceof StartupAbortedException || e instanceof PluginException) {
                        StartupAbortedException.logAndExit((Throwable)e);
                    }
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(ProjectFrameAllocator.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error((Throwable)e);
                    Exception exception = e;
                    if (!(exception instanceof CannotConvertException)) {
                        exception = null;
                    }
                    this.this$0.projectNotLoaded((CannotConvertException)exception);
                }
            }
            {
                this.this$0 = projectUiFrameAllocator;
                this.$result = objectRef;
                this.$task = function0;
            }
        };
        ApplicationEx applicationEx = ApplicationManagerEx.getApplicationEx();
        String string = this.getProgressTitle();
        ProjectUiFrameManager projectUiFrameManager = this.frameManager;
        Intrinsics.checkNotNull((Object)projectUiFrameManager);
        if (applicationEx.runProcessWithProgressSynchronously(progressTask2, string, true, true, null, projectUiFrameManager.getComponent(), null)) {
            return (T)result2.element;
        }
        return null;
    }

    @NlsContexts.ProgressTitle
    private final String getProgressTitle() {
        String string = this.options.getProjectName();
        if (string == null) {
            Path path = this.projectStoreBaseDir.getFileName();
            if (path == null) {
                path = this.projectStoreBaseDir;
            }
            string = ((Object)path).toString();
        }
        String projectName = string;
        String string2 = IdeUICustomization.getInstance().projectMessage("progress.title.project.loading.name", new Object[]{projectName});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeUICustomization.getIn\u2026ading.name\", projectName)");
        return string2;
    }

    private final ProjectUiFrameManager createFrameManager() {
        if (this.options.getFrameManager$intellij_platform_ide_impl() instanceof ProjectUiFrameManager) {
            return (ProjectUiFrameManager)this.options.getFrameManager$intellij_platform_ide_impl();
        }
        return (ProjectUiFrameManager)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<ProjectUiFrameManager>(this){
            final /* synthetic */ ProjectUiFrameAllocator this$0;

            @NotNull
            public final ProjectUiFrameManager invoke() {
                WindowManager windowManager = WindowManager.getInstance();
                if (windowManager == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
                }
                ProjectFrameHelper freeRootFrame = ((WindowManagerImpl)windowManager).removeAndGetRootFrame$intellij_platform_ide_impl();
                if (freeRootFrame != null) {
                    IdeFrameImpl ideFrameImpl = freeRootFrame.getFrame();
                    Intrinsics.checkNotNull((Object)ideFrameImpl);
                    Intrinsics.checkNotNullExpressionValue((Object)ideFrameImpl, (String)"freeRootFrame.frame!!");
                    return new DefaultProjectUiFrameManager(ideFrameImpl, freeRootFrame);
                }
                String name$iv = "create a frame";
                boolean $i$f$runMainActivity = false;
                ActivityCategory category$iv$iv = ActivityCategory.MAIN;
                boolean $i$f$runActivity = false;
                Activity activity$iv$iv = StartUpMeasurerKt.createActivity((String)name$iv, (ActivityCategory)category$iv$iv);
                boolean bl = false;
                IdeFrameImpl preAllocated = (IdeFrameImpl)SplashManager.getAndUnsetProjectFrame();
                ProjectUiFrameManager result$iv$iv = preAllocated == null ? (this.this$0.getOptions().getFrameManager$intellij_platform_ide_impl() instanceof FrameInfo ? (ProjectUiFrameManager)new SingleProjectUiFrameManager((FrameInfo)((Object)this.this$0.getOptions().getFrameManager$intellij_platform_ide_impl()), ProjectFrameAllocatorKt.createNewProjectFrame(false, (FrameInfo)((Object)this.this$0.getOptions().getFrameManager$intellij_platform_ide_impl()))) : (ProjectUiFrameManager)new DefaultProjectUiFrameManager(ProjectFrameAllocatorKt.createNewProjectFrame(false, null), null)) : (ProjectUiFrameManager)new SplashProjectUiFrameManager(preAllocated);
                activity$iv$iv.end();
                return result$iv$iv;
            }
            {
                this.this$0 = projectUiFrameAllocator;
                super(0);
            }
        }), (int)1, null);
    }

    @Override
    public void projectLoaded(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationManager.getApplication().invokeLater(new Runnable(this, project){
            final /* synthetic */ ProjectUiFrameAllocator this$0;
            final /* synthetic */ Project $project;

            public final void run() {
                Object object = this.this$0.getFrameManager();
                if (object == null || (object = object.getFrameHelper()) == null) {
                    return;
                }
                Object frameHelper = object;
                WindowManager windowManager = WindowManager.getInstance();
                if (windowManager == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
                }
                WindowManagerImpl windowManager2 = (WindowManagerImpl)windowManager;
                String name$iv = "project frame assigning";
                ActivityCategory category$iv = ActivityCategory.APP_INIT;
                boolean $i$f$runActivity = false;
                Activity activity$iv = StartUpMeasurerKt.createActivity((String)name$iv, (ActivityCategory)category$iv);
                boolean bl = false;
                windowManager2.assignFrame((ProjectFrameHelper)frameHelper, this.$project);
                Unit result$iv = Unit.INSTANCE;
                activity$iv.end();
                name$iv = "tool window pane creation";
                category$iv = ActivityCategory.APP_INIT;
                $i$f$runActivity = false;
                activity$iv = StartUpMeasurerKt.createActivity((String)name$iv, (ActivityCategory)category$iv);
                boolean bl2 = false;
                ToolWindowManagerEx.getInstanceEx(this.$project).init((ProjectFrameHelper)frameHelper);
                result$iv = Unit.INSTANCE;
                activity$iv.end();
            }
            {
                this.this$0 = projectUiFrameAllocator;
                this.$project = project;
            }
        }, project.getDisposed());
    }

    @Override
    public void projectNotLoaded(@Nullable CannotConvertException error) {
        this.cancelled = true;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, error){
            final /* synthetic */ ProjectUiFrameAllocator this$0;
            final /* synthetic */ CannotConvertException $error;

            public final void run() {
                ProjectUiFrameManager projectUiFrameManager = this.this$0.getFrameManager();
                ProjectFrameHelper frame = projectUiFrameManager != null ? projectUiFrameManager.getFrameHelper() : null;
                this.this$0.setFrameManager(null);
                if (this.$error != null) {
                    ProjectFrameHelper projectFrameHelper = frame;
                    ProjectManagerImpl.showCannotConvertMessage(this.$error, projectFrameHelper != null ? projectFrameHelper.getFrame() : null);
                }
                if (frame != null) {
                    Disposer.dispose((Disposable)frame);
                }
            }
            {
                this.this$0 = projectUiFrameAllocator;
                this.$error = cannotConvertException;
            }
        });
    }

    @Override
    public void projectOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectUiFrameManager projectUiFrameManager = this.frameManager;
        Intrinsics.checkNotNull((Object)projectUiFrameManager);
        projectUiFrameManager.projectOpened(project);
    }

    @NotNull
    public final OpenProjectTask getOptions() {
        return this.options;
    }

    @NotNull
    public final Path getProjectStoreBaseDir() {
        return this.projectStoreBaseDir;
    }

    public ProjectUiFrameAllocator(@NotNull OpenProjectTask options2, @NotNull Path projectStoreBaseDir) {
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Intrinsics.checkNotNullParameter((Object)projectStoreBaseDir, (String)"projectStoreBaseDir");
        super(options2);
        this.options = options2;
        this.projectStoreBaseDir = projectStoreBaseDir;
    }
}

